<?php
defined('ABSPATH') || exit;

spl_autoload_register(function($class){
    $prefix = 'Qrc\\';

    if (strncmp($prefix, $class, strlen($prefix)) !== 0) {
        return;
    }

    $rel = substr($class, strlen($prefix));
    $rel = str_replace('\\', DIRECTORY_SEPARATOR, $rel) . '.php';

    $base = __DIR__ . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR;
    $file = $base . $rel;

    if (is_readable($file)) {
        require_once $file;
    }
});
