<?php
namespace AegisShield\MFA;

defined( 'ABSPATH' ) || exit;

class AS_MFA_Email {

    const META_CODE    = 'aegisshield_mfa_email_code';
    const META_EXPIRES = 'aegisshield_mfa_email_expires';
    const META_LAST    = 'aegisshield_mfa_email_last_sent';
    const META_ENABLED = 'aegisshield_mfa_email_enabled';

    public static function send_email_otp( \WP_User $user, int $expiry_minutes = 10 ): bool {
        $user_id = (int) $user->ID;

        $email_enabled = get_user_meta( $user_id, self::META_ENABLED, '' );
        if ( '' !== $email_enabled && '1' !== (string) $email_enabled ) {
            return false;
        }

        $email = $user->user_email;
        if ( ! $email || ! is_email( $email ) ) {
            return false;
        }

        $last = (int) get_user_meta( $user_id, self::META_LAST, true );
        if ( $last && ( time() - $last ) < 60 ) {
            return false;
        }

        $code    = wp_rand( 100000, 999999 );
        $expires = time() + max( 1, $expiry_minutes ) * 60;

        $hash = wp_hash_password( (string) $code );

        update_user_meta( $user_id, self::META_CODE, $hash );
        update_user_meta( $user_id, self::META_EXPIRES, $expires );
        update_user_meta( $user_id, self::META_LAST, time() );

        $blogname = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );

        $subject = sprintf( __( '[%s] Your AegisShield login code', 'aegisshield-security' ), $blogname );

        $message  = sprintf(
            __( 'A login verification was requested for your account on %s.', 'aegisshield-security' ),
            $blogname
        ) . "\r\n\r\n";

        $message .= sprintf(
            /* translators: %s: One-time code. */
            __( 'Your one-time code is: %s', 'aegisshield-security' ),
            $code
        ) . "\r\n\r\n";

        $message .= __( 'This code will expire in 10 minutes. If you did not request this, you can ignore this email.', 'aegisshield-security' ) . "\r\n";

        wp_mail( $email, $subject, $message );

        return true;
    }

    public static function verify_email_otp( \WP_User $user, string $code ): bool {
        $user_id = (int) $user->ID;
        $code    = trim( (string) $code );

        if ( '' === $code ) {
            return false;
        }

        $expires = (int) get_user_meta( $user_id, self::META_EXPIRES, true );
        if ( ! $expires || time() > $expires ) {
            delete_user_meta( $user_id, self::META_CODE );
            delete_user_meta( $user_id, self::META_EXPIRES );
            return false;
        }

        $hash = get_user_meta( $user_id, self::META_CODE, true );
        if ( ! is_string( $hash ) || '' === $hash ) {
            return false;
        }

        $valid = wp_check_password( $code, $hash );

        if ( $valid ) {
            delete_user_meta( $user_id, self::META_CODE );
            delete_user_meta( $user_id, self::META_EXPIRES );
        }

        return $valid;
    }
}
