<?php
namespace AegisShield\MFA;

defined( 'ABSPATH' ) || exit;

use AegisShield\MFA\AS_MFA_Email;
use AegisShield\MFA\AS_MFA_WebAuthn;
use AegisShield\MFA\AS_MFA_Storage;
use AegisShield\AS_Logger;

class AS_MFA_Engine {

    public static function validate( $user, $posted ) {

        if ( ! ( $user instanceof \WP_User ) ) {
            return false;
        }

        $preferred = AS_MFA_Storage::get_user_preferred_method( $user->ID );

        if ( isset( $posted['aegis_mfa_method'] ) ) {
            $preferred = sanitize_key( $posted['aegis_mfa_method'] );
        }

        $log_fail = function( $reason ) use ( $user, $preferred ) {
            if ( class_exists( '\\AegisShield\\AS_Logger' ) ) {
                $ip = isset( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
                AS_Logger::log(
                    'mfa_failed_attempt',
                    __( 'MFA validation failed.', 'aegisshield-security' ),
                    'high',
                    array(
                        'user_id' => $user->ID,
                        'method'  => $preferred,
                        'ip'      => $ip,
                        'reason'  => $reason,
                    )
                );
            }
        };
switch ( $preferred ) {

            case 'email':
                $ok = AS_MFA_Email::verify_email_otp( $user, $posted );
                if ( ! $ok ) { $log_fail( 'email_otp_invalid' ); }
                return $ok;

            case 'webauthn':
                $ok = AS_MFA_WebAuthn::verify_webauthn( $user, $posted );
                if ( ! $ok ) { $log_fail( 'webauthn_invalid' ); }
                return $ok;

            case 'backup':
                $ok = AS_MFA_Storage::verify_backup_code( $user, $posted );
                if ( ! $ok ) { $log_fail( 'backup_code_invalid' ); }
                return $ok;

            case 'totp':
            default:
                $code = isset( $posted['aegisshield_2fa_code'] )
                    ? preg_replace( '/[^0-9]/', '', (string) $posted['aegisshield_2fa_code'] )
                    : '';

                if ( strlen( $code ) !== 6 ) {
                    $log_fail( 'totp_code_invalid_format' );
                    return false;
                }

                $ok = AS_MFA_Storage::verify_totp( $user, $code );
                if ( ! $ok ) { $log_fail( 'totp_invalid' ); }
                return $ok;
        }
    }
}