<?php
namespace AegisSitemap\Admin;

use AegisSitemap\Utils\Options;

require_once AEGISSITEMAP_DIR . 'includes/class-aegisify-bundled-plugins-page.php';

if (!defined('ABSPATH')) { exit; }

class Admin_Menu {

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;
        add_action('admin_menu', array($this, 'register_menu'));
    }

    private function cap() : string { return 'manage_options'; }

    public function register_menu() : void {

        add_menu_page(
            __('AegisSitemap', 'aegissitemap'),
            __('AegisSitemap', 'aegissitemap'),
            $this->cap(),
            'aegissitemap',
            array($this, 'render_main'),
            'dashicons-networking',
            58
        );

        add_submenu_page(
            'aegissitemap',
            __('Sitemap Settings', 'aegissitemap'),
            __('Settings', 'aegissitemap'),
            $this->cap(),
            'aegissitemap',
            array($this, 'render_main')
        );

		add_submenu_page(
			'aegissitemap',
			__('License', 'aegissitemap'),
			__('License', 'aegissitemap'),
			$this->cap(),
			'admin.php?page=aegissitemap&tab=license'
		);

		if (class_exists('\\Aegisify_Bundled_Plugins_Page')) {

			if (method_exists('\\Aegisify_Bundled_Plugins_Page', 'register')) {
				\Aegisify_Bundled_Plugins_Page::register(array(
					'parent_slug' => 'aegissitemap',
					'menu_slug'   => 'aegisify-bundled-plugins',
					'page_title'  => 'Aegisify Plugins',
					'menu_title'  => 'Aegisify Plugins',
				));
			} else {
				add_submenu_page(
					'aegissitemap',
					__('Aegisify Plugins', 'aegissitemap'),
					__('Aegisify Plugins', 'aegissitemap'),
					$this->cap(),
					'aegisify-bundled-plugins',
					array($this, 'render_aegisify_plugins')
				);
			}
		}
    }

    public function redirect_license() : void {
        wp_safe_redirect(admin_url('admin.php?page=aegissitemap&tab=license'));
        exit;
    }
	
	public function render_aegisify_plugins() : void {

		if (!current_user_can($this->cap())) {
			wp_die(esc_html__('Sorry, you are not allowed to access this page.', 'aegissitemap'));
		}

		if (!class_exists('\\Aegisify_Bundled_Plugins_Page')) {
			echo '<div class="wrap"><h1>Aegisify Plugins</h1><p>Missing bundled plugins page class.</p></div>';
			return;
		}

		$page = new \Aegisify_Bundled_Plugins_Page();

		if (method_exists($page, 'render_page')) {
			$page->render_page();
			return;
		}

		if (method_exists($page, 'render')) {
			$page->render();
			return;
		}

		echo '<div class="wrap"><h1>Aegisify Plugins</h1><p>Bundled plugins page class loaded, but no render method was found.</p></div>';

	}
	
    public function render_main() : void {
        if (!current_user_can($this->cap())) {
            wp_die(esc_html__('Sorry, you are not allowed to access this page.', 'aegissitemap'));
        }
        require AEGISSITEMAP_DIR . 'views/admin/settings-page.php';
    }
}
