<?php
namespace AegisSitemap;

use AegisSitemap\Admin\Admin_Menu;
use AegisSitemap\Admin\Admin_Settings;
use AegisSitemap\SEO\Sitemap;
use AegisSitemap\SEO\Robots;
use AegisSitemap\Utils\Options;
use AegisSitemap\Utils\License;

if (!defined('ABSPATH')) { exit; }

final class Plugin {
    private static $instance = null;

    public $options;
    public $license;
    public $admin_menu;
    public $admin_settings;
    public $sitemap;
    public $robots;

    public static function instance() : Plugin {
        if (self::$instance === null) self::$instance = new self();
        return self::$instance;
    }
    public static function activate_static() : void { self::instance()->activate(); }
    public static function deactivate_static() : void { self::instance()->deactivate(); }

    private function __construct() {
        require_once AEGISSITEMAP_DIR . 'includes/utils/class-aegissitemap-sanitize.php';
        require_once AEGISSITEMAP_DIR . 'includes/utils/class-aegissitemap-options.php';
        require_once AEGISSITEMAP_DIR . 'includes/utils/class-aegissitemap-license.php';

        require_once AEGISSITEMAP_DIR . 'includes/seo/class-aegissitemap-sitemap.php';
        require_once AEGISSITEMAP_DIR . 'includes/seo/class-aegissitemap-robots.php';

        require_once AEGISSITEMAP_DIR . 'includes/admin/class-aegissitemap-admin-settings.php';
        require_once AEGISSITEMAP_DIR . 'includes/admin/class-aegissitemap-admin-menu.php';

		$this->options = new Options();
		$this->license = new License();

        add_action('init', array($this->options, 'ensure_defaults'), 1);

        if (is_admin()) {
            $this->admin_settings = new Admin_Settings($this->options, $this->license);
            $this->admin_menu     = new Admin_Menu($this->options);

            add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));

            add_action('admin_init', function() {
                if (!current_user_can('manage_options')) return;
                $this->license->maybe_send_free_register(AEGISSITEMAP_VERSION);
            });
        }

        $this->sitemap = new Sitemap($this->options);
        $this->robots  = new Robots($this->options);
    }

    public function enqueue_admin_assets($hook) {
        if (!is_string($hook)) return;
        if (strpos($hook, 'aegissitemap') === false && strpos($hook, 'aegisify-bundled-plugins') === false) return;
        wp_enqueue_style('aegissitemap-admin', AEGISSITEMAP_URL . 'assets/css/admin.css', array(), AEGISSITEMAP_VERSION);
        wp_enqueue_script('aegissitemap-admin', AEGISSITEMAP_URL . 'assets/js/admin.js', array('jquery'), AEGISSITEMAP_VERSION, true);
    }

    public function activate() : void {
        $this->options->ensure_defaults();
        flush_rewrite_rules();
    }
    public function deactivate() : void {
        flush_rewrite_rules();
    }
}
