<?php
namespace AegisSitemap\Utils;

if (!defined('ABSPATH')) { exit; }

class Options {
    const OPTION_KEY = 'aegissitemap_settings';

    public function ensure_defaults() : void {
        $existing = get_option(self::OPTION_KEY, null);
        if (!is_array($existing)) {
            update_option(self::OPTION_KEY, $this->defaults(), false);
            return;
        }
		$merged = array_merge($this->defaults(), $existing);

		if ($merged !== $existing) {
			update_option(self::OPTION_KEY, $merged, false);
		}
    }

    public function get_all() : array {
        $v = get_option(self::OPTION_KEY, array());
        return is_array($v) ? $v : array();
    }

    public function get(string $key, $default = null) {
        $all = $this->get_all();
        return array_key_exists($key, $all) ? $all[$key] : $default;
    }

    public function set(string $key, $value) : void {
        $all = $this->get_all();
        $all[$key] = $value;
        update_option(self::OPTION_KEY, $all, false);
    }

	public function update(string $key, $value) : bool {
		$opts = get_option(self::OPTION_KEY, array());
		if (!is_array($opts)) { $opts = array(); }

		$opts[$key] = $value;

		return update_option(self::OPTION_KEY, $opts, false);
	}

    public function defaults() : array {
        return array(
            'sitemap_enabled' => 1,
            'sitemap_robots_add' => 1,
            'sitemap_index_enabled' => 1,
            'sitemap_page_size' => 2000,
            'sitemap_include_images' => 1,
            'sitemap_include_attached_images' => 0,
            'sitemap_video_enabled' => 1,
            'sitemap_news_enabled' => 0,
            'sitemap_html_enabled' => 1,
            'sitemap_post_types' => array('post' => 1, 'page' => 1),
            'sitemap_taxonomies' => array('category' => 1, 'post_tag' => 1),
            'sitemap_folder_exclusions' => '',
            'sitemap_last_ping' => array(),
            'ping_search_engines' => 1,
            'sitemap_plugins' => array(),
            'robots_enabled' => 0,
            'robots_write_physical' => 1,
            'robots_excluded_dirs' => array(
                '/wp-admin/',
                '/wp-includes/',
                '/cgi-bin/',
                '/?s=',
                '/search/',
            ),
            'robots_optimization_enabled' => 1,
            'robots_block_internal_search' => 1,
            'robots_block_feeds' => 0,
            'robots_block_attachments' => 0,
            'robots_custom_enabled' => 0,
            'robots_custom_rules' => '',
'sitemap_cache_v' => 1,
        );
    }
}
