<?php
namespace AegisSitemap\Utils;

if (!defined('ABSPATH')) { exit; }

class Sanitize {

    public static function bool_int($v) {
        return (int) (!empty($v));
    }

    public static function text($v, $max = 300) {
        $v = is_string($v) ? $v : '';
        $v = wp_strip_all_tags($v);
        $v = trim($v);
        if (strlen($v) > $max) {
            $v = substr($v, 0, $max);
        }
        return $v;
    }

    public static function url($v, $max = 500) {
        $v = is_string($v) ? trim($v) : '';
        if (strlen($v) > $max) { $v = substr($v, 0, $max); }
        return esc_url_raw($v);
    }

    public static function int($v) {
        return (int) $v;
    }

    public static function array_text($arr, $max = 500) {
        if (!is_array($arr)) { return array(); }
        $out = array();
        foreach ($arr as $k => $v) {
            $out[$k] = self::text($v, $max);
        }
        return $out;
    }
}
