<?php
if (!defined('ABSPATH')) { exit; }

$tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'sitemap';
$allowed = array('sitemap','robots','license','aegisify_plugin');
if (!in_array($tab, $allowed, true)) { $tab = 'sitemap'; }

function aegissitemap_tab_url($t) { return admin_url('admin.php?page=aegissitemap&tab=' . urlencode($t)); }

$tabs = array(
    'sitemap' => __('Sitemap', 'aegissitemap'),
    'robots' => __('Robots', 'aegissitemap'),
    'license' => __('License', 'aegissitemap'),
	'aegisify_plugin' => __('Aegisify Plugin', 'aegissitemap'),
);
?>
<div class="wrap aegissitemap-wrap">
    <h1><?php echo esc_html__('AegisSitemap', 'aegissitemap'); ?></h1>

    <h2 class="nav-tab-wrapper">
        <?php foreach ($tabs as $k => $label): ?>
            <a class="nav-tab <?php echo ($tab === $k) ? 'nav-tab-active' : ''; ?>" href="<?php echo esc_url(aegissitemap_tab_url($k)); ?>">
                <?php echo esc_html($label); ?>
            </a>
        <?php endforeach; ?>
    </h2>
	<?php if ($tab === 'aegisify_plugin'): ?>

		<?php
		if (!class_exists('Aegisify_Bundled_Plugins_Page')) {
			require_once AEGISSITEMAP_DIR . 'includes/class-aegisify-bundled-plugins-page.php';
		}

		if (class_exists('Aegisify_Bundled_Plugins_Page')) {
			$page = new \Aegisify_Bundled_Plugins_Page();

			if (method_exists($page, 'render_page')) {
				$page->render_page();
			} elseif (method_exists($page, 'render')) {
				$page->render();
			} else {
				echo '<div class="notice notice-error"><p>Bundled plugins page loaded, but no render method was found.</p></div>';
			}
		} else {
			echo '<div class="notice notice-error"><p>Missing bundled plugins page class.</p></div>';
		}
		?>
		
    <?php elseif ($tab === 'license'): ?>

        <?php require AEGISSITEMAP_DIR . 'views/admin/license-page.php'; ?>


    <?php elseif ($tab === 'robots'): ?>

        <?php
            $plugin = \AegisSitemap\Plugin::instance();
            $robots = $plugin->robots;
            $preview = '';
            if (is_object($robots) && method_exists($robots, 'generate')) {
                $preview = (string) $robots->generate();
            }
            $status = array();
            if (is_object($robots) && method_exists($robots, 'robots_file_status')) {
                $status = (array) $robots->robots_file_status();
            }
        ?>

        <style>
            .aegissitemap-robots-grid{display:flex;gap:16px;align-items:flex-start;box-sizing:border-box;padding-right:20px}
            .aegissitemap-robots-left{flex:1 1 60%;min-width:420px}
            .aegissitemap-robots-right{flex:1 1 40%;min-width:360px}
            @media (max-width:1100px){
                .aegissitemap-robots-grid{flex-direction:column}
                .aegissitemap-robots-left,.aegissitemap-robots-right{max-width:100%}
            }
            .aegissitemap-panel{background:#fff;border:1px solid #dcdcde;border-radius:10px;padding:14px;margin-bottom:14px}
            .aegissitemap-panel h2{margin:0 0 10px 0}
            .aegissitemap-pre{white-space:pre;overflow:auto;max-height:520px;font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace;font-size:12px;background:#f6f7f7;border:1px solid #dcdcde;border-radius:10px;padding:12px}
            .aegissitemap-help{font-size:12px;color:#646970;margin:6px 0 0 0}
        </style>

        <div class="aegissitemap-robots-grid">
            <div class="aegissitemap-robots-left">
                <form method="post" action="options.php">
                    <?php
                        settings_fields('aegissitemap_settings_group');
                        do_settings_sections('aegissitemap_robots');
                        submit_button(__('Save Robots Settings', 'aegissitemap'));
                    ?>
                </form>
            </div>

            <div class="aegissitemap-robots-right">
                <div class="aegissitemap-panel">
                    <h2><?php echo esc_html__('Robots.txt Preview', 'aegissitemap'); ?></h2>
                    <p class="aegissitemap-help"><?php echo esc_html__('This is the robots.txt content AegisSitemap will serve (and optionally write to /robots.txt).', 'aegissitemap'); ?></p>
                    <div class="aegissitemap-pre"><?php echo esc_html($preview !== '' ? $preview : "# Robots manager is currently disabled.\n# Enable it on the left and click Save.\n"); ?></div>
                </div>

                <div class="aegissitemap-panel">
                    <h2><?php echo esc_html__('robots.txt File Status', 'aegissitemap'); ?></h2>
                    <ul class="aegissitemap-ul">
                        <li><strong><?php echo esc_html__('Path:', 'aegissitemap'); ?></strong> <span class="aegissitemap-mono"><?php echo esc_html($status['path'] ?? (ABSPATH . 'robots.txt')); ?></span></li>
                        <li><strong><?php echo esc_html__('Exists:', 'aegissitemap'); ?></strong> <?php echo !empty($status['exists']) ? esc_html__('Yes', 'aegissitemap') : esc_html__('No', 'aegissitemap'); ?></li>
                        <li><strong><?php echo esc_html__('Writable:', 'aegissitemap'); ?></strong> <?php echo !empty($status['writable']) ? esc_html__('Yes', 'aegissitemap') : esc_html__('No', 'aegissitemap'); ?></li>
                        <li><strong><?php echo esc_html__('Last modified:', 'aegissitemap'); ?></strong>
                            <?php
                                $m = (int) ($status['modified'] ?? 0);
                                echo $m ? esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $m)) : esc_html__('—', 'aegissitemap');
                            ?>
                        </li>
                    </ul>
                    <p class="aegissitemap-help"><?php echo esc_html__('If your host blocks writing to the site root, AegisSitemap will still serve robots.txt virtually via WordPress.', 'aegissitemap'); ?></p>
                </div>
            </div>
        </div>

        <script>
        (function(){
            function escHtml(s){ return String(s).replace(/[&<>"']/g, function(c){ return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c]); }); }

            var input = document.getElementById('aegissitemap-robots-exclude-input');
            var addBtn = document.getElementById('aegissitemap-robots-exclude-add-btn');
            var list = document.getElementById('aegissitemap-robots-excluded-list');

            if (!input || !addBtn || !list) return;

            function addItem(val){
                val = (val || '').trim();
                if (!val) return;

                var existing = list.parentNode.querySelectorAll('input.aegissitemap-robots-exclude-hidden');
                for (var i=0;i<existing.length;i++){
                    if (existing[i].value === val) return;
                }

                var li = document.createElement('li');
                li.className = 'aegissitemap-inline-row';
                li.style.margin = '6px 0';
                li.innerHTML = '<span class="aegissitemap-pill aegissitemap-mono">' + escHtml(val) + '</span>' +
                               '<button type="button" class="button-link-delete aegissitemap-robots-exclude-remove" data-val="' + escHtml(val) + '">Remove</button>';
                list.appendChild(li);

                var hidden = document.createElement('input');
                hidden.type = 'hidden';
                hidden.className = 'aegissitemap-robots-exclude-hidden';
                hidden.name = '<?php echo esc_js(\AegisSitemap\Utils\Options::OPTION_KEY); ?>[robots_excluded_dirs][]';
                hidden.value = val;
                list.parentNode.appendChild(hidden);
            }

            addBtn.addEventListener('click', function(){
                addItem(input.value);
                input.value = '';
                input.focus();
            });

            list.addEventListener('click', function(e){
                var t = e.target;
                if (!t || !t.classList.contains('aegissitemap-robots-exclude-remove')) return;
                e.preventDefault();
                var val = t.getAttribute('data-val') || '';
                var li = t.closest('li');
                if (li) li.parentNode.removeChild(li);

                var hidden = list.parentNode.querySelectorAll('input.aegissitemap-robots-exclude-hidden');
                for (var i=0;i<hidden.length;i++){
                    if (hidden[i].value === val) {
                        hidden[i].parentNode.removeChild(hidden[i]);
                        break;
                    }
                }
            });
        })();
        </script>


    <?php else: ?>

		<?php
			$is_pro = false;
			if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license) {
				$is_pro = (bool) aegissitemap()->license->is_pro();
			}
		?>



				<style>
					.aegissitemap-sitemap-grid{display:flex;gap:16px;align-items:flex-start;box-sizing:border-box;padding-right:20px}
					.aegissitemap-sitemap-grid > form{
						display:flex;
						gap:16px;
						align-items:flex-start;
						width:100%;
					}
					.aegissitemap-sitemap-left{flex:0 0 30%;max-width:30%}
					.aegissitemap-sitemap-right{flex:0 0 70%;max-width:70%}
					@media (max-width: 1100px){
						.aegissitemap-sitemap-grid{flex-direction:column}
						.aegissitemap-sitemap-left,.aegissitemap-sitemap-right{flex:0 0 auto;max-width:100%}
					}
					.aegissitemap-sitemap-panel{background:#fff;border:1px solid #dcdcde;border-radius:10px;padding:14px}
					.aegissitemap-sitemap-panel h2{margin:0 0 10px 0}
					.aegissitemap-sitemap-mini{font-size:12px;color:#646970}
					.aegissitemap-sitemap-table{width:100%;border-collapse:collapse}
					.aegissitemap-sitemap-table th,.aegissitemap-sitemap-table td{border-bottom:1px solid #f0f0f1;padding:8px;vertical-align:top;text-align:left}
					.aegissitemap-pill{display:inline-block;padding:2px 8px;border-radius:999px;background:#f6f7f7;border:1px solid #dcdcde;font-size:12px}
					.aegissitemap-ok{background:#edfaef;border-color:#68de7c}
					.aegissitemap-bad{background:#fff2f0;border-color:#ffb3ad}
					.aegissitemap-mono{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,"Liberation Mono","Courier New",monospace;font-size:12px}
					.aegissitemap-ul{margin:8px 0 0 18px}

					.aegissitemap-inline-row{display:flex;gap:10px;align-items:center;flex-wrap:wrap;margin-top:8px}
					.aegissitemap-box{background:#fff;border:1px solid #dcdcde;border-radius:10px;padding:12px;margin-top:12px;margin-bottom:12px}
					.aegissitemap-box h3{margin:0 0 8px 0}
					.aegissitemap-help{font-size:12px;color:#646970;margin:6px 0 0 0}
					.aegissitemap-chip{display:inline-block;background:#f6f7f7;border:1px solid #dcdcde;border-radius:999px;padding:2px 8px;font-size:12px;margin:4px 6px 0 0}
					.aegissitemap-chip button{margin-left:6px}
					.aegissitemap-pro-locked-wrap{opacity:0.55}

					/* PRO upsell banner (match pro.png look/feel) */
					.aegissitemap-pro-banner{background:#fff;border:1px solid #dcdcde;border-radius:0;padding:12px;margin:0 0 12px 0}
					.aegissitemap-pro-banner .aegissitemap-pro-banner-title{font-weight:600}
					.aegissitemap-pro-banner .aegissitemap-pro-banner-text{margin:0 0 10px 0}
					.aegissitemap-pro-banner .button{margin-top:2px}
				</style>

				<?php if (!$is_pro && $tab === 'sitemap'): ?>
					<div class="aegissitemap-pro-banner">
						<p class="aegissitemap-pro-banner-text">
							<span class="aegissitemap-pro-banner-title"><?php echo esc_html__('PRO Feature:', 'aegissitemap'); ?></span>
							<?php echo esc_html__('Sitemap controls are view-only in the free version. Activate a license to unlock editing, exclusions, automation, and settings.', 'aegissitemap'); ?>
						</p>
						<a class="button button-primary" href="<?php echo esc_url(admin_url('admin.php?page=aegissitemap&tab=license')); ?>">
							<?php echo esc_html__('Activate License', 'aegissitemap'); ?>
						</a>
					</div>
				<?php endif; ?>

				<div class="aegissitemap-sitemap-grid">
					<form method="post" action="options.php">
						<div class="aegissitemap-sitemap-left">
							<?php
								settings_fields('aegissitemap_settings_group');
								do_settings_sections('aegissitemap_' . $tab);

								$opts = get_option('aegissitemap_settings', array());
								$saved_plugins = array();
								if (!empty($opts['sitemap_plugins']) && is_array($opts['sitemap_plugins'])) {
									foreach ($opts['sitemap_plugins'] as $p) {
										$p = is_string($p) ? trim($p) : '';
										if ($p !== '') $saved_plugins[] = $p;
									}
									$saved_plugins = array_values(array_unique($saved_plugins));
								}

								$folder_ex = isset($opts['sitemap_folder_exclusions']) ? (string) $opts['sitemap_folder_exclusions'] : '';
							?>

						<script>
						document.addEventListener('DOMContentLoaded', function () {
							(function(){
								var isPro = <?php echo $is_pro ? 'true' : 'false'; ?>;
								function chipExists(val){
									var chips = document.querySelectorAll('#aegissitemap-plugin-chips .aegissitemap-chip');
									for (var i=0;i<chips.length;i++){
										if (chips[i].getAttribute('data-plugin') === val) return true;
									}
									return false;
								}

								var addBtn = document.getElementById('aegissitemap-add-plugin-btn');
								var picker = document.getElementById('aegissitemap-plugin-picker');
								var chipsWrap = document.getElementById('aegissitemap-plugin-chips');

								if (!isPro){
									if (addBtn) addBtn.disabled = true;
									if (picker) picker.disabled = true;
									// Disable existing remove buttons.
									var rms = document.querySelectorAll('#aegissitemap-plugin-chips .aegissitemap-remove-plugin');
									for (var r=0;r<rms.length;r++){ rms[r].disabled = true; rms[r].style.pointerEvents='none'; }
								}

								if (addBtn && picker && chipsWrap){
									addBtn.addEventListener('click', function(){
										if (!isPro) return;
										var val = picker.value;
										if (!val) return;
										if (chipExists(val)) return;

										var span = document.createElement('span');
										span.className = 'aegissitemap-chip';
										span.setAttribute('data-plugin', val);

										var txt = document.createTextNode(val + ' ');
										span.appendChild(txt);

										var rm = document.createElement('button');
										rm.type = 'button';
										rm.className = 'button-link-delete aegissitemap-remove-plugin';
										rm.setAttribute('aria-label', 'Remove');
										rm.textContent = '×';
										span.appendChild(rm);

										var hidden = document.createElement('input');
										hidden.type = 'hidden';
										hidden.name = 'aegissitemap_settings[sitemap_plugins][]';
										hidden.value = val;
										span.appendChild(hidden);

										chipsWrap.appendChild(span);
									});

									chipsWrap.addEventListener('click', function(e){
									if (!isPro) return;
									if (e.target && e.target.classList.contains('aegissitemap-remove-plugin')){
											var chip = e.target.closest('.aegissitemap-chip');
											if (chip) chip.remove();
										}
									});
								}

								(function(){
									var input = document.getElementById('aegissitemap-exclude-folder-input');
									var addBtn = document.getElementById('aegissitemap-add-folder-exclusion-btn');
									var textarea = document.getElementById('aegissitemap-folder-exclusions');
									var chips = document.getElementById('aegissitemap-folder-exclusion-chips');

									if (!input || !addBtn || !textarea || !chips) return;

								if (!isPro){
									input.disabled = true;
									addBtn.disabled = true;
									textarea.disabled = true;
									chips.style.pointerEvents='none';
								}

									function normalize(val){
										val = (val || '').trim();
										if (!val) return '';
										val = val.replace(/^https?:\/\/[^/]+/i, '');
										if (val[0] !== '/') val = '/' + val;
										val = val.replace(/\/+$/,''); // trim trailing slash
										return val;
									}

									function getLines(){
										var raw = textarea.value || '';
										return raw.split(/\r?\n/).map(function(x){ return x.trim(); }).filter(Boolean);
									}

									function setLines(lines){
										textarea.value = lines.join("\n");
										renderChips(lines);
									}

									function renderChips(lines){
										chips.innerHTML = '';
										lines.forEach(function(l){
											var n = normalize(l);
											if (!n) return;

											var span = document.createElement('span');
											span.className = 'aegissitemap-chip';
											span.setAttribute('data-folder', n);
											span.textContent = n + ' ';

											var btn = document.createElement('button');
											btn.type = 'button';
											btn.className = 'button-link-delete';
											btn.textContent = '×';
											btn.setAttribute('aria-label', 'Remove');

											btn.addEventListener('click', function(){
												var current = getLines().map(normalize).filter(Boolean);
												current = current.filter(function(x){ return x !== n; });
												setLines(current);
											});

											span.appendChild(btn);
											chips.appendChild(span);
										});
									}

									renderChips(getLines().map(normalize).filter(Boolean));

								addBtn.addEventListener('click', function(){
									if (!isPro) return;
										var val = normalize(input.value);
										if (!val) return;

										var current = getLines().map(normalize).filter(Boolean);
										if (current.indexOf(val) === -1){
											current.push(val);
											setLines(current);
										}
										input.value = '';
									});
								})();
							})();
						});
						</script>
						<?php submit_button(); ?>
					</div>

					<div class="aegissitemap-sitemap-right <?php echo !$is_pro ? 'aegissitemap-pro-locked-wrap' : ''; ?>">

						<div class="aegissitemap-box">
							<h3><?php echo esc_html__('Plugins', 'aegissitemap'); ?></h3>
							<p class="aegissitemap-help"><?php echo esc_html__('Add a plugin to auto-include its known content types in the sitemap. WooCommerce is supported by default.', 'aegissitemap'); ?></p>

							<?php
							if (!function_exists('get_plugins')) {
								require_once ABSPATH . 'wp-admin/includes/plugin.php';
							}
							$all_plugins = function_exists('get_plugins') ? get_plugins() : array();
							?>

							<div class="aegissitemap-inline-row">
								<select id="aegissitemap-plugin-picker">
									<option value=""><?php echo esc_html__('-- Select a plugin --', 'aegissitemap'); ?></option>
									<?php foreach ($all_plugins as $file => $data): ?>
										<option value="<?php echo esc_attr($file); ?>">
											<?php echo esc_html($data['Name'] . ' (' . $file . ')'); ?>
										</option>
									<?php endforeach; ?>
								</select>

								<button type="button" class="button" id="aegissitemap-add-plugin-btn">
									<?php echo esc_html__('Add Plugin', 'aegissitemap'); ?>
								</button>
							</div>

							<div id="aegissitemap-plugin-chips">
								<input type="hidden" name="aegissitemap_settings[sitemap_plugins_present]" value="1" />
								<?php if (!empty($saved_plugins)): ?>
									<?php foreach ($saved_plugins as $p): ?>
										<span class="aegissitemap-chip" data-plugin="<?php echo esc_attr($p); ?>">
											<?php echo esc_html($p); ?>
											<button type="button" class="button-link-delete aegissitemap-remove-plugin" aria-label="<?php echo esc_attr__('Remove', 'aegissitemap'); ?>">×</button>
											<input type="hidden" name="aegissitemap_settings[sitemap_plugins][]" value="<?php echo esc_attr($p); ?>" />
										</span>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
						</div>

						<div class="aegissitemap-box">
							<h3><?php echo esc_html__('Folder Exclusions', 'aegissitemap'); ?></h3>
							<p class="aegissitemap-help"><?php echo esc_html__('One per line. Any sitemap URL containing one of these path fragments will be excluded. Examples: /private/, /wp-content/uploads/tmp, /downloads/', 'aegissitemap'); ?></p>
							<div class="aegissitemap-inline-row" style="margin:10px 0;">
								<input type="text"
									id="aegissitemap-exclude-folder-input"
									placeholder="<?php echo esc_attr__('/private/  (example)', 'aegissitemap'); ?>"
									style="flex:1;min-width:260px;" />

								<button type="button" class="button" id="aegissitemap-add-folder-exclusion-btn">
									<?php echo esc_html__('Exclude Folder', 'aegissitemap'); ?>
								</button>
							</div>
							<p class="aegissitemap-help" style="margin-top:0;">
								<?php echo esc_html__('Tip: Use a path fragment. Anything containing it will be excluded from ALL sitemap XML outputs.', 'aegissitemap'); ?>
							</p>
							<textarea id="aegissitemap-folder-exclusions"
								name="aegissitemap_settings[sitemap_folder_exclusions]"
								rows="6"
								style="width:100%;"><?php echo esc_textarea($folder_ex); ?></textarea>

							<div id="aegissitemap-folder-exclusion-chips" style="margin-top:10px;"></div>
						</div>

						<?php
						if (class_exists('\\AegisSEO\\SEO\\Sitemap') && method_exists('\\AegisSEO\\SEO\\Sitemap', 'render_sitemap_inventory_panel')) {
							\AegisSitemap\SEO\Sitemap::render_sitemap_inventory_panel();
						}
						?>

					</div>
					</form>
				</div>
				

    <?php endif; ?>

</div>
