<?php
if (!defined('ABSPATH')) { exit; }

if (!current_user_can('manage_options')) { return; }

$notice = array('type' => '', 'message' => '');

$license_key   = '';
$license_email = '';
$status        = array();
$free_optin  = (int) get_option('aegissitemap_free_reg_optin', 0);
$free_status = (string) get_option('aegissitemap_free_reg_status', 'unregistered');

if (!function_exists('aegissitemap_clm_post')) {
	function aegissitemap_clm_post(string $endpoint, array $body): array {
		$args = array(
			'timeout' => 20,
			'headers' => array('Content-Type' => 'application/json'),
			'body'    => wp_json_encode($body),
		);

		$resp = wp_remote_post($endpoint, $args);

		if (is_wp_error($resp)) {
			return array('success' => false, 'message' => $resp->get_error_message());
		}

		$code = (int) wp_remote_retrieve_response_code($resp);
		$raw  = (string) wp_remote_retrieve_body($resp);
		$data = json_decode($raw, true);

		if (!is_array($data)) {
			return array(
				'success' => false,
				'message' => 'Invalid response from license server.',
				'http_code' => $code,
				'raw' => $raw,
			);
		}

		if (!isset($data['success'])) {
			$data['success'] = ($code >= 200 && $code < 300);
		}

		return $data;
	}
}

if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license) {
    if (method_exists(aegissitemap()->license, 'get_key')) {
        $license_key = (string) aegissitemap()->license->get_key();
    } else {
        $license_key = (string) get_option('aegissitemap_license_key', '');
    }

    if (method_exists(aegissitemap()->license, 'get_email')) {
        $license_email = (string) aegissitemap()->license->get_email();
    } else {
        $license_email = (string) get_option('aegissitemap_license_email', '');
    }

    if (method_exists(aegissitemap()->license, 'get_cached_status')) {
        $status = (array) aegissitemap()->license->get_cached_status();
    }
} else {
    $license_key   = (string) get_option('aegissitemap_license_key', '');
    $license_email = (string) get_option('aegissitemap_license_email', '');
    $status        = (array) get_option('aegissitemap_license_status_cache', array());
}

if (!empty($_POST) && isset($_POST['aegissitemap_license_action'])) {
    check_admin_referer('aegissitemap_license_action');

    $posted_key   = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
    $posted_email = isset($_POST['license_email']) ? sanitize_email(wp_unslash($_POST['license_email'])) : '';

    update_option('aegissitemap_license_key', $posted_key);
    update_option('aegissitemap_license_email', $posted_email);

    $license_key   = $posted_key;
    $license_email = $posted_email;

    if (isset($_POST['aegissitemap_register_free_install'])) {

        $consent = isset($_POST['aegissitemap_free_reg_consent']) && wp_unslash($_POST['aegissitemap_free_reg_consent']) === '1';

        if (!$consent) {
            $notice['type']    = 'error';
            $notice['message'] = __('Please confirm consent before registering this installation.', 'aegissitemap');
        } else {

            update_option('aegissitemap_free_reg_optin', 1);

            $ok = false;

            if (function_exists('aegissitemap_clm_register_free_install')) {
                $resp = aegissitemap_clm_register_free_install(true);
                if (is_array($resp) && !empty($resp['success'])) {
                    $ok = true;
                }
            }

            if ($ok) {
                update_option('aegissitemap_free_reg_status', 'registered');
                $notice['type']    = 'success';
                $notice['message'] = __('Registered successfully with Aegisify.', 'aegissitemap');
            } else {
                update_option('aegissitemap_free_reg_status', 'error');
				$last_error = (string) get_option('aegissitemap_clm_free_reg_last_error', '');

				$notice['type']    = 'error';
				$notice['message'] = !empty($last_error)
					? $last_error
					: __('Registration failed. Please try again. Check /includes/log/aegissitemap.log for details.', 'aegissitemap');
            }

            $free_optin  = (int) get_option('aegissitemap_free_reg_optin', 0);
            $free_status = (string) get_option('aegissitemap_free_reg_status', 'unregistered');
        }
    }

    if (isset($_POST['aegissitemap_unregister_free_install'])) {

        update_option('aegissitemap_free_reg_optin', 0);
        update_option('aegissitemap_free_reg_status', 'unregistered');

        $notice['type']    = 'success';
        $notice['message'] = __('Free-install registration set to Unregistered.', 'aegissitemap');

        $free_optin  = (int) get_option('aegissitemap_free_reg_optin', 0);
        $free_status = (string) get_option('aegissitemap_free_reg_status', 'unregistered');
    }

	if (isset($_POST['aegissitemap_activate_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '',
		);

		$res = aegissitemap_clm_post(AEGISSITEMAP_CLM_ACTIVATE_ENDPOINT, $payload);

		// HARD RULE: Email must match the license email on CLM. If CLM returns an email field and it
		// does not match what the user entered, we treat this as a failed activation.
		$server_email = '';
		foreach (array('email','customer_email','license_email','registered_email','billing_email') as $k) {
			if (!empty($res[$k]) && is_string($res[$k])) { $server_email = (string) $res[$k]; break; }
		}
		if ($server_email !== '' && $posted_email !== '' && strcasecmp(trim($server_email), trim($posted_email)) !== 0) {
			$res['success'] = false;
			$res['status']  = 'email_mismatch';
			$res['message'] = 'Email mismatch: the license email must match the email used at checkout.';
		}

		update_option('aegissitemap_license_status_cache', $res);
		if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license) {
			aegissitemap()->license->check_now(defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Activation completed.');
	}

	if (isset($_POST['aegissitemap_deactivate_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '',
		);

		$res = aegissitemap_clm_post(AEGISSITEMAP_CLM_DEACTIVATE_ENDPOINT, $payload);

		update_option('aegissitemap_license_status_cache', $res);
		if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license) {
			aegissitemap()->license->check_now(defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Deactivation completed.');
	}

	if (isset($_POST['aegissitemap_check_license'])) {

		$payload = array(
			'license_key' => $posted_key,
			'email'       => $posted_email,
			'site_url'    => home_url(),
			'version'     => defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '',
		);

		$res = aegissitemap_clm_post(AEGISSITEMAP_CLM_STATUS_ENDPOINT, $payload);

		update_option('aegissitemap_license_status_cache', $res);
		if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license) {
			aegissitemap()->license->check_now(defined('AEGISSITEMAP_VERSION') ? (string) AEGISSITEMAP_VERSION : '');
		}

		$notice['type']    = !empty($res['success']) ? 'success' : 'error';
		$notice['message'] = (string) ($res['message'] ?? 'Status updated.');
	}

    if (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license && method_exists(aegissitemap()->license, 'get_cached_status')) {
        $status = (array) aegissitemap()->license->get_cached_status();
    } else {
        $status = (array) get_option('aegissitemap_license_status_cache', $status);
    }

	$current_page = isset($_GET['page']) ? sanitize_key(wp_unslash($_GET['page'])) : 'aegissitemap';

	$redirect_url = add_query_arg(
		array(
			'page' => $current_page,
			'tab'  => 'license',
		),
		admin_url('admin.php')
	);

	if (!headers_sent()) {
		wp_safe_redirect($redirect_url);
		exit;
	}

	echo '<script>window.location.href=' . wp_json_encode($redirect_url) . ';</script>';
	exit;
}

$suite_pro = (function_exists('aegisify_is_pro') && aegisify_is_pro(true));

$is_pro = false;
if ($suite_pro) {
    $is_pro = true;

    if (!isset($status['status']) || (string)$status['status'] === '' || (string)$status['status'] === '—') {
        $status['status'] = 'active';
    }
    if (!isset($status['plan']) || (string)$status['plan'] === '' || (string)$status['plan'] === '—') {
        $status['plan'] = 'pro';
    }
} elseif (function_exists('aegissitemap') && isset(aegissitemap()->license) && aegissitemap()->license && method_exists(aegissitemap()->license, 'is_pro')) {
    $is_pro = (bool) aegissitemap()->license->is_pro();
} elseif (!empty($status['is_pro'])) {
    $is_pro = true;
}

?>
<div class="aegissitemap-card">
    <h2><?php echo esc_html__('License', 'aegissitemap'); ?></h2>

    <?php if (!empty($notice['message'])): ?>
        <div class="notice notice-<?php echo esc_attr($notice['type']); ?> is-dismissible">
            <p><?php echo esc_html($notice['message']); ?></p>
        </div>
    <?php endif; ?>

    <div style="margin:10px 0 14px;color:#50575e;font-size:13px;">
        <?php echo esc_html__('Enter your license key and the email used at checkout. Activate to unlock PRO features and updates.', 'aegissitemap'); ?>
    </div>

    <form method="post">
        <?php wp_nonce_field('aegissitemap_license_action'); ?>
        <input type="hidden" name="aegissitemap_license_action" value="1" />

        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="aegissitemap_license_key"><?php echo esc_html__('License Key', 'aegissitemap'); ?></label>
                    </th>
                    <td>
                        <input type="text"
                               id="aegissitemap_license_key"
                               name="license_key"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_key); ?>"
                               autocomplete="off" />
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="aegissitemap_license_email"><?php echo esc_html__('License Email', 'aegissitemap'); ?></label>
                    </th>
                    <td>
                        <input type="email"
                               id="aegissitemap_license_email"
                               name="license_email"
                               class="regular-text"
                               style="width:420px;"
                               value="<?php echo esc_attr($license_email); ?>"
                               autocomplete="email" />
                    </td>
                </tr>
            </tbody>
        </table>

        <p>
            <button type="submit" class="button button-primary" name="aegissitemap_activate_license" value="1">
                <?php echo esc_html__('Activate License', 'aegissitemap'); ?>
            </button>

            <?php
            $confirm = __('Deactivate this license on this site?', 'aegissitemap');
            ?>
            <button type="submit"
                    class="button"
                    name="aegissitemap_deactivate_license"
                    value="1"
                    onclick="return confirm('<?php echo esc_js( $confirm ); ?>');">
                <?php echo esc_html__('Deactivate', 'aegissitemap'); ?>
            </button>

            <button type="submit" class="button button-secondary" name="aegissitemap_check_license" value="1">
                <?php echo esc_html__('Check Status', 'aegissitemap'); ?>
            </button>
        </p>

        <hr style="margin:18px 0;" />

        <?php if (trim($license_key) !== '' || $is_pro): ?>
            <div class="notice notice-info" style="margin:0 0 12px 0;">
                <p><?php echo esc_html__('Free-install registration is optional telemetry and has nothing to do with licensing. Since you entered/activated a license, you do not need to register this free installation.', 'aegissitemap'); ?></p>
            </div>
        <?php else: ?>

        <h3 style="margin:0 0 6px 0;"><?php echo esc_html__('Optional: Register this free installation', 'aegissitemap'); ?></h3>

        <p class="description" style="margin:0 0 10px 0;">
            <?php
            echo esc_html__(
                'This is optional and if you want update checks and license-related features through Aegisify, you can register this free installation.  This will send your site domain, site URL, and the WordPress admin email to Aegisify. Your information will never leave our database nor be sold to any 3rd party.',
                'aegissitemap'
            );
            ?>
        </p>

        <label style="display:block; margin:0 0 10px 0;">
            <input type="checkbox"
                   name="aegissitemap_free_reg_consent"
                   value="1"
                   <?php checked(1, $free_optin); ?> />
            <?php echo esc_html__('I consent to send the data described above to Aegisify.', 'aegissitemap'); ?>
        </label>

        <p style="margin:0 0 10px 0;">
            <strong><?php echo esc_html__('Registration Status:', 'aegissitemap'); ?></strong>
            <?php if ($free_status === 'registered'): ?>
                <span style="color:#0a7b34; font-weight:600;"><?php echo esc_html__('Registered', 'aegissitemap'); ?></span>
            <?php elseif ($free_status === 'error'): ?>
                <span style="color:#b32d2e; font-weight:600;"><?php echo esc_html__('Error', 'aegissitemap'); ?></span>
            <?php else: ?>
                <span style="color:#555; font-weight:600;"><?php echo esc_html__('Unregistered', 'aegissitemap'); ?></span>
            <?php endif; ?>
        </p>

        <p style="margin:0;">
            <?php if ($free_status !== 'registered'): ?>
                <button type="submit" class="button" name="aegissitemap_register_free_install" value="1">
                    <?php echo esc_html__('Register Free Installation', 'aegissitemap'); ?>
                </button>
            <?php else: ?>
                <button type="submit" class="button" name="aegissitemap_unregister_free_install" value="1">
                    <?php echo esc_html__('Unregister Free Installation', 'aegissitemap'); ?>
                </button>
            <?php endif; ?>
        </p>

        <?php endif; ?>

    </form>
<hr />

<h4>
    <?php echo esc_html__( 'Create an account on', 'aegissitemap' ); ?>
    <a href="<?php echo esc_url( 'https://aegisify.com/register/' ); ?>" target="_blank" rel="noopener noreferrer">
        <?php echo esc_html( 'https://aegisify.com/register/' ); ?>
    </a>
    <?php echo esc_html__( 'to get the latest updates.  Please help support Aegisify by buying a license today!!', 'aegissitemap' ); ?>
</h4>
<hr />

    <h3><?php echo esc_html__('Status', 'aegissitemap'); ?></h3>
    <table class="widefat striped">
        <tbody>
            <tr>
                <th><?php echo esc_html__('Tier', 'aegissitemap'); ?></th>
                <td><?php echo esc_html($is_pro ? 'PRO' : 'FREE'); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('License Status', 'aegissitemap'); ?></th>
                <td><?php echo esc_html((string)($status['status'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Plan', 'aegissitemap'); ?></th>
                <td><?php echo esc_html((string)($status['plan'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Expires', 'aegissitemap'); ?></th>
                <td><?php echo esc_html((string)($status['expires'] ?? '—')); ?></td>
            </tr>
            <tr>
                <th><?php echo esc_html__('Last Checked', 'aegissitemap'); ?></th>
                <td>
                    <?php
                    $checked_at = isset($status['checked_at']) ? (int) $status['checked_at'] : 0;
                    echo esc_html($checked_at ? date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $checked_at) : '—');
                    ?>
                </td>
            </tr>
        </tbody>
    </table>
    </table>

</div>

