<?php
if (!defined('WP_UNINSTALL_PLUGIN')) { exit; }

global $wpdb;

if (!is_object($wpdb)) { return; }

$tables = array(
    $wpdb->prefix . 'asg_events',
    $wpdb->prefix . 'asg_fingerprints',
    $wpdb->prefix . 'asg_lists',
    $wpdb->prefix . 'asg_ml_tokens',
    $wpdb->prefix . 'asg_firewall_events',
);

foreach ($tables as $t) {
    // DROP is a schema change; use identifier placeholder when supported.
    if (method_exists($wpdb, 'has_cap') && $wpdb->has_cap('identifier_placeholders')) {
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
        $wpdb->query($wpdb->prepare('DROP TABLE IF EXISTS %i', $t));
	} else {
		$t_safe = preg_replace('/[^A-Za-z0-9_]/', '', (string) $t);
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.NotPrepared -- Identifier placeholder (%i) not available; identifier is sanitized before use.
		$wpdb->query('DROP TABLE IF EXISTS `' . $t_safe . '`');
	}
}
