(function($){
  function openDrawer(btn){
    var id = $(btn).data('asg-id');
    var $drawer = $('#asg-drawer');
    if (!$drawer.length) return;

    var meta = {
      id: id,
      time: $(btn).data('asg-time'),
      type: $(btn).data('asg-type'),
      action: $(btn).data('asg-action'),
      score: $(btn).data('asg-score'),
      fingerprint: $(btn).data('asg-fp'),
      email_hash: $(btn).data('asg-email')
    };

    var reasons = $('.asg-hidden-reasons[data-asg-id="'+id+'"]').val() || '';
    var payload  = $('.asg-hidden-payload[data-asg-id="'+id+'"]').val() || '';

    $('#asg-drawer-meta').html(
      '<div class="asg-meta-grid">'+
        '<div><strong>ID</strong><div>'+escapeHtml(String(meta.id))+'</div></div>'+
        '<div><strong>Time</strong><div>'+escapeHtml(String(meta.time||''))+'</div></div>'+
        '<div><strong>Type</strong><div>'+escapeHtml(String(meta.type||''))+'</div></div>'+
        '<div><strong>Action</strong><div>'+escapeHtml(String(meta.action||''))+'</div></div>'+
        '<div><strong>Score</strong><div>'+escapeHtml(String(meta.score||''))+'</div></div>'+
        '<div><strong>Fingerprint</strong><div class="asg-mono">'+escapeHtml(String(meta.fingerprint||''))+'</div></div>'+
        '<div><strong>Email hash</strong><div class="asg-mono">'+escapeHtml(String(meta.email_hash||''))+'</div></div>'+
      '</div>'
    );

    $('#asg-drawer-reasons').text(reasons);
    $('#asg-drawer-payload').text(payload);

    $drawer.attr('aria-hidden','false').addClass('is-open');
    $('body').addClass('asg-drawer-open');
  }

  function closeDrawer(){
    var $drawer = $('#asg-drawer');
    $drawer.attr('aria-hidden','true').removeClass('is-open');
    $('body').removeClass('asg-drawer-open');
  }

  function escapeHtml(str){
    return str.replace(/[&<>"']/g, function(m){
      return ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m]);
    });
  }

  $(document).on('click', '.asg-view', function(e){
    e.preventDefault();
    openDrawer(this);
  });

  $(document).on('click', '[data-asg-close]', function(e){
    e.preventDefault();
    closeDrawer();
  });

  $(document).on('change', '.asg-checkmark input[type="checkbox"]', function(){
    var $wrap = $(this).closest('.asg-checkmark');
    $wrap.find('.asg-checkmark__text').text(this.checked ? 'Enabled' : 'Disabled');
  });

  $(document).on('keydown', function(e){
    if (e.key === 'Escape') closeDrawer();
  });

  
  function updateBulkBar(){
    var c = $('.asg-select:checked').length;
    $('#asg-selected-count').text(c);
    if (c>0){ $('#asg-bulkbar').show(); } else { $('#asg-bulkbar').hide(); }
  }

  function renderBreakdown($card){
    var bd = $card.data('asg-breakdown');
    var score = $card.find('.asg-badge--score').text();
    var id = $card.data('asg-id');

    $('#asg-wh-id').text('#'+id);
    $('#asg-wh-score').text(score);

    var $box = $('#asg-wh-breakdown');
    $box.empty();

    if (!bd || !bd.length){
      $box.append('<div class="asg-muted">No breakdown data was recorded for this event.</div>');
    } else {
      bd.forEach(function(it){
        var code = it.code || '';
        var pts = (typeof it.points !== 'undefined') ? it.points : 0;
        var cls = (pts>=0) ? 'asg-wh-pos' : 'asg-wh-neg';
        $box.append(
          '<div class="asg-wh-item">'+
            '<span class="asg-wh-code">'+ $('<div>').text(code).html() +'</span>'+
            '<span class="asg-wh-points '+cls+'">'+ pts +'</span>'+
          '</div>'
        );
      });
    }
    $('#asg-whathappened-empty').hide();
    $('#asg-whathappened').show();
  }

  $(document).on('change', '.asg-select', function(){
    updateBulkBar();
    var $card = $(this).closest('.asg-log-card');
    renderBreakdown($card);
  });

  $(document).on('click', '.asg-toggle-details', function(){
    var $btn = $(this);
    var $card = $btn.closest('.asg-log-card');
    var $body = $card.find('.asg-log-card__body').first();
    var open = $body.is(':visible');
    $('.asg-log-card__body').hide();
    $('.asg-toggle-details').attr('aria-expanded','false');
    if (!open){
      $body.show();
      $btn.attr('aria-expanded','true');
      renderBreakdown($card);
    } else {
      $body.hide();
      $btn.attr('aria-expanded','false');
    }
  });

  $(function(){
    updateBulkBar();
  });


})(jQuery);
