<?php
if (!defined('WP_UNINSTALL_PLUGIN')) { exit; }

global $wpdb;
$tables = array(
    $wpdb->prefix . 'asg_events',
    $wpdb->prefix . 'asg_fingerprints',
    $wpdb->prefix . 'asg_lists',
    $wpdb->prefix . 'asg_ml_tokens',
);

foreach ($tables as $t) {
    $wpdb->query("DROP TABLE IF EXISTS {$t}");
}

delete_option('asg_settings');
delete_option('asg_ml_totals');

$timestamp = wp_next_scheduled('asg_daily_cleanup');
if ($timestamp) {
    wp_unschedule_event($timestamp, 'asg_daily_cleanup');
}
