<?php
/**
 * Plugin Name: AegisSpamGuard
 * Plugin URI: https://aegisify.com/aegisspam
 * Description: Local-first anti-spam protection for WordPress comments, registrations, and Contact Form 7 with transparent scoring, logs, allow/deny lists, and optional lightweight on-site learning.
 * Version: 1.1.6
 * Requires at least: 6.8
 * Requires PHP: 8.2
 * Author:      Aegisify | AegisWAF | AegisShield | AegisSEO
 * Author URI:  https://aegisify.com/
 * License: GPLv2 or later
 * Text Domain: aegisspam
 */

if (!defined('ABSPATH')) { exit; }

define('ASG_VERSION','1.1.6');
define('ASG_PLUGIN_FILE', __FILE__);
define('ASG_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ASG_PLUGIN_URL', plugin_dir_url(__FILE__));

define('ASG_SLUG', 'aegisspam');
define('ASG_PLUGIN_BASENAME', plugin_basename(__FILE__));


if (!defined('AEGISSPAM_BASENAME')) {
    define('AEGISSPAM_BASENAME', ASG_PLUGIN_BASENAME);
}

define('ASG_CLM_BASE', 'https://aegisify.com');
define('ASG_CLM_FREE_REG_ENDPOINT', ASG_CLM_BASE . '/wp-json/chue-license/v1/' . ASG_SLUG . '/free-register');
define('ASG_CLM_UPDATE_ENDPOINT',    ASG_CLM_BASE . '/wp-json/chue-license/v1/' . ASG_SLUG . '/update-check');
define('ASG_CLM_ACTIVATE_ENDPOINT',  ASG_CLM_BASE . '/wp-json/chue-license/v1/' . ASG_SLUG . '/activate');
define('ASG_CLM_STATUS_ENDPOINT',    ASG_CLM_BASE . '/wp-json/chue-license/v1/' . ASG_SLUG . '/status');
define('ASG_CLM_FREE_UNREG_ENDPOINT',ASG_CLM_BASE . '/wp-json/chue-license/v1/' . ASG_SLUG . '/free-unregister');

require_once ASG_PLUGIN_DIR . 'includes/class-asg-core.php';

register_activation_hook(__FILE__, array('ASG_Core', 'activate'));
register_deactivation_hook(__FILE__, array('ASG_Core', 'deactivate'));

add_action('plugins_loaded', function () {
    ASG_Core::instance();
});