<?php
defined('ABSPATH') || exit;

add_action('admin_menu', function () {

    add_menu_page(
        __('AegisTickets', 'aegisticket'),
        __('AegisTickets', 'aegisticket'),
        'view_support_tickets',
        'aegisticket_tickets',
        'aegisticket_admin_open_page',
        'dashicons-sos',
        58
    );

    add_submenu_page(
    'aegisticket',
    'Dashboard',
    'Dashboard',
    'manage_options',
    'aegisticket-dashboard',
    'aegisticket_render_dashboard_page'
);

    add_submenu_page(
        'aegisticket_tickets',
        __('Closed Tickets', 'aegisticket'),
        __('Closed Tickets', 'aegisticket'),
        'view_support_tickets',
        'aegisticket_closed',
        'aegisticket_admin_closed_page'
    );

	add_submenu_page(
		'aegisticket_tickets',
		'Dashboard',
		'Dashboard',
		'view_support_tickets',
		'aegisticket_dashboard',
		'aegisticket_render_dashboard_page'
	);

    add_submenu_page(
        'aegisticket_tickets',
        __('Helper', 'aegisticket'),
        __('Helper', 'aegisticket'),
        'view_support_tickets',
        'aegisticket_helper',
        'aegisticket_admin_helper_page'
    );
	
	if ( class_exists( 'Aegisify_Bundled_Plugins_Page' ) ) {

		Aegisify_Bundled_Plugins_Page::init( array(
			'parent_slug' => 'aegisticket_tickets',          // MUST match AegisTicket top-level slug
			'menu_slug'   => 'aegisify-bundled-plugins',      // keep consistent across products
			'page_title'  => 'Aegisify Plugins',
			'menu_title'  => 'Aegisify Plugins',
			'view_cap'    => 'view_support_tickets',          // match AegisTicket capability
		) );

	}

});

function aegisticket_admin_ticket_table(string $status) {
    if (!current_user_can('view_support_tickets')) {
        wp_die('Access denied.');
    }

    $q = new WP_Query([
        'post_type' => 'support_ticket',
        'post_status' => [$status],
        'posts_per_page' => 50,
        'orderby' => 'date',
        'order' => 'DESC',
    ]);

    echo '<table class="widefat striped"><thead><tr>';
    echo '<th>Ticket #</th><th>User</th><th>Subject</th><th>Priority</th><th>Date</th><th>Has Reply</th><th>Actions</th>';
    echo '</tr></thead><tbody>';

    if (!$q->have_posts()) {
        echo '<tr><td colspan="7">No tickets found.</td></tr>';
    } else {
        while ($q->have_posts()) {
            $q->the_post();
            $id = get_the_ID();
            $num = (int) get_post_meta($id, '_ticket_number', true);
            $pri = (string) get_post_meta($id, '_ticket_priority', true);
            $adm = (int) get_post_meta($id, '_admin_replied', true);
            $author_id = (int) get_post_field('post_author', $id);
            $author = get_userdata($author_id);

            $edit_link = get_edit_post_link($id);
            $view_link = get_permalink($id); // CPT is not public; use edit link
            echo '<tr>';
            echo '<td>'.esc_html($num ?: $id).'</td>';
            echo '<td>'.esc_html($author ? $author->user_login : 'user').'</td>';
            echo '<td>'.esc_html(get_the_title()).'</td>';
            echo '<td>'.esc_html($pri ?: 'medium').'</td>';
            echo '<td>'.esc_html(get_the_date()).'</td>';
            echo '<td>'.esc_html($adm ? 'Yes' : 'No').'</td>';
            echo '<td><a href="'.esc_url($edit_link).'">Open</a></td>';
            echo '</tr>';
        }
        wp_reset_postdata();
    }

    echo '</tbody></table>';
}

function aegisticket_admin_open_page() {
    echo '<div class="wrap"><h1>Open Tickets</h1>';
    aegisticket_admin_ticket_table('open');
    echo '</div>';
}

function aegisticket_admin_closed_page() {
    echo '<div class="wrap"><h1>Closed Tickets</h1>';
    aegisticket_admin_ticket_table('closed');
    echo '</div>';
}

function aegisticket_admin_kb_page() {
    echo '<div class="wrap"><h1>Dashboard</h1>';
    echo '<p></p>';
    echo '</div>';
}


function aegisticket_admin_helper_page() {
    echo '<div class="wrap"><h1>Helper</h1>';
    echo '<p>Quick reference for AegisTicket shortcodes and usage.</p>';
    echo '<hr />';
    echo '<h2>Shortcodes</h2>';
    echo '<ol>';
    echo '<li><code>[support_ticket_form]</code> — Ticket submission form (logged-in users only).</li>';
    echo '<li><code>[my_support_tickets]</code> — Ticket list + inline view/edit/chat on the same page using <code>?support-ticket=###</code>.</li>';
    echo '<li><code>[aegisticket_profile]

[aegisticket_admin_dashboard] — Frontend admin ticket dashboard (list, assign, view/edit inline, reply with attachments, close tickets).</code> — Displays and edits the logged-in user\'s profile details.</li>';
    echo '</ol>';
    echo '<hr />';
    echo '<h2>[support_ticket_form]</h2>';
    echo '<p><strong>Purpose:</strong> Allows logged-in users to submit a new support ticket.</p>';
    echo '<p><strong>Fields:</strong> Subject, Priority, Description (4 lines), File uploads.</p>';
    echo '<p><strong>Usage:</strong> Add to a page:</p><pre><code>[support_ticket_form]</code></pre>';
    echo '<p><strong>Notes:</strong> Uses WordPress upload handling with safe file types and size limits.</p>';
    echo '<hr />';
    echo '<h2>[my_support_tickets]</h2>';
    echo '<p><strong>Purpose:</strong> Shows the logged-in user\'s ticket list with actions View/Edit/Delete.</p>';
    echo '<p><strong>Inline ticket panel:</strong> Clicking View or Edit loads the selected ticket below the list on the same page.</p>';
    echo '<p><strong>URL parameters:</strong></p>';
    echo '<ul>';
    echo '<li><code>?support-ticket=123</code> — View ticket inline.</li>';
    echo '<li><code>?support-ticket=123&amp;mode=edit</code> — Edit ticket inline (ticket must be open and user must own it).</li>';
    echo '</ul>';
    echo '<p><strong>Usage:</strong></p><pre><code>[my_support_tickets]</code></pre>';
    echo '<p><strong>Chat replies:</strong> Displays replies below as a chat thread. Replies are stored as WordPress comments with <code>comment_type=ticket_reply</code>.</p>';
    echo '<hr />';
    echo '<h2>[aegisticket_profile]

[aegisticket_admin_dashboard] — Frontend admin ticket dashboard (list, assign, view/edit inline, reply with attachments, close tickets).</h2>';
    echo '<p><strong>Purpose:</strong> Displays the logged-in user\'s profile details and allows editing.</p>';
    echo '<p><strong>View mode:</strong> First/Last name inline, Username, Email, Password masked, and an Edit button.</p>';
    echo '<p><strong>Edit mode:</strong> Click Edit (adds <code>?profile-edit=1</code>) to switch all fields into edit mode, then Submit to save.</p>';
    echo '<p><strong>Usage:</strong></p><pre><code>[aegisticket_profile]

[aegisticket_admin_dashboard] — Frontend admin ticket dashboard (list, assign, view/edit inline, reply with attachments, close tickets).</code></pre>';
    echo '<p><strong>Password:</strong> Leave blank to keep existing password. If changed, user may need to log in again.</p>';
    echo '</div>';
}



function aegisticket_render_dashboard_page() {
    if (!current_user_can('manage_options')) {
        echo '<div class="wrap"><p>Access denied.</p></div>';
        return;
    }

    $products = get_option('aegisticket_products', []);
    if (!is_array($products)) {
        $products = [];
    }

    $notice = '';

    // ADD (append/merge) product + versions (no overwrite)
    if (
        isset($_POST['aegisticket_action']) &&
        $_POST['aegisticket_action'] === 'add_product' &&
        isset($_POST['_wpnonce']) &&
        wp_verify_nonce($_POST['_wpnonce'], 'aegisticket_save_product')
    ) {
        $name = sanitize_text_field($_POST['product_name'] ?? '');
        $versions_raw = sanitize_text_field($_POST['product_versions'] ?? '');

        if ($name === '' || $versions_raw === '') {
            $notice = '<div class="notice notice-error"><p>Please enter a Product Name and at least one Version.</p></div>';
        } else {
            $new_versions = array_filter(array_map('trim', explode(',', $versions_raw)));
            if (!isset($products[$name]) || !is_array($products[$name])) {
                $products[$name] = [];
            }
            $products[$name] = array_values(array_unique(array_merge($products[$name], $new_versions)));
            update_option('aegisticket_products', $products);
            $notice = '<div class="notice notice-success"><p>Product/version(s) added.</p></div>';
        }
    }

    // Sort for nicer display
    if (!empty($products)) {
        ksort($products, SORT_NATURAL | SORT_FLAG_CASE);
        foreach ($products as $p => $vs) {
            if (is_array($vs)) {
                natsort($vs);
                $products[$p] = array_values($vs);
            }
        }
    }

    echo '<div class="wrap">';
    echo '<h1>AegisTicket Dashboard</h1>';
    echo $notice;

    echo '<h2>Add Product / Versions</h2>';
    echo '<form method="post">';
    wp_nonce_field('aegisticket_save_product');
    echo '<input type="hidden" name="aegisticket_action" value="add_product" />';
    echo '<table class="form-table">';
    echo '<tr><th><label for="aegisticket_product_name">Product Name</label></th><td><input id="aegisticket_product_name" type="text" name="product_name" required placeholder="AegisWAF" class="regular-text" /></td></tr>';
    echo '<tr><th><label for="aegisticket_product_versions">Product Versions</label></th><td><input id="aegisticket_product_versions" type="text" name="product_versions" required placeholder="1.5, 1.6, 1.7" class="regular-text" /><p class="description">Comma-separated. Each version is stored individually.</p></td></tr>';
    echo '</table>';
    echo '<p><button type="submit" class="button button-primary">Add Product</button></p>';
    echo '</form>';

    echo '<h2>Existing Products</h2>';
    if (empty($products)) {
        echo '<p>No products added yet.</p>';
    } else {
        echo '<table class="widefat striped">';
        echo '<thead><tr><th style="width:220px;">Product</th><th>Versions</th></tr></thead><tbody>';
        foreach ($products as $p => $vs) {
            $vs = is_array($vs) ? $vs : [];
            echo '<tr>';
            echo '<td><strong>' . esc_html($p) . '</strong></td>';
            echo '<td>' . esc_html(implode(', ', $vs)) . '</td>';
            echo '</tr>';
        }
        echo '</tbody></table>';
    }

    echo '</div>';
}
