<?php
defined('ABSPATH') || exit;

/**
 * Restrict comments to our ticket reply system, and enforce ownership.
 */

// Ensure only ticket replies are allowed on tickets
add_filter('preprocess_comment', function ($commentdata) {
    $post_id = (int) ($commentdata['comment_post_ID'] ?? 0);
    if (!$post_id) return $commentdata;

    $post = get_post($post_id);
    if (!$post || $post->post_type !== 'support_ticket') return $commentdata;

    // Force our type
    $commentdata['comment_type'] = 'ticket_reply';

    // Must be logged in
    if (!is_user_logged_in()) {
        wp_die('You must be logged in to reply.');
    }

    // Must be owner or agent
    if (!(aegisticket_ticket_can_view($post_id))) {
        wp_die('Access denied.');
    }

    // Must be open
    if (!aegisticket_ticket_is_open($post_id)) {
        wp_die('Ticket is closed.');
    }

    return $commentdata;
});

// Hide default comment form on ticket post type (in case theme renders it somewhere)
add_filter('comments_open', function ($open, $post_id) {
    $post = get_post($post_id);
    if ($post && $post->post_type === 'support_ticket') {
        return false;
    }
    return $open;
}, 10, 2);
