<?php
defined('ABSPATH') || exit;

const AEGISTICKET_CPT = 'support_ticket';

/**
 * Register CPT + statuses
 */
add_action('init', function () {

    register_post_status('open', [
        'label' => _x('Open', 'ticket status', 'aegisticket'),
        'public' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => _n_noop('Open <span class="count">(%s)</span>', 'Open <span class="count">(%s)</span>', 'aegisticket'),
    ]);

    register_post_status('closed', [
        'label' => _x('Closed', 'ticket status', 'aegisticket'),
        'public' => false,
        'show_in_admin_all_list' => true,
        'show_in_admin_status_list' => true,
        'label_count' => _n_noop('Closed <span class="count">(%s)</span>', 'Closed <span class="count">(%s)</span>', 'aegisticket'),
    ]);

    register_post_type(AEGISTICKET_CPT, [
        'labels' => [
            'name' => __('Support Tickets', 'aegisticket'),
            'singular_name' => __('Support Ticket', 'aegisticket'),
            'add_new_item' => __('Add New Ticket', 'aegisticket'),
            'edit_item' => __('Edit Ticket', 'aegisticket'),
            'view_item' => __('View Ticket', 'aegisticket'),
        ],
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => false, // We provide our own menu pages.
        'supports' => ['title', 'editor', 'author', 'revisions'],
        'capability_type' => ['support_ticket', 'support_tickets'],
        'map_meta_cap' => true,
    ]);
});

/**
 * Define custom caps for CPT.
 */
add_filter('register_post_type_args', function ($args, $post_type) {
    if ($post_type !== AEGISTICKET_CPT) return $args;

    $args['capabilities'] = [
        'edit_post' => 'edit_support_ticket',
        'read_post' => 'read_support_ticket',
        'delete_post' => 'delete_support_ticket',
        'edit_posts' => 'edit_support_tickets',
        'edit_others_posts' => 'edit_others_support_tickets',
        'publish_posts' => 'publish_support_tickets',
        'read_private_posts' => 'read_private_support_tickets',
        'delete_posts' => 'delete_support_tickets',
        'delete_private_posts' => 'delete_private_support_tickets',
        'delete_published_posts' => 'delete_published_support_tickets',
        'delete_others_posts' => 'delete_others_support_tickets',
        'edit_private_posts' => 'edit_private_support_tickets',
        'edit_published_posts' => 'edit_published_support_tickets',
        'create_posts' => 'create_support_tickets',
    ];

    return $args;
}, 10, 2);

/**
 * Helpers
 */
function aegisticket_is_agent(): bool {
    return current_user_can('reply_support_tickets') || current_user_can('manage_options');
}

function aegisticket_is_ticket_owner(int $ticket_id): bool {
    $p = get_post($ticket_id);
    if (!$p) return false;
    return (int)$p->post_author === (int)get_current_user_id();
}

function aegisticket_ticket_can_view(int $ticket_id): bool {
    return aegisticket_is_agent() || aegisticket_is_ticket_owner($ticket_id);
}

function aegisticket_ticket_is_open(int $ticket_id): bool {
    $p = get_post($ticket_id);
    return $p && $p->post_status === 'open';
}
