<?php
defined('ABSPATH') || exit;

/**
 * Email notifications
 * - When admin/agent responds: email the ticket owner + mark _admin_replied=1
 * - When user responds: optional email admin
 */
add_action('comment_post', function ($comment_id, $approved, $commentdata = null) {
    $comment = get_comment($comment_id);
    if (!$comment) return;

    $post = get_post($comment->comment_post_ID);
    if (!$post || $post->post_type !== 'support_ticket') return;

    if ($comment->comment_type !== 'ticket_reply') return;

    $ticket_id = (int) $post->ID;
    $ticket_number = (int) get_post_meta($ticket_id, '_ticket_number', true);
    $ticket_number = $ticket_number ?: $ticket_id;

    $ticket_url = ''; // user-configurable (depends on their page)
    // If they use a "view ticket" page, they can pass ?id=; we include ID.
    $ticket_url = add_query_arg(['id' => $ticket_id], home_url('/'));

    $is_agent = $comment->user_id && (user_can($comment->user_id, 'reply_support_tickets') || user_can($comment->user_id, 'manage_options'));

    if ($is_agent) {
        update_post_meta($ticket_id, '_admin_replied', 1);

        $user = get_userdata($post->post_author);
        if ($user && $user->user_email) {
            wp_mail(
                $user->user_email,
                "Support Ticket #{$ticket_number} Updated",
                "An admin has replied to your ticket.\n\nView it here (ensure your view page supports ?id=): {$ticket_url}\n"
            );
        }
    } else {
        // User reply -> email admin (simple)
        $admin_email = get_option('admin_email');
        wp_mail(
            $admin_email,
            "User replied: Ticket #{$ticket_number}",
            "A user replied to a ticket.\n\nTicket ID: {$ticket_id}\n"
        );
    }
}, 10, 3);
