<?php
defined('ABSPATH') || exit;

/**
 * Shortcode: [my_support_tickets]
 * Shows list with View | Edit | Delete
 */
add_shortcode('my_support_tickets', function () {
	
	$active_ticket_id = isset($_GET['support-ticket'])
    ? (int) $_GET['support-ticket']
    : 0;

	$mode = sanitize_text_field($_GET['mode'] ?? '');

    if (!is_user_logged_in()) {
        auth_redirect();
        return '';
    }

    $user_id = get_current_user_id();

    // Delete own reply (comment) for this ticket
    if (
        isset($_GET['aegisticket_action'], $_GET['comment_id'], $_GET['_wpnonce']) &&
        $_GET['aegisticket_action'] === 'delete_reply' &&
        wp_verify_nonce($_GET['_wpnonce'], 'aegisticket_delete_reply')
    ) {
        $cid = (int) $_GET['comment_id'];
        $c = get_comment($cid);
        if ($c && (int)$c->user_id === (int)$user_id && $c->comment_type === 'ticket_reply') {
            // Ensure this reply belongs to a ticket owned by this user
            $pid = (int) $c->comment_post_ID;
            if (aegisticket_is_ticket_owner($pid)) {
                wp_delete_comment($cid, true);
            }
        }
        wp_safe_redirect(remove_query_arg(['aegisticket_action','comment_id','_wpnonce','edit-reply']));
        exit;
    }

    // Handle delete action
    if (
        isset($_GET['aegisticket_action'], $_GET['ticket_id'], $_GET['_wpnonce']) &&
        $_GET['aegisticket_action'] === 'delete' &&
        wp_verify_nonce($_GET['_wpnonce'], 'aegisticket_delete_ticket')
    ) {
        $ticket_id = (int) $_GET['ticket_id'];
        if (aegisticket_is_ticket_owner($ticket_id) && aegisticket_ticket_is_open($ticket_id)) {
            wp_trash_post($ticket_id);
        }
        // soft redirect to remove query params
        wp_safe_redirect(remove_query_arg(['aegisticket_action','ticket_id','_wpnonce']));
        exit;
    }
    // Close ticket (user, only if open + owner)
    if (
        isset($_GET['aegisticket_action'], $_GET['ticket_id'], $_GET['_wpnonce']) &&
        $_GET['aegisticket_action'] === 'close' &&
        wp_verify_nonce($_GET['_wpnonce'], 'aegisticket_close_ticket')
    ) {
        $ticket_id = (int) $_GET['ticket_id'];
        if (aegisticket_is_ticket_owner($ticket_id) && aegisticket_ticket_is_open($ticket_id)) {
            wp_update_post(['ID' => $ticket_id, 'post_status' => 'closed']);
            $u = wp_get_current_user();
            update_post_meta($ticket_id, '_closed_by', $u ? $u->user_login : 'user');
            update_post_meta($ticket_id, '_closed_date_gmt', current_time('mysql', true));
        }
        wp_safe_redirect(remove_query_arg(['aegisticket_action','ticket_id','_wpnonce']));
        exit;
    }



    $tickets = get_posts([
        'post_type' => 'support_ticket',
        'author' => $user_id,
        'post_status' => ['open', 'closed'],
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC',
    ]);

    ob_start();
    ?>
    <div class="aegisticket">
        <table class="aegisticket-table">
            <thead>
                <tr>
                    <th>Ticket #</th>
                    <th>Subject</th>
                    <th>Priority</th>
                    <th>Status</th>
                    <th>Date Open</th>
                    <th>Date Closed</th>
                    <th>Admin Replied</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($tickets)) : ?>
                <tr><td colspan="6">No tickets found.</td></tr>
            <?php else : foreach ($tickets as $t) :
                $num = (int) get_post_meta($t->ID, '_ticket_number', true);
                $pri = (string) get_post_meta($t->ID, '_ticket_priority', true);
                $adm = (int) get_post_meta($t->ID, '_admin_replied', true);

                // Compute admin replied reliably (meta can be stale)
                $admin_replied = $adm ? 1 : 0;
                if (!$admin_replied) {
                    $maybe = get_comments([
                        'post_id' => $t->ID,
                        'status'  => 'approve',
                        'type'    => 'ticket_reply',
                        'number'  => 1,
                        'orderby' => 'comment_date_gmt',
                        'order'   => 'DESC',
                    ]);
                    if (!empty($maybe)) {
                        $c = $maybe[0];
                        $is_agent = $c->user_id && (user_can($c->user_id, 'manage_options') || user_can($c->user_id, 'reply_support_tickets'));
                        if ($is_agent) {
                            $admin_replied = 1;
                            update_post_meta($t->ID, '_admin_replied', 1);
                        }
                    }
                }

                $date_open = $t->post_date ? mysql2date(get_option('date_format') . ' ' . get_option('time_format'), $t->post_date) : '—';
                $date_closed_meta = (string) get_post_meta($t->ID, '_closed_date_gmt', true);
                $date_closed = '—';
                if ($t->post_status === 'closed') {
                    if ($date_closed_meta) {
                        $date_closed = mysql2date(get_option('date_format') . ' ' . get_option('time_format'), get_date_from_gmt($date_closed_meta));
                    } else {
                        $date_closed = $t->post_modified ? mysql2date(get_option('date_format') . ' ' . get_option('time_format'), $t->post_modified) : '—';
                    }
                }

				$view_url = add_query_arg(['support-ticket' => $t->ID], get_permalink());
				$edit_url = add_query_arg(['support-ticket' => $t->ID, 'mode' => 'edit'], get_permalink());
                $del_url  = wp_nonce_url(add_query_arg(['aegisticket_action' => 'delete', 'ticket_id' => $t->ID], get_permalink()), 'aegisticket_delete_ticket');
                $close_url = wp_nonce_url(add_query_arg(['aegisticket_action' => 'close', 'ticket_id' => $t->ID], get_permalink()), 'aegisticket_close_ticket');
            ?>
                <tr>
                    <td><?php echo esc_html($num ?: $t->ID); ?></td>
                    <td><?php echo $admin_replied ? '<strong>' . esc_html($t->post_title) . '</strong>' : esc_html($t->post_title); ?></td>
                    <td><?php echo esc_html($pri ?: 'medium'); ?></td>
                    <td><span class="aegisticket-badge <?php echo esc_attr($t->post_status); ?>"><?php echo esc_html($t->post_status); ?></span></td>
                    <td><?php echo esc_html($date_open); ?></td>
                    <td><?php echo esc_html($date_closed); ?></td>
                    <td><?php echo esc_html($admin_replied ? 'Yes' : 'No'); ?></td>
                    <td>
                        <a href="<?php echo esc_url($view_url); ?>">Open</a>
                        <?php if ($t->post_status === 'open') : ?>
                            | <a href="<?php echo esc_url($edit_url); ?>">Edit</a>
                            | <a href="<?php echo esc_url($close_url); ?>" onclick="return confirm('Close this ticket?');">Close</a>
                            | <a href="<?php echo esc_url($del_url); ?>" onclick="return confirm('Delete this ticket?');">Delete</a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>


        <?php
        // Inline ticket panel (Open/Edit/Reply) using ?support-ticket=###&mode=edit
        $active_ticket_id = isset($_GET['support-ticket']) ? (int) $_GET['support-ticket'] : 0;
$force_open = $active_ticket_id > 0;
        $mode = sanitize_text_field($_GET['mode'] ?? '');

        if ($force_open) :
            if (!aegisticket_ticket_can_view($active_ticket_id)) {
                echo '<p>Access denied.</p>';
            } else {
                $ticket = get_post($active_ticket_id);
                if ($ticket && $ticket->post_type === 'support_ticket') {

                    $errors = [];
                    $success = '';

                    $num  = (int) get_post_meta($ticket->ID, '_ticket_number', true);
                    $pri  = (string) get_post_meta($ticket->ID, '_ticket_priority', true);
                    $adm  = (int) get_post_meta($ticket->ID, '_admin_replied', true);
                    $atts = (array) get_post_meta($ticket->ID, '_ticket_attachments', true);
                    $atts = is_array($atts) ? $atts : [];

                    // User edit (open only)
                    if (
                        $mode === 'edit' &&
                        isset($_POST['aegisticket_update']) &&
                        isset($_POST['_wpnonce']) &&
                        wp_verify_nonce($_POST['_wpnonce'], 'aegisticket_update_ticket') &&
                        aegisticket_is_ticket_owner($ticket->ID) &&
                        aegisticket_ticket_is_open($ticket->ID)
                    ) {
                        $subject = sanitize_text_field($_POST['subject'] ?? '');
                        $priority = sanitize_text_field($_POST['priority'] ?? 'medium');
                        $description = sanitize_textarea_field($_POST['description'] ?? '');

                        if ($subject === '') $errors[] = 'Subject is required.';
                        if ($description === '') $errors[] = 'Description is required.';

                        $valid_pri = ['low','medium','high','production alert'];
                        if (!in_array($priority, $valid_pri, true)) $priority = 'medium';

                        if (empty($errors)) {
                            wp_update_post([
                                'ID' => $ticket->ID,
                                'post_title' => $subject,
                                'post_content' => $description,
                            ]);

                            update_post_meta($ticket->ID, '_ticket_priority', $priority);

                            // Append ticket-level uploads
                            $new_ids = aegisticket_handle_uploads('attachments');
                            if (!empty($new_ids)) {
                                $merged = array_values(array_unique(array_merge($atts, $new_ids)));
                                update_post_meta($ticket->ID, '_ticket_attachments', $merged);
                                $atts = $merged;
                            }

                            $success = 'Ticket updated.';
                            $ticket = get_post($ticket->ID);
                            $pri = (string) get_post_meta($ticket->ID, '_ticket_priority', true);
                        }
                    }

                    
                    // Edit own reply (comment) (ticket owner only)
                    if (
                        isset($_POST['aegisticket_edit_reply']) &&
                        isset($_POST['_wpnonce']) &&
                        wp_verify_nonce($_POST['_wpnonce'], 'aegisticket_edit_reply') &&
                        aegisticket_ticket_can_view($ticket->ID)
                    ) {
                        $comment_id = (int) ($_POST['comment_id'] ?? 0);
                        $new_text = sanitize_textarea_field($_POST['reply_edit_text'] ?? '');
                        $c = $comment_id ? get_comment($comment_id) : null;
                        if (!$c || (int)$c->comment_post_ID !== (int)$ticket->ID || $c->comment_type !== 'ticket_reply' || (int)$c->user_id !== (int)get_current_user_id()) {
                            $errors[] = 'Invalid reply.';
                        } elseif ($new_text === '') {
                            $errors[] = 'Reply cannot be empty.';
                        } else {
                            wp_update_comment([
                                'comment_ID' => $comment_id,
                                'comment_content' => $new_text,
                            ]);
                            $success = 'Reply updated.';
                        }
                    }

// User reply with attachments (open only)
                    if (
                        isset($_POST['aegisticket_reply']) &&
                        isset($_POST['_wpnonce']) &&
                        wp_verify_nonce($_POST['_wpnonce'], 'aegisticket_reply_ticket') &&
                        aegisticket_ticket_is_open($ticket->ID) &&
                        aegisticket_ticket_can_view($ticket->ID)
                    ) {
                        $reply = sanitize_textarea_field($_POST['reply'] ?? '');
                        if ($reply === '') {
                            $errors[] = 'Reply cannot be empty.';
                        } else {
                            $comment_id = wp_insert_comment([
                                'comment_post_ID' => $ticket->ID,
                                'comment_content' => $reply,
                                'comment_type' => 'ticket_reply',
                                'user_id' => get_current_user_id(),
                                'comment_approved' => 1,
                            ]);

                            if ($comment_id) {
                                $reply_ids = aegisticket_handle_uploads('reply_attachments');
                                if (!empty($reply_ids)) {
                                    delete_comment_meta($comment_id, '_aegisticket_reply_attachments');
                                add_comment_meta($comment_id, '_aegisticket_reply_attachments', array_values($reply_ids), true);
                                }
                                $success = 'Reply posted.';
                            } else {
                                $errors[] = 'Could not post reply.';
                            }
                        }
                    }

                    $replies = get_comments([
                        'post_id' => $ticket->ID,
                        'status'  => 'approve',
                        'type'    => 'ticket_reply',
                        'orderby' => 'comment_date_gmt',
                        'order'   => 'ASC',
                    ]);
                    ?>
                    <hr>
                    <div class="aegisticket-card">
                        <?php if (!empty($success)) : ?>
                            <div class="aegisticket-notice success"><?php echo esc_html($success); ?></div>
                        <?php endif; ?>
                        <?php if (!empty($errors)) : ?>
                            <div class="aegisticket-notice error"><ul>
                                <?php foreach ($errors as $e) : ?><li><?php echo esc_html($e); ?></li><?php endforeach; ?>
                            </ul></div>
                        <?php endif; ?>

                        <h3>Ticket #<?php echo esc_html($num ?: $ticket->ID); ?> — <?php echo esc_html($ticket->post_title); ?></h3>
                        <p>
                            <strong>Status:</strong>
                            <span class="aegisticket-badge <?php echo esc_attr($ticket->post_status); ?>"><?php echo esc_html($ticket->post_status); ?></span>
                            &nbsp;
                            <?php
            $prod = get_post_meta($ticket->ID, '_ticket_product', true);
            $ver  = get_post_meta($ticket->ID, '_ticket_version', true);
            ?>
            <strong>Product:</strong> <?php echo esc_html($prod ?: '—'); ?>
            &nbsp;
            <strong>Version:</strong> <?php echo esc_html($ver ?: '—'); ?>
            &nbsp;
            <strong>Priority:</strong> <?php echo esc_html($pri ?: 'medium'); ?>
                            &nbsp;
                            <strong>Date Open:</strong> <?php echo esc_html($ticket->post_date ? mysql2date(get_option('date_format') . ' ' . get_option('time_format'), $ticket->post_date) : '—'); ?>
                            &nbsp;
                            <strong>Date Closed:</strong> <?php echo esc_html(($ticket->post_status === 'closed') ? ( ( ($dc = (string) get_post_meta($ticket->ID, '_closed_date_gmt', true)) ? mysql2date(get_option('date_format') . ' ' . get_option('time_format'), get_date_from_gmt($dc)) : ($ticket->post_modified ? mysql2date(get_option('date_format') . ' ' . get_option('time_format'), $ticket->post_modified) : '—') ) ) : '—'); ?>
                        </p>

                        <?php if ($mode === 'edit' && aegisticket_is_ticket_owner($ticket->ID) && $ticket->post_status === 'open') : ?>
                            <form method="post" enctype="multipart/form-data" class="aegisticket-form">
                                <?php wp_nonce_field('aegisticket_update_ticket'); ?>
                                <label>Subject</label>
                                <input type="text" name="subject" value="<?php echo esc_attr($ticket->post_title); ?>" required>

                                <label>Priority</label>
                                <select name="priority">
                                    <?php foreach (['low','medium','high','production alert'] as $o) : ?>
                                        <option value="<?php echo esc_attr($o); ?>" <?php selected($pri, $o); ?>><?php echo esc_html($o); ?></option>
                                    <?php endforeach; ?>
                                </select>

                                <label>Description</label>
                                <textarea name="description" rows="4" style="width:100%;" required><?php echo esc_textarea($ticket->post_content); ?></textarea>

                                <label>Upload additional files</label>
                                <input type="file" name="attachments[]" multiple>

                                <button type="submit" name="aegisticket_update" class="aegisticket-btn">Save Changes</button>
                            </form>
                        <?php else : ?>
                            <div class="aegisticket-desc"><?php echo wpautop(esc_html($ticket->post_content)); ?></div>
                        <?php endif; ?>

                        <?php if (!empty($atts)) : ?>
                            <h4>Attachments</h4>
                            <ul>
                                <?php foreach ($atts as $aid) :
                                    $url = wp_get_attachment_url((int)$aid);
                                    if (!$url) continue;
                                ?>
                                    <li><a href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener"><?php echo esc_html(basename($url)); ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>

                    <div class="aegisticket-chat">
                        <h3>Conversation</h3>
                        <?php if (empty($replies)) : ?>
                            <p>No replies yet.</p>
                        <?php else : foreach ($replies as $c) :
                            $u = $c->user_id ? get_userdata($c->user_id) : null;
                            $who = $u ? $u->user_login : 'User';
                            if ($c->user_id && (user_can($c->user_id, 'manage_options') || user_can($c->user_id, 'reply_support_tickets'))) {
                                $who = 'Admin';
                            }

                            $reply_atts = get_comment_meta($c->comment_ID, '_aegisticket_reply_attachments', true);
                            // Normalize attachments per message
                            if (is_string($reply_atts)) {
                                $maybe = @unserialize($reply_atts);
                                if ($maybe !== false || $reply_atts === 'b:0;') {
                                    $reply_atts = $maybe;
                                }
                            }
                            $reply_atts = is_array($reply_atts) ? $reply_atts : [];
                        ?>
                            <div class="aegisticket-msg <?php echo ($who === 'Admin') ? 'agent' : 'user'; ?>">
                                <div class="aegisticket-msg-meta">
                                    <strong><?php echo esc_html($who); ?>:</strong>
                                    <?php if ((int)$c->user_id === (int)get_current_user_id()) :
                                        $edit_link = add_query_arg(['support-ticket' => $ticket->ID, 'edit-reply' => $c->comment_ID], get_permalink());
                                        $del_link  = wp_nonce_url(add_query_arg(['aegisticket_action' => 'delete_reply', 'comment_id' => $c->comment_ID], get_permalink()), 'aegisticket_delete_reply');
                                    ?>
                                        <a href="<?php echo esc_url($edit_link); ?>" title="Edit" style="margin-left:8px; text-decoration:none;">
                                            <span class="dashicons dashicons-edit"></span>
                                        </a>
                                        <a href="<?php echo esc_url($del_link); ?>" title="Delete" onclick="return confirm('Delete this message?');" style="margin-left:4px; text-decoration:none;">
                                            <span class="dashicons dashicons-trash"></span>
                                        </a>
                                    <?php endif; ?>
                                    <span><?php echo esc_html(get_date_from_gmt($c->comment_date_gmt)); ?></span>
                                </div>
                                <div class="aegisticket-msg-body"><?php echo nl2br(esc_html($c->comment_content)); ?></div>

                                <?php if (!empty($reply_atts)) : ?>
                                    <div class="aegisticket-attachments">
                                        <strong>Attachments:</strong>
                                        <ul>
                                            <?php foreach ($reply_atts as $aid) :
                                                $url = wp_get_attachment_url((int)$aid);
                                                if (!$url) continue;
                                            ?>
                                                <li><a href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener"><?php echo esc_html(basename($url)); ?></a></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; endif; ?>
                    </div>

                    <?php if ($ticket->post_status === 'open') : ?>
                        <div class="aegisticket-reply">
                            <h3>Post a reply</h3>
                            <form method="post" enctype="multipart/form-data" class="aegisticket-form">
                                <?php wp_nonce_field('aegisticket_reply_ticket'); ?>
                                <textarea name="reply" rows="4" style="width:100%;" required></textarea>
                                <label>Attach files</label>
                                <input type="file" name="reply_attachments[]" multiple accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.zip">
                                <button type="submit" name="aegisticket_reply" class="aegisticket-btn">Send Reply</button>
                            </form>
                        </div>
                    <?php else : ?>
                        <p><em>This ticket is closed.</em></p>
                    <?php endif; ?>
                    <?php
                }
            }
        endif;
        ?>

    </div>

    <?php
    return ob_get_clean();
});
