<?php
defined('ABSPATH') || exit;

/**
 * Meta keys per spec:
 * _ticket_number, _ticket_priority, _admin_replied, _ticket_attachments
 */

function sts_generate_ticket_number(): int {
    $last = (int) get_option('sts_last_ticket_number', 999);
    $next = $last + 1;
    update_option('sts_last_ticket_number', $next, false);
    return $next;
}

/**
 * Add ticket details box in admin.
 */
add_action('add_meta_boxes', function () {
    add_meta_box('aegisticket_details', __('Ticket Details', 'aegisticket'), function ($post) {
        $num = (int) get_post_meta($post->ID, '_ticket_number', true);
        $pri = (string) get_post_meta($post->ID, '_ticket_priority', true);
        $adm = (int) get_post_meta($post->ID, '_admin_replied', true);
        $atts = (array) get_post_meta($post->ID, '_ticket_attachments', true);
        $atts = is_array($atts) ? $atts : [];

        echo '<p><strong>'.esc_html__('Ticket #','aegisticket').'</strong> '.esc_html($num ?: $post->ID).'</p>';
        echo '<p><strong>'.esc_html__('Priority','aegisticket').'</strong> '.esc_html($pri ?: 'medium').'</p>';
        echo '<p><strong>'.esc_html__('Admin Replied','aegisticket').'</strong> '.esc_html($adm ? 'Yes' : 'No').'</p>';

        if (!empty($atts)) {
            echo '<p><strong>'.esc_html__('Attachments','aegisticket').'</strong></p><ul>';
            foreach ($atts as $aid) {
                $url = wp_get_attachment_url((int)$aid);
                if ($url) {
                    echo '<li><a href="'.esc_url($url).'" target="_blank" rel="noopener">'.esc_html(basename($url)).'</a></li>';
                }
            }
            echo '</ul>';
        }
    }, 'support_ticket', 'side');
});

/**
 * Ensure new tickets created in admin default to open.
 */
add_filter('wp_insert_post_data', function ($data, $postarr) {
    if (($data['post_type'] ?? '') !== 'support_ticket') return $data;
    if (!empty($postarr['ID'])) return $data;

    // if no explicit status, default open
    if (($data['post_status'] ?? '') === 'publish') {
        $data['post_status'] = 'open';
    }
    return $data;
}, 10, 2);
