<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class AegisWAF_Endpoint_Policy {

    public static function match_policy( string $path ) : array {
        $settings = AegisWAF_Storage::get_settings();
        $eps = is_array( $settings['endpoint_policies'] ?? null ) ? $settings['endpoint_policies'] : [];
        if ( empty( $eps ) ) { return []; }

        foreach ( $eps as $p ) {
            $pat = (string) ( $p['path_pattern'] ?? '' );
            if ( $pat === '' ) {
                if ( class_exists( 'AegisWAF_Logger' ) && method_exists( 'AegisWAF_Logger', 'log' ) ) {
                    AegisWAF_Logger::log( $path, 'GET', 'endpoint_policy', 'invalid_entry', [
                        'reason' => 'empty path_pattern',
                    ] );
                }
                error_log( '[AegisWAF] Endpoint policy entry skipped: empty path_pattern.' );
                continue;
            }

            if ( self::path_matches( $path, $pat ) ) {
                return is_array( $p ) ? $p : [];
            }
            if ( class_exists( 'AegisWAF_Logger' ) && method_exists( 'AegisWAF_Logger', 'log' ) ) {
                AegisWAF_Logger::log( $path, 'MATCH', 'endpoint_policy', 'matched', [
                    'pattern' => $pat,
                ] );
            }
        }
        return [];
    }

    public static function path_matches( string $path, string $pattern ) : bool {
        $pattern = trim( $pattern );
        if ( $pattern === '' ) { return false; }
        if ( strpos( $pattern, '*' ) !== false ) {
            $re = '#^' . str_replace( '\*', '.*', preg_quote( $pattern, '#' ) ) . '$#i';
            return (bool) preg_match( $re, $path );
        }
        return strtolower( $path ) === strtolower( $pattern );
    }

    public static function effective_categories( array $base, array $policy ) : array {
        $cats = $base;
        if ( isset( $policy['categories'] ) && is_array( $policy['categories'] ) ) {
            foreach ( $policy['categories'] as $k => $v ) {
                $cats[ (string) $k ] = (bool) $v;
            }
        }
        return $cats;
    }

    public static function effective_action( string $base_action, array $policy, bool $is_pro ) : string {
        $a = $base_action;
        if ( $is_pro && ! empty( $policy['mode_pro'] ) ) {
            $a = (string) $policy['mode_pro'];
        } elseif ( ! $is_pro && ! empty( $policy['mode_free'] ) ) {
            $a = (string) $policy['mode_free'];
        }
        return $a;
    }

    public static function effective_thresholds( array $base, array $policy ) : array {
        $t = $base;
        if ( isset( $policy['thresholds'] ) && is_array( $policy['thresholds'] ) ) {
            foreach ( $policy['thresholds'] as $k => $v ) {
                $t[ (string) $k ] = max( 0, (int) $v );
            }
        }
        return $t;
    }
}
