<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-overview.php';
require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-waf-rules.php';
require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-api-shield.php';
require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-bot-control.php';
require_once AEGISWAF_PATH . 'includes/ddos/class-aegiswaf-ddos-admin.php';
require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-logs.php';
require_once AEGISWAF_PATH . 'includes/admin/pages/class-aegiswaf-page-license.php';
require_once AEGISWAF_PATH . 'includes/admin/class-aegiswaf-pro-notice.php';

class AegisWAF_Admin {

    private $tabs = [];

    public function __construct() {
        $this->tabs = [
            'overview' => [
                'label' => 'Overview',
                'class' => 'AegisWAF_Page_Overview',
            ],
            'waf_rules' => [
                'label' => 'WAF Settings',
                'class' => 'AegisWAF_Page_WAF_Rules',
            ],
            'api_shield' => [
                'label' => 'API Shield',
                'class' => 'AegisWAF_Page_API_Shield',
            ],
            'bot_control' => [
                'label' => 'Bot Control',
                'class' => 'AegisWAF_Page_Bot_Control',
            ],
            'ddos' => [
                'label' => 'DDoS Settings',
                'class' => 'AegisWAF_DDoS_Admin',
            ],
            'logs' => [
                'label' => 'Logs / Attack Story',
                'class' => 'AegisWAF_Page_Logs',
            ],
            'license' => [
                'label' => 'License, Matrix and Settings',
                'class' => 'AegisWAF_Page_License',
            ],
        ];
		add_action( 'admin_menu', [ $this, 'register_menu' ] );
    }

    public function register_menu() : void {
        add_menu_page(
            'AegisWAF',
            'AegisWAF',
            'manage_options',
            'aegiswaf',
            [ $this, 'render_admin_page' ],
            'dashicons-shield',
            58
        );
    }

    public function render_admin_page() : void {
        if ( ! current_user_can( 'manage_options' ) ) { return; }

        $tab = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'overview'; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        if ( ! isset( $this->tabs[ $tab ] ) ) {
            $tab = 'overview';
        }

        echo '<div class="wrap">';
        echo '<h1>AegisWAF</h1>';

        if ( class_exists( 'AegisWAF_Utils' ) && method_exists( 'AegisWAF_Utils', 'render_tabs' ) ) {
            AegisWAF_Utils::render_tabs( $this->tabs );
        } else {
            echo '<p class="description">Tabs renderer not available.</p>';
        }

        $class = $this->tabs[ $tab ]['class'];
        if ( class_exists( $class ) && method_exists( $class, 'render' ) ) {
            ( new $class() )->render();
        } else {
            echo '<div class="notice notice-warning"><p>Tab not available.</p></div>';
            if ( class_exists( 'AegisWAF_Logger' ) && method_exists( 'AegisWAF_Logger', 'log' ) ) {
                AegisWAF_Logger::log( 'admin', 'GET', 'warning', 'tab_missing', [
                    'tab' => $tab,
                    'class' => $class,
                ] );
            } else {
                // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
                error_log( '[AegisWAF] tab_missing: ' . $tab . ' class=' . $class );
            }
        }

        echo '</div>';
    }
}

new AegisWAF_Admin();
