<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class AegisWAF_Pro_Notice {

    public static function is_pro_active() : bool {
        return (bool) apply_filters( 'aegiswaf_is_pro', false );
    }

    public static function render( string $message = '' ) : void {
        if ( self::is_pro_active() ) {
            return;
        }

        if ( $message === '' ) {
            $message = __( 'This section contains PRO features. Upgrade to unlock full protection.', 'aegiswaf' );
        }

        echo '<div class="notice notice-warning aegiswaf-pro-notice" style="margin:12px 0;">';
        echo '<p><strong>' . esc_html__( 'AegisWAF PRO', 'aegiswaf' ) . ':</strong> ' . esc_html( $message ) . '</p>';
        echo '<p><a class="button button-primary" href="' . esc_url( admin_url( 'admin.php?page=aegiswaf&tab=license' ) ) . '">' . esc_html__( 'Upgrade to PRO', 'aegiswaf' ) . '</a></p>';
        echo '</div>';
    }
}