<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AegisWAF_Behavioral_Timeline {
    public static function get_last_hour() : array {
        $out = [];
        for ( $i = 59; $i >= 0; $i-- ) {
            $bucket = gmdate( 'YmdHi', time() - ( $i * 60 ) );
            $out[] = [
                'minute' => gmdate( 'H:i', time() - ( $i * 60 ) ),
                'count'  => (int) get_transient( 'aegiswaf_bhv_count_' . $bucket ),
            ];
        }
        return $out;
    }

    public static function incr() {
        $bucket = gmdate( 'YmdHi' );
        $key = 'aegiswaf_bhv_count_' . $bucket;
        $v = (int) get_transient( $key );
        set_transient( $key, $v + 1, 3600 );
    }
}
