<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class AegisWAF_Features {

	public static function is_pro() : bool {
		static $cached = null;
		if ( $cached !== null ) {
			return (bool) $cached;
		}
		$cached = (bool) apply_filters( 'aegiswaf_is_pro', false );
		return (bool) $cached;
	}

    public static function feature_available( string $feature_id ) : bool {
        $pro = [
            'bot_behavior' => true,
            'bot_ip_reputation' => true,
            'bot_country_block' => true,
            'bot_asn_block' => true,
            'vp_manual_rules' => true,
            'vp_auto_shields' => true,
            'vp_zero_day_rules' => true,
            'logs_retention_pro' => true,
            'logs_export' => true,
        ];
        if ( isset( $pro[ $feature_id ] ) ) {
            return self::is_pro();
        }
        return true;
    }
}
