<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AegisWAF_Rule_Sets {
    public static function presets() : array {
        return [
            'wp_login_protect' => [
                'name' => 'WP Login Protection',
                'rules' => [
                    [
                        'name' => 'Block login abuse',
                        'path_pattern' => '/wp-login.php',
                        'method' => 'POST',
                        'action' => 'block',
                        'contains' => '',
                        'regex' => '',
                        'enabled' => true,
                    ],
                ],
            ],
            'xmlrpc_block' => [
                'name' => 'XML-RPC Hard Block',
                'rules' => [
                    [
                        'name' => 'Block XML-RPC',
                        'path_pattern' => '/xmlrpc.php',
                        'method' => 'ANY',
                        'action' => 'block',
                        'enabled' => true,
                    ],
                ],
            ],
            'wpjson_throttle' => [
                'name' => 'WP-JSON Throttle',
                'rules' => [
                    [
                        'name' => 'Log WP-JSON access',
                        'path_pattern' => '/wp-json/*',
                        'method' => 'ANY',
                        'action' => 'log',
                        'enabled' => true,
                    ],
                ],
            ],
        ];
    }
}
