<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class AegisWAF_Utils {

    public static function admin_url_tab( string $tab ) : string {
        return admin_url( 'admin.php?page=aegiswaf&tab=' . urlencode( $tab ) );
    }

    public static function current_tab() : string {
        $tab = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'overview';
        return $tab ?: 'overview';
    }

    public static function render_tabs( array $tabs ) : void {
        $current = self::current_tab();
        echo '<h2 class="nav-tab-wrapper">';
        foreach ( $tabs as $tab_id => $tab ) {
            $cls = ( $current === $tab_id ) ? ' nav-tab-active' : '';
            echo '<a class="nav-tab' . esc_attr( $cls ) . '" href="' . esc_url( self::admin_url_tab( $tab_id ) ) . '">' . esc_html( $tab['label'] ) . '</a>';
        }
        echo '</h2>';
    }

    public static function pro_gate_box( string $title, string $why, string $cta_label = 'Upgrade to PRO' ) : void {
        echo '<div class="aegiswaf-pro-box">';
        echo '<div class="aegiswaf-pro-box__title">🔒 ' . esc_html( $title ) . '</div>';
        echo '<div class="aegiswaf-pro-box__why">' . esc_html( $why ) . '</div>';
        echo '<div class="aegiswaf-pro-box__cta"><a href="' . esc_url( self::admin_url_tab( 'license' ) ) . '" class="button button-primary">' . esc_html( $cta_label ) . '</a></div>';
        echo '</div>';
    }

    public static function dim_wrap_open( bool $dim ) : void {
        echo $dim ? '<div class="aegiswaf-dim">' : '<div>';
    }

    public static function dim_wrap_close() : void {
        echo '</div>';
    }

    public static function sanitize_action( string $action ) : string {
        $allowed = [ 'allow', 'log', 'inspect', 'rate_limit', 'block' ];
        return in_array( $action, $allowed, true ) ? $action : 'inspect';
    }

    public static function client_ip() : string {
        $ip = isset( $_SERVER['REMOTE_ADDR'] ) ? (string) wp_unslash( $_SERVER['REMOTE_ADDR'] ) : '';
        return sanitize_text_field( $ip );
    }

    public static function user_agent() : string {
        $ua = isset( $_SERVER['HTTP_USER_AGENT'] ) ? (string) wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) : '';
        return substr( sanitize_text_field( $ua ), 0, 255 );
    }
}
