<?php
/**
 * Plugin Name: AegisBackup
 * Description: AegisBackup is a professional WordPress backup, migration, and disaster-recovery plugin engineered for stability and safe restores without risky background jobs or unreliable AJAX loops.
 * Version: 1.1.24
 * Requires at least: 6.8
 * Requires PHP: 8.2
 * Author:      Aegisify, LLC
 * Author URI:  https://aegisify.com/
 * Text Domain: aegisbackup
 * License: GPLv2 or later
 */

defined( 'ABSPATH' ) || exit;

define( 'AEGISBACKUP_VERSION', '1.1.24' );
define( 'AEGISBACKUP_FILE', __FILE__ );
define( 'AEGISBACKUP_DIR', plugin_dir_path( __FILE__ ) );
define( 'AEGISBACKUP_URL', plugin_dir_url( __FILE__ ) );

define( 'AEGISBACKUP_BASENAME', plugin_basename( __FILE__ ) );
define( 'AEGISBACKUP_SLUG', 'aegisbackup' );
define( 'AEGISBACKUP_CLM_BASE', 'https://aegisify.com' );
define( 'AEGISBACKUP_CLM_FREE_REG_ENDPOINT', AEGISBACKUP_CLM_BASE . '/wp-json/chue-license/v1/aegisbackup/free-register' );
define( 'AEGISBACKUP_CLM_ACTIVATE_ENDPOINT', AEGISBACKUP_CLM_BASE . '/wp-json/chue-license/v1/aegisbackup/activate' );
define( 'AEGISBACKUP_CLM_DEACTIVATE_ENDPOINT', AEGISBACKUP_CLM_BASE . '/wp-json/chue-license/v1/aegisbackup/deactivate' );
define( 'AEGISBACKUP_CLM_STATUS_ENDPOINT', AEGISBACKUP_CLM_BASE . '/wp-json/chue-license/v1/aegisbackup/status' );

require_once AEGISBACKUP_DIR . 'includes/class-ab-plugin.php';

require_once AEGISBACKUP_DIR . 'includes/utils/class-ab-license.php';

function aegisbackup() {
    return \AegisBackup\AB_Plugin::instance();
}

add_action( 'plugins_loaded', array( aegisbackup(), 'init' ) );

register_activation_hook( __FILE__, function() {
    if ( class_exists( '\\AegisBackup\\Utils\\License' ) ) {
        $lic = new \AegisBackup\Utils\License();
        $lic->maybe_send_free_register( AEGISBACKUP_VERSION );
    }
} );

// Install the standalone Migration Wizard runner at /aegismw/.
register_activation_hook( __FILE__, function() {
    if ( ! function_exists( 'get_option' ) ) {
        return;
    }
    $installer = AEGISBACKUP_DIR . 'includes/migrationwizard/class-ab-mw-installer.php';
    if ( file_exists( $installer ) ) {
        require_once $installer;
        if ( class_exists( '\\AegisBackup\\MigrationWizard\\AB_MW_Installer' ) ) {
            \AegisBackup\MigrationWizard\AB_MW_Installer::ensure_installed();
        }
    }
} );

add_action( 'aegisbackup_clm_daily_check', function () {
    if ( class_exists( '\\AegisBackup\\Utils\\License' ) ) {
        $lic = new \AegisBackup\Utils\License();
        $lic->maybe_daily_check( AEGISBACKUP_VERSION );
    }} );

register_activation_hook( __FILE__, function () {
    if ( ! function_exists( 'wp_next_scheduled' ) ) {
        return;
    }
    if ( ! wp_next_scheduled( 'aegisbackup_clm_daily_check' ) ) {
        wp_schedule_event( time() + HOUR_IN_SECONDS, 'daily', 'aegisbackup_clm_daily_check' );
    }
} );

register_deactivation_hook( __FILE__, function () {
    if ( ! function_exists( 'wp_next_scheduled' ) || ! function_exists( 'wp_unschedule_event' ) ) {
        return;
    }
    $ts = wp_next_scheduled( 'aegisbackup_clm_daily_check' );
    if ( $ts ) {
        wp_unschedule_event( $ts, 'aegisbackup_clm_daily_check' );
    }
} );

register_activation_hook( __FILE__, function() {
	$admin = get_role( 'administrator' );
	if ( $admin && ! $admin->has_cap( 'aegisbackup_manage_backups' ) ) {
		$admin->add_cap( 'aegisbackup_manage_backups' );
	}

	if ( ! get_role( 'aegisbackup_backup_manager' ) ) {
		add_role(
			'aegisbackup_backup_manager',
			'AegisBackup Backup Manager',
			array(
				'read' => true,
				'aegisbackup_manage_backups' => true,
			)
		);
	}
} );

register_activation_hook( __FILE__, function() {
    add_rewrite_rule( '^aegisbackup_connect/?$', 'index.php?aegisbackup_connect=1', 'top' );
    flush_rewrite_rules();
} );

register_activation_hook( __FILE__, function() {
	$admin = get_role( 'administrator' );
	if ( $admin && ! $admin->has_cap( 'aegisbackup_manage_backups' ) ) {
		$admin->add_cap( 'aegisbackup_manage_backups' );
	}
	if ( ! get_role( 'aegisbackup_backup_manager' ) ) {
		add_role(
			'aegisbackup_backup_manager',
			'AegisBackup Backup Manager',
			array(
				'read' => true,
				'aegisbackup_manage_backups' => true,
			)
		);
	}
} );
