<?php
declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) {
    define( 'ABSPATH', __DIR__ . DIRECTORY_SEPARATOR );
}
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

header( 'Content-Type: text/html; charset=utf-8' );

if ( ! function_exists( 'esc_html' ) ) {
    function esc_html( $text ) : string {
        return htmlspecialchars( (string) $text, ENT_QUOTES, 'UTF-8' );
    }
}
function aegis_mw_http_403( string $message ) : void {
    http_response_code( 403 );
    echo '<!doctype html><html><head><meta charset="utf-8"><title>403 Forbidden</title>';
    echo '<style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,sans-serif;margin:24px;line-height:1.4}code{background:#f6f8fa;padding:6px 8px;border-radius:8px}</style>';
    echo '</head><body>';
    echo '<h1>403 - Authorization Required</h1>';
    echo '<p>' . esc_html( $message ) . '</p>';
    echo '</body></html>';
    exit;
}

$aegis_mw_latest = __DIR__ . DIRECTORY_SEPARATOR . 'latest.json';

$aegis_mw_data = array();
if ( is_file( $aegis_mw_latest ) ) {
    $aegis_mw_raw = @file_get_contents( $aegis_mw_latest );
    if ( is_string( $aegis_mw_raw ) ) {
        $aegis_mw_j = json_decode( $aegis_mw_raw, true );
        if ( is_array( $aegis_mw_j ) ) {
            $aegis_mw_data = $aegis_mw_j;
        }
    }
}

?><!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>AegisBackup Migration Wizard Report</title>
    <style>
        body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,sans-serif;margin:20px;line-height:1.4}
        .ok{color:green;font-weight:600}
        .fail{color:#b00020;font-weight:600}
        code,pre{background:#f6f8fa;padding:8px;border-radius:8px;display:block;overflow:auto}
        .card{border:1px solid #e5e7eb;border-radius:12px;padding:14px;margin:12px 0}
        .muted{color:#6b7280}
        a.btn{display:inline-block;background:#111827;color:#fff;border-radius:10px;padding:10px 14px;text-decoration:none;font-weight:600}
    </style>
</head>
<body>
    <h1>AegisBackup Migration Wizard Report</h1>

    <?php if ( empty( $aegis_mw_data ) ) : ?>
        <p class="muted">No report found yet. If you just ran a restore, confirm that <code>latest.json</code> was created in this folder.
        <?php
        $aegis_mw_files = glob( __DIR__ . DIRECTORY_SEPARATOR . '*.json' );
        if ( is_array( $aegis_mw_files ) && ! empty( $aegis_mw_files ) ) {
            echo '<div class="card"><div class="muted">Report files found:</div><ul>';
            foreach ( $aegis_mw_files as $aegis_mw_f ) {
                $aegis_mw_bn = basename( $aegis_mw_f );
                echo '<li><code>' . esc_html( $aegis_mw_bn ) . '</code></li>';
            }
            echo '</ul></div>';
        } else {
            echo '<div class="card"><div class="muted">No JSON report files were found in this folder.</div></div>';
        }
        ?>
</p>
    <?php else : ?>
        <div class="card">
            <div><strong>Run:</strong> <?php echo esc_html( $aegis_mw_data['run_id'] ?? '' ); ?></div>
            <div><strong>Started:</strong> <?php echo esc_html( $aegis_mw_data['started'] ?? '' ); ?></div>
            <div><strong>Ended:</strong> <?php echo esc_html( $aegis_mw_data['ended'] ?? '' ); ?></div>
            <div><strong>Status:</strong>
                <?php if ( ! empty( $aegis_mw_data['ok'] ) ) : ?>
                    <span class="ok">SUCCESS</span>
                <?php else : ?>
                    <span class="fail">FAIL</span>
                <?php endif; ?>
            </div>
            <div><strong>Message:</strong> <?php echo esc_html( $aegis_mw_data['message'] ?? '' ); ?></div>
        </div>

        <h2>Phases</h2>
        <?php foreach ( (array) ( $aegis_mw_data['phases'] ?? array() ) as $aegis_mw_k => $aegis_mw_p ) : ?>
            <div class="card">
                <div><strong><?php echo esc_html( $aegis_mw_p['label'] ?? $aegis_mw_k ); ?></strong></div>
                <div class="muted">Started: <?php echo esc_html( $aegis_mw_p['started'] ?? '' ); ?> — Ended: <?php echo esc_html( $aegis_mw_p['ended'] ?? '' ); ?></div>
                <div>Status:
                    <?php if ( ! empty( $aegis_mw_p['ok'] ) ) : ?>
                        <span class="ok">SUCCESS</span>
                    <?php else : ?>
                        <span class="fail">FAIL</span>
                    <?php endif; ?>
                </div>
                <?php if ( ! empty( $aegis_mw_p['message'] ) ) : ?>
                    <div><?php echo esc_html( $aegis_mw_p['message'] ); ?></div>
                <?php endif; ?>
                <?php if ( ! empty( $aegis_mw_p['errors'] ) ) : ?>
                    <div class="fail">Errors:
                        <ul>
                            <?php foreach ( (array) $aegis_mw_p['errors'] as $aegis_mw_e ) : ?>
                                <li><?php echo esc_html( $aegis_mw_e ); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if ( ! empty( $aegis_mw_p['warnings'] ) ) : ?>
                    <div>Warnings:
                        <ul>
                            <?php foreach ( (array) $aegis_mw_p['warnings'] as $aegis_mw_w ) : ?>
                                <li><?php echo esc_html( $aegis_mw_w ); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>

        <h2>Log</h2>
        <pre><?php echo esc_html( implode( "\n", (array) ( $aegis_mw_data['log'] ?? array() ) ) ); ?></pre>

        <p class="muted">Raw JSON is stored on disk as <code>report/latest.json</code> (direct access is blocked).</p>
    <?php endif; ?>
</body>
</html>
