(function($){
  var tbPostMode = false;
  $(function(){
    tbPostMode = ($('#ab_tb_mode').length && ($('#ab_tb_mode').val()||'') === 'post');
  });																								 
  function log($el, msg){
    var cur = $el.text();
    $el.text(cur + (cur ? "\n" : "") + msg);
    $el.scrollTop($el[0].scrollHeight);
  }

  function setProgress($bar, pct){
    pct = Math.max(0, Math.min(100, pct));
    $bar.css('width', pct + '%');
  }

  function abEscHtml(s){
    s = (s === null || typeof s === 'undefined') ? '' : String(s);
    return s
      .replace(/&/g,'&amp;')
      .replace(/</g,'&lt;')
      .replace(/>/g,'&gt;')
      .replace(/"/g,'&quot;')
      .replace(/'/g,'&#039;');
  }

  function abSetStatus(type, msg){
    var $el = $('#ab_backup_status');
    if(!$el.length){ return; }
    msg = (msg === null || typeof msg === 'undefined') ? '' : String(msg);

    if(type === 'error'){
      $el.html('<div class="notice notice-error inline" style="margin:6px 0 0 0; padding:8px 12px;"><p><strong>Error:</strong> ' + abEscHtml(msg) + '</p></div>');
      return;
    }
    if(type === 'success'){
      $el.html('<div class="notice notice-success inline" style="margin:6px 0 0 0; padding:8px 12px;"><p><strong>Success:</strong> ' + abEscHtml(msg) + '</p></div>');
      return;
    }
    if(type === 'info'){
      $el.html('<div class="notice notice-info inline" style="margin:6px 0 0 0; padding:8px 12px;"><p>' + abEscHtml(msg) + '</p></div>');
      return;
    }
    $el.text(msg);
  }

  function abRestorePhaseLabel(phase){
    phase = (phase||'') + '';
    var map = {
      'validate': 'Pre-flight Checks are running',
      'preflight': 'Pre-flight Checks are running',
      'verify': 'Pre-flight Checks are running',
      'db_prepare': 'Preparing Database',
      'db_import': 'Copy Database Tables',
      'prefix': 'Updating DB Prefix',
      'domain': 'Updating Domain / URLs',
      'files': 'Copy files',
      'wpconfig': 'Finalizing (wp-config.php)',
      'cleanup': 'Finalizing',
      'step3': 'Finalizing',
      'done': 'Finished!'
    };
    return map[phase] || 'Running…';
  }

  function abRenderRestoreChecklist($wrap, d){
    if(!$wrap || !$wrap.length){ return; }
    d = d || {};
    var phase = (d.phase||'') + '';
    var status = (d.status||'') + '';
    var done = !!d.done || status === 'complete' || phase === 'done' || (typeof d.progress !== 'undefined' && parseInt(d.progress,10) >= 100);

    var steps = [
      {label:'Pre-Flight Checks are running', phases:['validate','preflight','verify']},
      {label:'Copy files', phases:['files']},
      {label:'Copy Database Tables', phases:['db_prepare','db_import','prefix','domain']},
      {label:'Finalizing', phases:['wpconfig','cleanup','step3']},
      {label:'Finished!', phases:['done']}
    ];

    function currentIndex(){
      for(var i=0;i<steps.length;i++){
        if(steps[i].phases.indexOf(phase) !== -1){ return i; }
      }
      return -1;
    }

    var curIdx = currentIndex();
    var html = '';
    html += '<div style="padding:10px; background:#fff; border:1px solid #dcdcde; border-radius:6px;">';

    for(var i=0;i<steps.length;i++){
      var st = 'pending';
      if(done){
        st = 'done';
      }else if(status === 'error'){
        if(curIdx === -1){ st = 'pending'; }
        else if(i < curIdx){ st = 'done'; }
        else if(i == curIdx){ st = 'fail'; }
        else { st = 'pending'; }
      }else{
        if(curIdx === -1){ st = 'pending'; }
        else if(i < curIdx){ st = 'done'; }
        else if(i == curIdx){ st = 'run'; }
        else { st = 'pending'; }
      }

      var icon = '○';
      var color = '#646970';
      if(st === 'run'){ icon = '⟳'; color = '#2271b1'; }
      if(st === 'done'){ icon = '✔'; color = '#00a32a'; }
      if(st === 'fail'){ icon = '✖'; color = '#d63638'; }
      html += '<div style="margin:4px 0; color:'+color+';">'+icon+' <strong>' + $('<div/>').text(steps[i].label).html() + '</strong></div>';
    }

    html += '<div style="margin-top:8px; color:#1d2327;">Now: <strong>' + $('<div/>').text(abRestorePhaseLabel(phase)).html() + '</strong></div>';
    html += '</div>';

    if(d.preflight && (Array.isArray(d.preflight) || typeof d.preflight === 'object')){
      html += '<div style="margin-top:10px; padding:10px; background:#fff; border:1px solid #dcdcde; border-radius:6px;">';
      html += '<div style="font-weight:700; margin-bottom:6px;">Pre-flight Details</div>';

      if(Array.isArray(d.preflight)){
        for(var j=0;j<d.preflight.length;j++){
          var it = d.preflight[j]||{};
          var ok = !!it.ok;
          var ic = ok ? '<span style="color:#00a32a; font-weight:700;">✔</span>' : '<span style="color:#d63638; font-weight:700;">✖</span>';
          var lbl = it.label || it.name || ('Check ' + (j+1));
          var det = it.detail ? ('<span style="color:#646970;"> — ' + $('<div/>').text(it.detail).html() + '</span>') : '';
          html += '<div style="margin:2px 0;">' + ic + ' <strong>' + $('<div/>').text(lbl).html() + '</strong>' + det + '</div>';
        }
      }else{
        for(var k in d.preflight){
          if(!Object.prototype.hasOwnProperty.call(d.preflight,k)) continue;
          var v = d.preflight[k];
          var ok2 = !!(v && v.ok);
          var ic2 = ok2 ? '<span style="color:#00a32a; font-weight:700;">✔</span>' : '<span style="color:#d63638; font-weight:700;">✖</span>';
          var det2 = (v && v.detail) ? ('<span style="color:#646970;"> — ' + $('<div/>').text(v.detail).html() + '</span>') : '';
          html += '<div style="margin:2px 0;">' + ic2 + ' <strong>' + $('<div/>').text(k).html() + '</strong>' + det2 + '</div>';
        }
      }
      html += '</div>';
    }

    $wrap.html(html);
  }

  function renderPreflight($wrap, preflight){
    abRenderRestoreChecklist($wrap, {preflight: preflight || []});
  }

  function abRenderRecentPackages(packages){
    var $area = $('#ab_recent_packages_area');
    if(!$area.length){ return; }

    packages = packages || [];
    if(!packages.length){
      $area.html('<p class="description">No packages found yet.</p>');
      return;
    }

    var html = '';
    html += '<table class="widefat striped">';
    html += '<thead><tr>';
    html += '<th>Name</th><th>Created</th><th>Size</th><th>Action</th>';
    html += '</tr></thead>';
    html += '<tbody>';
    for(var i=0;i<packages.length;i++){
      var p = packages[i] || {};
      var name = p.name || '';
      var created = p.created || '';
      var size = p.size || '';
      var durl = p.download_url || '';
      var xurl = p.delete_url || '';
      html += '<tr>';
      html += '<td><code>' + $('<div/>').text(name).html() + '</code></td>';
      html += '<td>' + $('<div/>').text(created).html() + '</td>';
      html += '<td>' + $('<div/>').text(size).html() + '</td>';
      html += '<td>';
      if(durl){
        html += '<a class="button button-small" href="' + durl + '">Download</a> ';
        html += '<a class="button button-small" href="' + xurl + '" onclick="return confirm(\'Delete this package?\');">Delete</a>';
      }else{
        html += '—';
      }
      html += '</td>';
      html += '</tr>';
    }
    html += '</tbody></table>';
    $area.html(html);
  }

  function abRefreshRecentPackages(){
    if(!$('#ab_recent_packages_area').length){ return; }
    $.post(AegisBackup.ajaxurl, {
      action: 'aegisbackup_list_packages',
      nonce: AegisBackup.nonce
    }).done(function(res){
      if(res && res.success && res.data && res.data.packages){
        abRenderRecentPackages(res.data.packages);
      }
    });
  }

  $('#ab_start_backup').on('click', function(e){
    e.preventDefault();
    $('#ab_progress_wrap').show();
    $('#ab_progress_log').text('');
    setProgress($('#ab_progress_bar'), 1);
    abSetStatus('info', 'Starting...');
    if($('#ab_backup_checklist').length){ $('#ab_backup_checklist').html(''); }
    if($('#ab_backup_download').length){ $('#ab_backup_download').html(''); }

    $.post(AegisBackup.ajaxurl, {
      action: (( $('#ab_dr_generate_link').length && $('#ab_dr_generate_link').is(':checked') ) ? 'aegisbackup_start_dr_recovery_backup' : 'aegisbackup_start_backup'),
      nonce: AegisBackup.nonce,
      include_files: $('#ab_include_files').is(':checked') ? 1 : 0,
      include_db: $('#ab_include_db').is(':checked') ? 1 : 0,
      include_config: $('#ab_include_config').is(':checked') ? 1 : 0,
      include_core: $('#ab_include_core').is(':checked') ? 1 : 0,
      dr_generate_link: ($('#ab_dr_generate_link').length && $('#ab_dr_generate_link').is(':checked')) ? 1 : 0,

      include_htaccess: ($('#ab_include_htaccess').length && $('#ab_include_htaccess').is(':checked')) ? 1 : 0,
      package_purpose: $('#ab_package_purpose').length ? ($('#ab_package_purpose').val() || '') : '',
      snapshot: ($('#ab_snapshot').length && $('#ab_snapshot').is(':checked')) ? 1 : 0,
      backup_type: $('#ab_backup_type').length ? ($('#ab_backup_type').val() || 'full') : 'full',
      db_export_mode: $('#ab_db_export_mode').val() || 'table',
      excludes: $('#ab_excludes').val(),
      db_export_mode: $('#ab_db_export_mode').val()
    }).done(function(res){
	if(!res || !res.success){
	  var msg = (res && res.data && res.data.message) ? res.data.message : 'Failed to start.';
	  abSetStatus('error', msg || 'Failed to start.');
	  log($('#ab_progress_log'), msg);
	  if(res && res.data && res.data.path){
		log($('#ab_progress_log'), 'Path: ' + res.data.path);
	  }
	  return;
	}
      var jobId = res.data.job_id;
      log($('#ab_progress_log'), 'Job: ' + jobId);

      function tick(){
        $.post(AegisBackup.ajaxurl, {
          action: 'aegisbackup_process_backup',
          nonce: AegisBackup.nonce,
          job_id: jobId
        }).done(function(r){
          if(!r || !r.success){
            var em = (r && r.data && r.data.message) ? r.data.message : ( (r && r.data && r.data.log) ? r.data.log : '' );
            if(!em && typeof r === 'string'){
              em = 'Non-JSON response from server (likely PHP fatal). See browser Network response.';
              log($('#ab_progress_log'), 'Raw response (first 300 chars): ' + r.substring(0,300));
            }
            if(!em){ em = 'An error occurred while processing the backup.'; }
            abSetStatus('error', em);
            return;
          }
          var d = r.data;
          if(d && d.log){ log($('#ab_progress_log'), d.log); }
          if(d && typeof d.progress !== 'undefined'){ setProgress($('#ab_progress_bar'), d.progress); }
          if(d && d.done){
            abSetStatus('success', 'Done');
            if(d && d.package){ log($('#ab_progress_log'), 'Package: ' + d.package); }
            if(d && d.sanity && d.sanity.items){
              var it = d.sanity.items;

              var phases = [];
              function p(label, ok, detail){ phases.push({label:label, ok:!!ok, detail:detail||''}); }

              p('Package Created (ZIP)', (it.zip_exists && it.zip_exists.ok) && (it.zip_open && it.zip_open.ok), (it.zip_exists && it.zip_exists.detail) ? it.zip_exists.detail : '');
              p('Manifest Generated', (it.has_manifest_json && it.has_manifest_json.ok) && (it.manifest_has_urls && it.manifest_has_urls.ok), 'manifest.json');
              p('Checksums Written', (it.has_checksums && it.has_checksums.ok), 'checksums.sha256');
              p('Files Backup (wp-content)', (it.has_wp_content && it.has_wp_content.ok), (it.has_wp_content && it.has_wp_content.detail) ? it.has_wp_content.detail : '');
              p('Database Backup (db.sql)', (it.has_db_dump && it.has_db_dump.ok), (it.has_db_dump && it.has_db_dump.detail) ? it.has_db_dump.detail : '');

              log($('#ab_progress_log'), '--- Sanity Checklist ---');
              for(var i=0;i<phases.length;i++){
                var st = phases[i].ok ? 'PASS' : 'FAIL';
                log($('#ab_progress_log'), st + ' - ' + phases[i].label + (phases[i].detail ? (' - ' + phases[i].detail) : ''));
              }

              if($('#ab_backup_checklist').length){
                var html = '<div style="border:1px solid #dcdcde; background:#fff; padding:10px; border-radius:6px;">';
                html += '<div style="font-weight:600; margin-bottom:6px;">Sanity Check (Migration Backup)</div>';
                for(var j=0;j<phases.length;j++){
                  var icon = phases[j].ok ? '<span style="color:#00a32a; font-weight:700;">✔</span>' : '<span style="color:#d63638; font-weight:700;">✖</span>';
                  var det = phases[j].detail ? ('<span style="color:#646970;"> — ' + $('<div/>').text(phases[j].detail).html() + '</span>') : '';
                  html += '<div style="margin:2px 0;">' + icon + ' <strong>' + $('<div/>').text(phases[j].label).html() + '</strong>' + det + '</div>';
                }
                html += '</div>';
                $('#ab_backup_checklist').html(html);
              }
            }

            if(d && d.download_url && $('#ab_backup_download').length){
              var linkText = 'Download AegisBackup WP MIGRATION ZIP FILE';
              $('#ab_backup_download').html('<a class="button button-primary" href="' + d.download_url + '">' + linkText + '</a>');
            }

            abRefreshRecentPackages();

            setTimeout(function(){ window.location.reload(); }, 900);

            return;
          }
          setTimeout(tick, 450);
        }).fail(function(xhr){
          try{
            var st = xhr && xhr.status ? xhr.status : '';
            var rt = xhr && xhr.responseText ? xhr.responseText : '';
            abSetStatus('error', 'AJAX failed ('+st+'). See Network tab for response.');
            if(rt){ log($('#ab_progress_log'), 'AJAX response (first 400 chars): ' + rt.substring(0,400)); }
          }catch(e){}
        });
      }
      tick();
    });
  });

  function abToggleRestoreModeUI(){
    var mode = $('input[name="ab_restore_mode"]:checked').val() || 'existing';
    var $sec = $('#ab_wpconfig_section');
    if(!$sec.length){ return; }

    if(mode === 'newdb'){
      $sec.show();
    }else{
      $sec.hide();
      if($('#ab_wpconfig_update').length){ $('#ab_wpconfig_update').prop('checked', false); }
      if($('#ab_wpconfig_regen_salts').length){ $('#ab_wpconfig_regen_salts').prop('checked', false); }
    }
  }

  $(function(){
    if($('input[name="ab_restore_mode"]').length){
      abToggleRestoreModeUI();
      $(document).on('change', 'input[name="ab_restore_mode"]', abToggleRestoreModeUI);
    }
  });

  function abStartRestorePolling(jobId){
    if(!jobId){ return; }

    function pollStatus(){
      $.post(AegisBackup.ajaxurl, {
        action: 'aegisbackup_restore_status',
        nonce: AegisBackup.nonce,
        job_id: jobId
      }).done(function(r){
        if(!r || !r.success){
          if($('#ab_restore_status').length){ $('#ab_restore_status').text('Error'); }
          setTimeout(pollStatus, 2000);
          return;
        }
        var d = r.data || {};

        if(d.log && Array.isArray(d.log) && d.log.length){
          if($('#ab_restore_progress_log').length){ $('#ab_restore_progress_log').text(d.log.join("\n")); }
        } else if(d.last_log){
          if($('#ab_restore_progress_log').length){ log($('#ab_restore_progress_log'), d.last_log); }
        } else {
          if($('#ab_restore_progress_log').length && $.trim($('#ab_restore_progress_log').text() || '') === ''){
            $('#ab_restore_progress_log').text('No log output yet. Waiting for background runner…');
          }
        }

        if(typeof d.progress !== 'undefined'){
          setProgress($('#ab_restore_progress_bar'), d.progress);
          if($('#ab_restore_percent').length){ $('#ab_restore_percent').text(String(parseInt(d.progress,10) || 0) + '%'); }
        }

        var curTask = d.last_log || abRestorePhaseLabel(d.phase || '');
        if($('#ab_restore_current_task').length){ $('#ab_restore_current_task').text(curTask); }

        if($('#ab_preflight_results').length){
          abRenderRestoreChecklist($('#ab_preflight_results'), d);
        }

        if(d.done){
          if($('#ab_restore_status').length){ $('#ab_restore_status').text((d.status === 'error') ? 'Error' : 'Done'); }
          if($('#ab_migration_report_inner').length){
            $.post(AegisBackup.ajaxurl, {action:'aegisbackup_get_last_report', nonce:AegisBackup.nonce}).done(function(rr){
              if(rr && rr.success && rr.data && rr.data.report){
                renderReport($('#ab_migration_report_inner'), rr.data.report);
              }
            });
          }
          return;
        }

        if($('#ab_restore_status').length){ $('#ab_restore_status').text(abRestorePhaseLabel(d.phase || '')); }
        setTimeout(pollStatus, 1500);
      }).fail(function(){
        setTimeout(pollStatus, 2000);
      });
    }

    pollStatus();
  }

  $(function(){
    var $meta = $('#ab_restore_job_meta');
    if($meta.length){
      var jobId = $meta.data('jobid') || '';
      if(jobId){
        abStartRestorePolling(jobId);
      }
    }
  });

  $('#ab_start_restore').on('click', function(e){
    e.preventDefault();
    $('#ab_restore_progress_wrap').show();
    $('#ab_restore_progress_log').text('');
    setProgress($('#ab_restore_progress_bar'), 1);
    $('#ab_restore_status').text('Starting...');

    var mode = $('input[name="ab_restore_mode"]:checked').val();

    if(!$('#ab_confirm_drop').is(':checked')){
      alert('Please confirm you understand this will overwrite the current site and database tables.');
      $('#ab_restore_progress_wrap').hide();
      return;
    }
    var ctxt = ($.trim($('#ab_confirm_text').val() || '')).toUpperCase();
    if(ctxt !== 'RESTORE'){
      alert('Type RESTORE to confirm.');
      $('#ab_restore_progress_wrap').hide();
      return;
    }

    $.post(AegisBackup.ajaxurl, {
      action: 'aegisbackup_start_restore',
      nonce: AegisBackup.nonce,
      package_path: $('#ab_restore_package').val(),
      mode: mode,
      new_prefix: $('#ab_new_prefix').val(),
      old_domain: $('#ab_old_domain').val(),
      new_domain: $('#ab_new_domain').val(),
      wpconfig_update: (mode === 'newdb' && $('#ab_wpconfig_update').length && $('#ab_wpconfig_update').is(':checked')) ? 1 : 0,
      db_name: (mode === 'newdb' && $('#ab_db_name').length) ? $('#ab_db_name').val() : '',
      db_user: (mode === 'newdb' && $('#ab_db_user').length) ? $('#ab_db_user').val() : '',
      db_pass: (mode === 'newdb' && $('#ab_db_pass').length) ? $('#ab_db_pass').val() : '',
      db_host: (mode === 'newdb' && $('#ab_db_host').length) ? $('#ab_db_host').val() : '',
      wpconfig_regen_salts: (mode === 'newdb' && $('#ab_wpconfig_regen_salts').length && $('#ab_wpconfig_regen_salts').is(':checked')) ? 1 : 0,
      confirm_drop: 1,
      confirm_text: 'RESTORE'
    }).done(function(res){
      if(!res || !res.success){
        $('#ab_restore_status').text('Failed to start.');
        return;
      }
      var jobId = res.data.job_id;
      log($('#ab_restore_progress_log'), 'Restore Job: ' + jobId);

      abStartRestorePolling(jobId);
    });
  });

  $(document).on('click', '.ab-pick-restore', function(e){
    e.preventDefault();
    var pkg = $(this).data('package') || '';
    if(!pkg) return;
    var $sel = $('#ab_restore_package');
    if(!$sel.length) return;
    $sel.val(pkg);
    try{
      $('html, body').animate({scrollTop: ($sel.offset().top - 80)}, 250);
    }catch(err){}
  });

	function abAjax(action, data){
	  data = data || {};
	  data.action = action;
	  var nonce = (window.AegisBackup && AegisBackup.nonce) ? AegisBackup.nonce : '';
	  if(!nonce && $('#aegisbackup_nonce').length){ nonce = $('#aegisbackup_nonce').val() || ''; }
	  data.nonce = nonce;

	  var url = (window.AegisBackup && AegisBackup.ajaxurl) ? AegisBackup.ajaxurl : '';
	  if(!url && $('#aegisbackup_ajaxurl').length){ url = $('#aegisbackup_ajaxurl').val() || ''; }
	  if(!url){ url = (typeof ajaxurl !== 'undefined') ? ajaxurl : '/wp-admin/admin-ajax.php'; }

	  return $.post(url, data);
	}

	function abSetNotice($el, msg, ok){
	  if(!$el || !$el.length) return;
	  $el.text(msg || '');
	  try{
		$el.css({color: ok ? '#1d7f31' : '#b32d2e'});
	  }catch(e){}
	}

	$(document).on('click', '#ab_copy_token', function(e){
	  e.preventDefault();
	  var target = $(this).attr('data-copy-target') || '#ab_token_out';
	  var $t = $(target);
	  if(!$t.length){
		abSetNotice($('#ab_token_notice'), 'Nothing to copy.', false);
		return;
	  }
	  var val = ($t.val() || '').trim();
	  if(!val){
		abSetNotice($('#ab_token_notice'), 'Nothing to copy.', false);
		return;
	  }

	  try{
		if(navigator && navigator.clipboard && navigator.clipboard.writeText){
		  navigator.clipboard.writeText(val).then(function(){
			abSetNotice($('#ab_token_notice'), 'Copied.', true);
		  }).catch(function(){
			try{ $t.focus().select(); document.execCommand('copy'); abSetNotice($('#ab_token_notice'), 'Copied.', true);}catch(err){ abSetNotice($('#ab_token_notice'), 'Copy failed. Select and copy manually.', false); }
		  });
		  return;
		}
	  }catch(err){}

	  try{
		$t.focus().select();
		document.execCommand('copy');
		abSetNotice($('#ab_token_notice'), 'Copied.', true);
	  }catch(err){
		abSetNotice($('#ab_token_notice'), 'Copy failed. Select and copy manually.', false);
	  }
	});

	$(document).on('click', '#ab_start_push', function(e){
	  if($(this).attr('data-ab-post') === '1'){
		return;
	  }
	  e.preventDefault();

	  var pkg = ($('#ab_push_package').val() || '');
	  var tok = ($('#ab_destination_token').val() || '');
	  if(!pkg){
		abSetNotice($('#ab_push_notice'), 'Select a package.', false);
		return;
	  }
	  if(!tok){
		abSetNotice($('#ab_push_notice'), 'Paste the Destination Token JSON.', false);
		return;
	  }

	  $('#ab_push_progress_wrap').show();
	  $('#ab_push_progress_bar').css('width', '0%');
	  $('#ab_push_progress_log').val('');
	  $('#ab_push_status').text('Starting…');
	  abSetNotice($('#ab_push_notice'), '', true);

	  abAjax('aegisbackup_start_push', {
		token_json: tok,
		package_path: pkg
	  }).done(function(resp){
		if(!resp || !resp.success || !resp.data || !resp.data.job_id){
		  var m = (resp && resp.data && resp.data.message) ? resp.data.message : 'Failed to start push job.';
		  $('#ab_push_status').text(m);
		  abSetNotice($('#ab_push_notice'), m, false);
		  return;
		}
		var jobId = resp.data.job_id;
		$('#ab_push_status').text('Push Job: ' + jobId);
		$('#ab_push_progress_log').val('Push Job: ' + jobId + "\n");

		var timer = setInterval(function(){
		  abAjax('aegisbackup_process_push', {job_id: jobId}).done(function(step){
			if(!step || !step.success || !step.data){
			  return;
			}
			var d = step.data;
			var pct = (d.progress !== undefined) ? parseInt(d.progress, 10) : 0;
			if(isNaN(pct)) pct = 0;
			$('#ab_push_progress_bar').css('width', pct + '%');
			if(d.log){
			  var cur = $('#ab_push_progress_log').val() || '';
			  $('#ab_push_progress_log').val(cur + d.log + "\n");
			  try{ $('#ab_push_progress_log')[0].scrollTop = $('#ab_push_progress_log')[0].scrollHeight; }catch(err){}
			}
			if(d.done){
			  clearInterval(timer);
			  $('#ab_push_status').text('Push complete.');
			}
		  });
		}, 900);
	  }).fail(function(){
		$('#ab_push_status').text('Failed to start push job.');
		abSetNotice($('#ab_push_notice'), 'Failed to start push job.', false);
	  });
	});

  $(function(){
    try {
		if($('#ab_dash_chart_1').length && typeof window.AegisBackupDashPayload !== 'undefined'){
		  abDashFillBadges(window.AegisBackupDashPayload);
		  abDashRenderCharts(window.AegisBackupDashPayload);
		}
      if($('#ab_dbtools_snapshots_wrap').length || $('#ab_prefix_snapshots_wrap').length){
        loadSnapshots();
      }
      if($('#ab_dbtools_activity_wrap').length){
        loadActivity();
      }
    } catch(e) {
      // silent
    }
  });

  function abAppendTextarea($ta, lines){
    if(!$ta || !$ta.length){ return; }
    var cur = $ta.val() || '';
    if(Array.isArray(lines)){
      for(var i=0;i<lines.length;i++){
        cur += (cur ? "\n" : "") + (lines[i] || '');
      }
    } else if(typeof lines === 'string'){
      cur += (cur ? "\n" : "") + lines;
    }
    $ta.val(cur);
    try { $ta.scrollTop($ta[0].scrollHeight); } catch(e) {}
  }

  $(document).on('submit', 'form', function(e){
    var $f = $(this);
    var $action = $f.find('input[name="action"]');
    if(!$action.length){ return; }
    if(($action.val() || '') !== 'aegisbackup_pp_migrate_files_post'){ return; }

    if(!window.AegisBackup || !AegisBackup.ajaxurl || !AegisBackup.nonce){ return; }

    e.preventDefault();

    var $wrap = $('#ab_pp_files_progress_wrap');
    var $ta = $('#ab_pp_files_progress');
    var $lbl = $('#ab_pp_files_progress_label');
    if($wrap.length){ $wrap.show(); }
    if($ta.length){ $ta.val(''); }
    if($lbl.length){ $lbl.text(''); }

    abAppendTextarea($ta, '[Starting file migration…]');

    var data = $f.serializeArray();
    data.push({name:'action', value:'aegisbackup_pp_files_start'});
    data.push({name:'nonce', value:AegisBackup.nonce});

    $.post(AegisBackup.ajaxurl, $.param(data)).done(function(res){
      if(!res || !res.success){
        var msg = (res && res.data && res.data.message) ? res.data.message : 'Failed to start file migration job.';
        abAppendTextarea($ta, '[ERROR] ' + msg);
        return;
      }
      var jobId = res.data.job_id;
      var totalFiles = parseInt(res.data.total_files || 0, 10);
      if($lbl.length && totalFiles){ $lbl.text('(0/' + totalFiles + ' files)'); }
      abAppendTextarea($ta, 'Job: ' + jobId);

      function tick(){
        $.post(AegisBackup.ajaxurl, {
          action: 'aegisbackup_pp_files_process',
          nonce: AegisBackup.nonce,
          job_id: jobId
        }).done(function(r){
          if(!r || !r.success){
            var m = (r && r.data && r.data.message) ? r.data.message : 'Processing failed.';
            abAppendTextarea($ta, '[ERROR] ' + m);
            return;
          }
          var d = r.data || {};
          if(d.lines && d.lines.length){
            abAppendTextarea($ta, d.lines);
          }
          if($lbl.length && typeof d.sent_files !== 'undefined' && typeof d.total_files !== 'undefined'){
            $lbl.text('(' + d.sent_files + '/' + d.total_files + ' files, ' + (d.errors||0) + ' errors)');
          }
          if(d.done){
            abAppendTextarea($ta, '[Done] Sent ' + (d.sent_files||0) + ' file(s), ' + (d.sent_dirs||0) + ' folder(s). Errors: ' + (d.errors||0));
            return;
          }
          setTimeout(tick, 700);
        });
      }

      tick();
    });
  });

  $(function(){
    var $destTa = $('#ab_pp_dest_live_log');
    if(!$destTa.length){ return; }
    if(!window.AegisBackup || !AegisBackup.resturl || !AegisBackup.restnonce){ return; }

    function refresh(){
      try{
        window.fetch(AegisBackup.resturl, {
          method: 'GET',
          credentials: 'same-origin',
          headers: {
            'X-WP-Nonce': AegisBackup.restnonce
          }
        }).then(function(r){ return r.json(); }).then(function(res){
          if(!res || !res.success){ return; }
          var lines = res.lines || [];
          if(!Array.isArray(lines)){ lines = []; }
          $destTa.val(lines.join("\n"));
          try { $destTa.scrollTop($destTa[0].scrollHeight); } catch(e) {}
        }).catch(function(){});
      }catch(e){}
    }

    refresh();

    var lastDbCount = null;
    var lastDbReceived = null;

    function refreshDbStatus(){
      $.post(AegisBackup.ajaxurl, {
        action: 'aegisbackup_pp_destdb_status',
        nonce: AegisBackup.nonce
      }).done(function(res){
        if(!res || !res.success){ return; }
        var d = res.data || {};
        var c = (typeof d.count !== 'undefined') ? parseInt(d.count,10) : 0;
        var lr = (typeof d.last_received !== 'undefined') ? parseInt(d.last_received,10) : 0;

        if(lastDbCount === null){ lastDbCount = c; lastDbReceived = lr; return; }

        if(c > lastDbCount || lr > lastDbReceived){
          try {
            var key = 'ab_pp_dest_db_reload_once';
            if(!sessionStorage.getItem(key)){
              sessionStorage.setItem(key, String(Date.now()));
              window.location.reload();
              return;
            }
          } catch(e) {}
        }
        lastDbCount = c;
        lastDbReceived = lr;
      });
    }

    refreshDbStatus();
    setInterval(refreshDbStatus, 4000);

    setInterval(refresh, 4000);
  });

	$(function(){
		if(!$('#ab_file_plan_form').length || !$('.ab-filetree').length){
			return;
		}

		function expandAll(open){
			$('.ab-filetree details').each(function(){
				this.open = !!open;
			});
		}

		$('#ab_ft_expand_all').on('click', function(e){
			e.preventDefault();
			expandAll(true);
		});
		$('#ab_ft_collapse_all').on('click', function(e){
			e.preventDefault();
			expandAll(false);
		});
		$('#ab_ft_clear_selection').on('click', function(e){
			e.preventDefault();
			$('.ab-filetree input[type="checkbox"]').prop('checked', false);
		});
	});

})(jQuery);

(function($){
  var tbPostMode = false;
  $(function(){
    tbPostMode = ($('#ab_tb_mode').length && ($('#ab_tb_mode').val()||'') === 'post');
  });
  function esc(s){
    return String(s===undefined?'':s).replace(/[&<\>"']/g,function(c){return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[c];});
  }

  function ajaxPost(action, data){
    data = data || {};
    data.action = action;

    if(typeof AegisBackup !== 'undefined' && AegisBackup.nonce){
      data._ajax_nonce = AegisBackup.nonce;
    } else if($('#aegisbackup_nonce').length){
      data._ajax_nonce = $('#aegisbackup_nonce').val();
    }

    var url = '';
    if(typeof AegisBackup !== 'undefined' && AegisBackup.ajaxurl){
      url = AegisBackup.ajaxurl;
    } else if(typeof ajaxurl !== 'undefined' && ajaxurl){
      url = ajaxurl;
    } else if($('#aegisbackup_ajaxurl').length){
      url = $('#aegisbackup_ajaxurl').val() || '';
    }
    if(!url){
      url = window.location.origin + '/wp-admin/admin-ajax.php';
    }

    return $.post(url, data);
  }

  function log(msg){
    var $el = $('#ab_tb_log');
    if(!$el.length) return;
    var cur = $el.text();
    $el.text(cur + (cur ? "\n" : "") + msg);
    $el.scrollTop($el[0].scrollHeight);
  }

  function loadDatabases(){
    return ajaxPost('aegisbackup_tablebacks_list_databases', {}).done(function(resp){
      var dbs = (resp && resp.success && resp.data && resp.data.databases) ? resp.data.databases : [];
      var $db = $('#ab_tb_db');
      var $pdb = $('#ab_tb_plan_db');
      $db.empty();
      $pdb.empty();
      for(var i=0;i<dbs.length;i++){
        var d = dbs[i];
        $db.append('<option value="'+esc(d)+'">'+esc(d)+'</option>');
        $pdb.append('<option value="'+esc(d)+'">'+esc(d)+'</option>');
      }
      if(!$db.val() && dbs.length){ $db.val(dbs[0]); }
      if(!$pdb.val() && dbs.length){ $pdb.val(dbs[0]); }
    });
  }

  function renderTables($wrap, tables){
    var html = '';
    if(!tables || !tables.length){
      html = '<em>No tables found.</em>';
      $wrap.html(html);
      return;
    }
    for(var i=0;i<tables.length;i++){
      var t = tables[i];
      html += '<div class="ab-tb-table" style="margin:0 0 8px 0; padding:6px 8px; border:1px solid #eee;">';
      html += '  <label style="font-weight:600;"><input type="checkbox" class="ab_tb_table" value="'+esc(t)+'" /> '+esc(t)+'</label>';
      html += '  <button type="button" class="button button-small ab_tb_cols_btn" data-table="'+esc(t)+'" style="margin-left:10px;">Columns</button>';
      html += '  <div class="ab_tb_cols" data-table="'+esc(t)+'" style="display:none; margin-top:6px; padding:6px; background:#fafafa; border:1px dashed #ddd;"></div>';
      html += '</div>';
    }
    $wrap.html(html);
  }

  function loadTables(db){
    $('#ab_tb_tables_spinner').addClass('is-active');
    return ajaxPost('aegisbackup_tablebacks_list_tables', {db: db}).done(function(resp){
      var tables = (resp && resp.success && resp.data && resp.data.tables) ? resp.data.tables : [];
      renderTables($('#ab_tb_tables'), tables);
      renderTables($('#ab_tb_plan_tables'), tables);
    }).always(function(){
      $('#ab_tb_tables_spinner').removeClass('is-active');
    });
  }

  function loadBackups(){
    return ajaxPost('aegisbackup_tablebacks_list_backups', {}).done(function(resp){
      var items = (resp && resp.success && resp.data && resp.data.backups) ? resp.data.backups : [];
      if(!items.length){
        $('#ab_tb_backups_wrap').html('<em>No table backups yet.</em>');
        return;
      }
      var html = '<table class="widefat striped"><thead><tr>'+
        '<th>Name</th><th>Created</th><th>Database</th><th>Tables</th><th>Size</th><th>Actions</th>'+
        '</tr></thead><tbody>';
      for(var i=0;i<items.length;i++){
        var b = items[i];
        var created = b.created ? new Date(b.created*1000).toLocaleString() : '';
        var tables = (b.tables && b.tables.length) ? b.tables.join(', ') : '';
        html += '<tr>';
        html += '<td><strong>'+esc(b.name||'')+'</strong><br><code>'+esc(b.id||'')+'</code></td>';
        html += '<td>'+esc(created)+'</td>';
        html += '<td>'+esc(b.db||'')+'</td>';
        html += '<td style="max-width:360px;">'+esc(tables)+'</td>';
        html += '<td>'+esc(b.size_human||'')+'</td>';
        html += '<td>'+
          '<a class="button button-small" href="'+esc(b.download_url||'#')+'">Download</a> ' +
          '<button type="button" class="button button-small ab_tb_restore" data-id="'+esc(b.id||'')+'">Restore</button> ' +
          '<button type="button" class="button button-small ab_tb_delete" data-id="'+esc(b.id||'')+'">Delete</button>' +
          '</td>';
        html += '</tr>';
      }
      html += '</tbody></table>';
      $('#ab_tb_backups_wrap').html(html);
    });
  }

  function loadPlans(){
    return ajaxPost('aegisbackup_tablebacks_list_plans', {}).done(function(resp){
      var plans = (resp && resp.success && resp.data && resp.data.plans) ? resp.data.plans : {};
      var keys = Object.keys(plans||{});
      if(!keys.length){
        $('#ab_tb_plans_wrap').html('<em>No schedules yet.</em>');
        return;
      }
      var html = '<table class="widefat striped"><thead><tr>'+
        '<th>Name</th><th>Frequency</th><th>Time</th><th>Database</th><th>Tables</th><th>Actions</th>'+
        '</tr></thead><tbody>';
      for(var i=0;i<keys.length;i++){
        var p = plans[keys[i]];
        var t = (p.tables && p.tables.length) ? p.tables.join(', ') : '';
        html += '<tr>';
        html += '<td><strong>'+esc(p.name||'')+'</strong><br><code>'+esc(p.id||'')+'</code></td>';
        html += '<td>'+esc(p.frequency||'')+'</td>';
        html += '<td>'+esc(p.time||'')+'</td>';
        html += '<td>'+esc(p.db||'')+'</td>';
        html += '<td style="max-width:360px;">'+esc(t)+'</td>';
        html += '<td><button type="button" class="button button-small ab_tb_plan_delete" data-id="'+esc(p.id||'')+'">Delete</button></td>';
        html += '</tr>';
      }
      html += '</tbody></table>';
      $('#ab_tb_plans_wrap').html(html);
    });
  }

  $(document).on('change', '#ab_tb_db', function(){
	if(tbPostMode) return; 																		  
    loadTables($(this).val()||'');
  });

  $(document).on('change', '#ab_tb_plan_db', function(){
	if(tbPostMode) return;					  
    loadTables($(this).val()||'');
  });

  $(document).on('change', '#ab_tb_select_all', function(){
    var on = $(this).is(':checked');
    $('#ab_tb_tables .ab_tb_table').prop('checked', on);
  });

  $(document).on('change', '.ab_tb_table', function(){
    var $all = $('#ab_tb_tables .ab_tb_table');
    if(!$all.length){ return; }
    var allOn = ($all.filter(':checked').length === $all.length);
    $('#ab_tb_select_all').prop('checked', allOn);
  });

  function syncScheduleFreqUI(){
    var f = $('#ab_tb_plan_freq').val() || 'daily';
    $('#ab_tb_plan_weekly').toggle(f === 'weekly');
    $('#ab_tb_plan_monthly').toggle(f === 'monthly');
  }

  $(function(){
    try {
      syncScheduleFreqUI();
      var $all = $('#ab_tb_tables .ab_tb_table');
      if($all.length){
        $('#ab_tb_select_all').prop('checked', ($all.filter(':checked').length === $all.length));
      }
    } catch(e) {}
  });

  $(document).on('change', '#ab_tb_plan_freq', function(){
    syncScheduleFreqUI();
  });

  function submitColumnsPost(table){
    var $f = $('#ab_tb_cols_form');
    if(!$f.length) return;
    $('#ab_tb_cols_db').val($('#ab_tb_plan_db').val() || $('#ab_tb_db').val() || '');
    $('#ab_tb_cols_name').val($('#ab_tb_plan_name').val() || $('#ab_tb_name').val() || '');
    $('#ab_tb_cols_table').val(table || '');

    var $payload = $('#ab_tb_cols_payload');
    $payload.empty();

    $('#ab_tb_tables .ab_tb_table:checked').each(function(){
      $payload.append('<input type="hidden" name="ab_tb_tables[]" value="'+esc($(this).val())+'" />');
      $payload.append('<input type="hidden" name="ab_tb_plan_tables[]" value="'+esc($(this).val())+'" />');
    });

    $('#ab_tb_tables .ab_tb_col:checked').each(function(){
      var t = $(this).closest('.ab-tb-table').find('.ab_tb_cols_btn').data('table') || $(this).data('table');
      var name = 'ab_tb_columns['+esc(t)+'][]';
      $payload.append('<input type="hidden" name="'+name+'" value="'+esc($(this).val())+'" />');
    });

    $f[0].submit();
  }

  $(document).on('click', '.ab_tb_cols_btn', function(e){
    e.preventDefault();
    var table = $(this).data('table');
    if(tbPostMode){
      submitColumnsPost(table);
      return;
    }
    var db = $('#ab_tb_db').val() || '';
    var $box = $('.ab_tb_cols[data-table="'+table+'"]').first();
    if(!$box.length) return;
    if($box.is(':visible')){ $box.hide(); return; }
    $box.html('<span class="spinner is-active" style="float:none;"></span> Loading columns...').show();
    ajaxPost('aegisbackup_tablebacks_list_columns', {db: db, table: table}).done(function(resp){
      var cols = (resp && resp.success && resp.data && resp.data.columns) ? resp.data.columns : [];
      if(!cols.length){ $box.html('<em>No columns found.</em>'); return; }
      var html = '<div style="margin:0 0 6px 0;"><strong>Columns</strong> (optional subset)</div>';
      for(var i=0;i<cols.length;i++){
        var c = cols[i];
        var label = c.name;
        html += '<label style="display:inline-block; margin:0 12px 6px 0;">' +
          '<input type="checkbox" class="ab_tb_col" data-table="'+esc(table)+'" value="'+esc(c.name)+'" /> ' + esc(label) +
          '</label>';
      }
      html += '<div class="description" style="margin-top:6px;">If you select columns here, only those columns are exported as INSERT data. The table schema is always exported in full.</div>';
      $box.html(html);
    }).fail(function(){
      $box.html('<em>Failed to load columns.</em>');
    });
  });

  $(document).on('click', '#ab_tb_create_backup', function(e){
	if(tbPostMode) return true;						   
    e.preventDefault();
    $('#ab_tb_create_spinner').addClass('is-active');
    $('#ab_tb_log').text('');
    var db = $('#ab_tb_db').val() || '';
    var name = $('#ab_tb_name').val() || '';
    var tables = $('.ab_tb_table:checked').map(function(){return $(this).val();}).get();
    var columns_map = {};
    $('.ab_tb_col:checked').each(function(){
      var t = $(this).data('table');
      if(!columns_map[t]) columns_map[t] = [];
      columns_map[t].push($(this).val());
    });
    log('Creating table backup...');
    ajaxPost('aegisbackup_tablebacks_create_backup', {db: db, name: name, tables: tables, columns_map: columns_map}).done(function(resp){
      if(!resp || !resp.success){
        log((resp && resp.data && resp.data.message) ? resp.data.message : 'Failed.');
        return;
      }
      log(resp.data.message || 'Created.');
      loadBackups();
    }).fail(function(xhr){
      log('Request failed.');
    }).always(function(){
      $('#ab_tb_create_spinner').removeClass('is-active');
    });
  });

  $(document).on('click', '.ab_tb_delete', function(e){
    e.preventDefault();
    if(!confirm('Delete this table backup?')) return;
    var id = $(this).data('id');
    ajaxPost('aegisbackup_tablebacks_delete_backup', {id: id}).always(function(){
      loadBackups();
    });
  });

  function pollRestore(jobId){
    ajaxPost('aegisbackup_tablebacks_process_restore', {job_id: jobId}).done(function(resp){
      if(!resp || !resp.success){
        log('Restore error.');
        return;
      }
      var d = resp.data || {};
      if(d.log){ log(d.log); }
      if(d.done){
        log('Restore finished.');
        return;
      }
      setTimeout(function(){ pollRestore(jobId); }, 650);
    }).fail(function(){
      log('Restore request failed.');
    });
  }

  $(document).on('click', '.ab_tb_restore', function(e){
    e.preventDefault();
    if(!confirm('Restore will APPLY the SQL in this backup and may overwrite tables. Continue?')) return;
    var id = $(this).data('id');
    $('#ab_tb_log').text('');
    log('Starting restore for ' + id + ' ...');
    ajaxPost('aegisbackup_tablebacks_start_restore', {id: id}).done(function(resp){
      if(!resp || !resp.success){
        log((resp && resp.data && resp.data.message) ? resp.data.message : 'Failed to start restore.');
        return;
      }
      var job = resp.data.job_id;
      log('Restore job: ' + job);
      pollRestore(job);
    }).fail(function(){
      log('Failed to start restore.');
    });
  });

  $(document).on('click', '#ab_tb_plan_save', function(e){
	if(tbPostMode) return true;						   
    e.preventDefault();
    $('#ab_tb_plan_spinner').addClass('is-active');
    var name = $('#ab_tb_plan_name').val() || '';
    var frequency = $('#ab_tb_plan_freq').val() || 'daily';
    var time = $('#ab_tb_plan_time').val() || '02:00';
    var db = $('#ab_tb_plan_db').val() || '';
    var tables = $('#ab_tb_plan_tables .ab_tb_table:checked').map(function(){return $(this).val();}).get();
    ajaxPost('aegisbackup_tablebacks_save_plan', {name:name, frequency:frequency, time:time, db:db, tables:tables, enabled:1}).done(function(resp){
      if(resp && resp.success){
        $('#ab_tb_plan_name').val('');
        loadPlans();
      }
    }).always(function(){
      $('#ab_tb_plan_spinner').removeClass('is-active');
    });
  });

  $(document).on('click', '.ab_tb_plan_delete', function(e){
    e.preventDefault();
    if(!confirm('Delete this schedule?')) return;
    var id = $(this).data('id');
    ajaxPost('aegisbackup_tablebacks_delete_plan', {id:id}).always(function(){ loadPlans(); });
  });

  $(function(){
    if(!$('#ab_tb_db').length && !$('#ab_tb_plan_db').length) return;
	syncScheduleFreqUI();
	if(tbPostMode) return;									  
    loadDatabases().done(function(){
      loadTables($('#ab_tb_db').val()||'');
    });
    loadBackups();
    loadPlans();
  });

})(jQuery);

(function($){
  function esc(s){
    return String(s===undefined?'':s).replace(/[&<>"']/g,function(c){return {'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[c];});
  }
  function abDbLog(msg){
    var $el = $('#ab_dbtools_log');
    if(!$el.length) return;
    var cur = $el.text();
    $el.text(cur + (cur ? "\n" : "") + msg);
    $el.scrollTop($el[0].scrollHeight);
  }

  function abPrefixNotice(type, msg){
    var $wrap = $('#ab_prefix_notice');
    if(!$wrap.length){
      abDbLog((type ? ('['+type.toUpperCase()+'] ') : '') + msg);
      return;
    }
    var cls = 'notice';
    if(type === 'success') cls += ' notice-success';
    else if(type === 'warning') cls += ' notice-warning';
    else if(type === 'error') cls += ' notice-error';
    else cls += ' notice-info';

    $wrap
      .html('<div class="'+cls+'" style="margin:10px 0;padding:8px 12px;"><p style="margin:0;">'+esc(msg)+'</p></div>')
      .show();
  }

	function ajaxPost(action, data){
	  data = data || {};
	  data.action = action;

	  var nonce = (window.AegisBackup && AegisBackup.nonce) ? AegisBackup.nonce : '';
	  if(!nonce && $('#aegisbackup_nonce').length){ nonce = $('#aegisbackup_nonce').val() || ''; }
	  data.nonce = nonce;

	  var url = (window.AegisBackup && AegisBackup.ajaxurl) ? AegisBackup.ajaxurl : '';
	  if(!url && $('#aegisbackup_ajaxurl').length){ url = $('#aegisbackup_ajaxurl').val() || ''; }
	  if(!url){ url = (typeof ajaxurl !== 'undefined') ? ajaxurl : ''; }
	  if(!url){ url = '/wp-admin/admin-ajax.php'; }

	  return $.ajax({
		url: url,
		method: 'POST',
		data: data,
		dataType: 'json'
	  });
	}

  function getSelectedTables(){
    return $('.ab_dbtools_table:checked').map(function(){ return $(this).val(); }).get();
  }

  $(document).on('change', '#ab_dbtools_select_all', function(){
    var checked = $(this).is(':checked');
    $('.ab_dbtools_table').prop('checked', checked);
  });

  $(document).on('click', '#ab_dbtools_export_csv', function(e){
    e.preventDefault();
    var $btn = $(this);
    $btn.closest('p').find('.spinner').addClass('is-active');
    abDbLog('Exporting CSV...');
    ajaxPost('aegisbackup_dbtools_export_csv', {}).done(function(resp){
      if(!resp || !resp.success){ abDbLog('CSV export failed.'); return; }
      var csv = (resp.data && resp.data.csv) ? resp.data.csv : '';
      var filename = (resp.data && resp.data.filename) ? resp.data.filename : 'db-table-summary.csv';
      try {
        var blob = new Blob([csv], {type: 'text/csv;charset=utf-8;'});
        var url = URL.createObjectURL(blob);
        var a = document.createElement('a');
        a.href = url;
        a.download = filename;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
        abDbLog('CSV downloaded.');
      } catch(err){
        abDbLog('CSV download failed in browser.');
      }
    }).fail(function(){
      abDbLog('CSV export failed (request error).');
    }).always(function(){
      $btn.closest('p').find('.spinner').removeClass('is-active');
    });
  });

  function runDbOp(op){
    var tables = getSelectedTables();
    if(!tables.length){
      abDbLog('No tables selected.');
      return;
    }
    abDbLog('Running ' + op + ' on ' + tables.length + ' tables...');
    var $spinner = $('#ab_dbtools_log').closest('div').find('.spinner');
    $spinner.addClass('is-active');
    try { $('#ab_dbtools_results_wrap').hide(); $('#ab_dbtools_results').empty(); } catch(e) {}

    ajaxPost('aegisbackup_dbtools_table_op', { op: op, tables: tables }).done(function(resp){
      if(!resp || !resp.success){
        abDbLog('Operation failed.');
        return;
      }
      if(resp.data){
        renderDbOpResults(op, resp.data);
      }

      var msgs = (resp.data && resp.data.messages) ? resp.data.messages : [];
      msgs.forEach(function(m){ abDbLog(m); });
      abDbLog('Done.');
    }).fail(function(){
      abDbLog('Operation failed (request error).');
    }).always(function(){
      $spinner.removeClass('is-active');
    });
  }

  function renderDbOpResults(op, data){
    var $wrap = $('#ab_dbtools_results_wrap');
    var $box  = $('#ab_dbtools_results');
    if(!$wrap.length || !$box.length) return;

    var rows = (data && data.results) ? data.results : [];
    if(!rows.length && data && data.messages){
      rows = (data.messages||[]).map(function(m){
        return { table: (m.split(':')[0]||'').trim(), status:'ok', msg_type:'', msg_text:m };
      });
    }

    if(!rows.length){
      $box.html('<p><strong>No results returned.</strong></p>');
      $wrap.show();
      return;
    }

    var title = (op === 'analyze') ? 'Analyze Results' : (op === 'optimize' ? 'Optimize Results' : 'Repair Results');
    var html = '<div style="margin-bottom:8px;"><strong>' + esc(title) + '</strong></div>';
    html += '<table class="widefat striped" style="margin:0;">';
    html += '<thead><tr><th style="width:28%;">Table</th><th style="width:14%;">Status</th><th style="width:18%;">Type</th><th>Message</th></tr></thead><tbody>';
    rows.forEach(function(r){
      var st = (r.status||'').toString().toLowerCase();
      var badge = st === 'error' ? '<span style="color:#b32d2e;font-weight:600;">Error</span>' : '<span style="color:#1d6f2b;font-weight:600;">OK</span>';
      html += '<tr>';
      html += '<td><code>' + esc(r.table||'') + '</code></td>';
      html += '<td>' + badge + '</td>';
      html += '<td>' + esc(r.msg_type||'') + '</td>';
      html += '<td>' + esc(r.msg_text||'') + '</td>';
      html += '</tr>';
    });
    html += '</tbody></table>';
    $box.html(html);
    $wrap.show();
  }

  $(document).on('click', '#ab_dbtools_analyze', function(e){ e.preventDefault(); runDbOp('analyze'); });
  $(document).on('click', '#ab_dbtools_optimize', function(e){ e.preventDefault(); runDbOp('optimize'); });
  $(document).on('click', '#ab_dbtools_repair', function(e){ e.preventDefault(); runDbOp('repair'); });


  function renderSnapshots(list){
    var $wrap = $('#ab_dbtools_snapshots_wrap');
    var $wrap2 = $('#ab_prefix_snapshots_wrap');
    if(!$wrap.length && !$wrap2.length) return;
    if(!$wrap.length) $wrap = $wrap2;


    list = list || [];
    if(!list.length){
      $wrap.html('<p><em>No snapshots found yet.</em></p>');
      if($wrap2 && $wrap2.length){ $wrap2.html('<p><em>No snapshots found yet.</em></p>'); }

      return;
    }

    var html = '<table class="widefat striped"><thead><tr><th>File</th><th>Size</th><th>Modified</th><th>Actions</th></tr></thead><tbody>';
    list.forEach(function(it){
      html += '<tr>';
      html += '<td><code>' + esc(it.file) + '</code></td>';
      html += '<td>' + esc(it.size_h || it.size || '') + '</td>';
      html += '<td>' + esc(it.mtime_h || '') + '</td>';
      html += '<td>';
      if(it.download_url){
        html += '<a class="button button-small" href="' + esc(it.download_url) + '">Download</a> ';
      }
      html += '<button class="button button-small ab_dbtools_delete_snapshot" data-file="' + esc(it.file) + '">Delete</button>';
      html += '</td>';
      html += '</tr>';
    });
    html += '</tbody></table>';
    $wrap.html(html);
    if($wrap2 && $wrap2.length){ $wrap2.html(html); }
  }

  var prefixPreviewOk = false;

  function updateApplyEnabled(){
    var $btn = $('#ab_dbtools_apply_prefix');
    if(!$btn.length) return;
    var hasPreview = !!prefixPreviewOk;
    var snap = ($('#ab_prefix_snapshot').val()||'').trim();
    var confirmed = $('#ab_prefix_confirm_apply').is(':checked');
    $btn.prop('disabled', !(hasPreview && !!snap && confirmed));
  }

	function renderPrefixSnapshotSelect(list, autoSelectFile){
	  var $sel = $('#ab_prefix_snapshot');
	  if(!$sel.length) return;
	  list = list || [];

	  if(!list.length){
		updateApplyEnabled();
		return;
	  }

	  var cur = $sel.val();
	  $sel.empty();
	  $sel.append('<option value="">-- Select a DB snapshot --</option>');

	  list.forEach(function(it){
		var label = (it.file||'') + (it.mtime_h ? (' ('+it.mtime_h + (it.size_h?(', '+it.size_h):'') + ')') : '');
		$sel.append('<option value="' + esc(it.file||'') + '">' + esc(label) + '</option>');
	  });

	  if(autoSelectFile){
		$sel.val(autoSelectFile);
	  } else if(cur){
		$sel.val(cur);
	  }

	  updateApplyEnabled();
	}

  function renderPairTable(rows, col1, col2){
    rows = rows || [];
    if(!rows.length){
      return '<p class="description"><em>None detected.</em></p>';
    }
    var html = '<table class="widefat striped"><thead><tr><th>'+esc(col1)+'</th><th>'+esc(col2)+'</th></tr></thead><tbody>';
    rows.forEach(function(r){
      html += '<tr><td><code>'+esc(r.current||'')+'</code></td><td><code>'+esc(r.new||'')+'</code></td></tr>';
    });
    html += '</tbody></table>';
    return html;
  }

  function renderAffectedTables(rows){
    rows = rows || [];
    if(!rows.length){
      return '<p class="description"><em>No matching tables found.</em></p>';
    }
    var html = '<table class="widefat striped"><thead><tr><th>Current Name</th><th>New Name</th><th>Type</th></tr></thead><tbody>';
    rows.forEach(function(r){
      html += '<tr><td><code>'+esc(r.current||'')+'</code></td><td><code>'+esc(r.new||'')+'</code></td><td>'+esc(r.type||'')+'</td></tr>';
    });
    html += '</tbody></table>';
    return html;
  }

  function renderWpConfigInfo(info){
    info = info || {};
    var html = '<table class="widefat striped"><tbody>';
    html += '<tr><th style="width:240px;">Config file</th><td><code>'+esc(info.path||'')+'</code></td></tr>';
    html += '<tr><th>Writable</th><td>' + (info.writable ? 'Yes' : 'No') + '</td></tr>';
    html += '<tr><th>Current $table_prefix</th><td><code>'+esc(info.current||'')+'</code></td></tr>';
    html += '<tr><th>Planned $table_prefix</th><td><code>'+esc(info.planned||'')+'</code></td></tr>';
    if(info.manual_line){
      html += '<tr><th>Manual line (if not writable)</th><td><code>'+esc(info.manual_line)+'</code></td></tr>';
    }
    html += '</tbody></table>';
    return html;
  }

  function renderVerifyResult(res){
    res = res || {};
    var issues = res.issues || [];
    var warnings = res.warnings || [];
    var samples = res.samples || null;
    var html = '';
    if(issues.length){
      html += '<div class="notice notice-error inline"><p><strong>Blocking issues</strong></p><ul style="margin-left:18px;">';
      issues.forEach(function(m){ html += '<li>'+esc(m)+'</li>'; });
      html += '</ul></div>';
    } else {
      html += '<div class="notice notice-success inline"><p><strong>No blocking issues detected.</strong></p></div>';
    }
    if(warnings.length){
      html += '<div class="notice notice-warning inline" style="margin-top:10px;"><p><strong>Warnings</strong></p><ul style="margin-left:18px;">';
      warnings.forEach(function(m){ html += '<li>'+esc(m)+'</li>'; });
      html += '</ul></div>';
    }
    if(samples){
      html += '<details style="margin-top:10px;"><summary>View samples</summary><pre style="background:#fff;border:1px solid #ccd0d4;padding:10px;overflow:auto;">'+esc(JSON.stringify(samples,null,2))+'</pre></details>';
    }
    return html;
  }

  function loadSnapshots(){
    ajaxPost('aegisbackup_dbtools_list_snapshots', {}).done(function(resp){
      if(resp && resp.success){
        var list = (resp.data && resp.data.items) ? resp.data.items : [];
        renderSnapshots(list);
        if($('#ab_prefix_snapshot').length){
          renderPrefixSnapshotSelect(list);
        }
		} else {
			renderSnapshots([]);
			abDbLog('Snapshot list request failed. If your host blocks admin-ajax, use the DB Snapshots tab list and the dropdown should still work.');
		  }
		}).fail(function(){
		  renderSnapshots([]);
		  abDbLog('Snapshot list request failed (request error). If your host blocks admin-ajax, the server-rendered dropdown options will still work.');
		});

  }

  function renderActivity(list){
    var $wrap = $('#ab_dbtools_activity_wrap');
    if(!$wrap.length) return;
    list = list || [];
    if(!list.length){
      $wrap.html('<p><em>No activity recorded yet.</em></p>');
      return;
    }

    var html = '<table class="widefat striped"><thead><tr><th style="width:110px;">Day</th><th style="width:90px;">Time</th><th style="width:120px;">Action</th><th>Result</th></tr></thead><tbody>';
    list.forEach(function(it){
      html += '<tr>';
      html += '<td>' + esc(it.date || '') + '</td>';
      html += '<td>' + esc(it.time || '') + '</td>';
      html += '<td><code>' + esc(it.action || '') + '</code></td>';
      html += '<td>' + esc(it.result || '') + '</td>';
      html += '</tr>';
    });
    html += '</tbody></table>';
    $wrap.html(html);
  }

  function loadActivity(){
    if(!$('#ab_dbtools_activity_wrap').length) return;
    ajaxPost('aegisbackup_dbtools_list_activity', { limit: 50 }).done(function(resp){
      if(resp && resp.success){
        renderActivity((resp.data && resp.data.items) ? resp.data.items : []);
      } else {
        renderActivity([]);
      }
    }).fail(function(){
      renderActivity([]);
    });
  }

  $(document).on('click', '#ab_dbtools_create_snapshot', function(e){
    e.preventDefault();
    var $sp = $('#ab_dbtools_snapshot_spinner').addClass('is-active');
    abDbLog('Creating DB snapshot…');
    ajaxPost('aegisbackup_dbtools_create_snapshot', {}).done(function(resp){
      if(resp && resp.success){
        abDbLog(resp.data && resp.data.message ? resp.data.message : 'Snapshot created.');
        loadSnapshots();
        loadActivity();
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Snapshot failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

  $(document).on('click', '.ab_dbtools_delete_snapshot', function(e){
    e.preventDefault();
    var file = $(this).data('file');
    if(!file) return;
    if(!confirm('Delete snapshot ' + file + '?')) return;
    abDbLog('Deleting snapshot: ' + file);
    ajaxPost('aegisbackup_dbtools_delete_snapshot', { file: file }).done(function(resp){
      if(resp && resp.success){
        abDbLog('Snapshot deleted.');
        loadSnapshots();
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Delete failed.');
      }
    }).fail(function(){
      abDbLog('Delete failed (request error).');
    });
  });

  $(document).on('click', '.ab_dbtools_restore_snapshot', function(e){
    e.preventDefault();
    var file = $(this).data('file');
    if(!file) return;
    if(!confirm('RESTORE DATABASE from snapshot ' + file + '? This will overwrite current tables.')) return;
    abDbLog('Restoring snapshot: ' + file);
    var $sp = $('#ab_dbtools_snapshot_spinner').addClass('is-active');
    ajaxPost('aegisbackup_dbtools_restore_snapshot', { file: file }).done(function(resp){
      if(resp && resp.success){
        abDbLog((resp.data && resp.data.message) ? resp.data.message : 'Snapshot restored.');
        if(resp.data && resp.data.messages && resp.data.messages.length){
          resp.data.messages.forEach(function(m){ abDbLog(m); });
        }
        loadSnapshots();
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Restore failed.');
      }
    }).fail(function(){
      abDbLog('Restore failed (request error).');
    }).always(function(){
      $sp.removeClass('is-active');
    });
  });

  $(function(){

    if($('#ab_dbtools_snapshots_wrap').length || $('#ab_prefix_snapshot').length){
      loadSnapshots();
    }

    if($('#ab_dbtools_activity_wrap').length){
      loadActivity();
    }
  });

  $(document).on('change keyup', '#ab_prefix_snapshot, #ab_prefix_confirm_apply, #ab_new_prefix', function(){
    if($(this).is('#ab_new_prefix')){
      prefixPreviewOk = false;
      $('#ab_prefix_preview_wrap').hide();
    }
    updateApplyEnabled();
  });

  $(document).on('click', '#ab_dbtools_prefix_preview', function(e){
    e.preventDefault();
    prefixPreviewOk = false;
    updateApplyEnabled();

    var newPrefix = ($('#ab_new_prefix').val()||'').trim();
    if(!newPrefix){
      abDbLog('Please enter a new prefix.');
      return;
    }

    var currentPrefix = ($('#ab_prefix_current').val()||'').trim();
    var $sp = $('#ab_dbtools_prefix_preview_spinner').addClass('is-active');
    abDbLog('Generating prefix preview (dry-run)…');

    ajaxPost('aegisbackup_dbtools_prefix_preview', { new_prefix: newPrefix, current_prefix: currentPrefix }).done(function(resp){
      if(resp && resp.success){
        var d = resp.data || {};
        $('#ab_prefix_preview_tables').html(renderAffectedTables(d.tables||[]));
        $('#ab_prefix_preview_options').html(renderPairTable(d.options||[], 'Current option_name', 'New option_name'));
        $('#ab_prefix_preview_usermeta').html(renderPairTable(d.usermeta||[], 'Current meta_key', 'New meta_key'));
        $('#ab_prefix_preview_wpconfig').html(renderWpConfigInfo(d.wpconfig||{}));
        $('#ab_prefix_preview_wrap').show();

        if(d.collisions && d.collisions.length){
          abDbLog('BLOCKING: Destination table(s) already exist: ' + d.collisions.join(', '));
          prefixPreviewOk = false;
        } else {
          prefixPreviewOk = true;
          if(d.new){ $('#ab_new_prefix').val(d.new); }
          abDbLog('Preview OK. Select a snapshot + confirm to enable Apply.');
		  updateApplyEnabled();
        }

      } else {
        var m = (resp && resp.data && (resp.data.message || (resp.data.data && resp.data.data.message))) ? (resp.data.message || resp.data.data.message) : 'Preview failed.';
        abDbLog(m);
        $('#ab_prefix_preview_wrap').hide();
        prefixPreviewOk = false;
      }
		}).fail(function(){
		  abDbLog('Preview failed (request error).');
		  $('#ab_prefix_preview_tables').html('<div class="notice notice-error inline"><p><strong>Preview failed.</strong> Your server may be blocking admin-ajax requests. Check browser console/network for admin-ajax.php.</p></div>');
		  $('#ab_prefix_preview_wrap').show();
		  prefixPreviewOk = false;
		}).always(function(){
      $sp.removeClass('is-active');
      updateApplyEnabled();
    });
  });

  $(document).on('click', '#ab_prefix_create_snapshot_inline', function(e){
    e.preventDefault();
    var $sp = $('#ab_prefix_create_snapshot_spinner').addClass('is-active');
    abDbLog('Creating DB snapshot…');
    ajaxPost('aegisbackup_dbtools_create_snapshot', {}).done(function(resp){
      if(resp && resp.success){
        abDbLog(resp.data && resp.data.message ? resp.data.message : 'Snapshot created.');
        ajaxPost('aegisbackup_dbtools_list_snapshots', {}).done(function(r2){
          if(r2 && r2.success){
            var list = (r2.data && r2.data.items) ? r2.data.items : [];
            renderSnapshots(list);
            var newest = list.length ? (list[0].file||'') : '';
            renderPrefixSnapshotSelect(list, newest);
            if(newest){ abDbLog('Selected snapshot: ' + newest); }
          }
        });
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Snapshot failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); updateApplyEnabled(); });
  });

  $(document).on('click', '#ab_dbtools_apply_prefix', function(e){
    e.preventDefault();
    if($(this).prop('disabled')) return;
    var newPrefix = ($('#ab_new_prefix').val() || '').trim();
    var snapshot = ($('#ab_prefix_snapshot').val() || '').trim();
    if(!snapshot){ abDbLog('Select a DB snapshot first (required).'); return; }
    if(!$('#ab_prefix_confirm_apply').is(':checked')){ abDbLog('Please confirm before applying.'); return; }
    if(!prefixPreviewOk){ abDbLog('Run Preview first (required).'); return; }



    var $sp = $('#ab_dbtools_apply_prefix_spinner').addClass('is-active');
    abDbLog('Applying prefix change…');
    ajaxPost('aegisbackup_dbtools_prefix_change', {
      new_prefix: newPrefix,
      backup_first: 0,
      snapshot_file: snapshot
    }).done(function(resp){
      if(resp && resp.success){
        var d = resp.data || {};
        abDbLog(d.message || 'Prefix change completed.');
        (d.details || []).forEach(function(m){ abDbLog(m); });
        abDbLog('NEXT: verify wp-config.php $table_prefix matches the NEW prefix, then run the Verification Scan below.');
      } else {
        var data = resp && resp.data ? resp.data : {};
        abDbLog((data.message || 'Prefix change failed.') );
        (data.details || []).forEach(function(m){ abDbLog(m); });
      }
    }).fail(function(){
      abDbLog('Prefix change failed (request error).');
    }).always(function(){
      $sp.removeClass('is-active');
    });
  });

  $(document).on('click', '#ab_dbtools_prefix_verify', function(e){
    e.preventDefault();
    var expected = ($('#ab_new_prefix').val()||'').trim();
    var oldp = ($('#ab_prefix_current').val()||'').trim();
    if(!expected){ abDbLog('Enter the expected NEW prefix first.'); return; }
    var $sp = $('#ab_dbtools_prefix_verify_spinner').addClass('is-active');
    abDbLog('Running verification scan (read-only)…');
    ajaxPost('aegisbackup_dbtools_prefix_verify', { expected_prefix: expected, old_prefix: oldp }).done(function(resp){
      if(resp && resp.success){
        $('#ab_prefix_verify_wrap').html(renderVerifyResult(resp.data||{})).show();
        abDbLog('Verification scan completed.');
      } else {
        $('#ab_prefix_verify_wrap').hide();
        abDbLog('Verification scan failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

  $(document).on('click', '#ab_dbtools_save_settings', function(e){
    e.preventDefault();
    var $sp = $('#ab_dbtools_save_spinner').addClass('is-active');
    var weekly = $('#ab_dbtools_weekly_opt').is(':checked') ? 1 : 0;
    var growth = $('#ab_dbtools_growth_monitor').is(':checked') ? 1 : 0;
    abDbLog('Saving DB Tools settings…');
    ajaxPost('aegisbackup_dbtools_save_settings', { weekly: weekly, growth: growth }).done(function(resp){
      if(resp && resp.success){
        abDbLog('Settings saved.');
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Save failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

  $(document).on('click', '#ab_dbtools_run_optimize', function(e){
    e.preventDefault();
    var $sp = $('#ab_dbtools_opt_spinner').addClass('is-active');
    abDbLog('Running optimization…');
    ajaxPost('aegisbackup_dbtools_run_optimization', {}).done(function(resp){
      if(resp && resp.success){
        abDbLog(resp.data && resp.data.message ? resp.data.message : 'Optimization done.');
        loadActivity();
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Optimization failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

  $(document).on('click', '#ab_dbtools_run_growth', function(e){
    e.preventDefault();
    var $sp = $('#ab_dbtools_growth_spinner').addClass('is-active');
    abDbLog('Running growth check…');
    ajaxPost('aegisbackup_dbtools_run_growth', {}).done(function(resp){
      if(resp && resp.success){
        var d = resp.data || {};
        abDbLog((d.message||'Growth check done.') + ' Total: ' + (d.total_h||d.total||'') + ' Delta: ' + (d.delta_h||d.delta||''));
        loadActivity();
      } else {
        abDbLog((resp && resp.data && resp.data.message) ? resp.data.message : 'Growth check failed.');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

  $(document).on('click', '#ab_dbtools_run_scan', function(e){
    e.preventDefault();
    var $sp = $('#ab_dbtools_scan_spinner').addClass('is-active');
    var pfx = $('#ab_dbtools_scan_prefix').val() || '';
    abDbLog('Running prefix verification scan…');
    ajaxPost('aegisbackup_dbtools_prefix_scan', { prefix: pfx }).done(function(resp){
      var $out = $('#ab_dbtools_scan_results');
      if(!$out.length) return;
      if(resp && resp.success){
        var res = resp.data && resp.data.results ? resp.data.results : [];
        var html = '<ul style="margin-left:18px;">';
        res.forEach(function(r){
          html += '<li><strong>' + esc((r.level||'info').toUpperCase()) + ':</strong> ' + esc(r.message||'') + '</li>';
        });
        html += '</ul>';
        $out.html(html);
      } else {
        $out.html('<p><strong>Scan failed.</strong></p>');
      }
    }).always(function(){ $sp.removeClass('is-active'); });
  });

	function abDashRenderCharts(payload){
	  if(typeof Chart === 'undefined'){ return; }
	  if(!payload || !payload.charts){ return; }

	  var c = payload.charts;
	  window.AB_DashCharts = window.AB_DashCharts || {};
	  
	function abDashFillBadges(payload){
	  if(!payload){ return; }
	  var meta = payload.meta || {};
	  var settings = payload.settings || {};

	  var elLast = document.getElementById('ab_dash_last_backup');
	  if(elLast){
		if(meta.last_backup_ts && parseInt(meta.last_backup_ts,10) > 0){
		  var d = new Date(parseInt(meta.last_backup_ts,10) * 1000);
		  elLast.textContent = d.toLocaleString();
		  elLast.classList.add('ok');
		} else {
		  elLast.textContent = 'No backups yet';
		  elLast.classList.remove('ok');
		}
	  }

	  var elVer = document.getElementById('ab_dash_version');
	  if(elVer){
		elVer.textContent = meta.version ? meta.version : '—';
	  }

	  var elRemote = document.getElementById('ab_dash_remote');
	  if(elRemote){
		if(settings.remote_enabled){
		  elRemote.textContent = 'Enabled (' + (settings.remote_provider || 'provider') + ')';
		  elRemote.classList.add('ok');
		} else {
		  elRemote.textContent = 'Disabled';
		  elRemote.classList.remove('ok');
		}
	  }

	  var elSmtp = document.getElementById('ab_dash_smtp');
	  if(elSmtp){
		if(settings.smtp_enabled){
		  elSmtp.textContent = 'Enabled';
		  elSmtp.classList.add('ok');
		} else {
		  elSmtp.textContent = 'Disabled';
		  elSmtp.classList.remove('ok');
		}
	  }

		var elLic = document.getElementById('ab_dash_license');
		if(elLic){
		  var lic = payload.license || {};
		  if(lic.active){
			var label = lic.is_pro ? 'Active (Pro)' : 'Active';
			if(lic.plan){ label += ' • ' + lic.plan; }
			elLic.textContent = label;
			elLic.classList.remove('fail');
			elLic.classList.add('ok');
		  } else {
			elLic.textContent = 'Inactive';
			elLic.classList.remove('ok');
			elLic.classList.add('fail');
		  }
		}
	}
	
	function mount(id, cfg){
	  var el = document.getElementById(id);
	  if(!el){ return; }

	  if(window.AB_DashCharts[id]){
		try{ window.AB_DashCharts[id].destroy(); }catch(e){}
	  }

	  try {
		if(!cfg.type && cfg.data && cfg.data.datasets && cfg.data.datasets.length){
		  cfg.type = cfg.data.datasets[0].type || 'bar';
		}

		window.AB_DashCharts[id] = new Chart(el.getContext('2d'), cfg);
	  } catch(e) {

		if(window.console && console.error){
		  console.error('AegisBackup Dashboard chart failed:', id, e);
		}
	  }
	}

	  var wh = c.wp_health || {};
	  mount('ab_dash_chart_1', {
		type: 'doughnut',
		data: {
		  labels: ['Good','Recommended','Critical'],
		  datasets: [{ label:'WordPress Health', data:[wh.good||0, wh.recommended||0, wh.critical||0] }]
		},
		options: { responsive:true, maintainAspectRatio:false, plugins:{ title:{ display:true, text:'WP Health Score: ' + (wh.score||0) + '/100' } } }
	  });

	  var dh = c.db_health || {};
	  mount('ab_dash_chart_2', {
		type: 'doughnut',
		data: {
		  labels: ['OK','Warnings','Critical'],
		  datasets: [{ label:'Database Health', data:[dh.ok||0, dh.warn||0, dh.critical||0] }]
		},
		options: { responsive:true, maintainAspectRatio:false, plugins:{ title:{ display:true, text:'DB Score: ' + (dh.score||0) + '/100 • Size: ' + (dh.size_mb||0) + 'MB' } } }
	  });

	  var sh = c.svc_health || {};
	  mount('ab_dash_chart_3', {
		type: 'doughnut',
		data: {
		  labels: ['OK','Warnings','Critical'],
		  datasets: [{ label:'Services Health', data:[sh.ok||0, sh.warn||0, sh.critical||0] }]
		},
		options: { responsive:true, maintainAspectRatio:false, plugins:{ title:{ display:true, text:'Services Score: ' + (sh.score||0) + '/100' } } }
	  });

	  var days = c.days || [];
		mount('ab_dash_chart_4', {
		  type: 'bar', 
		  data: {
			labels: days,
			datasets: [
			  { type:'bar',  label:'Success', data:c.backup_success_14d||[], stack:'bk' },
			  { type:'bar',  label:'Failed',  data:c.backup_failed_14d||[],  stack:'bk' },
			  { type:'bar',  label:'Error',   data:c.backup_error_14d||[],   stack:'bk' },
			  { type:'line', label:'Avg Size (MB)', data:c.backup_avg_size_mb||[], yAxisID:'y1', tension:0.25 }
			]
		  },
		  options: {
			responsive:true,
			maintainAspectRatio:false,
			plugins:{ legend:{ display:true } },
			scales:{
			  y:{ stacked:true, beginAtZero:true },
			  y1:{ beginAtZero:true, position:'right', grid:{ drawOnChartArea:false } }
			}
		  }
		});

	  mount('ab_dash_chart_5', {
		type:'bar',
		data:{
		  labels: days,
		  datasets:[
			{ label:'Success', data:c.restore_success_14d||[], stack:'rs' },
			{ label:'Failed',  data:c.restore_failed_14d||[],  stack:'rs' },
			{ label:'Error',   data:c.restore_error_14d||[],   stack:'rs' }
		  ]
		},
		options:{ responsive:true, maintainAspectRatio:false, scales:{ y:{ stacked:true, beginAtZero:true } } }
	  });

	  var br = c.backup_radar || {};
	  mount('ab_dash_chart_6', {
		type:'radar',
		data:{
		  labels: br.labels || [],
		  datasets:[{ label:'Backup KPI (0-100)', data: br.values || [], fill:true }]
		},
		options:{ responsive:true, maintainAspectRatio:false, scales:{ r:{ beginAtZero:true, suggestedMax:100 } } }
	  });
	}

  $(function(){
    try {
		if($('#ab_dash_chart_1').length && typeof window.AegisBackupDashPayload !== 'undefined'){
		  abDashFillBadges(window.AegisBackupDashPayload);
		  abDashRenderCharts(window.AegisBackupDashPayload);
		}
      if($('#ab_dbtools_snapshots_wrap').length || $('#ab_prefix_snapshots_wrap').length){
        loadSnapshots();
      }
      if($('#ab_dbtools_activity_wrap').length){
        loadActivity();
      }
    } catch(e) {
    }
  });

})(jQuery);
