<?php
namespace AegisBackup\Admin;

use AegisBackup\AB_Plugin;

defined( 'ABSPATH' ) || exit;

require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-backups.php';
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-dashboard.php';				
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-restore.php';
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-pushpull.php';
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-migration-wizard.php';
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-logs.php';
require_once AEGISBACKUP_DIR . 'includes/admin/pages/class-ab-page-license.php';

class AB_Admin {

    protected $plugin;

    public function __construct( AB_Plugin $plugin ) {
        $this->plugin = $plugin;
    }

    public function init() {
        add_action( 'admin_menu', array( $this, 'admin_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_assets' ) );
        add_action( 'wp_ajax_aegisbackup_start_backup', array( $this, 'ajax_start_backup' ) );
        add_action( 'wp_ajax_aegisbackup_start_dr_recovery_backup', array( $this, 'ajax_start_dr_recovery_backup' ) );
        add_action( 'wp_ajax_aegisbackup_process_backup', array( $this, 'ajax_process_backup' ) );
        add_action( 'wp_ajax_aegisbackup_list_packages', array( $this, 'ajax_list_packages' ) );
		add_action( 'wp_ajax_aegisbackup_filetree_list', array( $this, 'ajax_filetree_list' ) );
		add_action( 'wp_ajax_aegisbackup_dashboard_prune', array( $this, 'ajax_dashboard_prune' ) );
		add_action( 'admin_post_aegisbackup_dashboard_download_logs', array( $this, 'handle_dashboard_download_logs' ) );
        add_action( 'admin_post_aegisbackup_upload_package', array( $this, 'handle_upload_package' ) );
        add_action( 'admin_post_aegisbackup_generate_dr_link', array( $this, 'handle_generate_dr_link' ) );
        add_action( 'aegisbackup_dr_process_job', array( $this, 'cron_dr_process_job' ), 10, 1 );
		add_action( 'admin_post_aegisbackup_save_file_plan', array( $this, 'handle_save_file_plan' ) );
		add_action( 'admin_post_aegisbackup_delete_file_plan', array( $this, 'handle_delete_file_plan' ) );
		add_action( 'admin_post_aegisbackup_run_file_plan_now', array( $this, 'handle_run_file_plan_now' ) );
		add_action( 'admin_post_aegisbackup_delete_file_backup', array( $this, 'handle_delete_file_backup' ) );
		add_action( 'admin_post_aegisbackup_restore_file_backup', array( $this, 'handle_restore_file_backup' ) );
		add_action( 'admin_post_aegisbackup_restore_file_backup_wizard', array( $this, 'handle_restore_file_backup_wizard' ) );
		add_action( 'admin_post_aegisbackup_download_file_backup', array( $this, 'handle_download_file_backup' ) );
		add_action( 'admin_post_aegisbackup_save_wp_plan', array( $this, 'handle_save_wp_plan' ) );
		add_action( 'admin_post_aegisbackup_delete_wp_plan', array( $this, 'handle_delete_wp_plan' ) );
		add_action( 'admin_post_aegisbackup_run_wp_plan_now', array( $this, 'handle_run_wp_plan_now' ) );
		add_action( 'admin_post_aegisbackup_download_package', array( $this, 'handle_download_package' ) );
        add_action( 'admin_post_aegisbackup_delete_dr_token', array( $this, 'handle_delete_dr_token' ) );
		add_action( 'admin_post_aegisbackup_delete_package', array( $this, 'handle_delete_package' ) );
		add_action( 'admin_post_aegisbackup_mw_regen_token', array( $this, 'handle_mw_regen_token' ) );
		add_action( 'admin_post_aegisbackup_mw_save_password', array( $this, 'handle_mw_save_password' ) );
		add_action( 'admin_post_aegisbackup_mw_remove_runner', array( $this, 'handle_mw_remove_runner' ) );
		add_action( 'wp_ajax_aegisbackup_generate_token', array( $this, 'ajax_generate_token' ) );
		add_action( 'wp_ajax_aegisbackup_start_push', array( $this, 'ajax_start_push' ) );
		add_action( 'wp_ajax_aegisbackup_process_push', array( $this, 'ajax_process_push' ) );
		add_action( 'wp_ajax_aegisbackup_pp_files_start', array( $this, 'ajax_pp_files_start' ) );
		add_action( 'wp_ajax_aegisbackup_pp_files_process', array( $this, 'ajax_pp_files_process' ) );
		add_action( 'wp_ajax_aegisbackup_pp_destlog_fetch', array( $this, 'ajax_pp_destlog_fetch' ) );
		add_action( 'wp_ajax_aegisbackup_pp_destdb_status', array( $this, 'ajax_pp_destdb_status' ) );
		add_action( 'admin_post_aegisbackup_generate_token_post', array( $this, 'handle_generate_token_post' ) );
		add_action( 'admin_post_aegisbackup_start_push_post', array( $this, 'handle_start_push_post' ) );
		add_action( 'admin_post_aegisbackup_process_push_post', array( $this, 'handle_process_push_post' ) );
		add_action( 'admin_post_aegisbackup_pp_set_package_post', array( $this, 'handle_pp_set_package_post' ) );
		add_action( 'admin_post_aegisbackup_pp_set_paths_post', array( $this, 'handle_pp_set_paths_post' ) );
		add_action( 'admin_post_aegisbackup_pp_send_package_post', array( $this, 'handle_pp_send_package_post' ) );
		add_action( 'admin_post_aegisbackup_pp_migrate_db_post', array( $this, 'handle_pp_migrate_db_post' ) );
		add_action( 'admin_post_aegisbackup_pp_migrate_files_post', array( $this, 'handle_pp_migrate_files_post' ) );
		add_action( 'admin_post_aegisbackup_pp_migrate_file_backup_post', array( $this, 'handle_pp_migrate_file_backup_post' ) );
		add_action( 'admin_post_aegisbackup_pp_delete_received_file_backup_post', array( $this, 'handle_pp_delete_received_file_backup_post' ) );
		add_action( 'admin_post_aegisbackup_pp_file_restore_bulk_post', array( $this, 'handle_pp_file_restore_bulk_post' ) );
		add_action( 'admin_post_aegisbackup_pp_file_restore_confirm_post', array( $this, 'handle_pp_file_restore_confirm_post' ) );
		add_action( 'admin_post_aegisbackup_pp_file_delete_post', array( $this, 'handle_pp_file_delete_post' ) );
		add_action( 'admin_post_aegisbackup_pp_upload_received_file_backup', array( $this, 'handle_pp_upload_received_file_backup' ) );
		add_action( 'admin_post_aegisbackup_pp_upload_received_db_backup', array( $this, 'handle_pp_upload_received_db_backup' ) );

		// Resumable (chunked) upload for large packages (Push/Pull Destination).
		add_action( 'wp_ajax_aegisbackup_pp_resumable_upload_init', array( $this, 'pp_resumable_upload_init' ) );
		add_action( 'wp_ajax_aegisbackup_pp_resumable_upload_chunk', array( $this, 'pp_resumable_upload_chunk' ) );
		add_action( 'wp_ajax_aegisbackup_pp_resumable_upload_finalize', array( $this, 'pp_resumable_upload_finalize' ) );
		add_action( 'admin_post_aegisbackup_pp_restore_db_post', array( $this, 'handle_pp_restore_db_post' ) );
		add_action( 'admin_post_aegisbackup_pp_restore_db_bulk_post', array( $this, 'handle_pp_restore_db_bulk_post' ) );
		add_action( 'admin_post_aegisbackup_pp_delete_db_post', array( $this, 'handle_pp_delete_db_post' ) );
        add_action( 'wp_ajax_aegisbackup_start_restore', array( $this, 'ajax_start_restore' ) );
        add_action( 'wp_ajax_aegisbackup_process_restore', array( $this, 'ajax_process_restore' ) );
        add_action( 'wp_ajax_aegisbackup_get_last_report', array( $this, 'ajax_get_last_report' ) );
		add_action( 'admin_init', array( $this, 'maybe_dispatch_restore_jobs' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_export_csv', array( $this, 'ajax_dbtools_export_csv' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_table_op', array( $this, 'ajax_dbtools_table_op' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_prefix_change', array( $this, 'ajax_dbtools_prefix_change' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_prefix_preview', array( $this, 'ajax_dbtools_prefix_preview' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_prefix_verify', array( $this, 'ajax_dbtools_prefix_verify' ) );
		add_action( 'admin_post_aegisbackup_dbtools_prefix_preview', array( $this, 'handle_dbtools_prefix_preview' ) );
		add_action( 'admin_post_aegisbackup_dbtools_prefix_change', array( $this, 'handle_dbtools_prefix_change' ) );
		add_action( 'admin_post_aegisbackup_dbtools_prefix_verify', array( $this, 'handle_dbtools_prefix_verify' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_create_snapshot', array( $this, 'ajax_dbtools_create_snapshot' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_list_snapshots', array( $this, 'ajax_dbtools_list_snapshots' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_delete_snapshot', array( $this, 'ajax_dbtools_delete_snapshot' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_restore_snapshot', array( $this, 'ajax_dbtools_restore_snapshot' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_save_settings', array( $this, 'ajax_dbtools_save_settings' ) );
        add_action( 'admin_post_aegisbackup_dbtools_save_settings', array( $this, 'handle_dbtools_save_settings' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_run_optimization', array( $this, 'ajax_dbtools_run_optimization' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_run_growth', array( $this, 'ajax_dbtools_run_growth' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_prefix_scan', array( $this, 'ajax_dbtools_prefix_scan' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_download_snapshot', array( $this, 'ajax_dbtools_download_snapshot' ) );
        add_action( 'wp_ajax_aegisbackup_dbtools_list_activity', array( $this, 'ajax_dbtools_list_activity' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_list_databases', array( $this, 'ajax_tablebacks_list_databases' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_list_tables', array( $this, 'ajax_tablebacks_list_tables' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_list_columns', array( $this, 'ajax_tablebacks_list_columns' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_create_backup', array( $this, 'ajax_tablebacks_create_backup' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_list_backups', array( $this, 'ajax_tablebacks_list_backups' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_delete_backup', array( $this, 'ajax_tablebacks_delete_backup' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_start_restore', array( $this, 'ajax_tablebacks_start_restore' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_process_restore', array( $this, 'ajax_tablebacks_process_restore' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_save_plan', array( $this, 'ajax_tablebacks_save_plan' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_list_plans', array( $this, 'ajax_tablebacks_list_plans' ) );
        add_action( 'wp_ajax_aegisbackup_tablebacks_delete_plan', array( $this, 'ajax_tablebacks_delete_plan' ) );
		add_action( 'admin_post_aegisbackup_tablebacks_post', array( $this, 'handle_tablebacks_post' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_save_plan_post', array( $this, 'handle_tablebacks_save_plan_post' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_plan_download', array( $this, 'handle_tablebacks_plan_download' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_plan_delete', array( $this, 'handle_tablebacks_plan_delete' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_plan_run_now', array( $this, 'handle_tablebacks_plan_run_now' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_backup_delete', array( $this, 'handle_tablebacks_backup_delete' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_download', array( $this, 'handle_tablebacks_download' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_restore_start', array( $this, 'handle_tablebacks_restore_start' ) );
        add_action( 'admin_post_aegisbackup_tablebacks_restore_start_wizard', array( $this, 'handle_tablebacks_restore_start_wizard' ) );
        add_action( 'aegisbackup_tablebacks_process_restore_job', array( $this, 'cron_tablebacks_process_restore_job' ), 10, 1 );
		add_action( 'admin_post_aegisbackup_pp_connect_post', array( $this, 'handle_pp_connect_post' ) );
		add_action( 'admin_post_aegisbackup_pp_disconnect_post', array( $this, 'handle_pp_disconnect_post' ) );
		add_action( 'admin_post_aegisbackup_pp_delete_connection_post', array( $this, 'handle_pp_delete_connection_post' ) );
		add_action( 'admin_post_aegisbackup_pp_delete_incoming_post', array( $this, 'handle_pp_delete_incoming_post' ) );
		add_action( 'aegisbackup_pp_process_db_restore_job', array( $this, 'cron_pp_process_db_restore_job' ), 10, 1 );
        add_action( 'admin_post_aegisbackup_dbtools_create_snapshot', array( $this, 'handle_dbtools_create_snapshot' ) );
        add_action( 'admin_post_aegisbackup_dbtools_delete_snapshot', array( $this, 'handle_dbtools_delete_snapshot' ) );
        add_action( 'admin_post_aegisbackup_dbtools_download_snapshot', array( $this, 'handle_dbtools_download_snapshot' ) );
        add_action( 'admin_post_aegisbackup_dbtools_restore_snapshot', array( $this, 'handle_dbtools_restore_snapshot' ) );
        add_action( 'admin_post_aegisbackup_dbtools_restore_snapshot_wizard', array( $this, 'handle_dbtools_restore_snapshot_wizard' ) );
		add_action( 'admin_post_aegisbackup_dbtools_table_op', array( $this, 'handle_dbtools_table_op' ) );
        add_action( 'admin_post_aegisbackup_dbtools_run_optimization', array( $this, 'handle_dbtools_run_optimization' ) );
        add_action( 'admin_post_aegisbackup_dbtools_run_growth', array( $this, 'handle_dbtools_run_growth' ) );
		add_action( 'admin_post_aegisbackup_filetree_nav', array( $this, 'handle_filetree_nav' ) );
		add_action( 'admin_post_aegisbackup_restore_start', array( $this, 'handle_restore_start' ) );
		add_action( 'admin_post_aegisbackup_restore_continue', array( $this, 'handle_restore_continue' ) );
		add_action( 'admin_post_aegisbackup_restore_tick', array( $this, 'handle_restore_tick' ) );
		add_action( 'aegisbackup_restore_cron_tick', array( $this, 'cron_restore_tick' ), 10, 2 );
		add_action( 'wp_ajax_aegisbackup_restore_status', array( $this, 'ajax_restore_status' ) );
		add_action( 'admin_post_aegisbackup_restore_process_action', array( $this, 'handle_restore_process_action' ) );
		add_action( 'admin_post_aegisbackup_save_settings', array( $this, 'handle_save_settings' ) );
		add_action( 'admin_post_aegisbackup_send_test_email', array( $this, 'handle_send_test_email' ) );
		add_action( 'admin_post_aegisbackup_step3_start', array( $this, 'handle_step3_start' ) );
		add_action( 'admin_post_aegisbackup_step3_continue', array( $this, 'handle_step3_continue' ) );
    }

	public function handle_step3_start() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_step3_start', 'aegisbackup_step3_nonce' );

		$redirect = admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate', 'relative' );

		if ( isset( $_POST['ab_redirect'] ) ) {
			$cand = esc_url_raw( (string) wp_unslash( $_POST['ab_redirect'] ) );
			$redirect = wp_validate_redirect( $cand, $redirect );
		}
		$args = array(
			'new_prefix' => isset( $_POST['new_prefix'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_prefix'] ) ) : '',
			'old_domain' => isset( $_POST['old_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['old_domain'] ) ) : '',
			'new_domain' => isset( $_POST['new_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_domain'] ) ) : '',
			'regen_thumbs' => ! empty( $_POST['regen_thumbs'] ) ? 1 : 0,
			'fix_perms'    => ! empty( $_POST['fix_perms'] ) ? 1 : 0,
			'update_guid'  => ! empty( $_POST['update_guid'] ) ? 1 : 0,
		);

		$job_id = 'abs3_' . wp_generate_password( 10, false, false );
		$store_key = 'ab_step3_job_' . $job_id . '_' . (int) get_current_user_id();
		set_transient( $store_key, array(
			'job_id' => $job_id,
			'args'   => $args,
			'state'  => array(),
			'counts' => array(),
			'log'    => array(),
			'done'   => false,
		), 60 * 60 );

		// Initialize the migration-finalize job and immediately return to the Destination tab.
		// The Destination UI will auto-continue chunks via admin-post to avoid timeouts/white screens.
		$url = add_query_arg( array( 'ab_s3' => $job_id ), $redirect );
		if ( ! headers_sent() ) {
			wp_safe_redirect( $url );
		} else {
				echo '<!doctype html><html><head><meta charset="utf-8">' . '<meta http-equiv="refresh" content="0;url=' . esc_url( $url ) . '">' . '</head><body style="font-family:sans-serif;padding:20px;">' . '<p>' . esc_html__( 'Redirecting…', 'aegisbackup' ) . '</p>' . '<p><a href="' . esc_url( $url ) . '">' . esc_html__( 'Click here if you are not redirected.', 'aegisbackup' ) . '</a></p>' . '</body></html>';
		}
		exit;
	}


	public function handle_step3_continue() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_step3_continue', 'aegisbackup_step3_nonce' );

		$redirect = admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate', 'relative' );

		if ( isset( $_POST['ab_redirect'] ) ) {
			$cand = esc_url_raw( (string) wp_unslash( $_POST['ab_redirect'] ) );
			$redirect = wp_validate_redirect( $cand, $redirect );
		}
		$job_id = isset( $_POST['s3_job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['s3_job_id'] ) ) : '';
		if ( empty( $job_id ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'no_s3_job' ), $redirect ) );
			exit;
		}

		$store_key = 'ab_step3_job_' . $job_id . '_' . (int) get_current_user_id();


		$shutdown_ran       = false;
		$shutdown_redirect  = $redirect;
		$shutdown_job_id    = $job_id;
		$shutdown_store_key = $store_key;
		register_shutdown_function( function() use ( &$shutdown_ran, $shutdown_redirect, $shutdown_job_id, $shutdown_store_key ) {
			if ( $shutdown_ran ) {
				return;
			}
			$err = error_get_last();
			if ( empty( $err ) || ! isset( $err['type'] ) ) {
				return;
			}
			$fatal_types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR, E_RECOVERABLE_ERROR );
			if ( ! in_array( (int) $err['type'], $fatal_types, true ) ) {
				return;
			}
			$shutdown_ran = true;

			$data = get_transient( $shutdown_store_key );
			if ( ! is_array( $data ) ) {
				$data = array();
			}
			$msg = sprintf(
				'Step 3 fatal error: %s in %s on line %d',
				isset( $err['message'] ) ? (string) $err['message'] : '',
				isset( $err['file'] ) ? (string) $err['file'] : '',
				isset( $err['line'] ) ? (int) $err['line'] : 0
			);
			$msg = wp_strip_all_tags( $msg );

			$data['done'] = true;
			$data['last'] = $msg;
			if ( ! isset( $data['log'] ) || ! is_array( $data['log'] ) ) {
				$data['log'] = array();
			}
			$data['log'][] = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] ' . $msg;
			set_transient( $shutdown_store_key, $data, 60 * 60 );

			$url = add_query_arg( array( 'ab_s3' => $shutdown_job_id, 'ab_err' => 'step3_fatal' ), $shutdown_redirect );
			if ( ! headers_sent() ) {
				wp_safe_redirect( $url );
			} else {
				echo '<!doctype html><html><head><meta charset="utf-8">' . '<meta http-equiv="refresh" content="0;url=' . esc_url( $url ) . '">' . '</head><body style="font-family:sans-serif;padding:20px;">' . '<p>' . esc_html__( 'Redirecting…', 'aegisbackup' ) . '</p>' . '<p><a href="' . esc_url( $url ) . '">' . esc_html__( 'Click here if you are not redirected.', 'aegisbackup' ) . '</a></p>' . '</body></html>';
			}
		} );


		try {
			$this->run_step3_chunk( $store_key );
		} catch ( \Throwable $e ) {
			$data = get_transient( $store_key );
			if ( ! is_array( $data ) ) {
				$data = array();
			}
			$data['done'] = true;
			$data['last'] = 'Step 3 fatal: ' . $e->getMessage();
			if ( ! isset( $data['log'] ) || ! is_array( $data['log'] ) ) {
				$data['log'] = array();
			}
			$data['log'][] = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] ' . $data['last'];
			set_transient( $store_key, $data, 60 * 60 );

						$url = add_query_arg( array( 'ab_s3' => $job_id, 'ab_err' => 'step3_fatal' ), $redirect );
			if ( ! headers_sent() ) {
				wp_safe_redirect( $url );
			} else {
				echo '<!doctype html><html><head><meta charset="utf-8">' . '<meta http-equiv="refresh" content="0;url=' . esc_url( $url ) . '">' . '</head><body style="font-family:sans-serif;padding:20px;">' . '<p>' . esc_html__( 'Redirecting…', 'aegisbackup' ) . '</p>' . '<p><a href="' . esc_url( $url ) . '">' . esc_html__( 'Click here if you are not redirected.', 'aegisbackup' ) . '</a></p>' . '</body></html>';
			}
			exit;
		}


				$url = add_query_arg( array( 'ab_s3' => $job_id ), $redirect );
		if ( ! headers_sent() ) {
			wp_safe_redirect( $url );
		} else {
			echo '<!doctype html><html><head><meta charset="utf-8">' . '<meta http-equiv="refresh" content="0;url=' . esc_url( $url ) . '">' . '</head><body style="font-family:sans-serif;padding:20px;">' . '<p>' . esc_html__( 'Redirecting…', 'aegisbackup' ) . '</p>' . '<p><a href="' . esc_url( $url ) . '">' . esc_html__( 'Click here if you are not redirected.', 'aegisbackup' ) . '</a></p>' . '</body></html>';
		}
		exit;
	}

	protected function run_step3_chunk( $store_key ) {
		$data = get_transient( $store_key );
		if ( empty( $data ) || empty( $data['job_id'] ) ) {
			return;
		}

		if ( ! class_exists( '\\AegisBackup\\Restore\\AB_Post_Restore_Fixer' ) ) {
			require_once AEGISBACKUP_DIR . 'includes/restore/class-ab-post-restore-fixer.php';
		}
		$fixer = new \AegisBackup\Restore\AB_Post_Restore_Fixer();
		if ( ! method_exists( $fixer, 'run_step3' ) ) {
			$data['done'] = true;
			$data['last'] = 'Step 3 error: fixer method run_step3() not found. Please update AegisBackup files.';
			$data['log'][] = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] ' . $data['last'];
			set_transient( $store_key, $data, 60 * 60 );
			return;
		}

		$state  = isset( $data['state'] ) && is_array( $data['state'] ) ? (array) $data['state'] : array();
		$args   = isset( $data['args'] ) && is_array( $data['args'] ) ? (array) $data['args'] : array();

		if ( ! array_key_exists( 'regen_thumbs', $args ) ) {
			$args['regen_thumbs'] = false;
		}

		if ( ! array_key_exists( 'fix_perms', $args ) ) {
			$args['fix_perms'] = true;
		}

		if ( ! array_key_exists( 'update_guid', $args ) ) {
			$args['update_guid'] = false;
		}

		$start = time();
		$budget = 12; 
		$last_msg = '';
		$warnings = array();
		$counts = array();
		$done = false;

		while ( ( time() - $start ) < $budget ) {
			try {
				$res = $fixer->run_step3( $state, $args );
			} catch ( \Throwable $e ) {
				$last_msg = 'Step 3 fatal: ' . $e->getMessage();
				$warnings[] = $last_msg;
				$done = true;
				break;
			}
			$state = isset( $res['state'] ) && is_array( $res['state'] ) ? (array) $res['state'] : $state;
			$counts = isset( $res['counts'] ) && is_array( $res['counts'] ) ? (array) $res['counts'] : $counts;
			$last_msg = ! empty( $res['log'] ) ? (string) $res['log'] : $last_msg;
			if ( ! empty( $res['warnings'] ) && is_array( $res['warnings'] ) ) {
				$warnings = array_merge( $warnings, $res['warnings'] );
			}
			$done = ! empty( $res['done'] );
			if ( $done ) {
				break;
			}
		}

		$data['state']  = $state;
		$data['counts'] = $counts;
		$data['done']   = $done;
		$data['last']   = $last_msg;
		if ( ! empty( $last_msg ) ) {
			$data['log'][] = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] ' . $last_msg;
		}
		set_transient( $store_key, $data, 60 * 60 );

		if ( $done ) {
			$report = get_option( 'aegisbackup_last_migration_report', array() );
			if ( is_array( $report ) ) {
				if ( ! isset( $report['counts'] ) || ! is_array( $report['counts'] ) ) {
					$report['counts'] = array();
				}
				foreach ( $counts as $k => $v ) {
					$report['counts'][ $k ] = (int) $v;
				}

				if ( ! isset( $report['samples'] ) || ! is_array( $report['samples'] ) ) {
					$report['samples'] = array();
				}
				if ( isset( $state['missing_samples'] ) && is_array( $state['missing_samples'] ) ) {
					$report['samples']['missing_files'] = array_slice( (array) $state['missing_samples'], 0, 25 );
					$zb = array();
					foreach ( (array) $state['missing_samples'] as $row ) {
						if ( is_array( $row ) && ! empty( $row['zero'] ) ) {
							$zb[] = $row;
						}
					}
					$report['samples']['zero_byte_files'] = array_slice( $zb, 0, 25 );
				}
				if ( isset( $state['corrupted_samples'] ) && is_array( $state['corrupted_samples'] ) ) {
					$report['samples']['corrupted_meta'] = array_slice( (array) $state['corrupted_samples'], 0, 25 );
				}
				if ( ! isset( $report['steps'] ) || ! is_array( $report['steps'] ) ) {
					$report['steps'] = array();
				}
				$report['steps'][] = array(
					'time' => gmdate( 'c' ),
					'step' => 'step3',
					'msg'  => 'Step 3 finalization completed via "Finalize Migration & Automate Fix".',
				);
				if ( ! empty( $warnings ) ) {
					if ( ! isset( $report['warnings'] ) || ! is_array( $report['warnings'] ) ) {
						$report['warnings'] = array();
					}
					foreach ( $warnings as $w ) {
						$report['warnings'][] = (string) $w;
					}
				}
				update_option( 'aegisbackup_last_migration_report', $report, false );
			}
		}
	}

	public function handle_restore_start() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_restore_start', 'aegisbackup_restore_nonce' );

		$redirect = admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate', 'relative' );

		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		$mode         = isset( $_POST['ab_restore_mode'] ) ? sanitize_key( wp_unslash( $_POST['ab_restore_mode'] ) ) : 'existing';
		$new_prefix   = isset( $_POST['new_prefix'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_prefix'] ) ) : '';
		$old_domain   = isset( $_POST['old_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['old_domain'] ) ) : '';
		$new_domain   = isset( $_POST['new_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_domain'] ) ) : '';

		$wpconfig_update      = ! empty( $_POST['wpconfig_update'] ) ? 1 : 0;
		$wpconfig_regen_salts = ! empty( $_POST['wpconfig_regen_salts'] ) ? 1 : 0;

		$db_name = isset( $_POST['db_name'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_name'] ) ) : '';
		$db_user = isset( $_POST['db_user'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_user'] ) ) : '';
		$db_pass = isset( $_POST['db_pass'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_pass'] ) ) : ''; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized; password may contain special chars.
		$db_pass = str_replace( chr(0), '', $db_pass ); 
		$db_host = isset( $_POST['db_host'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_host'] ) ) : '';

		$confirm_drop = ! empty( $_POST['confirm_drop'] ) ? 1 : 0;
		$confirm_text = isset( $_POST['confirm_text'] ) ? strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) ) : '';

		if ( ! $confirm_drop || 'RESTORE' !== $confirm_text ) {
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'confirm' ), $redirect ) );
			exit;
		}

		if ( empty( $package_path ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'no_pkg' ), $redirect ) );
			exit;
		}

		if ( 'newdb' === $mode ) {
			if ( empty( $db_name ) || empty( $db_user ) ) {
				wp_safe_redirect( add_query_arg( array( 'ab_err' => 'db_creds' ), $redirect ) );
				exit;
			}
		} else {
			$db_name = '';
			$db_user = '';
			$db_pass = '';
			$db_host = '';
			$wpconfig_update = 0;
			$wpconfig_regen_salts = 0;
		}

		$restore_args = array(
			'package_path'        => $package_path,
			'mode'                => $mode,
			'new_prefix'          => $new_prefix,
			'old_domain'          => $old_domain,
			'new_domain'          => $new_domain,
			'wpconfig_update'     => $wpconfig_update,
			'db_name'             => $db_name,
			'db_user'             => $db_user,
			'db_pass'             => $db_pass,
			'db_host'             => $db_host,
			'wpconfig_regen_salts'=> $wpconfig_regen_salts,
			'confirm_drop'        => $confirm_drop,
			'confirm_text'        => $confirm_text,
		);

		$job = $this->plugin->restore->start_restore_job( $restore_args );
		if ( empty( $job['job_id'] ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'start_failed' ), $redirect ) );
			exit;
		}

		$job_id = sanitize_text_field( (string) $job['job_id'] );

        $dr_payload = array();
        if ( ! empty( $dr_generate ) ) {
            $mgr = $this->plugin->backup;
            $dr_base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
            $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : '';
            $endpoint_dir = ABSPATH . 'aegisbackup-recovery';
            $endpoint = trailingslashit( $endpoint_dir ) . 'index.php';

            if ( $dr_base && ! is_dir( $dr_base ) ) {
                @wp_mkdir_p( $dr_base );
            }

            if ( $endpoint_dir && ! is_dir( $endpoint_dir ) ) {
                @wp_mkdir_p( $endpoint_dir );
            }

            if ( $endpoint_dir && is_dir( $endpoint_dir ) ) {
                $ht = trailingslashit( $endpoint_dir ) . '.htaccess';
                if ( ! is_file( $ht ) ) {
                    @file_put_contents( $ht, "DirectoryIndex index.php\n" );
                }
            }

            if ( $tokens_file ) {
                $tokens_dir = dirname( $tokens_file );
                if ( $tokens_dir && ! is_dir( $tokens_dir ) ) {
                    @wp_mkdir_p( $tokens_dir );
                }
            }

            if ( $endpoint_dir && is_dir( $endpoint_dir ) && $tokens_file && ! is_file( $endpoint ) ) {
                $this->write_dr_recovery_endpoint( $endpoint, $tokens_file );
            }

            $dr_token = wp_generate_password( 26, false, false );
            $dr_link  = trailingslashit( site_url() ) . 'aegisbackup-recovery/?token=' . rawurlencode( $dr_token );

            $zip_path = ! empty( $job['zip_path'] ) ? (string) $job['zip_path'] : '';

            $tokens = array();
            if ( $tokens_file && is_file( $tokens_file ) ) {
                $raw = @file_get_contents( $tokens_file );
                $tmp = json_decode( (string) $raw, true );
                if ( is_array( $tmp ) ) {
                    $tokens = $tmp;
                }
            }

            $rec = array(
                'created' => time(),
                'status'  => 'building',
                'link'    => $dr_link,
                'job_id'  => $job_id,
                'package' => $zip_path ? basename( $zip_path ) : '',
                'zip_path'=> $zip_path,
                'opts'    => array(
                    'files'    => ! empty( $args['include_files'] ),
                    'db'       => ! empty( $args['include_db'] ),
                    'htaccess' => ! empty( $args['include_htaccess'] ),
                    'config'   => ! empty( $args['include_config'] ),
                    'core'     => ! empty( $args['include_core'] ),
                ),
            );

            $tokens[ $dr_token ] = $rec;

            if ( $tokens_file ) {
                @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );
            }

            if ( ! wp_next_scheduled( 'aegisbackup_dr_process_job', array( $job_id ) ) ) {
                wp_schedule_single_event( time() + 5, 'aegisbackup_dr_process_job', array( $job_id ) );
            }

            $dr_payload = array(
                'token' => $dr_token,
                'link'  => $dr_link,
                'status'=> 'building',
            );
        }

		$store_key = 'ab_restore_job_' . $job_id . '_' . (int) get_current_user_id();
		set_transient( $store_key, array( 'job_id' => $job_id, 'log' => array(), 'last' => array() ), 60 * 30 );

		$tick_token = 'abrt_' . wp_generate_password( 20, false, false );
		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state = get_option( $opt_key, array() );

		if ( ! empty( $state['job_id'] ) && ! empty( $this->plugin->restore ) ) {
			$phase  = isset( $state['phase'] ) ? (string) $state['phase'] : '';
			$status = isset( $state['status'] ) ? (string) $state['status'] : '';
			$last_tick = isset( $state['last_tick'] ) ? (int) $state['last_tick'] : 0;
			if ( 'done' !== $phase && 'running' === $status && ( time() - $last_tick ) > 12 ) {
				$state['last_tick'] = time();
				update_option( $opt_key, $state, false );
				try {
					$this->plugin->restore->process_restore_job( $job_id );
				} catch ( \Throwable $e ) {

					$this->restore_job_note( $job_id, 'UI tick exception: ' . $e->getMessage() );
				}
				$state = get_option( $opt_key, array() );
			}
		}
		if ( is_array( $state ) ) {
			$state['tick_token'] = $tick_token;
			$state['last_tick'] = time();
			update_option( $opt_key, $state, false );
		}

		$this->spawn_restore_tick( $job_id, $tick_token );

		wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id ), $redirect ) );
		exit;
	}

	public function handle_restore_continue() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_restore_continue', 'aegisbackup_restore_nonce' );

		$redirect = admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate', 'relative' );

		if ( isset( $_POST['ab_redirect'] ) ) {
	$cand = esc_url_raw( (string) wp_unslash( $_POST['ab_redirect'] ) );
	if ( $cand && 0 === strpos( $cand, admin_url() ) ) {
		$redirect = $cand;
	}
}
		$job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
		if ( empty( $job_id ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'no_job' ), $redirect ) );
			exit;
		}

		$store_key = 'ab_restore_job_' . $job_id . '_' . (int) get_current_user_id();
		$state = get_transient( $store_key );
		if ( ! is_array( $state ) ) {
			$state = array( 'job_id' => $job_id, 'log' => array(), 'last' => array() );
		}

		$done = false;
		$iterations = 0;
		$start = time();
		while ( $iterations < 8 && ( time() - $start ) < 12 ) {
			$step = $this->plugin->restore->process_restore_job( $job_id );
			$state['last'] = is_array( $step ) ? $step : array();
			if ( is_array( $step ) && ! empty( $step['log'] ) ) {
				$state['log'][] = (string) $step['log'];
			}
			if ( is_array( $step ) && ! empty( $step['done'] ) ) {
				$done = true;
				break;
			}
			$iterations++;
		}

		set_transient( $store_key, $state, 60 * 30 );

		if ( $done ) {
			wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id, 'ab_done' => 1 ), $redirect ) );
			exit;
		}

		wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id ), $redirect ) );
		exit;
	}

	protected function spawn_restore_tick( $job_id, $tick_token ) {
		$job_id = sanitize_text_field( (string) $job_id );
		$tick_token = sanitize_text_field( (string) $tick_token );
		if ( '' === $job_id || '' === $tick_token ) {
			return;
		}

		$url = admin_url( 'admin-post.php' );
		$args = array(
			'timeout'  => 0.5,
			'blocking' => false,
			'sslverify'=> apply_filters( 'https_local_ssl_verify', false ), // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Back-compat filter name.
			'body'     => array(
				'action' => 'aegisbackup_restore_tick',
				'job_id' => $job_id,
				'token'  => $tick_token,
			),
		);
		$resp = wp_remote_post( $url, $args );
		if ( is_wp_error( $resp ) ) {
			$this->restore_job_note( $job_id, 'Loopback runner blocked: ' . $resp->get_error_message() );
		}
		$this->schedule_restore_cron_tick( $job_id, $tick_token, 5 );
	}

	protected function restore_job_note( $job_id, $line ) {
		$job_id = sanitize_text_field( (string) $job_id );
		$line = trim( (string) $line );
		if ( '' === $job_id || '' === $line ) {
			return;
		}
		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state = get_option( $opt_key, array() );
		if ( ! is_array( $state ) ) {
			$state = array();
		}
		if ( ! isset( $state['log'] ) || ! is_array( $state['log'] ) ) {
			$state['log'] = array();
		}
		$last = end( $state['log'] );
		if ( $last !== $line ) {
			$state['log'][] = $line;
		}
		if ( count( $state['log'] ) > 250 ) {
			$state['log'] = array_slice( $state['log'], -250 );
		}
		$state['last_log'] = $line;
		$state['updated'] = time();
		update_option( $opt_key, $state, false );
	}

	protected function schedule_restore_cron_tick( $job_id, $tick_token, $delay_seconds = 30 ) {
		$job_id = sanitize_text_field( (string) $job_id );
		$tick_token = sanitize_text_field( (string) $tick_token );
		$delay_seconds = (int) $delay_seconds;
		if ( '' === $job_id || '' === $tick_token ) {
			return;
		}
		if ( $delay_seconds < 5 ) {
			$delay_seconds = 5;
		}
		if ( $delay_seconds > 300 ) {
			$delay_seconds = 300;
		}

		$existing = wp_next_scheduled( 'aegisbackup_restore_cron_tick', array( $job_id, $tick_token ) );
		if ( $existing ) {
			return;
		}
		wp_schedule_single_event( time() + $delay_seconds, 'aegisbackup_restore_cron_tick', array( $job_id, $tick_token ) );

		if ( function_exists( 'spawn_cron' ) ) {
			spawn_cron();
		}
		$cron_url = site_url( 'wp-cron.php?doing_wp_cron=' . urlencode( (string) microtime( true ) ) );
		$cron_resp = wp_remote_post( $cron_url, array(
			'timeout'  => 0.5,
			'blocking' => false,
			'sslverify'=> apply_filters( 'https_local_ssl_verify', false ), // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Back-compat filter name.
		) );
		if ( is_wp_error( $cron_resp ) ) {
			$this->restore_job_note( $job_id, 'WP-Cron trigger failed: ' . $cron_resp->get_error_message() );
		}
	}

	public function cron_restore_tick( $job_id, $token ) {
		$job_id = sanitize_text_field( (string) $job_id );
		$token  = sanitize_text_field( (string) $token );
		if ( '' === $job_id || '' === $token ) {
			return;
		}

		$lock_key = 'ab_restore_tick_lock_' . $job_id;
		if ( get_transient( $lock_key ) ) {
			return;
		}
		set_transient( $lock_key, 1, 20 );

		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state = get_option( $opt_key, array() );
		if ( empty( $state ) || empty( $state['job_id'] ) ) {
			delete_transient( $lock_key );
			return;
		}
		$expected = isset( $state['tick_token'] ) ? (string) $state['tick_token'] : '';
		if ( '' === $expected || ! hash_equals( $expected, $token ) ) {
			delete_transient( $lock_key );
			return;
		}

		$done = false;
		$iterations = 0;
		$start = time();
		while ( $iterations < 10 && ( time() - $start ) < 15 ) {
			$step = $this->plugin->restore->process_restore_job( $job_id );
			if ( is_array( $step ) && ! empty( $step['done'] ) ) {
				$done = true;
				break;
			}
			$iterations++;
		}

		delete_transient( $lock_key );

		if ( ! $done ) {
			$this->schedule_restore_cron_tick( $job_id, $token, 30 );
		}
	}

	public function handle_restore_tick() {
		$job_id = isset( $_REQUEST['job_id'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['job_id'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Token-authenticated tick endpoint (no form nonce).
		$token  = isset( $_REQUEST['token'] ) ? sanitize_text_field( wp_unslash( $_REQUEST['token'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Token-authenticated tick endpoint (no form nonce).
		if ( '' === $job_id || '' === $token ) {
			wp_die( 'Missing parameters.', 400 );
		}

		$lock_key = 'ab_restore_tick_lock_' . $job_id;
		if ( get_transient( $lock_key ) ) {
			exit;
		}
		set_transient( $lock_key, 1, 20 );

		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state = get_option( $opt_key, array() );
		if ( empty( $state ) || empty( $state['job_id'] ) ) {
			delete_transient( $lock_key );
			exit;
		}
		$expected = isset( $state['tick_token'] ) ? (string) $state['tick_token'] : '';
		if ( '' === $expected || ! hash_equals( $expected, $token ) ) {
			delete_transient( $lock_key );
			wp_die( 'Unauthorized.', 403 );
		}

		$done = false;
		$iterations = 0;
		$start = time();
		while ( $iterations < 10 && ( time() - $start ) < 15 ) {
			$step = $this->plugin->restore->process_restore_job( $job_id );
			if ( is_array( $step ) && ! empty( $step['done'] ) ) {
				$done = true;
				break;
			}
			$iterations++;
		}

		delete_transient( $lock_key );

		if ( ! $done ) {
			$this->spawn_restore_tick( $job_id, $token );
		}
		exit;
	}

	public function ajax_restore_status() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_send_json_error( array( 'message' => __( 'Insufficient permissions.', 'aegisbackup' ) ), 403 );
		}
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
		if ( '' === $job_id ) {
			wp_send_json_error( array( 'message' => __( 'Missing job id.', 'aegisbackup' ) ) );
		}
		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state = get_option( $opt_key, array() );
		if ( empty( $state ) || empty( $state['job_id'] ) ) {
			wp_send_json_error( array( 'message' => __( 'Restore job not found.', 'aegisbackup' ) ) );
		}

		$progress  = isset( $state['progress'] ) ? (int) $state['progress'] : 0;
		$phase     = isset( $state['phase'] ) ? (string) $state['phase'] : '';
		$status    = isset( $state['status'] ) ? (string) $state['status'] : '';
		$last_log  = isset( $state['last_log'] ) ? (string) $state['last_log'] : '';
		$log       = ( isset( $state['log'] ) && is_array( $state['log'] ) ) ? array_values( $state['log'] ) : array();
		$preflight = ( isset( $state['preflight'] ) && is_array( $state['preflight'] ) ) ? $state['preflight'] : array();

		$done = ( 'done' === $phase || 'complete' === $status || 'error' === $status || $progress >= 100 );

		wp_send_json_success( array(
			'job_id'    => $job_id,
			'progress'  => $progress,
			'phase'     => $phase,
			'status'    => $status,
			'last_log'  => $last_log,
			'log'       => $log,
			'preflight' => $preflight,
			'last_tick' => isset( $state['last_tick'] ) ? (int) $state['last_tick'] : 0,
			'done'      => $done,
		) );
	}

	public function handle_restore_process_action() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_restore_process_action', 'ab_restore_proc_nonce' );

		$job_id = isset( $_GET['job_id'] ) ? sanitize_text_field( wp_unslash( $_GET['job_id'] ) ) : '';
		$do    = isset( $_GET['do'] ) ? sanitize_key( wp_unslash( $_GET['do'] ) ) : '';
		$tab   = isset( $_GET['tab'] ) ? sanitize_key( wp_unslash( $_GET['tab'] ) ) : 'migrate';
		if ( '' === $job_id || '' === $do ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=' . $tab . '&ab_err=no_job' ) );
			exit;
		}

		$redirect_base = admin_url( 'admin.php?page=aegisbackup-restore&tab=' . $tab );
		$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
		$state   = get_option( $opt_key, array() );

		if ( 'open' === $do ) {
			wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id ), $redirect_base ) );
			exit;
		}

		if ( empty( $state ) || empty( $state['job_id'] ) ) {
			if ( isset( $this->plugin->restore ) && $this->plugin->restore ) {
				$this->plugin->restore->delete_job_from_index( $job_id );
			}
			wp_safe_redirect( add_query_arg( array( 'ab_err' => 'no_job' ), $redirect_base ) );
			exit;
		}

		if ( 'stop' === $do ) {
			$state['stop_requested'] = 1;
			$state['status'] = 'stopping';
			$state['last_log'] = 'Stop requested by user.';
			update_option( $opt_key, $state, false );
			$token = isset( $state['tick_token'] ) ? (string) $state['tick_token'] : '';
			if ( '' !== $token ) {
				$this->spawn_restore_tick( $job_id, $token );
			}

			wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id ), $redirect_base ) );
			exit;
		}

		if ( 'restart' === $do ) {
			$state['stop_requested'] = 0;
			$state['status']   = 'running';
			$state['phase']    = 'validate';
			$state['progress'] = 0;
			$state['tmp_dir']  = '';
			$state['manifest'] = array();
			$state['db_prepare'] = array();
			$state['db_import']  = array();
			$state['checksum']   = array();
			$state['files_restore'] = array();
			$state['domain'] = array();
			$state['last_log'] = 'Restart requested by user.';
			if ( ! isset( $state['log'] ) || ! is_array( $state['log'] ) ) {
				$state['log'] = array();
			}
			$state['log'][] = '[' . gmdate( 'Y-m-d H:i:s' ) . '] Restart requested by user.';
			$token = isset( $state['tick_token'] ) ? (string) $state['tick_token'] : '';
			if ( '' === $token ) {
				$token = wp_generate_password( 24, false, false );
				$state['tick_token'] = $token;
			}
			update_option( $opt_key, $state, false );
			$this->spawn_restore_tick( $job_id, $token );

			wp_safe_redirect( add_query_arg( array( 'ab_job' => $job_id ), $redirect_base ) );
			exit;
		}

		if ( 'delete' === $do ) {
			delete_option( $opt_key );
			delete_transient( 'ab_restore_tick_lock_' . $job_id );
			if ( isset( $this->plugin->restore ) && $this->plugin->restore ) {
				$this->plugin->restore->delete_job_from_index( $job_id );
			}
			wp_safe_redirect( $redirect_base );
			exit;
		}

		wp_safe_redirect( $redirect_base );
		exit;
	}

	public function handle_dbtools_table_op() {
		$this->require_admin_post( 'aegisbackup_dbtools_optimize' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

		$op = isset( $_POST['op'] ) ? sanitize_key( wp_unslash( $_POST['op'] ) ) : '';
		$tables = isset( $_POST['tables'] ) && is_array( $_POST['tables'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['tables'] ) ) : array();
		$pp = isset( $_POST['ab_db_pp'] ) ? (int) $_POST['ab_db_pp'] : 25;
		$p  = isset( $_POST['ab_db_p'] ) ? (int) $_POST['ab_db_p'] : 1;

		require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
		$mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
		$res = $mod->run_table_op( $op, $tables );
		$key = 'ab_dbtools_tableop_' . (int) get_current_user_id();
		set_transient( $key, $res, 60 );

		if ( method_exists( $mod, 'add_activity_log' ) ) {
			$summary = ! empty( $res['messages'] ) && is_array( $res['messages'] ) ? implode( '; ', array_slice( $res['messages'], 0, 5 ) ) : '';
			$mod->add_activity_log( 'optimize', sprintf( '%s: %s', strtoupper( (string) $op ), $summary ), array( 'op' => (string) $op ) );
		}

		$this->dbtools_redirect( 'optimize', array(
			'ab_ok'    => ( ! empty( $res['ok'] ) ) ? 1 : 0,
			'ab_msg'   => ( ! empty( $res['ok'] ) ) ? __( 'Operation completed.', 'aegisbackup' ) : __( 'Operation failed.', 'aegisbackup' ),
			'ab_db_pp' => $pp,
			'ab_db_p'  => $p,
		) );
	}

    protected function dbtools_redirect( $tab = 'backups', $args = array() ) {
        $url = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=' . rawurlencode( (string) $tab ) );
        if ( ! empty( $args ) && is_array( $args ) ) {
            $url = add_query_arg( $args, $url );
        }
        wp_safe_redirect( $url );
        exit;
    }

    protected function require_admin_post( $nonce_action, $nonce_name = '_wpnonce' ) {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
        check_admin_referer( $nonce_action, $nonce_name );
    }

    protected function ab_filesystem() {
        global $wp_filesystem;
        if ( ! $wp_filesystem ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            WP_Filesystem();
        }
        return $wp_filesystem;
    }


    public function handle_dbtools_create_snapshot() {
        $this->require_admin_post( 'aegisbackup_dbtools_snapshot' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().
        $module = $this->plugin->db_tools();
        $res    = $module ? $module->create_db_backup_snapshot() : array( 'success' => false, 'message' => __( 'DB Tools module not available.', 'aegisbackup' ) );
        $this->dbtools_redirect( 'backups', array(
            'ab_msg'  => isset( $res['message'] ) ? sanitize_text_field( (string) $res['message'] ) : '',
            'ab_ok'   => ! empty( $res['success'] ) ? 1 : 0,
        ) );
    }

    public function handle_dbtools_delete_snapshot() {
        $this->require_admin_post( 'aegisbackup_dbtools_snapshot' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $file = isset( $_GET['file'] ) ? sanitize_file_name( (string) wp_unslash( $_GET['file'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        $res  = array( 'success' => false, 'message' => __( 'Invalid snapshot.', 'aegisbackup' ) );

        if ( $file && false !== strpos( $file, '.sql' ) ) {
            $upload = wp_upload_dir();
            $dir    = trailingslashit( $upload['basedir'] ) . 'aegisbackup/db-tools';
            $path   = trailingslashit( $dir ) . $file;

            if ( file_exists( $path ) ) {
                $ok = wp_delete_file(  $path  );
                if ( $ok ) {
                    $res = array( 'success' => true, 'message' => __( 'Snapshot deleted.', 'aegisbackup' ) );
                } else {
                    $res = array( 'success' => false, 'message' => __( 'Failed to delete snapshot.', 'aegisbackup' ) );
                }
            } else {
                $res = array( 'success' => false, 'message' => __( 'Snapshot not found.', 'aegisbackup' ) );
            }
        }

        $return = isset( $_GET['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['ab_return'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        if ( $return && 0 === strpos( $return, admin_url() ) ) {
            wp_safe_redirect(
                add_query_arg(
                    array(
                        'ab_msg' => ! empty( $res['success'] ) ? 'dbsnap_deleted' : 'dbsnap_delete_failed',
                    ),
                    $return
                )
            );
            exit;
        }

        $this->dbtools_redirect(
            'backups',
            array(
                'ab_msg' => isset( $res['message'] ) ? sanitize_text_field( (string) $res['message'] ) : '',
                'ab_ok'  => ! empty( $res['success'] ) ? 1 : 0,
            )
        );
    }

    public function handle_dbtools_download_snapshot() {
        $this->require_admin_post( 'aegisbackup_dbtools_snapshot' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $file = isset( $_GET['file'] ) ? sanitize_file_name( (string) wp_unslash( $_GET['file'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        if ( empty( $file ) || false === strpos( $file, '.sql' ) ) {
            $this->dbtools_redirect( 'backups', array( 'ab_msg' => __( 'Invalid snapshot file.', 'aegisbackup' ), 'ab_ok' => 0 ) );
        }

        $module = $this->plugin->db_tools();
        if ( ! $module || ! method_exists( $module, 'get_db_tools_backup_dir' ) ) {
            $this->dbtools_redirect( 'backups', array( 'ab_msg' => __( 'DB Tools module not available.', 'aegisbackup' ), 'ab_ok' => 0 ) );
        }

        $dir = $module->get_db_tools_backup_dir();
        if ( empty( $dir ) || ! is_dir( $dir ) ) {
            $this->dbtools_redirect( 'backups', array( 'ab_msg' => __( 'Backup directory not available.', 'aegisbackup' ), 'ab_ok' => 0 ) );
        }

        $path = trailingslashit( $dir ) . $file;
        if ( ! file_exists( $path ) ) {
            $this->dbtools_redirect( 'backups', array( 'ab_msg' => __( 'Snapshot file not found.', 'aegisbackup' ), 'ab_ok' => 0 ) );
        }

        nocache_headers();
        header( 'Content-Type: application/sql' );
        header( 'Content-Disposition: attachment; filename="' . basename( $file ) . '"' );
        header( 'Content-Length: ' . (string) filesize( $path ) );
        readfile( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_readfile -- Streaming download.
        exit;
    }

    public function handle_dbtools_restore_snapshot() {
        $this->require_admin_post( 'aegisbackup_dbtools_snapshot' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $file   = isset( $_GET['file'] ) ? sanitize_file_name( (string) wp_unslash( $_GET['file'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        $return = isset( $_GET['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['ab_return'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        $return = $return ? wp_validate_redirect( $return, '' ) : '';
        $module = $this->plugin->db_tools();
        $res    = $module ? $module->restore_db_backup_snapshot( $file ) : array( 'success' => false, 'message' => __( 'DB Tools module not available.', 'aegisbackup' ) );

        if ( $return ) {
            wp_safe_redirect( add_query_arg( array(
                'ab_msg' => ! empty( $res['success'] ) ? 'snapshot_restored' : 'restore_failed',
            ), $return ) );
            exit;
        }

        $this->dbtools_redirect( 'backups', array(
            'ab_msg' => isset( $res['message'] ) ? sanitize_text_field( (string) $res['message'] ) : '',
            'ab_ok'  => ! empty( $res['success'] ) ? 1 : 0,
        ) );
    }

    public function handle_dbtools_restore_snapshot_wizard() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
        }
        check_admin_referer( 'aegisbackup_dbtools_restore_snapshot_wizard', 'aegisbackup_dbtools_restore_snapshot_wizard_nonce' );

        $file = isset( $_POST['file'] ) ? sanitize_file_name( (string) wp_unslash( $_POST['file'] ) ) : '';

        $return = isset( $_POST['ab_redirect'] ) ? esc_url_raw( (string) wp_unslash( $_POST['ab_redirect'] ) ) : '';
        $return = $return ? wp_validate_redirect( $return, '' ) : '';
        if ( ! $return ) {
            $return = admin_url( 'admin.php?page=aegisbackup-restore&tab=restore' );
        }

        $wizard_return = add_query_arg( array(
            'page'      => 'aegisbackup-restore',
            'tab'       => 'restore',
            'ab_wizard' => 1,
            'ab_kind'   => 'db_tools_snapshot',
            'file'      => $file,
        ), admin_url( 'admin.php' ) );

        $confirm = ! empty( $_POST['confirm_drop'] );
        $text    = isset( $_POST['confirm_text'] ) ? strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) ) : '';
        if ( ! $confirm || 'RESTORE' !== $text ) {
            wp_safe_redirect( add_query_arg( array( 'ab_err' => 'confirm' ), $wizard_return ) );
            exit;
        }

        $module = $this->plugin->db_tools();
        if ( ! $module ) {
            wp_safe_redirect( add_query_arg( array( 'ab_err' => 'restore_failed' ), $wizard_return ) );
            exit;
        }

        $res = $module->restore_db_backup_snapshot( $file );
        $ok  = ! empty( $res['success'] );

        $target = $return ? $return : $wizard_return;

        wp_safe_redirect( add_query_arg( array(
            'ab_msg' => $ok ? 'snapshot_restored' : 'restore_failed',
        ), $target ) );
        exit;
    }

    public function handle_dbtools_run_optimization() {
        $this->require_admin_post( 'aegisbackup_dbtools_health' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().
        $module = $this->plugin->db_tools();

        if ( $module && method_exists( $module, 'run_manual_optimization' ) ) {
            $res = $module->run_manual_optimization();
        } elseif ( $module && method_exists( $module, 'run_optimization' ) ) {
            $res = $module->run_optimization( 'manual' );
        } else {
            $res = array( 'success' => false, 'message' => __( 'DB Tools module not available.', 'aegisbackup' ) );
        }

        if ( $module && method_exists( $module, 'add_activity_log' ) ) {
            $module->add_activity_log( 'optimize', ! empty( $res['success'] ) ? 'OK' : ( isset( $res['message'] ) ? (string) $res['message'] : 'Failed' ) );
        }

        $this->dbtools_redirect( 'health', array(
            'ab_msg' => isset( $res['message'] ) ? sanitize_text_field( (string) $res['message'] ) : '',
            'ab_ok'  => ! empty( $res['success'] ) ? 1 : 0,
        ) );
    }

    public function handle_dbtools_run_growth() {
        $this->require_admin_post( 'aegisbackup_dbtools_health' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().
        $module = $this->plugin->db_tools();

        if ( $module && method_exists( $module, 'maybe_check_growth' ) ) {
            $res = $module->maybe_check_growth( true );
        } else {
            $res = array( 'success' => false, 'message' => __( 'DB Tools module not available.', 'aegisbackup' ) );
        }

        if ( $module && method_exists( $module, 'add_activity_log' ) ) {
            $module->add_activity_log( 'growth_check', ! empty( $res['success'] ) ? ( isset( $res['message'] ) ? (string) $res['message'] : 'OK' ) : ( isset( $res['message'] ) ? (string) $res['message'] : 'Failed' ) );
        }

        $this->dbtools_redirect( 'health', array(
            'ab_msg' => isset( $res['message'] ) ? sanitize_text_field( (string) $res['message'] ) : '',
            'ab_ok'  => ! empty( $res['success'] ) ? 1 : 0,
        ) );
    }

    public function admin_menu() {
        $cap = 'manage_options';
        $slug = 'aegisbackup-dashboard';

        add_menu_page(
            __( 'AegisBackup', 'aegisbackup' ),
            __( 'AegisBackup', 'aegisbackup' ),
            $cap,
            $slug,
            array( $this, 'render_dashboard' ),
            'dashicons-migrate',
            58
        );
		add_submenu_page( $slug, __( 'Dashboard', 'aegisbackup' ), __( 'Dashboard', 'aegisbackup' ), $cap, $slug, array( $this, 'render_dashboard' ) );
        add_submenu_page( $slug, __( 'Backups', 'aegisbackup' ), __( 'Backups', 'aegisbackup' ), $cap, 'aegisbackup', array( $this, 'render_backups' ) );
        add_submenu_page( $slug, __( 'Restore', 'aegisbackup' ), __( 'Restore', 'aegisbackup' ), $cap, 'aegisbackup-restore', array( $this, 'render_restore' ) );
		add_submenu_page( null, __( 'Restore & Migrate', 'aegisbackup' ), __( 'Restore & Migrate', 'aegisbackup' ), $cap, 'aegisbackup-restores', array( $this, 'render_restore' ) );
		add_submenu_page( $slug, __( 'Transfer Wizard', 'aegisbackup' ), __( 'Transfer Wizard', 'aegisbackup' ), $cap, 'aegisbackup-pushpull', array( $this, 'render_pushpull' ) );
		add_submenu_page( $slug, __( 'Migration Wizard', 'aegisbackup' ), __( 'Migration Wizard', 'aegisbackup' ), $cap, 'aegisbackup-migration-wizard', array( $this, 'render_migration_wizard' ) );
		add_submenu_page( $slug, __( 'Settings', 'aegisbackup' ), __( 'Settings', 'aegisbackup' ), $cap, 'aegisbackup-logs', array( $this, 'render_logs' ) );
		add_submenu_page(
			$slug,
			__( 'License', 'aegisbackup' ),
			__( 'License', 'aegisbackup' ),
			$cap,
			'aegisbackup-license',
			array( $this, 'render_license' )
		);
    }

	public function handle_save_settings() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_save_settings', 'aegisbackup_settings_nonce' );

		$section = isset( $_POST['settings_section'] ) ? sanitize_key( (string) wp_unslash( $_POST['settings_section'] ) ) : '';
		$redirect = admin_url( 'admin.php?page=aegisbackup-logs' );
		$is_pro = false;
		if ( isset( $this->plugin ) && isset( $this->plugin->license ) && is_object( $this->plugin->license ) && method_exists( $this->plugin->license, 'is_pro_active' ) ) {
			$is_pro = (bool) $this->plugin->license->is_pro_active();
		}
		if ( ! $is_pro && in_array( $section, array( 'remote_storage', 'smtp', 'preupdate' ), true ) ) {
			wp_safe_redirect( add_query_arg( array(
				'tab'   => $section,
				'ab_ok' => 0,
				'ab_msg'=> rawurlencode( __( 'This is a PRO feature. Please upgrade to save these settings.', 'aegisbackup' ) ),
			), $redirect ) );
			exit;
		}

		if ( 'remote_storage' === $section ) {
			$remote = array(
				'enabled'        => ! empty( $_POST['remote_enabled'] ) ? 1 : 0,
				'provider'       => isset( $_POST['remote_provider'] ) ? sanitize_key( (string) wp_unslash( $_POST['remote_provider'] ) ) : 'generic',
				'location'       => isset( $_POST['remote_location'] ) ? esc_url_raw( (string) wp_unslash( $_POST['remote_location'] ) ) : '',
				'port'           => isset( $_POST['remote_port'] ) ? absint( $_POST['remote_port'] ) : 0,
				'username'       => isset( $_POST['remote_username'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['remote_username'] ) ) : '',
				'password'       => isset( $_POST['remote_password'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['remote_password'] ) ) : '',
				's3_bucket_url'  => isset( $_POST['s3_bucket_url'] ) ? esc_url_raw( (string) wp_unslash( $_POST['s3_bucket_url'] ) ) : '',
				's3_region'      => isset( $_POST['s3_region'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['s3_region'] ) ) : '',
				's3_access_key'  => isset( $_POST['s3_access_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['s3_access_key'] ) ) : '',
				's3_secret_key'  => isset( $_POST['s3_secret_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['s3_secret_key'] ) ) : '',
				's3_json'        => isset( $_POST['s3_json'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['s3_json'] ) ) : '',
				's3_object_path' => isset( $_POST['s3_object_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['s3_object_path'] ) ) : '',
			);
			update_option( 'aegisbackup_remote_storage', $remote, false );
			wp_safe_redirect( add_query_arg( array( 'tab' => 'remote_storage', 'ab_ok' => 1, 'ab_msg' => rawurlencode( 'Remote storage settings saved.' ) ), $redirect ) );
			exit;
		}
		if ( 'preupdate' === $section ) {
			$pre = array(
				'enabled' => ! empty( $_POST['preupdate_enabled'] ) ? 1 : 0,
			);
			update_option( 'aegisbackup_preupdate_settings', $pre, false );

			wp_safe_redirect( add_query_arg( array(
				'tab'   => 'preupdate',
				'ab_ok' => 1,
				'ab_msg'=> rawurlencode( __( 'Pre-update settings saved.', 'aegisbackup' ) ),
			), $redirect ) );
			exit;
		}

		if ( 'smtp' === $section ) {
			$smtp = array(
				'enabled'    => ! empty( $_POST['smtp_enabled'] ) ? 1 : 0,
				'host'       => isset( $_POST['smtp_host'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['smtp_host'] ) ) : '',
				'port'       => isset( $_POST['smtp_port'] ) ? absint( $_POST['smtp_port'] ) : 0,
				'encryption' => isset( $_POST['smtp_encryption'] ) ? sanitize_key( (string) wp_unslash( $_POST['smtp_encryption'] ) ) : 'none',
				'username'   => isset( $_POST['smtp_username'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['smtp_username'] ) ) : '',
				'password'   => isset( $_POST['smtp_password'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['smtp_password'] ) ) : '',
				'from_name'  => isset( $_POST['smtp_from_name'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['smtp_from_name'] ) ) : '',
				'from_email' => isset( $_POST['smtp_from_email'] ) ? sanitize_email( (string) wp_unslash( $_POST['smtp_from_email'] ) ) : '',
			);

			$notify = array(
				'recipient'                 => isset( $_POST['notify_recipient'] ) ? sanitize_email( (string) wp_unslash( $_POST['notify_recipient'] ) ) : '',
				'on_backup_complete'        => ! empty( $_POST['notify_on_backup_complete'] ) ? 1 : 0,
				'on_backup_failed'          => ! empty( $_POST['notify_on_backup_failed'] ) ? 1 : 0,
				'on_restore_complete'       => ! empty( $_POST['notify_on_restore_complete'] ) ? 1 : 0,
				'on_restore_failed'         => ! empty( $_POST['notify_on_restore_failed'] ) ? 1 : 0,
				'on_offsite_failure'        => ! empty( $_POST['notify_on_offsite_failure'] ) ? 1 : 0,
				'webhook_url'               => isset( $_POST['notify_webhook_url'] ) ? esc_url_raw( (string) wp_unslash( $_POST['notify_webhook_url'] ) ) : '',
				'webhook_secret'            => isset( $_POST['notify_webhook_secret'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['notify_webhook_secret'] ) ) : '',
				'webhook_on_backup_complete'=> ! empty( $_POST['notify_webhook_on_backup_complete'] ) ? 1 : 0,
				'webhook_on_backup_failed'  => ! empty( $_POST['notify_webhook_on_backup_failed'] ) ? 1 : 0,
				'webhook_on_restore_complete'=> ! empty( $_POST['notify_webhook_on_restore_complete'] ) ? 1 : 0,
				'webhook_on_restore_failed' => ! empty( $_POST['notify_webhook_on_restore_failed'] ) ? 1 : 0,
				'webhook_on_offsite_failure'=> ! empty( $_POST['notify_webhook_on_offsite_failure'] ) ? 1 : 0,
			);
update_option( 'aegisbackup_smtp_settings', $smtp, false );
			update_option( 'aegisbackup_notification_settings', $notify, false );
			wp_safe_redirect( add_query_arg( array( 'tab' => 'smtp', 'ab_msg' => rawurlencode( 'SMTP & notifications settings saved.' ) ), $redirect ) );
			exit;
		}


		if ( 'retention' === $section ) {
			$context = isset( $_POST['retention_context'] ) ? sanitize_key( (string) wp_unslash( $_POST['retention_context'] ) ) : '';
			$days    = isset( $_POST['retention_days'] ) ? absint( $_POST['retention_days'] ) : 0;
			$action  = isset( $_POST['retention_action'] ) ? sanitize_key( (string) wp_unslash( $_POST['retention_action'] ) ) : 'purge';

			if ( $days < 1 ) { $days = 1; }
			if ( $days > 90 ) { $days = 90; }
			if ( ! in_array( $action, array( 'purge', 'offsite' ), true ) ) { $action = 'purge'; }

			$current = get_option( 'aegisbackup_local_retention', array() );
			if ( ! is_array( $current ) ) { $current = array(); }

			$current[ $context ] = array(
				'days'   => $days,
				'action' => $action,
			);

			update_option( 'aegisbackup_local_retention', $current, false );

			$back_url = isset( $_POST['retention_redirect'] ) ? esc_url_raw( (string) wp_unslash( $_POST['retention_redirect'] ) ) : '';
			if ( ! $back_url ) {
				if ( 'migration' === $context ) {
					$back_url = admin_url( 'admin.php?page=aegisbackup&tab=migration' );
				} elseif ( 'files' === $context ) {
					$back_url = admin_url( 'admin.php?page=aegisbackup&tab=files' );
				} else {
					$back_url = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=table_backups' );
				}
			}

			wp_safe_redirect( add_query_arg( array( 'ab_msg' => rawurlencode( 'Retention settings saved.' ) ), $back_url ) );
			exit;
		}

		wp_safe_redirect( add_query_arg( array( 'tab' => 'logs', 'ab_msg' => rawurlencode( 'Unknown settings section.' ) ), $redirect ) );
		exit;
	}

	public function handle_mw_regen_token() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_mw_regen_token' );
		require_once AEGISBACKUP_DIR . 'includes/migrationwizard/class-ab-mw-installer.php';
		\AegisBackup\MigrationWizard\AB_MW_Installer::regenerate_token();
		wp_safe_redirect( add_query_arg( array( 'ab_ok' => 1, 'ab_msg' => rawurlencode( __( 'Migration Wizard access key regenerated.', 'aegisbackup' ) ) ), admin_url( 'admin.php?page=aegisbackup-migration-wizard' ) ) );
		exit;
	}
	public function render_license() {
		( new \AegisBackup\Admin\Pages\AB_Page_License( $this->plugin ) )->render();
	}

	public function handle_mw_save_password() {
	if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
		wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
	}
	check_admin_referer( 'aegisbackup_mw_save_password', 'aegisbackup_mw_nonce' );

	$pw1 = isset( $_POST['ab_mw_password'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['ab_mw_password'] ) ) : '';
	$pw2 = isset( $_POST['ab_mw_password2'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['ab_mw_password2'] ) ) : '';
	$pw1 = trim( $pw1 );
	$pw2 = trim( $pw2 );

	$redirect = admin_url( 'admin.php?page=aegisbackup-migration-wizard' );

	if ( '' === $pw1 || '' === $pw2 ) {
		wp_safe_redirect( add_query_arg( array( 'ab_ok' => 0, 'ab_msg' => rawurlencode( __( 'Please enter and confirm the password.', 'aegisbackup' ) ) ), $redirect ) );
		exit;
	}
	if ( $pw1 !== $pw2 ) {
		wp_safe_redirect( add_query_arg( array( 'ab_ok' => 0, 'ab_msg' => rawurlencode( __( 'Passwords do not match.', 'aegisbackup' ) ) ), $redirect ) );
		exit;
	}
	if ( strlen( $pw1 ) < 8 ) {
		wp_safe_redirect( add_query_arg( array( 'ab_ok' => 0, 'ab_msg' => rawurlencode( __( 'Password must be at least 8 characters.', 'aegisbackup' ) ) ), $redirect ) );
		exit;
	}

	require_once AEGISBACKUP_DIR . 'includes/migrationwizard/class-ab-mw-installer.php';
	\AegisBackup\MigrationWizard\AB_MW_Installer::ensure_installed();

	$ok = \AegisBackup\MigrationWizard\AB_MW_Installer::write_secret_hash( $pw1 );
	wp_safe_redirect( add_query_arg( array(
		'ab_ok'  => $ok ? 1 : 0,
		'ab_msg' => rawurlencode( $ok ? __( 'Migration Wizard password saved.', 'aegisbackup' ) : __( 'Failed to save password. Check webroot permissions.', 'aegisbackup' ) ),
	), $redirect ) );
	exit;
}

public function handle_mw_remove_runner() {
	if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
		wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
	}
	check_admin_referer( 'aegisbackup_mw_remove_runner', 'aegisbackup_mw_remove_nonce' );

	require_once AEGISBACKUP_DIR . 'includes/migrationwizard/class-ab-mw-installer.php';
	$ok = \AegisBackup\MigrationWizard\AB_MW_Installer::remove_runner();

	$redirect = admin_url( 'admin.php?page=aegisbackup-migration-wizard' );
	wp_safe_redirect( add_query_arg( array(
		'ab_ok'  => $ok ? 1 : 0,
		'ab_msg' => rawurlencode( $ok ? __( 'Runner removed from webroot.', 'aegisbackup' ) : __( 'Failed to remove runner. Check permissions.', 'aegisbackup' ) ),
	), $redirect ) );
	exit;
}

	public function handle_send_test_email() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_send_test_email', 'aegisbackup_test_email_nonce' );

		$redirect = admin_url( 'admin.php?page=aegisbackup-logs' );
		$notify = get_option( 'aegisbackup_notification_settings', array() );
		$to = isset( $notify['recipient'] ) ? sanitize_email( (string) $notify['recipient'] ) : '';
		if ( empty( $to ) ) {
			$to = get_option( 'admin_email' );
		}

		$subject = '[AegisBackup] SMTP Test Email';
		$body = "This is a test email sent by AegisBackup to confirm SMTP settings are working.\n\nSite: " . home_url() . "\nTime: " . gmdate( 'c' );

		$sent = wp_mail( $to, $subject, $body );

		$msg = $sent ? __( 'Test email sent.', 'aegisbackup' ) : __( 'Failed to send test email.', 'aegisbackup' );
		if ( ! $sent ) {
			$last = get_option( 'aegisbackup_last_mail_error', array() );
			if ( is_array( $last ) && ! empty( $last['message'] ) ) {
				$detail = sanitize_text_field( (string) $last['message'] );
				if ( $detail ) {
					/* translators: %s: last mailer error message. */
					$msg .= ' ' . sprintf( __( 'Last error: %s', 'aegisbackup' ), $detail );
				}
			}
		}

		wp_safe_redirect( add_query_arg( array( 'tab' => 'smtp', 'ab_ok' => $sent ? 1 : 0, 'ab_msg' => rawurlencode( $msg ) ), $redirect ) );
		exit;
	}
    public function enqueue_assets( $hook ) {
        if ( false === strpos( (string) $hook, 'aegisbackup' ) ) {
            return;
        }
		$page = isset( $_GET['page'] ) ? sanitize_key( (string) wp_unslash( $_GET['page'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce verified earlier or not required.
        $admin_css_path = AEGISBACKUP_DIR . 'assets/admin.css';
		$admin_css_ver  = file_exists( $admin_css_path ) ? (string) filemtime( $admin_css_path ) : AEGISBACKUP_VERSION;

		wp_enqueue_style( 'aegisbackup-admin', AEGISBACKUP_URL . 'assets/admin.css', array(), $admin_css_ver );

        if ( wp_script_is( 'aegisbackup-db-overview', 'enqueued' ) || wp_script_is( 'aegisbackup-db-overview', 'registered' ) ) {
            wp_dequeue_script( 'aegisbackup-db-overview' );
            wp_deregister_script( 'aegisbackup-db-overview' );
        }

		if ( 'aegisbackup-dashboard' === $page ) {
			wp_enqueue_script( 'aegisbackup-chartjs', AEGISBACKUP_URL . 'assets/chart.umd.min.js', array(), AEGISBACKUP_VERSION, true );
			$admin_js_path = AEGISBACKUP_DIR . 'assets/admin.js';
			$admin_js_ver  = file_exists( $admin_js_path ) ? (string) filemtime( $admin_js_path ) : AEGISBACKUP_VERSION;

			wp_enqueue_script( 'aegisbackup-admin', AEGISBACKUP_URL . 'assets/admin.js', array( 'jquery', 'aegisbackup-chartjs' ), $admin_js_ver, true );

			} else {

				wp_enqueue_script(
					'aegisbackup-chartjs',
					AEGISBACKUP_URL . 'assets/chart.umd.min.js',
					array(),
					AEGISBACKUP_VERSION,
					true
				);

				$admin_js_path = AEGISBACKUP_DIR . 'assets/admin.js';
				$admin_js_ver  = file_exists( $admin_js_path ) ? (string) filemtime( $admin_js_path ) : AEGISBACKUP_VERSION;

				wp_enqueue_script(
					'aegisbackup-admin',
					AEGISBACKUP_URL . 'assets/admin.js',
					array( 'jquery', 'aegisbackup-chartjs' ),
					$admin_js_ver,
					true
				);
			}
			
        wp_localize_script(
            'aegisbackup-admin',
            'AegisBackup',
            array(
                'ajaxurl' => admin_url( 'admin-ajax.php' ),
                'nonce'   => wp_create_nonce( 'aegisbackup_nonce' ),
                            'resturl'  => esc_url_raw( rest_url( 'aegisbackup/v1/pp-destlog' ) ),
                'restnonce'=> wp_create_nonce( 'wp_rest' ),
)
        );

		// Chunked upload UI for large Push/Pull Destination uploads.
		$pp_upload_js_path = AEGISBACKUP_DIR . 'assets/pp-upload.js';
		$pp_upload_js_ver  = file_exists( $pp_upload_js_path ) ? (string) filemtime( $pp_upload_js_path ) : AEGISBACKUP_VERSION;
		wp_enqueue_script(
			'aegisbackup-pp-upload',
			AEGISBACKUP_URL . 'assets/pp-upload.js',
			array( 'jquery', 'aegisbackup-admin' ),
			$pp_upload_js_ver,
			true
		);
		wp_localize_script(
			'aegisbackup-pp-upload',
			'AegisBackupPPUpload',
			array(
				'ajaxurl' => admin_url( 'admin-ajax.php' ),
				'nonce'   => wp_create_nonce( 'aegisbackup_nonce' ),
				'chunksize' => 5242880, // 5MB.
			)
		);

    }

    public function render_backups() {
        ( new \AegisBackup\Admin\Pages\AB_Page_Backups( $this->plugin ) )->render();
    }

    public function render_dashboard() {
        ( new \AegisBackup\Admin\Pages\AB_Page_Dashboard( $this->plugin ) )->render();
    }																  
    public function render_restore() {
        ( new \AegisBackup\Admin\Pages\AB_Page_Restore( $this->plugin ) )->render();
    }

    public function render_pushpull() {
        ( new \AegisBackup\Admin\Pages\AB_Page_PushPull( $this->plugin ) )->render();
    }

	public function render_migration_wizard() {
		( new \AegisBackup\Admin\Pages\AB_Page_Migration_Wizard( $this->plugin ) )->render();
	}

    public function render_logs() {
        ( new \AegisBackup\Admin\Pages\AB_Page_Logs( $this->plugin ) )->render();
    }

    private function require_ajax() {
        if ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) {
            wp_send_json_error( array( 'message' => 'Not AJAX.' ), 400 );
        }
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_send_json_error( array( 'message' => 'Insufficient permissions.' ), 403 );
		}
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
    }

	public function ajax_filetree_list() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
		$rel = isset( $_POST['rel'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['rel'] ) ) : '';
		$rel = str_replace( array( '\\', chr(0) ), array( '/', '' ), $rel );
		$rel = ltrim( $rel, '/' );
		$root_real = realpath( (string) ABSPATH );
		if ( false === $root_real ) {
			wp_send_json_error( array( 'message' => 'ABSPATH is not accessible.' ), 500 );
		}
		$root_real = rtrim( $root_real, "/\\" );

		$target = $root_real . ( $rel ? ( DIRECTORY_SEPARATOR . str_replace( '/', DIRECTORY_SEPARATOR, $rel ) ) : '' );
		$target_real = realpath( $target );
		if ( false === $target_real ) {
			wp_send_json_error( array( 'message' => 'Path not found.' ), 404 );
		}
		$target_real = rtrim( $target_real, "/\\" );

		if ( 0 !== strpos( $target_real, $root_real ) ) {
			wp_send_json_error( array( 'message' => 'Invalid path.' ), 400 );
		}

		if ( ! is_dir( $target_real ) || ! is_readable( $target_real ) ) {
			wp_send_json_error( array( 'message' => 'Directory not readable.' ), 403 );
		}

		$items = @scandir( $target_real );
		if ( ! is_array( $items ) ) {
			wp_send_json_error( array( 'message' => 'Failed to scan directory.' ), 500 );
		}

		$dirs  = array();
		$files = array();
		$max = 1500;
		$count = 0;

		foreach ( $items as $name ) {
			if ( '.' === $name || '..' === $name ) {
				continue;
			}
			$count++;
			if ( $count > $max ) {
				break;
			}

			$abs = $target_real . DIRECTORY_SEPARATOR . $name;
			$is_dir = @is_dir( $abs );

			$child_rel = $rel ? ( $rel . '/' . $name ) : $name;

			if ( $is_dir ) {
				$dirs[] = array(
					'name' => $name,
					'rel'  => $child_rel,
				);
			} else {
				$size = @filesize( $abs );
				$mtime = @filemtime( $abs );
				$files[] = array(
					'name' => $name,
					'rel'  => $child_rel,
					'size' => is_numeric( $size ) ? (int) $size : 0,
					'mtime'=> is_numeric( $mtime ) ? (int) $mtime : 0,
				);
			}
		}

		usort( $dirs, static function( $a, $b ) { return strcmp( (string) $a['name'], (string) $b['name'] ); } );
		usort( $files, static function( $a, $b ) { return strcmp( (string) $a['name'], (string) $b['name'] ); } );

		wp_send_json_success( array(
			'rel'   => $rel,
			'dirs'  => $dirs,
			'files' => $files,
			'truncated' => ( $count > $max ),
		) );
	}

    public function ajax_start_backup() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
        $dbg_job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
        $this->ab_debug_job_log( $dbg_job_id, 'ajax_process_backup called. user=' . ( function_exists('get_current_user_id') ? (string) get_current_user_id() : '' ) . ' mem=' . ( function_exists('memory_get_usage') ? (string) memory_get_usage(true) : '' ) . ' time=' . (string) time() );


        $args = array(
            'include_files' => isset( $_POST['include_files'] ) ? (bool) $_POST['include_files'] : true,
            'include_db'    => isset( $_POST['include_db'] ) ? (bool) $_POST['include_db'] : true,
            'include_config'=> isset( $_POST['include_config'] ) ? (bool) $_POST['include_config'] : false,
            'include_core'  => isset( $_POST['include_core'] ) ? (bool) $_POST['include_core'] : false,
            'include_htaccess' => isset( $_POST['include_htaccess'] ) ? (bool) $_POST['include_htaccess'] : false,
            'backup_type'   => isset( $_POST['backup_type'] ) ? sanitize_key( wp_unslash( $_POST['backup_type'] ) ) : 'full',
            'package_purpose' => isset( $_POST['package_purpose'] ) ? sanitize_key( wp_unslash( $_POST['package_purpose'] ) ) : '',
            'snapshot'      => isset( $_POST['snapshot'] ) ? (bool) $_POST['snapshot'] : false,
            'excludes'      => isset( $_POST['excludes'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['excludes'] ) ) : '',
            'db_export_mode' => isset( $_POST['db_export_mode'] ) ? sanitize_key( wp_unslash( $_POST['db_export_mode'] ) ) : 'auto',
        );
        
        $dr_generate = ! empty( $_POST['dr_generate_link'] );
        $dr_payload = array();

        if ( $dr_generate ) {
            $mgr = $this->plugin->backup;
            $dr_base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
            if ( $dr_base ) {
                $args['base_dir'] = $dr_base;
            }
            $args['package_purpose'] = 'dr';
            $args['backup_type']     = 'full';
            $args['snapshot']        = true;
        }

        $job = $this->plugin->backup->start_backup_job( $args );

		if ( empty( $job['job_id'] ) ) {
			$msg = isset( $job['message'] ) ? (string) $job['message'] : 'Failed to start job.';
			$extra = array( 'message' => $msg );
			if ( ! empty( $job['path'] ) ) {
				$extra['path'] = (string) $job['path'];
			}
			wp_send_json_error( $extra, 500 );
		}
        $job_id = sanitize_text_field( (string) $job['job_id'] );

        if ( $dr_generate ) {
            $mgr = $this->plugin->backup;
            $dr_base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
            if ( empty( $dr_base ) ) {
                $upload = wp_upload_dir();
                $dr_base = trailingslashit( $upload['basedir'] ) . 'aegisbackup-dr';
            }
            wp_mkdir_p( $dr_base );

            $recovery_dir = trailingslashit( ABSPATH ) . 'aegisbackup-recovery';
            if ( ! is_dir( $recovery_dir ) ) {
                @wp_mkdir_p( $recovery_dir );
            }

            $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : trailingslashit( $dr_base ) . 'dr-tokens.json';

            $endpoint = trailingslashit( $recovery_dir ) . 'index.php';
            if ( ! is_file( $endpoint ) ) {
                $this->write_dr_recovery_endpoint( $endpoint, $tokens_file );
            }

            $token = wp_generate_password( 26, false, false );
            $link  = trailingslashit( site_url() ) . 'aegisbackup-recovery/?token=' . rawurlencode( $token );

            $zip_path = ! empty( $job['zip_path'] ) ? (string) $job['zip_path'] : '';

            $rec = array(
                'created' => time(),
                'status'  => 'building',
                'job_id'  => (string) $job_id,
                'zip_path'=> $zip_path,
                'package' => $zip_path ? basename( dirname( $zip_path ) ) : '',
                'link'    => $link,
                'opts'    => array(
                    'include_files'    => ! empty( $args['include_files'] ) ? 1 : 0,
                    'include_db'       => ! empty( $args['include_db'] ) ? 1 : 0,
                    'include_htaccess' => ! empty( $args['include_htaccess'] ) ? 1 : 0,
                    'include_config'   => ! empty( $args['include_config'] ) ? 1 : 0,
                    'include_core'     => ! empty( $args['include_core'] ) ? 1 : 0,
                ),
            );

            $tokens = array();
            if ( is_file( $tokens_file ) ) {
                $raw = @file_get_contents( $tokens_file );
                $tmp = json_decode( (string) $raw, true );
                if ( is_array( $tmp ) ) {
                    $tokens = $tmp;
                }
            }
            $tokens[ $token ] = $rec;
            @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );
            $job_opt = \AegisBackup\Backup\AB_Backup_Manager::JOB_OPTION_PREFIX . $job_id;
            $job_state = get_option( $job_opt, array() );
            if ( is_array( $job_state ) ) {
                if ( empty( $job_state['args'] ) || ! is_array( $job_state['args'] ) ) {
                    $job_state['args'] = array();
                }
                $job_state['args']['dr_token'] = (string) $token;
                $job_state['args']['dr_tokens_file'] = (string) $tokens_file;
                $job_state['args']['package_purpose'] = 'dr';
                update_option( $job_opt, $job_state, false );
            }

            $dr_payload = array(
                'token' => $token,
                'link'  => $link,
            );
        }

        $tick_token = 'abrt_' . wp_generate_password( 20, false, false );
        $opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
        $state = get_option( $opt_key, array() );
        if ( is_array( $state ) ) {
            $state['tick_token'] = $tick_token;
            $state['last_tick'] = time();
            update_option( $opt_key, $state, false );
        }

        $this->spawn_restore_tick( $job_id, $tick_token );

        if ( ! empty( $dr_payload ) ) {
            $job['dr'] = $dr_payload;
            $job['is_dr'] = 1;
        }

        wp_send_json_success( $job );
    }

    public function ajax_start_dr_recovery_backup() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
        $args = array(
            'include_files'    => isset( $_POST['include_files'] ) ? (bool) $_POST['include_files'] : true,
            'include_db'       => isset( $_POST['include_db'] ) ? (bool) $_POST['include_db'] : true,
            'include_config'   => isset( $_POST['include_config'] ) ? (bool) $_POST['include_config'] : false,
            'include_core'     => isset( $_POST['include_core'] ) ? (bool) $_POST['include_core'] : false,
            'include_htaccess' => isset( $_POST['include_htaccess'] ) ? (bool) $_POST['include_htaccess'] : false,
            'backup_type'      => 'dr',
            'package_purpose'  => 'dr_recovery_link',
            'snapshot'         => isset( $_POST['snapshot'] ) ? (bool) $_POST['snapshot'] : false,
            'excludes'         => isset( $_POST['excludes'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['excludes'] ) ) : '',
            'db_export_mode'   => isset( $_POST['db_export_mode'] ) ? sanitize_key( wp_unslash( $_POST['db_export_mode'] ) ) : 'auto',
        );

        $mgr = $this->plugin->backup;
        $dr_base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
        if ( empty( $dr_base ) ) {
            $upload = wp_upload_dir();
            $dr_base = trailingslashit( $upload['basedir'] ) . 'aegisbackup-dr';
        }
        wp_mkdir_p( $dr_base );
        $args['base_dir'] = $dr_base;
        $job_id = 'ab_' . wp_generate_password( 12, false, false );
        $args['job_id_override'] = $job_id;
        $args['package_name'] = 'dr-recovery-link-backup-' . gmdate( 'Ymd_His' ) . '-' . substr( $job_id, -6 );
        $job = $this->plugin->backup->start_backup_job( $args );

        if ( empty( $job['job_id'] ) ) {
            $msg = isset( $job['message'] ) ? (string) $job['message'] : 'Failed to start DR recovery link backup.';
            $extra = array( 'message' => $msg );
            if ( ! empty( $job['path'] ) ) {
                $extra['path'] = (string) $job['path'];
            }
            wp_send_json_error( $extra, 500 );
        }

        $job_id = sanitize_text_field( (string) $job['job_id'] );
        $recovery_dir = trailingslashit( ABSPATH ) . 'aegisbackup-recovery';
        if ( ! is_dir( $recovery_dir ) ) {
            @wp_mkdir_p( $recovery_dir );
        }

        $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : trailingslashit( $dr_base ) . 'dr-tokens.json';
        $endpoint = trailingslashit( $recovery_dir ) . 'index.php';
        if ( ! is_file( $endpoint ) ) {
            $this->write_dr_recovery_endpoint( $endpoint, $tokens_file );
        }

        $token = wp_generate_password( 26, false, false );
        $link  = trailingslashit( site_url() ) . 'aegisbackup-recovery/?token=' . rawurlencode( $token );

        $zip_path = ! empty( $job['zip_path'] ) ? (string) $job['zip_path'] : '';
        $rec = array(
            'created' => time(),
            'status'  => 'building',
            'job_id'  => (string) $job_id,
            'zip_path'=> $zip_path,
            'package' => $zip_path ? basename( dirname( $zip_path ) ) : ( ! empty( $job['package_dir'] ) ? basename( (string) $job['package_dir'] ) : '' ),
            'link'    => $link,
            'name'    => $args['package_name'],
            'opts'    => array(
                'include_files'    => ! empty( $args['include_files'] ) ? 1 : 0,
                'include_db'       => ! empty( $args['include_db'] ) ? 1 : 0,
                'include_htaccess' => ! empty( $args['include_htaccess'] ) ? 1 : 0,
                'include_config'   => ! empty( $args['include_config'] ) ? 1 : 0,
                'include_core'     => ! empty( $args['include_core'] ) ? 1 : 0,
            ),
        );

        $tokens = array();
        if ( is_file( $tokens_file ) ) {
            $raw = @file_get_contents( $tokens_file );
            $tmp = json_decode( (string) $raw, true );
            if ( is_array( $tmp ) ) {
                $tokens = $tmp;
            }
        }
        $tokens[ $token ] = $rec;
        @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );

        $job_opt = \AegisBackup\Backup\AB_Backup_Manager::JOB_OPTION_PREFIX . $job_id;
        $st = get_option( $job_opt, array() );
        if ( is_array( $st ) ) {
            if ( empty( $st['args'] ) || ! is_array( $st['args'] ) ) {
                $st['args'] = array();
            }
            $st['args']['dr_token'] = $token;
            $st['args']['dr_tokens_file'] = $tokens_file;
            update_option( $job_opt, $st, false );
        }

        wp_send_json_success( array(
            'job_id' => $job_id,
            'dr'     => array(
                'token' => $token,
                'link'  => $link,
            ),
        ) );
    }

public function ajax_process_backup() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        $job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
        if ( empty( $job_id ) ) {
            wp_send_json_error( array( 'message' => 'Missing job_id.' ), 400 );
        }

        $self = $this;
        register_shutdown_function( function() use ( $job_id, $self ) {
            $err = error_get_last();
            if ( ! $err || empty( $err['type'] ) ) { return; }
            $fatal_types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR );
            if ( ! in_array( (int) $err['type'], $fatal_types, true ) ) { return; }
            $self->ab_debug_job_log( $job_id, 'FATAL shutdown: ' . (string) $err['message'] . ' @ ' . (string) $err['file'] . ':' . (string) $err['line'] );
        } );

        $self->ab_debug_job_log( $job_id, 'ajax_process_backup start. memory=' . ( function_exists('memory_get_usage') ? (string) memory_get_usage(true) : '' ) . ' time=' . ( function_exists('microtime') ? (string) microtime(true) : '' ) );
        $step = $this->plugin->backup->process_backup_job( $job_id );
        $this->ab_debug_job_log( $job_id, 'process_backup_job returned. type=' . ( is_array($step) ? 'array' : gettype($step) ) . ' keys=' . ( is_array($step) ? implode(',', array_keys($step)) : '' ) . ' done=' . ( is_array($step) && ! empty($step['done']) ? '1' : '0' ) . ' progress=' . ( is_array($step) && isset($step['progress']) ? (string) $step['progress'] : '' ) . ' log=' . ( is_array($step) && isset($step['log']) ? (string) $step['log'] : '' ) );

        if ( is_array( $step ) && ! empty( $step['done'] ) && ! empty( $step['package'] ) ) {
            $pkg_name = basename( dirname( (string) $step['package'] ) );
            if ( $pkg_name ) {
                $step['package_name'] = $pkg_name;
                $step['download_url'] = wp_nonce_url(
                    add_query_arg( array( 'action' => 'aegisbackup_download_package', 'pkg' => $pkg_name ), admin_url( 'admin-post.php' ) ),
                    'aegisbackup_download_package',
                    'aegisbackup_nonce'
                );

                $mgr = new \AegisBackup\Backup\AB_Backup_Manager();
                if ( method_exists( $mgr, 'get_package_sanity' ) ) {
                    $step['sanity'] = $mgr->get_package_sanity( $pkg_name );
                }
            }
        }

        wp_send_json_success( $step );
    }

    public function ajax_list_packages() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
            wp_send_json_error( array( 'message' => 'Insufficient permissions.' ), 403 );
        }

        require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-backup-manager.php';
        $mgr  = new \AegisBackup\Backup\AB_Backup_Manager();
        $list = $mgr->list_packages( 5, true );

        $out = array();
        foreach ( (array) $list as $pkg ) {
            $name = isset( $pkg['name'] ) ? (string) $pkg['name'] : '';
            if ( '' === $name ) {
                continue;
            }

            $download = wp_nonce_url(
                add_query_arg( array( 'action' => 'aegisbackup_download_package', 'pkg' => $name ), admin_url( 'admin-post.php' ) ),
                'aegisbackup_download_package',
                'aegisbackup_nonce'
            );
            $delete = wp_nonce_url(
                add_query_arg( array( 'action' => 'aegisbackup_delete_package', 'pkg' => $name, 'redirect' => 'migration' ), admin_url( 'admin-post.php' ) ),
                'aegisbackup_delete_package',
                'aegisbackup_nonce'
            );

            $out[] = array(
                'name' => $name,
                'created' => isset( $pkg['created'] ) ? (string) $pkg['created'] : '',
                'size' => isset( $pkg['size'] ) ? (string) $pkg['size'] : '',
                'download_url' => $download,
                'delete_url' => $delete,
            );
        }

        wp_send_json_success( array( 'packages' => $out ) );
    }

    public function ajax_dashboard_prune() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        $keep = isset( $_POST['keep'] ) ? absint( $_POST['keep'] ) : 10;
        $keep = max( 3, min( 50, $keep ) );

        require_once AEGISBACKUP_DIR . 'includes/backup/class-ab-backup-manager.php';
        $mgr  = new \AegisBackup\Backup\AB_Backup_Manager();
        $mgr->list_packages( $keep, true ); // purge happens inside.

        wp_send_json_success( array( 'message' => sprintf( 'Pruned older packages (kept %d newest).', $keep ) ) );
    }

    public function handle_dashboard_download_logs() {
        if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_dashboard_download_logs', 'aegisbackup_nonce' );

        $logs = get_option( 'aegisbackup_logs', array() );
        if ( ! is_array( $logs ) ) {
            $logs = array();
        }
        require_once AEGISBACKUP_DIR . 'includes/libs/class-ab-activity-log.php';
        $activity = \AegisBackup\Libs\AB_Activity_Log::get( 250 );
        $reports  = get_option( 'aegisbackup_restore_reports', array() );
        if ( ! is_array( $reports ) ) {
            $reports = array();
        }

        $out = array();
        $out[] = 'AegisBackup Diagnostics';
        $out[] = '=======================';
        $out[] = 'Site: ' . home_url();
        $out[] = 'Timestamp (UTC): ' . gmdate( 'c' );
        $out[] = 'Plugin Version: ' . ( defined( 'AEGISBACKUP_VERSION' ) ? AEGISBACKUP_VERSION : '' );
        $out[] = 'WordPress: ' . ( function_exists( 'get_bloginfo' ) ? get_bloginfo( 'version' ) : '' );
        $out[] = 'PHP: ' . PHP_VERSION;
        $out[] = '';

        $out[] = '--- Rolling Logs (aegisbackup_logs) ---';
        $out[] = implode( "\n", array_slice( $logs, -250 ) );
        $out[] = '';

        $out[] = '--- Activity Log (structured) ---';
        foreach ( (array) $activity as $r ) {
            $ts = isset( $r['ts'] ) ? (int) $r['ts'] : 0;
            $out[] = sprintf(
                '[%s] %s/%s - %s',
                $ts ? gmdate( 'Y-m-d H:i:s', $ts ) : 'n/a',
                isset( $r['type'] ) ? (string) $r['type'] : '',
                isset( $r['status'] ) ? (string) $r['status'] : '',
                isset( $r['message'] ) ? (string) $r['message'] : ''
            );
        }
        $out[] = '';

        $out[] = '--- Restore Reports (latest 25) ---';
        $reports = array_slice( $reports, 0, 25 );
        foreach ( (array) $reports as $rep ) {
            $out[] = wp_json_encode( $rep );
        }

        $content = implode( "\n", $out );
        $filename = 'aegisbackup-diagnostics-' . gmdate( 'Ymd-His' ) . '.txt';

        if ( ! headers_sent() ) {
            header( 'Content-Type: text/plain; charset=utf-8' );
            header( 'Content-Disposition: attachment; filename=' . $filename );
            header( 'Cache-Control: no-store, no-cache, must-revalidate, max-age=0' );
        }
        echo esc_html( $content );
        exit;
    }
    public function ajax_start_restore() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        $restore_args = array(
            'package_path' => isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '',
            'mode'         => isset( $_POST['mode'] ) ? sanitize_key( wp_unslash( $_POST['mode'] ) ) : 'existing',
            'new_prefix'   => isset( $_POST['new_prefix'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_prefix'] ) ) : '',
            'old_domain'   => isset( $_POST['old_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['old_domain'] ) ) : '',
            'new_domain'   => isset( $_POST['new_domain'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['new_domain'] ) ) : '',
            'wpconfig_update' => ! empty( $_POST['wpconfig_update'] ) ? 1 : 0,
            'db_name' => isset( $_POST['db_name'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_name'] ) ) : '',
            'db_user' => isset( $_POST['db_user'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_user'] ) ) : '',
            'db_pass' => isset( $_POST['db_pass'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_pass'] ) ) : '',
            'db_host' => isset( $_POST['db_host'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_host'] ) ) : '',
            'wpconfig_regen_salts' => ! empty( $_POST['wpconfig_regen_salts'] ) ? 1 : 0,
            'confirm_drop' => ! empty( $_POST['confirm_drop'] ) ? 1 : 0,
            'confirm_text' => isset( $_POST['confirm_text'] ) ? strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) ) : '',
        );

        $confirm_text = isset( $restore_args['confirm_text'] ) ? strtoupper( trim( (string) $restore_args['confirm_text'] ) ) : '';
        if ( empty( $restore_args['confirm_drop'] ) || 'RESTORE' !== $confirm_text ) {
            wp_send_json_error( array( 'message' => 'Confirmation required. Please check the box and type RESTORE to continue.' ), 400 );
        }

        if ( isset( $restore_args['mode'] ) && 'newdb' === $restore_args['mode'] ) {
            if ( empty( $restore_args['db_name'] ) || empty( $restore_args['db_user'] ) ) {
                wp_send_json_error( array( 'message' => 'Database credentials are required for new database restore.' ), 400 );
            }
        }

        $job = $this->plugin->restore->start_restore_job( $restore_args );
        if ( empty( $job['job_id'] ) ) {
            wp_send_json_error( array( 'message' => 'Failed to start restore job.' ), 500 );
        }
        $job_id = sanitize_text_field( (string) $job['job_id'] );

        $tick_token = 'abrt_' . wp_generate_password( 20, false, false );
        $opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
        $state = get_option( $opt_key, array() );
        if ( is_array( $state ) ) {
            $state['tick_token'] = $tick_token;
            $state['last_tick'] = time();
            update_option( $opt_key, $state, false );
        }

		try {
			$this->plugin->restore->process_restore_job( $job_id );
		} catch ( \Throwable $e ) {
			$this->restore_job_note( $job_id, 'Restore start error: ' . $e->getMessage() );
		}

		$this->spawn_restore_tick( $job_id, $tick_token );

        if ( ! empty( $dr_payload ) ) {
            $job['dr'] = $dr_payload;
            $job['is_dr'] = 1;
        }

        wp_send_json_success( $job );
    }

    public function ajax_process_restore() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        $job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
        if ( empty( $job_id ) ) {
            wp_send_json_error( array( 'message' => 'Missing job_id.' ), 400 );
        }

        $step = $this->plugin->restore->process_restore_job( $job_id );
        wp_send_json_success( $step );
    }

    public function ajax_generate_token() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        require_once AEGISBACKUP_DIR . 'includes/admin/class-ab-rest-api.php';
        $api = new \AegisBackup\Admin\AB_REST_API( $this->plugin );
        $tok = $api->generate_token();

        if ( empty( $tok['id'] ) ) {
            wp_send_json_error( array( 'message' => 'Failed to generate token.' ), 500 );
        }
        wp_send_json_success( array( 'token' => $tok ) );
    }

	public function handle_generate_token_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_generate_token_post', 'aegisbackup_pp_nonce' );

		require_once AEGISBACKUP_DIR . 'includes/admin/class-ab-rest-api.php';
		$api = new \AegisBackup\Admin\AB_REST_API( $this->plugin );
		$tok = $api->generate_token();

		if ( empty( $tok['id'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Failed to generate token.' ) ) );
			exit;
		}

		update_user_meta( get_current_user_id(), 'aegisbackup_pp_token_json', wp_json_encode( $tok ) );

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_listen=1&ab_ok=1&ab_msg=' . rawurlencode( 'Token generated.' ) ) );
		exit;
	}

	public function handle_pp_set_package_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_set_package_post', 'aegisbackup_pp_nonce' );

		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		if ( empty( $package_path ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Select a package first.' ) ) );
			exit;
		}

		$packages = $this->plugin->backup->list_packages();
		$found    = false;
		foreach ( (array) $packages as $p ) {
			if ( empty( $p['package'] ) ) {
				continue;
			}
			if ( (string) $p['package'] === (string) $package_path ) {
				$found = true;
				break;
			}
		}

		if ( ! $found ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Selected package not found.' ) ) );
			exit;
		}

		update_user_meta( get_current_user_id(), 'aegisbackup_pp_package_path', $package_path );

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Package selection saved.' ) ) );
		exit;
	}

	public function handle_pp_set_paths_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_set_paths_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$src_root = isset( $_POST['src_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['src_root'] ) ) : '';
		$dst_root = isset( $_POST['dst_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['dst_root'] ) ) : '';
		$paths    = isset( $_POST['pp_paths'] ) ? array_values( array_filter( array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['pp_paths'] ) ) ) ) : array();

		if ( '' === $src_root ) {
			$src_root = '/public_html/';
		}
		if ( '' === $dst_root ) {
			$dst_root = '/public_html/';
		}

		$src_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $src_root );
		$dst_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $dst_root );
		$src_root = '/' . ltrim( $src_root, '/' );
		$dst_root = '/' . ltrim( $dst_root, '/' );
		if ( '/' !== substr( $src_root, -1 ) ) {
			$src_root .= '/';
		}
		if ( '/' !== substr( $dst_root, -1 ) ) {
			$dst_root .= '/';
		}

		$clean = array();
		foreach ( $paths as $p ) {
			$p = sanitize_text_field( (string) $p );
			$p = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $p );
			$p = ltrim( $p, '/' );
			if ( '' === $p ) {
				continue;
			}
			if ( false !== strpos( $p, '..' ) ) {
				continue;
			}
			$clean[ $p ] = true;
		}

		update_user_meta( $user_id, 'aegisbackup_pp_src_root', $src_root );
		update_user_meta( $user_id, 'aegisbackup_pp_dst_root', $dst_root );
		update_user_meta( $user_id, 'aegisbackup_pp_paths', array_keys( $clean ) );

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Directories / Files selection saved.' ) ) );
		exit;
	}

	public function handle_pp_migrate_db_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_migrate_db_post', 'aegisbackup_pp_nonce' );

		$user_id      = get_current_user_id();
		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		if ( empty( $package_path ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Select a backup first.' ) ) );
			exit;
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}
		$token_json = '';
		$dest_url = '';
		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['connected'] ) && ! empty( $c['token_json'] ) ) {
				$token_json = (string) $c['token_json'];
				$dest_url   = ! empty( $c['dest_url'] ) ? (string) $c['dest_url'] : '';
				break;
			}
		}
		if ( empty( $token_json ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'No connected Destination found. Save a connection first.' ) ) );
			exit;
		}

		update_user_meta( $user_id, 'aegisbackup_pp_package_path', $package_path );

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) || empty( $token['endpoint'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Invalid Destination token JSON saved on this connection.' ) ) );
			exit;
		}

$job = $this->plugin->push->start_push_job(
    array(
        'token'        => $token,
        'package_path' => $package_path,
        'purpose'      => 'db',
    )
);

if ( empty( $job['job_id'] ) ) {
    wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Failed to start DB migration job.' ) ) );
    exit;
}

$job_id = sanitize_text_field( (string) $job['job_id'] );
update_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, 'DB migration job started: ' . $job_id . "\n" );

$started = microtime( true );
$max_seconds = 18; 
$last_log = '';
$done = false;
$progress = 0;

while ( ( microtime( true ) - $started ) < $max_seconds ) {
    $step = $this->plugin->push->process_push_job( $job_id );
    if ( is_array( $step ) ) {
        $done = ! empty( $step['done'] );
        $progress = isset( $step['progress'] ) ? (int) $step['progress'] : $progress;
        $last_log = isset( $step['log'] ) ? (string) $step['log'] : $last_log;

        if ( $last_log ) {
            $prev = (string) get_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, true );
            $prev .= $last_log . "\n";
            $lines = preg_split( '/\r?\n/', $prev );
            if ( is_array( $lines ) && count( $lines ) > 220 ) {
                $lines = array_slice( $lines, -220 );
                $prev = implode( "\n", $lines );
            }
            update_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, $prev );
        }

        if ( $done ) {
            break;
        }
    } else {
        break;
    }
}

if ( $done ) {
    wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_job=' . rawurlencode( $job_id ) . '&ab_msg=' . rawurlencode( 'DB migration completed and delivered to Destination.' ) ) );
    exit;
}

wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_job=' . rawurlencode( $job_id ) . '&ab_msg=' . rawurlencode( 'DB migration started. Sending in the background is limited by hosting timeouts—check the push log for progress.' ) ) );
exit;
	}

	public function handle_pp_migrate_file_backup_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_migrate_file_backup_post', 'aegisbackup_pp_nonce' );

		$__ab_ok_url_base   = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=source' );
		$__ab_fail_url = add_query_arg(
			array(
				'page'   => 'aegisbackup-pushpull-migration',
				'pp_tab' => 'source',
				'pp_msg' => 'pp_migrate_failed',
			),
			admin_url( 'admin.php' )
		);

		register_shutdown_function(
			static function() use ( $__ab_fail_url ) {
				$e = error_get_last();
				if ( ! $e || empty( $e['type'] ) ) {
					return;
				}
				$fatal_types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR );
				if ( ! in_array( (int) $e['type'], $fatal_types, true ) ) {
					return;
				}

				update_option(
					'aegisbackup_pp_last_fatal',
					array(
						'time'    => time(),
						'type'    => (int) $e['type'],
						'message' => isset( $e['message'] ) ? (string) $e['message'] : '',
						'file'    => isset( $e['file'] ) ? (string) $e['file'] : '',
						'line'    => isset( $e['line'] ) ? (int) $e['line'] : 0,
					),
					false
				);

				if ( ! headers_sent() ) {
					wp_safe_redirect( add_query_arg( 'ab_fatal', 1, $__ab_fail_url ) );
					exit;
				}

				echo 'AegisBackup fatal error: ' . esc_html( (string) $e['message'] );
				exit;
			}
		);

		$user_id = get_current_user_id();

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}
		$token_json = '';
		$dest_url   = '';
		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['connected'] ) && ! empty( $c['token_json'] ) ) {
				$token_json = (string) $c['token_json'];
				$dest_url   = ! empty( $c['dest_url'] ) ? (string) $c['dest_url'] : '';
				break;
			}
		}

		$zip_path = isset( $_POST['file_backup_zip'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['file_backup_zip'] ) ) : '';
		$zip_path = wp_normalize_path( $zip_path );

		if ( '' === $token_json || '' === $zip_path || ! is_file( $zip_path ) ) {
			wp_safe_redirect( $__ab_fail_url );
			exit;
		}

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=source&ab_msg=pp_migrate_failed' ) );
			exit;
		}

		if ( empty( $token['endpoint'] ) ) {
			$token['endpoint'] = untrailingslashit( $dest_url );
		}

		try {
			$pm = $this->plugin->push;
			$job = $pm->start_push_job(
				array(
					'token'        => $token,
					'package_path' => $zip_path,
					'purpose'      => 'filebackup',
				)
			);

			if ( empty( $job ) || empty( $job['job_id'] ) ) {
				wp_safe_redirect( $__ab_fail_url_base . '&ab_ok=0&ab_msg=' . rawurlencode( 'Failed to start File Backup migration job.' ) );
				exit;
			}

			$job_id = sanitize_text_field( (string) $job['job_id'] );
			update_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, 'File Backup migration job started: ' . $job_id . "\n" );

			$started     = microtime( true );
			$max_seconds = 18; 
			$last_log    = '';
			$done        = false;
			$progress    = 0;

			while ( ( microtime( true ) - $started ) < $max_seconds ) {
				$step = $pm->process_push_job( $job_id );

				if ( is_array( $step ) ) {
					$done     = ! empty( $step['done'] );
					$progress = isset( $step['progress'] ) ? (int) $step['progress'] : $progress;
					$last_log = isset( $step['log'] ) ? (string) $step['log'] : $last_log;

					if ( $last_log ) {
						$prev = (string) get_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, true );
						$prev .= $last_log . "\n";

						$lines = preg_split( '/\r?\n/', $prev );
						if ( is_array( $lines ) && count( $lines ) > 220 ) {
							$lines = array_slice( $lines, -220 );
							$prev  = implode( "\n", $lines );
						}
						update_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, $prev );
					}

					if ( $done ) {
						break;
					}
				} else {
					break;
				}
			}

			if ( $done ) {
				wp_safe_redirect(
					$__ab_ok_url_base .
					'&ab_ok=1&ab_job=' . rawurlencode( $job_id ) .
					'&ab_msg=' . rawurlencode( 'File Backup migration completed and delivered to Destination.' )
				);
				exit;
			}

			wp_safe_redirect(
				$__ab_ok_url_base .
				'&ab_ok=1&ab_job=' . rawurlencode( $job_id ) .
				'&ab_msg=' . rawurlencode( 'File Backup migration started. Check the push log for progress (shared hosting time limits apply).' )
			);
			exit;

		} catch ( \Throwable $t ) {
			update_option(
				'aegisbackup_pp_last_fatal',
				array(
					'time'    => time(),
					'type'    => -1,
					'message' => $t->getMessage(),
					'file'    => $t->getFile(),
					'line'    => $t->getLine(),
				),
				false
			);

			wp_safe_redirect(
				$__ab_fail_url_base . '&ab_ok=0&ab_msg=' . rawurlencode( 'File Backup migration failed: ' . $t->getMessage() )
			);
			exit;
		}
	}

	public function handle_pp_delete_received_file_backup_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_delete_received_file_backup_post', 'aegisbackup_pp_nonce' );

		$fb_key = isset( $_POST['fb_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['fb_key'] ) ) : '';
		$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}
		if ( $fb_key && isset( $list[ $fb_key ] ) ) {
			$row = $list[ $fb_key ];
			$zip = isset( $row['zip'] ) ? (string) $row['zip'] : '';
			$backup_id = isset( $row['backup_id'] ) ? (string) $row['backup_id'] : '';
			unset( $list[ $fb_key ] );
			update_option( 'aegisbackup_pp_received_file_backups', $list, false );

			try {
				if ( $zip && is_file( $zip ) ) {
					wp_delete_file(  $zip  );
				}
				if ( $backup_id ) {
					$manifest = trailingslashit( dirname( $zip ) ) . basename( $backup_id ) . '.json';
					if ( is_file( $manifest ) ) {
						wp_delete_file(  $manifest  );
					}
				}
			} catch ( \Throwable $e ) {
			}
		}

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_msg=pp_file_backup_deleted' ) );
		exit;
	}

function handle_pp_migrate_files_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_migrate_files_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$src_root = isset( $_POST['src_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['src_root'] ) ) : '';
		$dst_root = isset( $_POST['dst_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['dst_root'] ) ) : '';
		$paths    = isset( $_POST['pp_paths'] ) ? array_values( array_filter( array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['pp_paths'] ) ) ) ) : array();

		if ( '' === $src_root ) { $src_root = '/public_html/'; }
		if ( '' === $dst_root ) { $dst_root = '/public_html/'; }

		$src_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $src_root );
		$dst_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $dst_root );
		$src_root = '/' . ltrim( $src_root, '/' );
		$dst_root = '/' . ltrim( $dst_root, '/' );
		if ( '/' !== substr( $src_root, -1 ) ) { $src_root .= '/'; }
		if ( '/' !== substr( $dst_root, -1 ) ) { $dst_root .= '/'; }

		$clean = array();
		foreach ( $paths as $p ) {
			$p = sanitize_text_field( (string) $p );
			$p = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $p );
			$p = ltrim( $p, '/' );
			if ( '' === $p ) { continue; }
			if ( false !== strpos( $p, '..' ) ) { continue; }
			$clean[ $p ] = true;
		}

		$clean_paths = array_keys( $clean );
		update_user_meta( $user_id, 'aegisbackup_pp_src_root', $src_root );
		update_user_meta( $user_id, 'aegisbackup_pp_dst_root', $dst_root );
		update_user_meta( $user_id, 'aegisbackup_pp_paths', $clean_paths );

		if ( empty( $clean_paths ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Select at least one directory or file.' ) ) );
			exit;
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) { $connections = array(); }
		$token_json = '';
		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['connected'] ) && ! empty( $c['token_json'] ) ) {
				$token_json = (string) $c['token_json'];
				break;
			}
		}
		if ( empty( $token_json ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'No connected Destination found. Save a connection first.' ) ) );
			exit;
		}

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) || empty( $token['endpoint'] ) || empty( $token['id'] ) || empty( $token['exp'] ) || empty( $token['sig'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Invalid Destination token JSON saved on this connection.' ) ) );
			exit;
		}

		$api = trailingslashit( (string) $token['endpoint'] ) . 'wp-json/aegisbackup/v1/file-put';
		$headers = array(
			'Content-Type'    => 'application/json; charset=utf-8',
			'X-AB-TOKEN-ID'   => (string) $token['id'],
			'X-AB-TOKEN-EXP'  => (string) $token['exp'],
			'X-AB-TOKEN-SIG'  => (string) $token['sig'],
		);

		$root_real = realpath( (string) ABSPATH );
		if ( false === $root_real ) {
			$root_real = (string) ABSPATH;
		}
		$root_real = rtrim( str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $root_real ), '/' );

		$sent_files = 0;
		$sent_dirs  = 0;
		$errors     = 0;
		$first_err  = '';

		$send_dir = function( $rel_path ) use ( $api, $headers, $dst_root, &$sent_dirs, &$errors, &$first_err ) {
			$body = wp_json_encode(
				array(
					'dst_root' => (string) $dst_root,
					'rel_path' => (string) $rel_path,
					'is_dir'   => 1,
				)
			);
			$res = wp_remote_post(
				$api,
				array(
					'headers' => $headers,
					'timeout' => 30,
					'body'    => $body,
				)
			);
			if ( is_wp_error( $res ) ) {
				$errors++;
				if ( '' === $first_err ) { $first_err = $res->get_error_message(); }
				return false;
			}
			$code = (int) wp_remote_retrieve_response_code( $res );
			if ( $code < 200 || $code >= 300 ) {
				$errors++;
				if ( '' === $first_err ) { $first_err = 'HTTP ' . $code; }
				return false;
			}
			$sent_dirs++;
			return true;
		};

		$send_file = function( $rel_path, $abs_path ) use ( $api, $headers, $dst_root, &$sent_files, &$errors, &$first_err ) {
			$bin = @file_get_contents( $abs_path );
			if ( false === $bin ) {
				$errors++;
				if ( '' === $first_err ) { $first_err = 'Failed to read: ' . $rel_path; }
				return false;
			}
			$body = wp_json_encode(
				array(
					'dst_root'    => (string) $dst_root,
					'rel_path'    => (string) $rel_path,
					'content_b64' => base64_encode( $bin ),
				)
			);
			$res = wp_remote_post(
				$api,
				array(
					'headers' => $headers,
					'timeout' => 60,
					'body'    => $body,
				)
			);
			if ( is_wp_error( $res ) ) {
				$errors++;
				if ( '' === $first_err ) { $first_err = $res->get_error_message(); }
				return false;
			}
			$code = (int) wp_remote_retrieve_response_code( $res );
			if ( $code < 200 || $code >= 300 ) {
				$errors++;
				if ( '' === $first_err ) { $first_err = 'HTTP ' . $code; }
				return false;
			}
			$sent_files++;
			return true;
		};

		foreach ( $clean_paths as $rel ) {
			$abs = $root_real . '/' . ltrim( $rel, '/' );
			$abs_real = realpath( $abs );
			if ( false === $abs_real ) { continue; }
			$abs_real = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $abs_real );
			if ( 0 !== strpos( $abs_real, $root_real ) ) { continue; }

			if ( is_dir( $abs_real ) ) {
				$send_dir( rtrim( $rel, '/' ) . '/' );

				$iter = new \RecursiveIteratorIterator(
					new \RecursiveDirectoryIterator( $abs_real, \FilesystemIterator::SKIP_DOTS ),
					\RecursiveIteratorIterator::SELF_FIRST
				);
				foreach ( $iter as $f ) {
					$fp = (string) $f;
					$fp_real = realpath( $fp );
					if ( false === $fp_real ) { continue; }
					$fp_real = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $fp_real );
					if ( 0 !== strpos( $fp_real, $root_real ) ) { continue; }
					$local = ltrim( str_replace( $root_real, '', $fp_real ), '/' );
					if ( $f->isDir() ) {
						$send_dir( rtrim( $local, '/' ) . '/' );
					} else {
						$send_file( $local, $fp_real );
					}
				}
			} else {
				$send_file( $rel, $abs_real );
			}
		}

		if ( $errors > 0 ) {
			$msg = sprintf( 'Files migration finished with %d error(s). Sent %d file(s), %d folder(s). First error: %s', (int) $errors, (int) $sent_files, (int) $sent_dirs, (string) $first_err );
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( $msg ) ) );
			exit;
		}

		$msg = sprintf( 'Files migrated successfully. Sent %d file(s), %d folder(s).', (int) $sent_files, (int) $sent_dirs );
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( $msg ) ) );
		exit;
	}

	public function handle_pp_file_restore_bulk_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_file_restore_bulk_post', 'aegisbackup_pp_nonce' );

		$keys = isset( $_POST['fb_keys'] ) ? (array) wp_unslash( $_POST['fb_keys'] ) : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized below via sanitize_text_field().
		$keys = array_values( array_filter( array_map( 'sanitize_text_field', $keys ) ) );
		if ( empty( $keys ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Please select a File Backup to restore.' ) ) );
			exit;
		}

		$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}

		$first = (string) $keys[0];
		if ( empty( $list[ $first ] ) || ! is_array( $list[ $first ] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Selected File Backup was not found.' ) ) );
			exit;
		}

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&pp_view=file_restore&fb_key=' . rawurlencode( $first ) ) );
		exit;
	}

	public function handle_pp_file_restore_confirm_post() {

		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}

		check_admin_referer( 'aegisbackup_pp_file_restore_confirm_post', 'aegisbackup_pp_nonce' );

		$fb_key = isset( $_POST['fb_key'] ) ? sanitize_text_field( wp_unslash( $_POST['fb_key'] ) ) : '';

		$overwrite = (
			! empty( $_POST['confirm_drop'] ) ||
			! empty( $_POST['confirm_overwrite'] ) ||
			! empty( $_POST['overwrite'] )
		);

		$confirm = '';
		if ( isset( $_POST['confirm_text'] ) ) {
			$confirm = strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) );
		} elseif ( isset( $_POST['confirm'] ) ) {
			$confirm = strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm'] ) ) ) );
		}

		$__ab_fail_url = add_query_arg(
			array(
				'page'   => 'aegisbackup-pushpull',
				'pp_tab' => 'destination',
				'pp_msg' => 'pp_file_restore_failed',
			),
			admin_url( 'admin.php' )
		);

		register_shutdown_function(
			static function() use ( $__ab_fail_url ) {
				$e = error_get_last();
				if ( $e && in_array( (int) $e['type'], array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR ), true ) ) {
					if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) { error_log( '[AegisBackup] Push/Pull file restore fatal: ' . $e->getMessage() ); } // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
					if ( ! headers_sent() ) {
						wp_safe_redirect( add_query_arg( array( 'fatal' => 1 ), $__ab_fail_url ) );
					}
				}
			}
		);

		if ( ! $fb_key || ! $overwrite || 'RESTORE' !== $confirm ) {
			wp_safe_redirect( add_query_arg( array( 'reason' => 'confirm' ), $__ab_fail_url ) );
			exit;
		}

		$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}

		if ( empty( $list[ $fb_key ] ) || ! is_array( $list[ $fb_key ] ) ) {
			$fail = add_query_arg(
				array(
					'page'    => 'aegisbackup-pushpull',
					'pp_tab'  => 'destination',
					'pp_view' => 'file_restore',
					'fb_key'  => $fb_key,
					'ab_ok'   => 0,
					'ab_msg'  => rawurlencode( 'Selected File Backup was not found.' ),
				),
				admin_url( 'admin.php' )
			);
			wp_safe_redirect( $fail );
			exit;
		}

		$entry    = $list[ $fb_key ];
		$backup_id = isset( $entry['backup_id'] ) ? (string) $entry['backup_id'] : '';
		$zip_path  = isset( $entry['zip'] ) ? (string) $entry['zip'] : '';

		// For file restores, the restore engine expects the backup "id" to match the ZIP basename (without extension).
		// Prefer the ZIP-derived id to avoid mismatches (e.g. older entries that stored a placeholder backup_id).
		if ( $zip_path ) {
			$backup_id = preg_replace( '/\.zip$/i', '', basename( $zip_path ) );
		} elseif ( $backup_id ) {
			$backup_id = (string) $backup_id;
		}

		$backup_id = sanitize_text_field( $backup_id );
		if ( $backup_id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $backup_id ) ) {
			$backup_id = '';
		}
		if ( ! $backup_id ) {
			$fail = add_query_arg(
				array(
					'page'    => 'aegisbackup-pushpull',
					'pp_tab'  => 'destination',
					'pp_view' => 'file_restore',
					'fb_key'  => $fb_key,
					'ab_ok'   => 0,
					'ab_msg'  => rawurlencode( 'Invalid backup id for selected File Backup.' ),
				),
				admin_url( 'admin.php' )
			);
			wp_safe_redirect( $fail );
			exit;
		}
	$ts = gmdate( 'Y-m-d H:i:s' );
		$this->pp_append_destination_log(
			sprintf(
				'[%s] RESTORE FILE START backup_id=%s zip=%s',
				$ts,
				$backup_id,
				$zip_path ? $zip_path : '(unknown)'
			)
		);

		$res = array( 'ok' => false, 'message' => '' );
		try {
			$res = $this->plugin->file_backup->restore_backup( $backup_id );
		} catch ( \Throwable $e ) {
			$res = array( 'ok' => false, 'message' => $e->getMessage() );
		}

		if ( empty( $res['ok'] ) ) {
			$fail_msg = 'File restore failed.';
			if ( ! empty( $res['message'] ) ) {
				$fail_msg .= ' ' . (string) $res['message'];
			}

			$ts = gmdate( 'Y-m-d H:i:s' );
			$this->pp_append_destination_log(
				sprintf(
					'[%s] RESTORE FILE FAIL backup_id=%s msg=%s',
					$ts,
					$backup_id,
					$fail_msg
				)
			);

			$fail = add_query_arg(
				array(
					'page'    => 'aegisbackup-pushpull',
					'pp_tab'  => 'destination',
					'pp_view' => 'file_restore',
					'fb_key'  => $fb_key,
					'ab_ok'   => 0,
					'ab_msg'  => rawurlencode( $fail_msg ),
				),
				admin_url( 'admin.php' )
			);
			wp_safe_redirect( $fail );
			exit;
		}

		$restored = isset( $res['restored'] ) ? (int) $res['restored'] : 0;
		$skipped  = isset( $res['skipped'] ) ? (int) $res['skipped'] : 0;
		$ts = gmdate( 'Y-m-d H:i:s' );
		$this->pp_append_destination_log(
			sprintf(
				'[%s] RESTORE FILE DONE backup_id=%s restored=%d skipped=%d',
				$ts,
				$backup_id,
				$restored,
				$skipped
			)
		);

		$success = add_query_arg(
			array(
				'page'   => 'aegisbackup-pushpull',
				'pp_tab' => 'destination',
				'ab_ok'  => 1,
				'ab_msg' => rawurlencode( sprintf( 'File restore complete. Restored %d files. Skipped %d items.', $restored, $skipped ) ),
			),
			admin_url( 'admin.php' )
		);

		wp_safe_redirect( $success );
		exit;
	}

	public function handle_pp_file_delete_post() {

		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}

		check_admin_referer( 'aegisbackup_pp_file_delete_post', 'aegisbackup_pp_nonce' );

		$fb_key = isset( $_POST['fb_key'] ) ? sanitize_text_field( wp_unslash( $_POST['fb_key'] ) ) : '';
		$fb_id  = isset( $_POST['fb_id'] ) ? sanitize_text_field( wp_unslash( $_POST['fb_id'] ) ) : '';

		$delete_id = $fb_key ? $fb_key : $fb_id;

		$ok = false;
		$ts = gmdate( 'Y-m-d H:i:s' );
		$this->pp_append_destination_log(
			sprintf(
				'[%s] DELETE FILEBACKUP START delete_id=%s',
				$ts,
				$delete_id ? $delete_id : '(missing)'
			)
		);

		if ( $delete_id ) {

			$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
			if ( ! is_array( $list ) ) {
				$list = array();
			}

			if ( isset( $list[ $delete_id ] ) && is_array( $list[ $delete_id ] ) ) {

				$entry = $list[ $delete_id ];

				$zip_path      = isset( $entry['zip'] ) ? (string) $entry['zip'] : '';
				$backup_id     = isset( $entry['backup_id'] ) ? (string) $entry['backup_id'] : '';
				$source_zip    = isset( $entry['source_zip'] ) ? (string) $entry['source_zip'] : '';
				$package_path  = isset( $entry['package_path'] ) ? (string) $entry['package_path'] : '';

				$json_path = '';
				if ( $zip_path && str_ends_with( $zip_path, '.zip' ) ) {
					$json_path = substr( $zip_path, 0, -4 ) . '.json';
				} elseif ( $backup_id ) {
					$uploads = wp_upload_dir();
					$json_path = trailingslashit( $uploads['basedir'] ) . 'aegisbackup/file-backups/' . basename( $backup_id ) . '.json';
				}

				$rrmdir = function( $dir ) use ( &$rrmdir ) {
					if ( ! $dir || ! is_dir( $dir ) ) {
						return;
					}
					$fs = $this->ab_filesystem();
					if ( $fs && method_exists( $fs, 'delete' ) ) {
						$fs->delete( $dir, true, 'd' );
						return;
					}

					$items = @scandir( $dir );
					if ( ! is_array( $items ) ) {
						return;
					}
					foreach ( $items as $item ) {
						if ( '.' === $item || '..' === $item ) {
							continue;
						}
						$p = $dir . DIRECTORY_SEPARATOR . $item;
						if ( is_dir( $p ) ) {
							$rrmdir( $p );
						} else {
							wp_delete_file(  $p  );
						}
					}
					@rmdir( $dir ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.
				};

				$uploads = wp_upload_dir();
				$base    = trailingslashit( $uploads['basedir'] ) . 'aegisbackup/';

				$deleted_any = false;

				if ( $zip_path && is_file( $zip_path ) ) {
					$deleted_any = wp_delete_file(  $zip_path ) || $deleted_any;
				}
				if ( $json_path && is_file( $json_path ) ) {
					$deleted_any = wp_delete_file(  $json_path ) || $deleted_any;
				}

				if ( $source_zip && is_file( $source_zip ) ) {
					$deleted_any = wp_delete_file(  $source_zip ) || $deleted_any;
				}

				if ( $package_path && is_dir( $package_path ) ) {
					$real_pkg  = realpath( $package_path );
					$real_base = realpath( $base );
					if ( $real_pkg && $real_base && 0 === strpos( $real_pkg, $real_base ) ) {
						$rrmdir( $real_pkg );
						$deleted_any = true;
					}
				}

				unset( $list[ $delete_id ] );
				update_option( 'aegisbackup_pp_received_file_backups', $list, false );

				$ok = $deleted_any ? true : true; 
			} else {

				$ok = $this->plugin->file_backup->delete_backup( $delete_id );
			}
		}

		$ts = gmdate( 'Y-m-d H:i:s' );
		$this->pp_append_destination_log(
			sprintf(
				'[%s] DELETE FILEBACKUP %s delete_id=%s',
				$ts,
				$ok ? 'DONE' : 'FAIL',
				$delete_id ? $delete_id : '(missing)'
			)
		);

		$url = add_query_arg(
			array(
				'page'   => 'aegisbackup-pushpull',
				'pp_tab' => 'destination',
				'pp_msg' => $ok ? 'pp_file_deleted' : 'pp_file_delete_failed',
			),
			admin_url( 'admin.php' )
		);

		wp_safe_redirect( $url );
		exit;
	}

	public function handle_pp_upload_received_file_backup() {
	if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
		wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
	}

	check_admin_referer( 'aegisbackup_pp_upload_received_file_backup', 'aegisbackup_nonce' );

	if ( empty( $_FILES['ab_pp_file_backup_zip']['name'] ) ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_missing' ) );
		exit;
	}

	$file = isset( $_FILES['ab_pp_file_backup_zip'] ) ? $_FILES['ab_pp_file_backup_zip'] : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Validated below.
	$original_name = isset( $file['name'] ) ? sanitize_file_name( (string) $file['name'] ) : '';
	$ext = strtolower( pathinfo( $original_name, PATHINFO_EXTENSION ) );

	if ( 'zip' !== $ext ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_invalid' ) );
		exit;
	}

	if ( ! function_exists( 'wp_handle_upload' ) ) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
	}

	$upload_dir = wp_upload_dir();
	$dest_dir   = trailingslashit( (string) $upload_dir['basedir'] ) . 'aegisbackup/file-backups';
	if ( ! wp_mkdir_p( $dest_dir ) ) {
		wp_die( esc_html__( 'Unable to create upload directory.', 'aegisbackup' ) );
	}

	$overrides = array(
		'test_form' => false,
		'mimes'     => array( 'zip' => 'application/zip' ),
	);

	$filter = static function( $dirs ) use ( $dest_dir ) {
		$dirs['path']    = $dest_dir;
		$dirs['url']     = '';
		$dirs['subdir']  = '';
		$dirs['basedir'] = $dest_dir;
		$dirs['baseurl'] = '';
		return $dirs;
	};

	add_filter( 'upload_dir', $filter );
	$uploaded = wp_handle_upload( $file, $overrides );
	remove_filter( 'upload_dir', $filter );

	if ( empty( $uploaded['file'] ) || ! empty( $uploaded['error'] ) ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_failed' ) );
		exit;
	}

	$path = (string) $uploaded['file'];
	$key  = md5( $path );

	$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
	if ( ! is_array( $list ) ) {
		$list = array();
	}

	$list[ $key ] = array(
		'id'            => $key,
		'backup_id'     => $backup_id ? $backup_id : preg_replace( '/\.zip$/i', '', basename( $dest_zip ) ),
		'name'          => basename( $path ),
		'zip'           => $path,
		'package_path'  => '',
		'source_zip'    => '',
		'received_at'   => time(),
		'token_id'      => 'manual',
		'connected'     => 0,
		'last_activity' => time(),
	);

	update_option( 'aegisbackup_pp_received_file_backups', $list, false );

	wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_ok' ) );
	exit;
}

public function handle_pp_upload_received_db_backup() {
	if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
		wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
	}

	check_admin_referer( 'aegisbackup_pp_upload_received_db_backup', 'aegisbackup_nonce' );

	if ( empty( $_FILES['ab_pp_db_backup_zip']['name'] ) ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_missing' ) );
		exit;
	}

	$file = isset( $_FILES['ab_pp_db_backup_zip'] ) ? $_FILES['ab_pp_db_backup_zip'] : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Validated below.
	$original_name = isset( $file['name'] ) ? sanitize_file_name( (string) $file['name'] ) : '';
	$ext = strtolower( pathinfo( $original_name, PATHINFO_EXTENSION ) );

	if ( 'zip' !== $ext ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_invalid' ) );
		exit;
	}

	if ( ! function_exists( 'wp_handle_upload' ) ) {
		require_once ABSPATH . 'wp-admin/includes/file.php';
	}

	$upload = wp_upload_dir();
	$base   = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup';
	wp_mkdir_p( $base );

	$pkg_dir = trailingslashit( $base ) . 'incoming-db-' . gmdate( 'Ymd_His' ) . '-manual';
	wp_mkdir_p( $pkg_dir );

	// Resolve and normalize the extracted package path (used later by the Restore Wizard / DB restorer).
	$real_pkg_dir = realpath( $pkg_dir );
	if ( false === $real_pkg_dir || '' === $real_pkg_dir ) {
		$real_pkg_dir = $pkg_dir;
	}
	$real_pkg_dir = trailingslashit( (string) $real_pkg_dir );


	$overrides = array(
		'test_form' => false,
		'mimes'     => array( 'zip' => 'application/zip' ),
	);

	$filter = static function( $dirs ) use ( $pkg_dir ) {
		$dirs['path']    = $pkg_dir;
		$dirs['url']     = '';
		$dirs['subdir']  = '';
		$dirs['basedir'] = $pkg_dir;
		$dirs['baseurl'] = '';
		return $dirs;
	};

	add_filter( 'upload_dir', $filter );
	$uploaded = wp_handle_upload( $file, $overrides );
	remove_filter( 'upload_dir', $filter );

	if ( empty( $uploaded['file'] ) || ! empty( $uploaded['error'] ) ) {
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_failed' ) );
		exit;
	}

	$dest_zip = (string) $uploaded['file'];

		// Extract to package folder so meta.json (if present) is available for UI labels.
		$unzip_res = $this->pp_extract_zip_fallback( $dest_zip, $pkg_dir );
		if ( is_wp_error( $unzip_res ) ) {
			// Log extraction error and do NOT register the DB backup as received.
			$this->pp_append_destination_log( sprintf( '[%s] DB UPLOAD EXTRACT ERROR: %s', gmdate( 'Y-m-d H:i:s' ), $unzip_res->get_error_message() ) );
			wp_delete_file( $dest_zip );
			$this->rrmdir_best_effort( $pkg_dir );
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_extract_failed' ) );
			exit;
		}

	$db_list = get_option( 'aegisbackup_pp_received_db_backups', array() );
	if ( ! is_array( $db_list ) ) {
		$db_list = array();
	}

	$key = md5( $dest_zip );
	$db_list[ $key ] = array(
		'id'            => $key,
		'zip'           => $dest_zip,
		'package_path'  => $real_pkg_dir,
		'received_at'   => time(),
			'received'      => time(),
		'token_id'      => 'manual',
		'connected'     => 0,
		'last_activity' => time(),
	);

	update_option( 'aegisbackup_pp_received_db_backups', $db_list, false );

	wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=pushpull&pp_tab=destination&ab_msg=upload_ok' ) );
	exit;
}

	/**
	 * Chunked/resumable upload init for very large ZIP files.
	 * Target: file | db
	 */
	public function pp_resumable_upload_init() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Insufficient permissions.', 'aegisbackup' ) ), 403 );
		}

		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$target   = isset( $_POST['target'] ) ? sanitize_key( (string) wp_unslash( $_POST['target'] ) ) : '';
		$filename = isset( $_POST['filename'] ) ? sanitize_file_name( (string) wp_unslash( $_POST['filename'] ) ) : '';
		$filesize = isset( $_POST['filesize'] ) ? absint( (int) wp_unslash( $_POST['filesize'] ) ) : 0;

		if ( '' === $target || ( 'file' !== $target && 'db' !== $target ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Invalid upload target.', 'aegisbackup' ) ), 400 );
		}
		if ( '' === $filename || $filesize <= 0 ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Missing file details.', 'aegisbackup' ) ), 400 );
		}
		$ext = strtolower( pathinfo( $filename, PATHINFO_EXTENSION ) );
		if ( 'zip' !== $ext ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Only .zip files are supported.', 'aegisbackup' ) ), 400 );
		}

		$upload = wp_upload_dir();
		$base   = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup/tmp-uploads';
		if ( ! wp_mkdir_p( $base ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Unable to create upload directory.', 'aegisbackup' ) ), 500 );
		}

		$upload_id = wp_generate_uuid4();
		$part_path = trailingslashit( $base ) . $upload_id . '.part';
		$meta_path = trailingslashit( $base ) . $upload_id . '.json';

		$meta = array(
			'upload_id' => $upload_id,
			'target'    => $target,
			'filename'  => $filename,
			'filesize'  => $filesize,
			'user_id'   => get_current_user_id(),
			'created'   => time(),
			'received'  => 0,
		);

		// Create/overwrite empty part file.
		$fs = $this->ab_filesystem();
		if ( ! $fs || ! is_object( $fs ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Unable to initialize filesystem.', 'aegisbackup' ) ), 500 );
		}
		$chmod = defined( 'FS_CHMOD_FILE' ) ? FS_CHMOD_FILE : 0644;
		$ok = $fs->put_contents( $part_path, '', $chmod );
		if ( ! $ok ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Unable to start upload.', 'aegisbackup' ) ), 500 );
		}

		// Store meta.
		@file_put_contents( $meta_path, wp_json_encode( $meta ) ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_read_file_put_contents -- Writing to uploads.

		wp_send_json_success(
			array(
				'upload_id' => $upload_id,
				'part_path' => $part_path,
			)
		);
	}

	/**
	 * Receive a chunk for an upload.
	 */
	public function pp_resumable_upload_chunk() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Insufficient permissions.', 'aegisbackup' ) ), 403 );
		}
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$upload_id    = isset( $_POST['upload_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['upload_id'] ) ) : '';
		$chunk_index  = isset( $_POST['chunk_index'] ) ? absint( (int) wp_unslash( $_POST['chunk_index'] ) ) : 0;
		$total_chunks = isset( $_POST['total_chunks'] ) ? absint( (int) wp_unslash( $_POST['total_chunks'] ) ) : 0;

		if ( '' === $upload_id || $total_chunks <= 0 ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Invalid upload session.', 'aegisbackup' ) ), 400 );
		}

		$upload = wp_upload_dir();
		$base   = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup/tmp-uploads';
		$part_path = trailingslashit( $base ) . $upload_id . '.part';
		$meta_path = trailingslashit( $base ) . $upload_id . '.json';

		if ( ! file_exists( $part_path ) || ! file_exists( $meta_path ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Upload session not found.', 'aegisbackup' ) ), 404 );
		}

		$meta_raw = @file_get_contents( $meta_path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_read_file_get_contents -- Reading from uploads.
		$meta     = $meta_raw ? json_decode( $meta_raw, true ) : array();
		if ( ! is_array( $meta ) ) {
			$meta = array();
		}
		$expected_user = isset( $meta['user_id'] ) ? absint( (int) $meta['user_id'] ) : 0;
		if ( $expected_user && get_current_user_id() !== $expected_user ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Upload session mismatch.', 'aegisbackup' ) ), 403 );
		}

		if ( empty( $_FILES['chunk']['tmp_name'] ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Missing chunk file.', 'aegisbackup' ) ), 400 );
		}

		$tmp_path = (string) $_FILES['chunk']['tmp_name']; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Temp path.
		$chunk_size = (int) filesize( $tmp_path );
		if ( $chunk_size <= 0 ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Empty chunk.', 'aegisbackup' ) ), 400 );
		}

		// phpcs:disable WordPress.WP.AlternativeFunctions.file_system_operations_fopen, WordPress.WP.AlternativeFunctions.file_system_operations_fclose, WordPress.WP.AlternativeFunctions.file_system_operations_fread, WordPress.WP.AlternativeFunctions.file_system_operations_fwrite -- Streaming chunk append; WP_Filesystem has no efficient append API.
		$in  = @fopen( $tmp_path, 'rb' ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fopen -- Reading temp upload.
		$out = @fopen( $part_path, 'ab' ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_fopen -- Appending to uploads.
		if ( ! $in || ! $out ) {
			if ( $in ) {
				fclose( $in );
			}
			if ( $out ) {
				fclose( $out );
			}
			wp_send_json_error( array( 'message' => esc_html__( 'Unable to write chunk.', 'aegisbackup' ) ), 500 );
		}
		while ( ! feof( $in ) ) {
			$buf = fread( $in, 1048576 );
			if ( false === $buf ) {
				break;
			}
			fwrite( $out, $buf );
		}
		fclose( $in );
		fclose( $out );
		// phpcs:enable WordPress.WP.AlternativeFunctions.file_system_operations_fopen, WordPress.WP.AlternativeFunctions.file_system_operations_fclose, WordPress.WP.AlternativeFunctions.file_system_operations_fread, WordPress.WP.AlternativeFunctions.file_system_operations_fwrite

		$received = (int) filesize( $part_path );
		$meta['received'] = $received;
		$meta['last_chunk'] = $chunk_index;
		$meta['total_chunks'] = $total_chunks;
		@file_put_contents( $meta_path, wp_json_encode( $meta ) ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_read_file_put_contents -- Writing to uploads.

		$filesize = isset( $meta['filesize'] ) ? absint( (int) $meta['filesize'] ) : 0;
		$progress = ( $filesize > 0 ) ? min( 100, (int) floor( ( $received / $filesize ) * 100 ) ) : 0;

		wp_send_json_success(
			array(
				'received' => $received,
				'progress' => $progress,
				'chunk_index' => $chunk_index,
			)
		);
	}

	/**
	 * Finalize an upload: move ZIP into correct folder and register it in the UI lists.
	 */
	public function pp_resumable_upload_finalize() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Insufficient permissions.', 'aegisbackup' ) ), 403 );
		}
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$upload_id = isset( $_POST['upload_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['upload_id'] ) ) : '';
		if ( '' === $upload_id ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Missing upload id.', 'aegisbackup' ) ), 400 );
		}

		$upload = wp_upload_dir();
		$tmp_base   = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup/tmp-uploads';
		$part_path = trailingslashit( $tmp_base ) . $upload_id . '.part';
		$meta_path = trailingslashit( $tmp_base ) . $upload_id . '.json';
		if ( ! file_exists( $part_path ) || ! file_exists( $meta_path ) ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Upload session not found.', 'aegisbackup' ) ), 404 );
		}

		$meta_raw = @file_get_contents( $meta_path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_read_file_get_contents -- Reading from uploads.
		$meta     = $meta_raw ? json_decode( $meta_raw, true ) : array();
		if ( ! is_array( $meta ) ) {
			$meta = array();
		}
		$expected_user = isset( $meta['user_id'] ) ? absint( (int) $meta['user_id'] ) : 0;
		if ( $expected_user && get_current_user_id() !== $expected_user ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Upload session mismatch.', 'aegisbackup' ) ), 403 );
		}

		$target   = isset( $meta['target'] ) ? sanitize_key( (string) $meta['target'] ) : '';
		$filename = isset( $meta['filename'] ) ? sanitize_file_name( (string) $meta['filename'] ) : '';
		$filesize = isset( $meta['filesize'] ) ? absint( (int) $meta['filesize'] ) : 0;
		$received = (int) filesize( $part_path );

		if ( $filesize > 0 && $received < $filesize ) {
			wp_send_json_error( array( 'message' => esc_html__( 'Upload is incomplete.', 'aegisbackup' ), 'received' => $received, 'filesize' => $filesize ), 409 );
		}

		$base = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup';
		wp_mkdir_p( $base );

		if ( 'file' === $target ) {
			$dest_dir = trailingslashit( $base ) . 'file-backups';
			wp_mkdir_p( $dest_dir );
			$dest_zip = trailingslashit( $dest_dir ) . $filename;
			$fs = $this->ab_filesystem();
			if ( $fs && is_object( $fs ) && method_exists( $fs, 'move' ) ) {
				$fs->move( $part_path, $dest_zip, true );
			} else {
				@rename( $part_path, $dest_zip ); // phpcs:ignore WordPress.WP.AlternativeFunctions.rename_rename -- Fallback when WP_Filesystem isn't available.
			}

			$backup_id = preg_replace( '/\.zip$/i', '', basename( $dest_zip ) );
			$backup_id = sanitize_text_field( (string) $backup_id );
			if ( $backup_id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $backup_id ) ) {
				$backup_id = '';
			}

			$key  = md5( $dest_zip );
			$list = get_option( 'aegisbackup_pp_received_file_backups', array() );
			if ( ! is_array( $list ) ) {
				$list = array();
			}
			$list[ $key ] = array(
				'id'            => $key,
				'backup_id'     => $backup_id ? $backup_id : preg_replace( '/\.zip$/i', '', basename( $dest_zip ) ),
				'name'          => basename( $dest_zip ),
				'zip'           => $dest_zip,
				'package_path'  => '',
				'source_zip'    => '',
				'received_at'   => time(),
				'token_id'      => 'manual',
				'connected'     => 0,
				'last_activity' => time(),
			);
			update_option( 'aegisbackup_pp_received_file_backups', $list, false );

			if ( file_exists( $meta_path ) ) {
				wp_delete_file( $meta_path );
			}
			wp_send_json_success( array( 'message' => esc_html__( 'Upload complete.', 'aegisbackup' ), 'target' => 'file', 'key' => $key ) );
		}

		if ( 'db' === $target ) {
			$pkg_dir = trailingslashit( $base ) . 'incoming-db-' . gmdate( 'Ymd_His' ) . '-manual';
			wp_mkdir_p( $pkg_dir );

	// Resolve and normalize the extracted package path (used later by the Restore Wizard / DB restorer).
	$real_pkg_dir = realpath( $pkg_dir );
	if ( false === $real_pkg_dir || '' === $real_pkg_dir ) {
		$real_pkg_dir = $pkg_dir;
	}
	$real_pkg_dir = trailingslashit( (string) $real_pkg_dir );

			$dest_zip = trailingslashit( $pkg_dir ) . $filename;
			$fs = $this->ab_filesystem();
			if ( $fs && is_object( $fs ) && method_exists( $fs, 'move' ) ) {
				$fs->move( $part_path, $dest_zip, true );
			} else {
				@rename( $part_path, $dest_zip ); // phpcs:ignore WordPress.WP.AlternativeFunctions.rename_rename -- Fallback when WP_Filesystem isn't available.
			}

			// Extract to package folder so meta.json (if present) is available for UI labels.
			$unzip_res = $this->pp_extract_zip_fallback( $dest_zip, $pkg_dir );
			if ( is_wp_error( $unzip_res ) ) {
				$this->pp_append_destination_log( sprintf( '[%s] DB UPLOAD EXTRACT ERROR: %s', gmdate( 'Y-m-d H:i:s' ), $unzip_res->get_error_message() ) );
				wp_delete_file( $dest_zip );
				$this->rrmdir_best_effort( $pkg_dir );
				if ( file_exists( $meta_path ) ) {
					wp_delete_file( $meta_path );
				}
				wp_send_json_error( array( 'message' => esc_html__( 'Unable to extract DB backup ZIP on this host.', 'aegisbackup' ) ), 500 );
			}

			$db_list = get_option( 'aegisbackup_pp_received_db_backups', array() );
			if ( ! is_array( $db_list ) ) {
				$db_list = array();
			}
			$key = md5( $dest_zip );
			$db_list[ $key ] = array(
				'id'            => $key,
				'zip'           => $dest_zip,
				'package_path'  => $real_pkg_dir,
				'received_at'   => time(),
			'received'      => time(),
				'token_id'      => 'manual',
				'connected'     => 0,
				'last_activity' => time(),
			);
			update_option( 'aegisbackup_pp_received_db_backups', $db_list, false );

			if ( file_exists( $meta_path ) ) {
				wp_delete_file( $meta_path );
			}
			wp_send_json_success( array( 'message' => esc_html__( 'Upload complete.', 'aegisbackup' ), 'target' => 'db', 'key' => $key ) );
		}

		wp_send_json_error( array( 'message' => esc_html__( 'Invalid upload target.', 'aegisbackup' ) ), 400 );
	}

public function handle_pp_restore_db_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_restore_db_post', 'aegisbackup_pp_nonce' );

		$return_tab  = isset( $_POST['return_tab'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['return_tab'] ) ) : '';
		$return_view = isset( $_POST['return_view'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['return_view'] ) ) : '';
		$return_key  = isset( $_POST['return_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['return_key'] ) ) : '';
		$confirm_overwrite = isset( $_POST['confirm_overwrite'] ) && '1' === sanitize_text_field( (string) wp_unslash( $_POST['confirm_overwrite'] ) );
		$confirm_text      = isset( $_POST['confirm_text'] ) ? trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) : '';
		if ( ! $confirm_overwrite || 'RESTORE' !== strtoupper( $confirm_text ) ) {
			$base = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=' . rawurlencode( $return_tab ? $return_tab : 'destination' ) );
			if ( $return_view ) {
				$base .= '&pp_view=' . rawurlencode( $return_view );
			}
			if ( $return_key ) {
				$base .= '&db_key=' . rawurlencode( $return_key );
			}
			wp_safe_redirect( $base . '&ab_ok=0&ab_msg=' . rawurlencode( 'Please confirm the restore (checkbox + type RESTORE).' ) );
			exit;
		}
		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		if ( empty( $package_path ) || ! is_dir( $package_path ) ) {
			$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB FAIL: package not found: %s', gmdate( 'Y-m-d H:i:s' ), (string) $package_path ) );
			$base = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=' . rawurlencode( $return_tab ? $return_tab : 'destination' ) );
			if ( $return_view ) {
				$base .= '&pp_view=' . rawurlencode( $return_view );
			}
			if ( $return_key ) {
				$base .= '&db_key=' . rawurlencode( $return_key );
			}
			wp_safe_redirect( $base . '&ab_ok=0&ab_msg=' . rawurlencode( 'DB backup not found on disk.' ) );
			exit;
		}


// Ensure the DB package is actually extracted. If extraction failed during upload,
// a restore will misleadingly "complete" with 0 tables. Attempt extraction again here.
$has_payload = false;
$pp_pkg = trailingslashit( (string) $package_path );
if ( is_file( $pp_pkg . 'meta.json' ) || is_dir( $pp_pkg . 'db/' ) ) {
	$has_payload = true;
} else {
	// Check one level deep.
	$subdirs = glob( $pp_pkg . '*', GLOB_ONLYDIR );
	if ( $subdirs ) {
		foreach ( $subdirs as $d ) {
			$d = trailingslashit( (string) $d );
			if ( is_file( $d . 'meta.json' ) || is_dir( $d . 'db/' ) ) {
				$has_payload = true;
				break;
			}
		}
	}
}

if ( ! $has_payload ) {
	// Try to locate the corresponding ZIP from the received list and extract it now.
	$list = get_option( 'aegisbackup_pp_received_db_backups', array() );
	if ( ! is_array( $list ) ) { $list = array(); }
	$zip_to_extract = '';
	if ( $return_key && isset( $list[ $return_key ] ) && is_array( $list[ $return_key ] ) && ! empty( $list[ $return_key ]['zip'] ) ) {
		$zip_to_extract = (string) $list[ $return_key ]['zip'];
	} else {
		foreach ( $list as $row ) {
			if ( is_array( $row ) && ! empty( $row['package_path'] ) && (string) $row['package_path'] === (string) $package_path && ! empty( $row['zip'] ) ) {
				$zip_to_extract = (string) $row['zip'];
				break;
			}
		}
	}

				if ( $zip_to_extract && is_file( $zip_to_extract ) ) {
					$unzip_res = $this->pp_extract_zip_fallback( $zip_to_extract, $package_path );
					if ( is_wp_error( $unzip_res ) ) {
						$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB EXTRACT ERROR: %s', gmdate( 'Y-m-d H:i:s' ), $unzip_res->get_error_message() ) );
						$base = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=' . rawurlencode( $return_tab ? $return_tab : 'destination' ) );
						if ( $return_view ) {
							$base .= '&pp_view=' . rawurlencode( $return_view );
						}
						if ( $return_key ) {
							$base .= '&db_key=' . rawurlencode( $return_key );
						}
						wp_safe_redirect( $base . '&ab_ok=0&ab_msg=' . rawurlencode( 'Unable to extract DB backup ZIP: ' . $unzip_res->get_error_message() ) );
						exit;
					}
				}

	// Re-check after attempted extraction.
	if ( is_file( $pp_pkg . 'meta.json' ) || is_dir( $pp_pkg . 'db/' ) ) {
		$has_payload = true;
	} else {
		$subdirs = glob( $pp_pkg . '*', GLOB_ONLYDIR );
		if ( $subdirs ) {
			foreach ( $subdirs as $d ) {
				$d = trailingslashit( (string) $d );
				if ( is_file( $d . 'meta.json' ) || is_dir( $d . 'db/' ) ) {
					$has_payload = true;
					break;
				}
			}
		}
	}
}

if ( ! $has_payload ) {
	$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB FAIL: no extracted payload found in %s', gmdate( 'Y-m-d H:i:s' ), (string) $package_path ) );
	$base = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=' . rawurlencode( $return_tab ? $return_tab : 'destination' ) );
	if ( $return_view ) { $base .= '&pp_view=' . rawurlencode( $return_view ); }
	if ( $return_key ) { $base .= '&db_key=' . rawurlencode( $return_key ); }
	wp_safe_redirect( $base . '&ab_ok=0&ab_msg=' . rawurlencode( 'DB backup extracted files were not found. Upload may have failed to extract the ZIP.' ) );
	exit;
}

		$res = $this->pp_run_db_restore_timeboxed( $package_path );
		$ok  = ! empty( $res['ok'] );
		$msg = ! empty( $res['msg'] ) ? (string) $res['msg'] : ( $ok ? 'DB restore completed.' : 'DB restore failed.' );
		$base = admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=' . rawurlencode( $return_tab ? $return_tab : 'destination' ) );
		if ( $return_view ) {
			$base .= '&pp_view=' . rawurlencode( $return_view );
		}
		if ( $return_key ) {
			$base .= '&db_key=' . rawurlencode( $return_key );
		}
		wp_safe_redirect( $base . '&ab_ok=' . ( $ok ? '1' : '0' ) . '&ab_msg=' . rawurlencode( $msg ) );
		exit;
	}

	public function handle_pp_restore_db_bulk_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_restore_db_bulk_post', 'aegisbackup_pp_nonce' );

		$keys = isset( $_POST['db_keys'] ) ? (array) wp_unslash( $_POST['db_keys'] ) : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized below via sanitize_text_field().
		$keys = array_values( array_filter( array_map( 'sanitize_text_field', $keys ) ) );
		if ( empty( $keys ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Please select a DB backup to restore.' ) ) );
			exit;
		}

		$list = get_option( 'aegisbackup_pp_received_db_backups', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}

		$first = (string) $keys[0];
		$package_path = ( ! empty( $list[ $first ] ) && is_array( $list[ $first ] ) && ! empty( $list[ $first ]['package_path'] ) )
			? sanitize_text_field( (string) $list[ $first ]['package_path'] )
			: '';

		if ( empty( $package_path ) || ! is_dir( $package_path ) ) {
			$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB BULK FAIL: package not found: %s', gmdate( 'Y-m-d H:i:s' ), (string) $package_path ) );
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Selected DB backup not found on disk.' ) ) );
			exit;
		}

		$note = ( count( $keys ) > 1 ) ? ' (Starting the first selected backup.)' : '';
		$res  = $this->pp_run_db_restore_timeboxed( $package_path );
		$ok   = ! empty( $res['ok'] );
		$msg  = ! empty( $res['msg'] ) ? (string) $res['msg'] : ( $ok ? 'DB restore completed.' : 'DB restore failed.' );
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_pp_tab=destination&ab_ok=' . ( $ok ? '1' : '0' ) . '&ab_msg=' . rawurlencode( $msg . $note ) ) );
		exit;
	}

	private function pp_run_db_restore_timeboxed( $package_path ) {
		$package_path = (string) $package_path;
		$job_id = 'ppdbr_' . substr( md5( $package_path . '|' . microtime( true ) . '|' . wp_rand() ), 0, 12 );
		$opt_key = 'aegisbackup_pp_db_restore_' . $job_id;

		$state = array(
			'job_id'       => $job_id,
			'package_path' => $package_path,
			'import_state' => array(),
			'created'      => time(),
			'updated'      => time(),
			'done'         => false,
			'errors'       => array(),
		);
		update_option( $opt_key, $state, false );

		$that = $this;
		register_shutdown_function( static function() use ( $that, $opt_key, $job_id, $package_path ) {
			$err = error_get_last();
			if ( ! $err || empty( $err['type'] ) ) {
				return;
			}
			$types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR );
			if ( ! in_array( (int) $err['type'], $types, true ) ) {
				return;
			}
			$msg = sprintf( 'Fatal during Push/Pull DB restore (%s): %s in %s:%d', (string) $job_id, (string) $err['message'], (string) $err['file'], (int) $err['line'] );
			try {
				$that->pp_append_destination_log( '[' . gmdate( 'Y-m-d H:i:s' ) . '] ' . $msg );
				if ( isset( $that->plugin ) && isset( $that->plugin->restore ) ) {
					$that->plugin->restore->append_settings_log( 'ERROR ' . $msg );
				}
			} catch ( \Throwable $e ) {

			}
		} );

		$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB START: %s (job=%s)', gmdate( 'Y-m-d H:i:s' ), (string) $package_path, (string) $job_id ) );
		$this->plugin->restore->append_settings_log( sprintf( 'DEBUG [PushPullDBRestore %s] starting restore from %s', (string) $job_id, (string) $package_path ) );

		$budget = 12.0; // seconds
		$deadline = microtime( true ) + $budget;
		$done = false;
		$last_log = '';
		try {
			while ( microtime( true ) < $deadline ) {
				$done = $this->pp_process_db_restore_job_once( $opt_key, $last_log );
				if ( $done ) {
					break;
				}
			}
		} catch ( \Throwable $e ) {
			$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB ERROR: %s', gmdate( 'Y-m-d H:i:s' ), $e->getMessage() ) );
			$this->plugin->restore->append_settings_log( 'ERROR [PushPullDBRestore] ' . $e->getMessage() );
			return array( 'ok' => false, 'msg' => 'DB restore failed: ' . $e->getMessage() );
		}

		if ( $done ) {
			delete_option( $opt_key );
			$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB DONE: %s (job=%s)', gmdate( 'Y-m-d H:i:s' ), (string) $package_path, (string) $job_id ) );
			$this->plugin->restore->append_settings_log( sprintf( 'DEBUG [PushPullDBRestore %s] restore complete.', (string) $job_id ) );
			return array( 'ok' => true, 'msg' => 'DB restore completed successfully.' );
		}

		if ( ! wp_next_scheduled( 'aegisbackup_pp_process_db_restore_job', array( $job_id ) ) ) {
			wp_schedule_single_event( time() + 5, 'aegisbackup_pp_process_db_restore_job', array( $job_id ) );
		}
		$this->pp_append_destination_log( sprintf( '[%s] RESTORE DB QUEUED: %s (job=%s) waiting for worker...', gmdate( 'Y-m-d H:i:s' ), (string) $package_path, (string) $job_id ) );
		$this->plugin->restore->append_settings_log( sprintf( 'DEBUG [PushPullDBRestore %s] queued for worker (time budget hit).', (string) $job_id ) );
		return array( 'ok' => true, 'msg' => 'Restore started. Continuing in background (worker scheduled).' );
	}

	private function pp_process_db_restore_job_once( $opt_key, &$last_log_out = '' ) {
		$opt_key = (string) $opt_key;
		$state = get_option( $opt_key, array() );
		if ( ! is_array( $state ) || empty( $state['package_path'] ) ) {
			return true; // nothing to do
		}
		$package_path = (string) $state['package_path'];
		if ( ! is_dir( $package_path ) ) {
			$this->plugin->restore->append_settings_log( sprintf( 'ERROR [PushPullDBRestore] package missing: %s', (string) $package_path ) );
			return true;
		}

		if ( empty( $state['import_state'] ) || ! is_array( $state['import_state'] ) ) {
			$state['import_state'] = array();
		}

		require_once AEGISBACKUP_DIR . 'includes/restore/class-ab-db-restorer.php';
		$restorer = new \AegisBackup\Restore\AB_DB_Restorer();
		$step = $restorer->import_db_step( $package_path, $state['import_state'], 120, 1.2 );
		$state['updated'] = time();

		$log = ( isset( $step['log'] ) ? (string) $step['log'] : '' );
		if ( '' !== $log && $log !== $last_log_out ) {
			$last_log_out = $log;
			$this->plugin->restore->append_settings_log( sprintf( 'DEBUG [PushPullDBRestore] %s', $log ) );
		}

		if ( ! empty( $step['done'] ) ) {
			$state['done'] = true;
			update_option( $opt_key, $state, false );
			return true;
		}

		update_option( $opt_key, $state, false );
		return false;
	}

	public function cron_pp_process_db_restore_job( $job_id ) {
		$job_id = (string) $job_id;
		$opt_key = 'aegisbackup_pp_db_restore_' . $job_id;
		$last_log = '';
		$budget = 20.0;
		$deadline = microtime( true ) + $budget;

		while ( microtime( true ) < $deadline ) {
			$done = $this->pp_process_db_restore_job_once( $opt_key, $last_log );
			if ( $done ) {
				delete_option( $opt_key );
				return;
			}
		}

		if ( ! wp_next_scheduled( 'aegisbackup_pp_process_db_restore_job', array( $job_id ) ) ) {
			wp_schedule_single_event( time() + 10, 'aegisbackup_pp_process_db_restore_job', array( $job_id ) );
		}
	}

	public function handle_pp_delete_db_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_delete_db_post', 'aegisbackup_pp_nonce' );
		$key = isset( $_POST['db_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['db_key'] ) ) : '';
		$list = get_option( 'aegisbackup_pp_received_db_backups', array() );
		if ( ! is_array( $list ) ) { $list = array(); }
		if ( empty( $key ) || empty( $list[ $key ] ) || ! is_array( $list[ $key ] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Backup not found.' ) ) );
			exit;
		}
		$path = isset( $list[ $key ]['package_path'] ) ? (string) $list[ $key ]['package_path'] : '';
		unset( $list[ $key ] );
		update_option( 'aegisbackup_pp_received_db_backups', $list, false );
		if ( $path && is_dir( $path ) ) {
			$fs = $this->ab_filesystem();
			if ( $fs && method_exists( $fs, 'delete' ) ) {
				$fs->delete( $path, true, 'd' );
			} else {
				// Fallback: best-effort recursive delete.
				$it = new \RecursiveIteratorIterator(
					new \RecursiveDirectoryIterator( $path, \FilesystemIterator::SKIP_DOTS ),
					\RecursiveIteratorIterator::CHILD_FIRST
				);
				foreach ( $it as $f ) {
					if ( $f->isDir() ) {
						@rmdir( (string) $f ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Fallback only.
					} else {
						wp_delete_file( (string) $f );
					}
				}
				@rmdir( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Fallback only.
			}
		}
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=1&ab_msg=' . rawurlencode( 'DB backup deleted.' ) ) );
		exit;
	}

	public function handle_pp_connect_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_connect_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$connection_id = isset( $_POST['connection_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['connection_id'] ) ) : '';
		$connect_name  = isset( $_POST['connect_name'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['connect_name'] ) ) : '';
		$dest_url      = isset( $_POST['destination_url'] ) ? esc_url_raw( (string) wp_unslash( $_POST['destination_url'] ) ) : '';
		$token_json    = isset( $_POST['token_json'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['token_json'] ) ) : '';

		if ( empty( $connect_name ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Connect Name is required.' ) ) );
			exit;
		}
		if ( empty( $dest_url ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Destination URL is required.' ) ) );
			exit;
		}

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) || empty( $token['id'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Invalid token JSON.' ) ) );
			exit;
		}

		$token_json_norm = wp_json_encode( $token );
		$endpoint = ! empty( $token['endpoint'] ) ? (string) $token['endpoint'] : (string) $dest_url;
		$endpoint = rtrim( $endpoint, '/' );
		$is_connected  = false;
		$connect_error = '';
		$skip_remote   = false;
		$dest_host = '';
		$ep_host   = '';
		$d = wp_parse_url( $dest_url );
		$e = wp_parse_url( $endpoint );
		if ( is_array( $d ) && ! empty( $d['host'] ) ) {
			$dest_host = strtolower( (string) $d['host'] );
		}
		if ( is_array( $e ) && ! empty( $e['host'] ) ) {
			$ep_host = strtolower( (string) $e['host'] );
		}
		if ( $dest_host && $ep_host && $dest_host !== $ep_host ) {
			$skip_remote   = true;
			$connect_error = 'Token endpoint host (' . $ep_host . ') does not match Destination URL host (' . $dest_host . '). Generate the token on the Destination site and paste it here.';
		}

		if ( ! $skip_remote ) {
			$ping_url = $endpoint . '/wp-json/aegisbackup/v1/ping';
			$reg_url  = $endpoint . '/wp-json/aegisbackup/v1/register-connection';

			$ping_resp = wp_remote_get(
				$ping_url,
				array(
					'timeout'     => 15,
					'redirection' => 0,
				)
			);
			if ( is_wp_error( $ping_resp ) ) {
				$connect_error = $ping_resp->get_error_message();
			} else {
				$code = (int) wp_remote_retrieve_response_code( $ping_resp );
				$body = (string) wp_remote_retrieve_body( $ping_resp );
				$ok = ( $code >= 200 && $code < 300 );
				if ( $ok ) {
					$ping_json = json_decode( $body, true );
					if ( is_array( $ping_json ) && ! empty( $ping_json['success'] ) ) {
						$headers = array(
							'Content-Type'   => 'application/json',
							'X-AB-Token-Id'  => (string) $token['id'],
							'X-AB-Token-Exp' => (string) $token['exp'],
							'X-AB-Token-Sig' => (string) $token['sig'],
						);
						$payload = array(
							'source_url'   => home_url(),
							'source_name'  => get_bloginfo( 'name' ),
							'connect_name' => $connect_name,
						);
						$reg_resp = wp_remote_post(
							$reg_url,
							array(
								'timeout'     => 15,
								'redirection' => 0,
								'headers'     => $headers,
								'body'        => wp_json_encode( $payload ),
							)
						);
						if ( is_wp_error( $reg_resp ) ) {
							$connect_error = $reg_resp->get_error_message();
						} else {
							$r_code = (int) wp_remote_retrieve_response_code( $reg_resp );
							$r_body = (string) wp_remote_retrieve_body( $reg_resp );
							if ( $r_code >= 200 && $r_code < 300 ) {
								$is_connected = true;
							} else {
								$connect_error = 'Register failed (HTTP ' . $r_code . '): ' . substr( $r_body, 0, 160 );
							}
						}
					} else {
						$connect_error = 'Ping did not return success.';
					}
				} else {
					$connect_error = 'Ping failed (HTTP ' . $code . ').';
				}
			}
		}
		update_user_meta( $user_id, 'aegisbackup_pp_connect_name', $connect_name );
		update_user_meta( $user_id, 'aegisbackup_pp_dest_url', $dest_url );

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}

		$now = time();
		$updated = false;

		if ( $connection_id ) {
			foreach ( $connections as $k => $c ) {
				if ( is_array( $c ) && ! empty( $c['id'] ) && (string) $c['id'] === (string) $connection_id ) {
					$connections[ $k ]['name']          = $connect_name;
					$connections[ $k ]['dest_url']      = $dest_url;
					$connections[ $k ]['token_json']    = $token_json_norm;
					$connections[ $k ]['connected']     = $is_connected ? 1 : 0;
					$connections[ $k ]['last_activity'] = $now;
					$updated = true;
					break;
				}
			}
		}

		if ( ! $updated ) {
			$connection_id = 'abcn_' . wp_generate_password( 12, false, false );
			$connections[] = array(
				'id'            => $connection_id,
				'name'          => $connect_name,
				'dest_url'      => $dest_url,
				'token_json'    => $token_json_norm,
				'created'       => $now,
				'connected'     => $is_connected ? 1 : 0,
				'last_activity' => $now,
			);
		}

		update_user_meta( $user_id, 'aegisbackup_pp_connections', $connections );

		if ( $is_connected ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Connected. Connection saved.' ) ) );
			exit;
		}

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Connection saved, but destination did not confirm connection: ' . $connect_error ) ) );
		exit;
	}

	public function handle_pp_disconnect_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_disconnect_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$connection_id = isset( $_POST['connection_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['connection_id'] ) ) : '';
		if ( empty( $connection_id ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Missing connection_id.' ) ) );
			exit;
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}

		$now = time();
		$found = false;

		foreach ( $connections as $k => $c ) {
			if ( is_array( $c ) && ! empty( $c['id'] ) && (string) $c['id'] === (string) $connection_id ) {
				$connections[ $k ]['connected']     = 0;
				$connections[ $k ]['last_activity'] = $now;
				$found = true;
				break;
			}
		}

		if ( $found ) {
			update_user_meta( $user_id, 'aegisbackup_pp_connections', $connections );
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Disconnected.' ) ) );
			exit;
		}

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Connection not found.' ) ) );
		exit;
	}

	public function handle_pp_delete_connection_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_delete_connection_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$connection_id = isset( $_POST['connection_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['connection_id'] ) ) : '';
		if ( empty( $connection_id ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Missing connection_id.' ) ) );
			exit;
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}

		$new = array();
		$deleted = false;

		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['id'] ) && (string) $c['id'] === (string) $connection_id ) {
				$deleted = true;
				continue;
			}
			$new[] = $c;
		}

		update_user_meta( $user_id, 'aegisbackup_pp_connections', $new );

		wp_safe_redirect(
			admin_url(
				'admin.php?page=aegisbackup-pushpull&ab_ok=' . ( $deleted ? '1' : '0' ) .
				'&ab_msg=' . rawurlencode( $deleted ? 'Connection deleted.' : 'Connection not found.' )
			)
		);
		exit;
	}

	public function handle_pp_delete_incoming_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_delete_incoming_post', 'aegisbackup_pp_nonce' );

		$incoming_key = isset( $_POST['incoming_key'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['incoming_key'] ) ) : '';
		if ( empty( $incoming_key ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=0&ab_msg=' . rawurlencode( 'Missing incoming_key.' ) ) );
			exit;
		}

		$incoming = get_option( 'aegisbackup_pp_incoming_connections', array() );
		if ( ! is_array( $incoming ) ) {
			$incoming = array();
		}

		$deleted = false;
		if ( isset( $incoming[ $incoming_key ] ) ) {
			unset( $incoming[ $incoming_key ] );
			$deleted = true;
		}

		update_option( 'aegisbackup_pp_incoming_connections', $incoming, false );

		wp_safe_redirect(
			admin_url(
				'admin.php?page=aegisbackup-pushpull&pp_tab=destination&ab_ok=' . ( $deleted ? '1' : '0' ) .
				'&ab_msg=' . rawurlencode( $deleted ? 'Incoming connection removed.' : 'Incoming connection not found.' )
			)
		);
		exit;
	}

	public function ajax_start_push() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

		$token_json = isset( $_POST['token_json'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['token_json'] ) ) : '';
		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) ) {
			wp_send_json_error( array( 'message' => 'Invalid token JSON.' ), 400 );
		}

		$job = $this->plugin->push->start_push_job(
			array(
				'token' => $token,
				'package_path' => $package_path,
			)
		);

		if ( empty( $job['job_id'] ) ) {
			wp_send_json_error( array( 'message' => 'Failed to start push job.' ), 500 );
		}

		wp_send_json_success( $job );
	}
	
	public function handle_start_push_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_start_push_post', 'aegisbackup_pp_nonce' );

		$token_json   = isset( $_POST['token_json'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['token_json'] ) ) : '';
		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		if ( empty( $package_path ) ) {
			$package_path = (string) get_user_meta( get_current_user_id(), 'aegisbackup_pp_package_path', true );
		}
		if ( empty( $package_path ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'No package selected. Use the Package selector below to choose a migration package first.' ) ) );
			exit;
		}
		$dest_url     = isset( $_POST['destination_url'] ) ? esc_url_raw( (string) wp_unslash( $_POST['destination_url'] ) ) : '';

		if ( $dest_url ) {
			update_user_meta( get_current_user_id(), 'aegisbackup_pp_dest_url', $dest_url );
		}

		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Invalid token JSON.' ) ) );
			exit;
		}

		$job = $this->plugin->push->start_push_job(
			array(
				'token'        => $token,
				'package_path' => $package_path,
				'src_root'     => (string) get_user_meta( $user_id, 'aegisbackup_pp_src_root', true ),
				'dst_root'     => (string) get_user_meta( $user_id, 'aegisbackup_pp_dst_root', true ),
				'paths'        => (array) get_user_meta( $user_id, 'aegisbackup_pp_paths', true ),
			)
		);

		if ( empty( $job['job_id'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Failed to start push job.' ) ) );
			exit;
		}

		$job_id = sanitize_text_field( (string) $job['job_id'] );

		update_user_meta( get_current_user_id(), 'aegisbackup_pp_pushlog_' . $job_id, 'Push job started: ' . $job_id . "\n" );

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Push job started.' ) . '&ab_job=' . rawurlencode( $job_id ) ) );
		exit;
	}

	public function handle_pp_send_package_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_pp_send_package_post', 'aegisbackup_pp_nonce' );

		$user_id = get_current_user_id();
		$connection_id = isset( $_POST['connection_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['connection_id'] ) ) : '';
		if ( empty( $connection_id ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Please choose a connection first.' ) ) );
			exit;
		}

		$package_path = isset( $_POST['package_path'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['package_path'] ) ) : '';
		if ( empty( $package_path ) ) {
			$package_path = (string) get_user_meta( $user_id, 'aegisbackup_pp_package_path', true );
		}
		if ( empty( $package_path ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'No package selected. Use the Package selector to choose a migration package first.' ) ) );
			exit;
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) {
			$connections = array();
		}

		$found = null;
		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['id'] ) && (string) $c['id'] === (string) $connection_id ) {
				$found = $c;
				break;
			}
		}
		if ( empty( $found ) || ! is_array( $found ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Connection not found.' ) ) );
			exit;
		}

		$token_json = isset( $found['token_json'] ) ? (string) $found['token_json'] : '';
		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Connection token is missing/invalid. Edit the connection and paste a fresh Destination Token JSON.' ) ) );
			exit;
		}

		$job = $this->plugin->push->start_push_job(
			array(
				'token'        => $token,
				'package_path' => $package_path,
				'src_root'     => (string) get_user_meta( $user_id, 'aegisbackup_pp_src_root', true ),
				'dst_root'     => (string) get_user_meta( $user_id, 'aegisbackup_pp_dst_root', true ),
				'paths'        => (array) get_user_meta( $user_id, 'aegisbackup_pp_paths', true ),
			)
		);

		if ( empty( $job['job_id'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Failed to start push job.' ) ) );
			exit;
		}

		$job_id = sanitize_text_field( (string) $job['job_id'] );
		update_user_meta( $user_id, 'aegisbackup_pp_pushlog_' . $job_id, 'Push job started: ' . $job_id . "\n" );

		wp_safe_redirect(
			admin_url(
				'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( 'Package send started.' ) .
				'&ab_job=' . rawurlencode( $job_id ) .
				'&ab_conn_send=' . rawurlencode( $connection_id )
			)
		);
		exit;
	}

	public function handle_process_push_post() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}
		check_admin_referer( 'aegisbackup_process_push_post', 'aegisbackup_pp_nonce' );

		$job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['job_id'] ) ) : '';
		if ( empty( $job_id ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=0&ab_msg=' . rawurlencode( 'Missing job_id.' ) ) );
			exit;
		}

		$log_key = 'aegisbackup_pp_pushlog_' . $job_id;
		$user_id = get_current_user_id();
		$log     = (string) get_user_meta( $user_id, $log_key, true );

		$start = microtime( true );
		$max_seconds = 12.0;
		$steps = 0;
		$done = false;

		while ( ( microtime( true ) - $start ) < $max_seconds ) {
			$step = $this->plugin->push->process_push_job( $job_id );
			$steps++;

			if ( is_wp_error( $step ) ) {
				$log .= 'ERROR: ' . $step->get_error_message() . "\n";
				break;
			}
			if ( ! is_array( $step ) ) {
				$log .= "ERROR: Unexpected push response.\n";
				break;
			}

			if ( ! empty( $step['log'] ) ) {
				$log .= (string) $step['log'] . "\n";
			}
			if ( ! empty( $step['done'] ) ) {
				$done = true;
				break;
			}

			if ( $steps >= 10 ) {
				break;
			}
		}

		update_user_meta( $user_id, $log_key, $log );

		$msg = $done ? 'Push complete.' : 'Push progressed. Click Continue again if needed.';
		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-pushpull&ab_ok=1&ab_msg=' . rawurlencode( $msg ) . '&ab_job=' . rawurlencode( $job_id ) ) );
		exit;
	}

    public function ajax_process_push() {
        $this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().

        $job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( wp_unslash( $_POST['job_id'] ) ) : '';
        if ( empty( $job_id ) ) {
            wp_send_json_error( array( 'message' => 'Missing job_id.' ), 400 );
        }

        $step = $this->plugin->push->process_push_job( $job_id );
        wp_send_json_success( $step );
    }

	public function ajax_pp_files_start() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$user_id = get_current_user_id();
		$src_root = isset( $_POST['src_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['src_root'] ) ) : '';
		$dst_root = isset( $_POST['dst_root'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['dst_root'] ) ) : '';
		$paths    = isset( $_POST['pp_paths'] ) ? array_values( array_filter( array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['pp_paths'] ) ) ) ) : array();

		if ( '' === $src_root ) { $src_root = '/public_html/'; }
		if ( '' === $dst_root ) { $dst_root = '/public_html/'; }

		$src_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $src_root );
		$dst_root = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $dst_root );
		$src_root = '/' . ltrim( $src_root, '/' );
		$dst_root = '/' . ltrim( $dst_root, '/' );
		if ( '/' !== substr( $src_root, -1 ) ) { $src_root .= '/'; }
		if ( '/' !== substr( $dst_root, -1 ) ) { $dst_root .= '/'; }

		$clean = array();
		foreach ( $paths as $p ) {
			$p = sanitize_text_field( (string) $p );
			$p = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $p );
			$p = ltrim( $p, '/' );
			if ( '' === $p ) { continue; }
			if ( false !== strpos( $p, '..' ) ) { continue; }
			$clean[ $p ] = true;
		}
		$clean_paths = array_keys( $clean );
		if ( empty( $clean_paths ) ) {
			wp_send_json_error( array( 'message' => 'Select at least one directory or file.' ), 400 );
		}

		$connections = get_user_meta( $user_id, 'aegisbackup_pp_connections', true );
		if ( ! is_array( $connections ) ) { $connections = array(); }
		$token_json = '';
		foreach ( $connections as $c ) {
			if ( is_array( $c ) && ! empty( $c['connected'] ) && ! empty( $c['token_json'] ) ) {
				$token_json = (string) $c['token_json'];
				break;
			}
		}
		if ( empty( $token_json ) ) {
			wp_send_json_error( array( 'message' => 'No connected Destination found. Save a connection first.' ), 400 );
		}
		$token = json_decode( $token_json, true );
		if ( ! is_array( $token ) || empty( $token['endpoint'] ) || empty( $token['id'] ) || empty( $token['exp'] ) || empty( $token['sig'] ) ) {
			wp_send_json_error( array( 'message' => 'Invalid Destination token JSON saved on this connection.' ), 400 );
		}

		$api = trailingslashit( (string) $token['endpoint'] ) . 'wp-json/aegisbackup/v1/file-put';
		$headers = array(
			'Content-Type'    => 'application/json; charset=utf-8',
			'X-AB-TOKEN-ID'   => (string) $token['id'],
			'X-AB-TOKEN-EXP'  => (string) $token['exp'],
			'X-AB-TOKEN-SIG'  => (string) $token['sig'],
		);

		$root_real = realpath( (string) ABSPATH );
		if ( false === $root_real ) {
			$root_real = (string) ABSPATH;
		}
		$root_real = rtrim( str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $root_real ), '/' );

		$tasks = array();
		$total_files = 0;
		foreach ( $clean_paths as $rel ) {
			$abs = $root_real . '/' . ltrim( $rel, '/' );
			$abs_real = realpath( $abs );
			if ( false === $abs_real ) { continue; }
			$abs_real = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $abs_real );
			if ( 0 !== strpos( $abs_real, $root_real ) ) { continue; }

			if ( is_dir( $abs_real ) ) {
				$tasks[] = array( 't' => 'dir', 'rel' => rtrim( $rel, '/' ) . '/', 'abs' => $abs_real );
				$iter = new \RecursiveIteratorIterator(
					new \RecursiveDirectoryIterator( $abs_real, \FilesystemIterator::SKIP_DOTS ),
					\RecursiveIteratorIterator::SELF_FIRST
				);
				foreach ( $iter as $f ) {
					$fp = (string) $f;
					$fp_real = realpath( $fp );
					if ( false === $fp_real ) { continue; }
					$fp_real = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), (string) $fp_real );
					if ( 0 !== strpos( $fp_real, $root_real ) ) { continue; }
					$local = ltrim( str_replace( $root_real, '', $fp_real ), '/' );
					if ( $f->isDir() ) {
						$tasks[] = array( 't' => 'dir', 'rel' => rtrim( $local, '/' ) . '/', 'abs' => $fp_real );
					} else {
						$tasks[] = array( 't' => 'file', 'rel' => $local, 'abs' => $fp_real );
						$total_files++;
					}
				}
			} else {
				$tasks[] = array( 't' => 'file', 'rel' => $rel, 'abs' => $abs_real );
				$total_files++;
			}
		}

		if ( empty( $tasks ) ) {
			wp_send_json_error( array( 'message' => 'No valid paths found to transfer (paths may not exist on disk).' ), 400 );
		}

		$job_id = 'abppf_' . wp_generate_password( 12, false, false );
		$opt_key = 'aegisbackup_pp_filejob_' . $job_id;
		$log_key = 'aegisbackup_pp_filejob_log_' . $job_id;

		$state = array(
			'job_id'      => $job_id,
			'created'     => time(),
			'api'         => $api,
			'headers'     => $headers,
			'dst_root'    => $dst_root,
			'tasks'       => $tasks,
			'idx'         => 0,
			'total_items' => count( $tasks ),
			'total_files' => (int) $total_files,
			'sent_files'  => 0,
			'sent_dirs'   => 0,
			'errors'      => 0,
			'done'        => 0,
		);
		update_option( $opt_key, $state, false );
		update_user_meta( $user_id, $log_key, "File migration job started: " . $job_id . "\n" );

		wp_send_json_success(
			array(
				'job_id'      => $job_id,
				'total_items' => (int) $state['total_items'],
				'total_files' => (int) $state['total_files'],
			)
		);
	}

	public function ajax_pp_files_process() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$job_id = isset( $_POST['job_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['job_id'] ) ) : '';
		if ( empty( $job_id ) ) {
			wp_send_json_error( array( 'message' => 'Missing job_id.' ), 400 );
		}
		$opt_key = 'aegisbackup_pp_filejob_' . $job_id;
		$state = get_option( $opt_key, array() );
		if ( empty( $state['job_id'] ) || empty( $state['tasks'] ) || ! is_array( $state['tasks'] ) ) {
			wp_send_json_error( array( 'message' => 'File migration job not found.' ), 404 );
		}

		$api     = isset( $state['api'] ) ? (string) $state['api'] : '';
		$headers = isset( $state['headers'] ) && is_array( $state['headers'] ) ? (array) $state['headers'] : array();
		$dst_root = isset( $state['dst_root'] ) ? (string) $state['dst_root'] : '/public_html/';

		$idx = isset( $state['idx'] ) ? (int) $state['idx'] : 0;
		$total_items = isset( $state['total_items'] ) ? (int) $state['total_items'] : count( $state['tasks'] );
		$total_files = isset( $state['total_files'] ) ? (int) $state['total_files'] : 0;
		$sent_files  = isset( $state['sent_files'] ) ? (int) $state['sent_files'] : 0;
		$sent_dirs   = isset( $state['sent_dirs'] ) ? (int) $state['sent_dirs'] : 0;
		$errors      = isset( $state['errors'] ) ? (int) $state['errors'] : 0;

		$lines = array();
		$user_id = get_current_user_id();
		$log_key = 'aegisbackup_pp_filejob_log_' . $job_id;
		$log     = (string) get_user_meta( $user_id, $log_key, true );

		$max_per_call = 3; 
		$processed = 0;
		while ( $idx < $total_items && $processed < $max_per_call ) {
			$task = $state['tasks'][ $idx ];
			$idx++;
			$processed++;

			$t = ( is_array( $task ) && ! empty( $task['t'] ) ) ? (string) $task['t'] : '';
			$rel = ( is_array( $task ) && ! empty( $task['rel'] ) ) ? (string) $task['rel'] : '';
			$abs = ( is_array( $task ) && ! empty( $task['abs'] ) ) ? (string) $task['abs'] : '';
			if ( '' === $t || '' === $rel ) {
				continue;
			}

			$ok = false;
			$err_msg = '';
			$bytes = 0;

			if ( 'dir' === $t ) {
				$body = wp_json_encode( array( 'dst_root' => (string) $dst_root, 'rel_path' => (string) $rel, 'is_dir' => 1 ) );
				$res = wp_remote_post( $api, array( 'headers' => $headers, 'timeout' => 30, 'body' => $body ) );
				if ( is_wp_error( $res ) ) {
					$err_msg = $res->get_error_message();
				} else {
					$code = (int) wp_remote_retrieve_response_code( $res );
					if ( $code >= 200 && $code < 300 ) {
						$ok = true;
					} else {
						$err_msg = 'HTTP ' . $code;
					}
				}
				if ( $ok ) { $sent_dirs++; }
			} else {
				if ( ! $abs || ! is_file( $abs ) ) {
					$err_msg = 'Missing on disk';
				} else {
					$bin = @file_get_contents( $abs );
					if ( false === $bin ) {
						$err_msg = 'Failed to read file';
					} else {
						$body = wp_json_encode( array( 'dst_root' => (string) $dst_root, 'rel_path' => (string) $rel, 'content_b64' => base64_encode( $bin ) ) );
						$res = wp_remote_post( $api, array( 'headers' => $headers, 'timeout' => 60, 'body' => $body ) );
						if ( is_wp_error( $res ) ) {
							$err_msg = $res->get_error_message();
						} else {
							$code = (int) wp_remote_retrieve_response_code( $res );
							if ( $code >= 200 && $code < 300 ) {
								$ok = true;
								$bytes = strlen( $bin );
							} else {
								$err_msg = 'HTTP ' . $code;
							}
						}
					}
				}
				if ( $ok ) { $sent_files++; }
			}

			if ( ! $ok ) {
				$errors++;
			}

			$line = '';
			if ( 'dir' === $t ) {
				$line = sprintf( '[%s] DIR  %s %s', gmdate( 'H:i:s' ), $ok ? 'OK' : 'FAIL', $rel );
			} else {
				$line = sprintf( '[%s] FILE %s (%d/%d) %s%s', gmdate( 'H:i:s' ), $ok ? 'OK' : 'FAIL', (int) $sent_files, (int) $total_files, $rel, $bytes ? ' [' . (int) $bytes . ' bytes]' : '' );
			}
			if ( ! $ok && $err_msg ) {
				$line .= ' — ' . $err_msg;
			}
			$lines[] = $line;
			$log .= $line . "\n";
		}

		$done = ( $idx >= $total_items ) ? 1 : 0;
		$state['idx'] = $idx;
		$state['sent_files'] = $sent_files;
		$state['sent_dirs']  = $sent_dirs;
		$state['errors']     = $errors;
		$state['done']       = $done;
		update_option( $opt_key, $state, false );

		if ( strlen( $log ) > 50000 ) {
			$log = substr( $log, -50000 );
		}
		update_user_meta( $user_id, $log_key, $log );

		$progress = 0;
		if ( $total_items > 0 ) {
			$progress = (int) floor( ( $idx / $total_items ) * 100 );
		}

		wp_send_json_success(
			array(
				'job_id'      => $job_id,
				'done'        => (int) $done,
				'progress'    => (int) $progress,
				'sent_files'  => (int) $sent_files,
				'total_files' => (int) $total_files,
				'sent_dirs'   => (int) $sent_dirs,
				'errors'      => (int) $errors,
				'lines'       => $lines,
			)
		);
	}

	public function ajax_pp_destlog_fetch() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$list = get_option( 'aegisbackup_pp_destination_live_log', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}

		$max = 200;
		if ( count( $list ) > $max ) {
			$list = array_slice( $list, -$max );
		}
		$lines = array();
		foreach ( $list as $row ) {
			if ( is_string( $row ) ) {
				$lines[] = $row;
			}
		}

		wp_send_json_success( array( 'lines' => $lines ) );
	}

	public function ajax_pp_destdb_status() {
		$this->require_ajax();
		// phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified in require_ajax().
		check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

		$list = get_option( 'aegisbackup_pp_received_db_backups', array() );
		if ( ! is_array( $list ) ) {
			$list = array();
		}

		$count = 0;
		$last  = 0;
		foreach ( $list as $row ) {
			if ( ! is_array( $row ) ) {
				continue;
			}
			$count++;
			if ( ! empty( $row['received'] ) ) {
				$ts = (int) $row['received'];
				if ( $ts > $last ) {
					$last = $ts;
				}
			}
		}

		wp_send_json_success(
			array(
				'count' => (int) $count,
				'last_received' => (int) $last,
			)
		);
	}


    public function ajax_dbtools_export_csv() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $csv = $mod->export_csv();
        wp_send_json_success( array( 'filename' => 'db-table-summary.csv', 'csv' => $csv ) );
    }

    public function ajax_dbtools_table_op() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $op = isset( $_POST['op'] ) ? sanitize_key( wp_unslash( $_POST['op'] ) ) : '';
        $tables = isset( $_POST['tables'] ) && is_array( $_POST['tables'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['tables'] ) ) : array();

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $res = $mod->run_table_op( $op, $tables );
        wp_send_json_success( $res );
    }

    public function ajax_dbtools_prefix_change() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $new_prefix    = isset( $_POST['new_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['new_prefix'] ) ) : '';
        $backup_first  = isset( $_POST['backup_first'] ) ? (bool) intval( $_POST['backup_first'] ) : false;
        $snapshot_file = isset( $_POST['snapshot_file'] ) ? sanitize_text_field( wp_unslash( $_POST['snapshot_file'] ) ) : '';

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        if ( empty( $snapshot_file ) ) {
            wp_send_json_error( array( 'ok' => false, 'message' => __( 'A DB snapshot must be selected before applying.', 'aegisbackup' ), 'details' => array() ) );
        }

        $snapshots = $mod->list_db_backups();
        $found = false;
        foreach ( $snapshots as $s ) {
            if ( isset( $s['file'] ) && (string) $s['file'] === (string) $snapshot_file ) {
                $found = true;
                break;
            }
        }
        if ( ! $found ) {
            wp_send_json_error( array( 'ok' => false, 'message' => __( 'Selected snapshot was not found. Please refresh snapshots and try again.', 'aegisbackup' ), 'details' => array() ) );
        }

        $res = $mod->apply_prefix_change( $this->plugin, $new_prefix, $backup_first );
        if ( ! empty( $res['ok'] ) ) {
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_prefix_preview() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => __( 'Insufficient permissions.', 'aegisbackup' ) ) );
        }

        $new_prefix     = isset( $_POST['new_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['new_prefix'] ) ) : '';
        $current_prefix = isset( $_POST['current_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['current_prefix'] ) ) : '';

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $module = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $preview = $module->build_prefix_preview_payload( $current_prefix, $new_prefix );
        if ( empty( $preview['ok'] ) ) {
            wp_send_json_error( array(
                'message' => isset( $preview['message'] ) ? $preview['message'] : __( 'Preview failed.', 'aegisbackup' ),
                'data'    => $preview,
            ) );
        }

        wp_send_json_success( $preview );
    }

    public function ajax_dbtools_prefix_verify() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => __( 'Insufficient permissions.', 'aegisbackup' ) ) );
        }

        $expected_prefix = isset( $_POST['expected_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['expected_prefix'] ) ) : '';
        $old_prefix      = isset( $_POST['old_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['old_prefix'] ) ) : '';

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $module = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $result = $module->run_prefix_verification_scan_strict( $expected_prefix, $old_prefix );

        wp_send_json_success( $result );
    }

	public function handle_dbtools_prefix_preview() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Forbidden', 403 );
		}
		$this->require_admin_post( 'aegisbackup_nonce' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

		$new_prefix     = isset( $_POST['new_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['new_prefix'] ) ) : '';
		$current_prefix = isset( $_POST['current_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['current_prefix'] ) ) : '';

		require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
		$module  = new \AegisBackup\Modules\AB_Module_DB_Tools();
		$preview = $module->build_prefix_preview_payload( $current_prefix, $new_prefix );

		$key = 'ab_dbtools_prefix_preview_' . (int) get_current_user_id();
		set_transient( $key, $preview, 5 * MINUTE_IN_SECONDS );

		$url = wp_get_referer();
		if ( ! $url ) {
			$url = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=prefix' );
		}
		$url = add_query_arg( array( 'ab_prefix_preview' => 1 ), $url );
		wp_safe_redirect( $url );
		exit;
	}

	public function handle_dbtools_prefix_change() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Forbidden', 403 );
		}
		$this->require_admin_post( 'aegisbackup_nonce' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

		$new_prefix    = isset( $_POST['new_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['new_prefix'] ) ) : '';
		$snapshot_file = isset( $_POST['snapshot_file'] ) ? sanitize_text_field( wp_unslash( $_POST['snapshot_file'] ) ) : '';
		$confirmed     = isset( $_POST['confirm_apply'] ) ? (bool) intval( $_POST['confirm_apply'] ) : false;

		require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
		$mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

		if ( ! $confirmed ) {
			$res = array( 'ok' => false, 'message' => __( 'Please confirm you understand the risk before applying.', 'aegisbackup' ) );
		} elseif ( empty( $snapshot_file ) ) {
			$res = array( 'ok' => false, 'message' => __( 'A DB snapshot must be selected before applying.', 'aegisbackup' ) );
		} else {
			$snapshots = $mod->list_db_backups();
			$found     = false;
			foreach ( $snapshots as $s ) {
				if ( isset( $s['file'] ) && (string) $s['file'] === (string) $snapshot_file ) {
					$found = true;
					break;
				}
			}
			if ( ! $found ) {
				$res = array( 'ok' => false, 'message' => __( 'Selected snapshot was not found. Please refresh snapshots and try again.', 'aegisbackup' ) );
			} else {
				$res = $mod->apply_prefix_change( $this->plugin, $new_prefix, false );
			}
		}

		$key = 'ab_dbtools_prefix_apply_' . (int) get_current_user_id();
		set_transient( $key, $res, 5 * MINUTE_IN_SECONDS );

		$url = wp_get_referer();
		if ( ! $url ) {
			$url = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=prefix' );
		}
		$url = add_query_arg( array( 'ab_prefix_applied' => 1 ), $url );
		wp_safe_redirect( $url );
		exit;
	}

	public function handle_dbtools_prefix_verify() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( 'Forbidden', 403 );
		}
		$this->require_admin_post( 'aegisbackup_nonce' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

		$expected_prefix = isset( $_POST['expected_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['expected_prefix'] ) ) : '';
		$old_prefix      = isset( $_POST['old_prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['old_prefix'] ) ) : '';

		require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
		$module = new \AegisBackup\Modules\AB_Module_DB_Tools();
		$result = $module->run_prefix_verification_scan_strict( $expected_prefix, $old_prefix );

		$key = 'ab_dbtools_prefix_verify_' . (int) get_current_user_id();
		set_transient( $key, $result, 5 * MINUTE_IN_SECONDS );

		$url = wp_get_referer();
		if ( ! $url ) {
			$url = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=prefix' );
		}
		$url = add_query_arg( array( 'ab_prefix_verified' => 1 ), $url );
		wp_safe_redirect( $url );
		exit;
	}

    public function ajax_dbtools_create_snapshot() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $res = $mod->create_db_backup_snapshot();
        if ( ! empty( $res['success'] ) ) {
            $msg = isset( $res['message'] ) ? (string) $res['message'] : 'DB snapshot created.';
            $mod->add_activity_log( 'snapshot', $msg, array(
                'file' => isset( $res['file'] ) ? (string) $res['file'] : '',
                'size' => isset( $res['filesize'] ) ? (int) $res['filesize'] : 0,
            ) );
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_list_snapshots() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $items = $mod->list_db_backups();
        $out = array();
        foreach ( $items as $it ) {
            $file = isset( $it['file'] ) ? (string) $it['file'] : '';
            if ( '' === $file ) {
                continue;
            }
            $out[] = array(
                'file'        => $file,
                'size'        => isset( $it['size'] ) ? (int) $it['size'] : 0,
                'size_h'      => size_format( isset( $it['size'] ) ? (int) $it['size'] : 0, 2 ),
                'mtime'       => isset( $it['mtime'] ) ? (int) $it['mtime'] : 0,
                'mtime_h'     => isset( $it['mtime'] ) ? gmdate( 'Y-m-d H:i:s', (int) $it['mtime'] ) . ' UTC' : '',
                'download_url'=> add_query_arg(
                    array(
                        'action' => 'aegisbackup_dbtools_download_snapshot',
                        'file'   => rawurlencode( $file ),
                        'nonce'  => wp_create_nonce( 'aegisbackup_nonce' ),
                    ),
                    admin_url( 'admin-ajax.php' )
                ),
            );
        }

        wp_send_json_success( array( 'items' => $out ) );
    }

    public function ajax_dbtools_delete_snapshot() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $file = isset( $_POST['file'] ) ? sanitize_file_name( (string) wp_unslash( $_POST['file'] ) ) : '';
        if ( empty( $file ) || false === strpos( $file, '.sql' ) ) {
            wp_send_json_error( array( 'message' => 'Invalid file.' ), 400 );
        }

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $dir = $mod->get_db_tools_backup_dir();
        if ( empty( $dir ) ) {
            wp_send_json_error( array( 'message' => 'Backup directory not available.' ), 400 );
        }

        $path = trailingslashit( $dir ) . $file;
        if ( ! file_exists( $path ) ) {
            wp_send_json_error( array( 'message' => 'File not found.' ), 404 );
        }

        $ok = wp_delete_file(  $path  );
        if ( ! $ok ) {
            wp_send_json_error( array( 'message' => 'Unable to delete file.' ), 500 );
        }
        $mod->add_activity_log( 'snapshot_delete', 'Snapshot deleted.', array( 'file' => $file ) );
        wp_send_json_success( array( 'message' => 'Deleted.' ) );
    }



    public function ajax_dbtools_restore_snapshot() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $file = isset( $_POST['file'] ) ? sanitize_file_name( (string) wp_unslash( $_POST['file'] ) ) : '';
        if ( empty( $file ) || false === strpos( $file, '.sql' ) ) {
            wp_send_json_error( array( 'message' => 'Invalid file.' ), 400 );
        }

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();

        $res = $mod->restore_db_backup_snapshot( $file );
        if ( ! empty( $res['success'] ) ) {
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_save_settings() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $weekly = ! empty( $_POST['weekly'] ) ? 1 : 0;
        $growth = ! empty( $_POST['growth'] ) ? 1 : 0;

        $settings = get_option( 'aegisbackup_dbtools_settings', array() );
        if ( ! is_array( $settings ) ) {
            $settings = array();
        }
        $settings['weekly_optimize_enabled'] = (bool) $weekly;
        $settings['growth_monitor_enabled']  = (bool) $growth;
        update_option( 'aegisbackup_dbtools_settings', $settings, false );

        wp_send_json_success( array( 'message' => 'Saved.' ) );
    }

    public function handle_dbtools_save_settings() {
        $this->require_admin_post( 'aegisbackup_dbtools_save_settings' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $weekly = ! empty( $_POST['weekly'] ) ? 1 : 0;
        $growth = ! empty( $_POST['growth'] ) ? 1 : 0;

        $settings = get_option( 'aegisbackup_dbtools_settings', array() );
        if ( ! is_array( $settings ) ) {
            $settings = array();
        }

        $settings['weekly_optimize_enabled'] = (bool) $weekly;
        $settings['growth_monitor_enabled']  = (bool) $growth;

        update_option( 'aegisbackup_dbtools_settings', $settings, false );

        $this->dbtools_redirect( 'optimize', array(
            'ab_msg' => __( 'Settings saved.', 'aegisbackup' ),
            'ab_ok'  => 1,
        ) );
    }

    public function ajax_dbtools_run_optimization() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $res = $mod->run_manual_optimization();
        if ( ! empty( $res['success'] ) ) {
            $mod->add_activity_log( 'optimize', isset( $res['message'] ) ? (string) $res['message'] : 'Optimization completed.', array(
                'tables' => isset( $res['tables'] ) ? (array) $res['tables'] : array(),
            ) );
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_run_growth() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $res = $mod->maybe_check_growth( true );

        if ( ! empty( $res['success'] ) ) {
            $res['total_h'] = size_format( (int) ( $res['total'] ?? 0 ), 2 );
            $res['delta_h'] = size_format( abs( (int) ( $res['delta'] ?? 0 ) ), 2 );

            $mod->add_activity_log( 'growth', isset( $res['message'] ) ? (string) $res['message'] : 'Growth check recorded.', array(
                'total' => (int) ( $res['total'] ?? 0 ),
                'delta' => (int) ( $res['delta'] ?? 0 ),
            ) );
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_list_activity() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $limit = isset( $_POST['limit'] ) ? (int) $_POST['limit'] : 50;
        $limit = max( 1, min( 200, $limit ) );

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod  = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $logs = $mod->get_activity_logs( $limit );

        $out = array();
        foreach ( $logs as $row ) {
            if ( ! is_array( $row ) ) {
                continue;
            }
            $ts = isset( $row['ts'] ) ? (int) $row['ts'] : 0;
            $out[] = array(
                'ts'     => $ts,
                'date'   => $ts ? wp_date( 'Y-m-d', $ts ) : '',
                'time'   => $ts ? wp_date( 'H:i:s', $ts ) : '',
                'action' => isset( $row['action'] ) ? (string) $row['action'] : '',
                'result' => isset( $row['result'] ) ? (string) $row['result'] : '',
                'context'=> isset( $row['context'] ) ? (array) $row['context'] : array(),
            );
        }

        wp_send_json_success( array( 'items' => $out ) );
    }

    public function ajax_dbtools_prefix_scan() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $prefix = isset( $_POST['prefix'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['prefix'] ) ) : '';
        if ( '' === $prefix ) {
            global $wpdb;
            $prefix = (string) $wpdb->prefix;
        }

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $res = $mod->run_prefix_verification_scan( $prefix );
        if ( ! empty( $res['success'] ) ) {
            wp_send_json_success( $res );
        }
        wp_send_json_error( $res );
    }

    public function ajax_dbtools_download_snapshot() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden', 403 );
        }
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );

        $file = isset( $_GET['file'] ) ? sanitize_file_name( (string) wp_unslash( $_GET['file'] ) ) : '';
        if ( empty( $file ) || false === strpos( $file, '.sql' ) ) {
            wp_die( 'Invalid file.', 400 );
        }

        require_once AEGISBACKUP_DIR . 'includes/modules/class-ab-module-db-tools.php';
        $mod = new \AegisBackup\Modules\AB_Module_DB_Tools();
        $dir = $mod->get_db_tools_backup_dir();
        if ( empty( $dir ) ) {
            wp_die( 'Backup directory not available.', 400 );
        }

        $path = trailingslashit( $dir ) . $file;
        if ( ! file_exists( $path ) ) {
            wp_die( 'File not found.', 404 );
        }

        nocache_headers();
        header( 'Content-Type: application/sql' );
        header( 'Content-Disposition: attachment; filename="' . basename( $file ) . '"' );
        header( 'Content-Length: ' . (string) filesize( $path ) );
        readfile( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_readfile -- Streaming download.
        exit;
    }


    
public function handle_upload_package() {
    if ( ! current_user_can( 'manage_options' ) ) {
        wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
    }
    check_admin_referer( 'aegisbackup_upload_package', 'aegisbackup_nonce' );

    if ( empty( $_FILES['ab_package_zip']['name'] ) ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_missing' ) );
        exit;
    }

    $file = isset( $_FILES['ab_package_zip'] ) ? $_FILES['ab_package_zip'] : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Validated below.
    $original_name = isset( $file['name'] ) ? sanitize_file_name( (string) $file['name'] ) : '';

    if ( ! function_exists( 'wp_handle_upload' ) ) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
    }

    $upload_dir = wp_upload_dir();
    $tmp_dir = trailingslashit( $upload_dir['basedir'] ) . 'aegisbackup/uploads';
    if ( ! wp_mkdir_p( $tmp_dir ) ) {
        wp_die( esc_html__( 'Unable to create upload directory.', 'aegisbackup' ) );
    }

    $overrides = array(
        'test_form' => false,
        'mimes'     => array( 'zip' => 'application/zip' ),
    );

    add_filter( 'upload_dir', function( $dirs ) use ( $tmp_dir ) {
        $dirs['path']    = $tmp_dir;
        $dirs['url']     = '';
        $dirs['subdir']  = '';
        $dirs['basedir'] = $tmp_dir;
        $dirs['baseurl'] = '';
        return $dirs;
    } );

    $moved = wp_handle_upload( $file, $overrides );

    remove_all_filters( 'upload_dir' );

    if ( ! empty( $moved['error'] ) ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_error' ) );
        exit;
    }

    $tmp_path = isset( $moved['file'] ) ? (string) $moved['file'] : '';
    if ( ! $tmp_path || ! file_exists( $tmp_path ) ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_error' ) );
        exit;
    }

    $base = trailingslashit( $upload_dir['basedir'] ) . 'aegisbackup';
    if ( ! wp_mkdir_p( $base ) ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_error' ) );
        exit;
    }

    $pkg_slug = 'package-upload-' . gmdate( 'Ymd-His' ) . '-' . wp_generate_password( 4, false, false );
    $pkg_dir  = trailingslashit( $base ) . $pkg_slug;
    if ( ! wp_mkdir_p( $pkg_dir ) ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_error' ) );
        exit;
    }

    $fs = $this->ab_filesystem();
    $dest_zip = trailingslashit( $pkg_dir ) . 'AegisBackup-' . basename( $pkg_dir ) . '.zip';
    $moved = ( $fs && method_exists( $fs, 'move' ) ) ? $fs->move( $tmp_path, $dest_zip, true ) : false;
    if ( ! $moved ) {
        wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup-restore&tab=migrate&ab_msg=upload_error' ) );
        exit;
    }

    $manifest = array();
    $manifest_path = trailingslashit( $pkg_dir ) . 'manifest.json';

    if ( class_exists( 'ZipArchive' ) ) {
        $zip = new \ZipArchive();
        if ( true === $zip->open( $dest_zip ) ) {
            $raw = $zip->getFromName( 'manifest.json' );
            if ( false === $raw ) {
                $raw = $zip->getFromName( 'package/manifest.json' );
            }
            if ( false === $raw ) {
                for ( $i = 0; $i < $zip->numFiles; $i++ ) {
                    $stat = $zip->statIndex( $i );
                    if ( ! empty( $stat['name'] ) && preg_match( '#(^|/)manifest\.json$#i', (string) $stat['name'] ) ) {
                        $raw = $zip->getFromIndex( $i );
                        break;
                    }
                }
            }
            if ( false !== $raw && is_string( $raw ) && '' !== trim( $raw ) ) {
                $tmp = json_decode( $raw, true );
                if ( is_array( $tmp ) ) {
                    $manifest = $tmp;
                }
            }
            $zip->close();
        }
    }

    $manifest['uploaded_filename'] = $original_name;
    $manifest['uploaded_at_utc']   = gmdate( 'c' );

    @file_put_contents( $manifest_path, wp_json_encode( $manifest, JSON_PRETTY_PRINT ) );

    $url = add_query_arg(
        array(
            'page'   => 'aegisbackup-restore',
            'tab'    => 'migrate',
            'ab_msg' => 'upload_ok',
            'ab_pkg' => $pkg_slug,
        ),
        admin_url( 'admin.php' )
    );
    wp_safe_redirect( $url );
    exit;
}



    public function ajax_get_last_report() {
        $this->check_nonce();
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Insufficient permissions.' ), 403 );
        }

        $report = get_option( 'aegisbackup_last_migration_report', array() );
        if ( ! is_array( $report ) ) $report = array();

        wp_send_json_success( array( 'report' => $report ) );
    }

	private function file_backups_redirect( array $args = array() ) {
		$url = add_query_arg(
			array_merge(
				array(
					'page' => 'aegisbackup',
					'tab'  => 'files',
				),
				$args
			),
			admin_url( 'admin.php' )
		);
		wp_safe_redirect( $url );
		exit;
	}

	public function handle_save_file_plan() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_save_file_plan' );

		$plan_id = isset( $_POST['plan_id'] ) ? sanitize_key( (string) wp_unslash( $_POST['plan_id'] ) ) : '';
		if ( '' === $plan_id ) {
			$plan_id = 'p_' . wp_generate_password( 8, false, false );
		}

		$name = isset( $_POST['plan_name'] ) ? sanitize_text_field( wp_unslash( $_POST['plan_name'] ) ) : '';
		$type = isset( $_POST['plan_type'] ) ? sanitize_key( wp_unslash( $_POST['plan_type'] ) ) : 'full';
		$schedule = isset( $_POST['plan_schedule'] ) ? sanitize_key( wp_unslash( $_POST['plan_schedule'] ) ) : 'daily';
		$time = isset( $_POST['plan_time'] ) ? sanitize_text_field( wp_unslash( $_POST['plan_time'] ) ) : '02:00';
		$dow = isset( $_POST['plan_dow'] ) ? (int) $_POST['plan_dow'] : 1;
		$dom = isset( $_POST['plan_dom'] ) ? (int) $_POST['plan_dom'] : 1;
		$enabled = ! empty( $_POST['plan_enabled'] ) ? 1 : 0;

		$paths = array();
		if ( isset( $_POST['plan_paths'] ) && is_array( $_POST['plan_paths'] ) ) {
			foreach ( (array) wp_unslash( $_POST['plan_paths'] ) as $p ) { // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized inside loop.
				$p = $this->plugin->file_backup->normalize_rel_path( sanitize_text_field( (string) $p ) );
				if ( '' !== $p ) {
					$paths[] = $p;
				}
			}
		}
		$paths = array_values( array_unique( $paths ) );

		$plan = array(
			'id' => $plan_id,
			'name' => $name ? $name : ( 'File Backup Plan ' . $plan_id ),
			'paths' => $paths,
			'type' => in_array( $type, array( 'full', 'incremental', 'differential' ), true ) ? $type : 'full',
			'schedule' => in_array( $schedule, array( 'daily', 'weekly', 'monthly' ), true ) ? $schedule : 'daily',
			'time' => $time,
			'dow' => max( 0, min( 6, $dow ) ),
			'dom' => max( 1, min( 31, $dom ) ),
			'enabled' => $enabled,
			'updated' => time(),
		);

		$existing = $this->plugin->file_backup->get_plan( $plan_id );
		$plan['created'] = is_array( $existing ) && isset( $existing['created'] ) ? (int) $existing['created'] : time();
		$plan['last_run'] = is_array( $existing ) && isset( $existing['last_run'] ) ? (int) $existing['last_run'] : 0;
		$plan['next_run'] = $enabled ? (int) $this->plugin->file_backup->next_run_timestamp( $plan ) : 0;


		$submit = isset( $_POST['ab_file_submit'] ) ? sanitize_key( (string) wp_unslash( $_POST['ab_file_submit'] ) ) : 'save';
		if ( 'run_now' === $submit ) {
			$plan['enabled'] = 0;
			$plan['schedule'] = 'manual';
			$plan['next_run'] = 0;
			$res = $this->plugin->file_backup->run_plan_now( $plan );
			if ( ! empty( $res['ok'] ) ) {
				$this->file_backups_redirect( array( 'ab_msg' => 'backup_created' ) );
			} else {
				$err = isset( $res['message'] ) ? (string) $res['message'] : 'Backup failed.';
				$this->file_backups_redirect( array(
					'ab_msg' => 'backup_failed',
					'ab_err' => rawurlencode( $err ),
				) );
			}
			return;
		}

		$is_pro = false;
		if ( isset( $this->plugin ) && isset( $this->plugin->license ) && is_object( $this->plugin->license ) && method_exists( $this->plugin->license, 'is_pro_active' ) ) {
			$is_pro = (bool) $this->plugin->license->is_pro_active();
		}
		if ( ! $is_pro ) {
			$this->file_backups_redirect( array( 'ab_msg' => 'plan_locked' ) );
			return;
		}

		$this->plugin->file_backup->save_plan( $plan );
		$this->plugin->file_backup->schedule_plan( $plan );

		$this->file_backups_redirect( array( 'ab_msg' => 'plan_saved' ) );
	}

	public function handle_delete_file_plan() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_delete_file_plan' );
		$plan_id = isset( $_GET['plan_id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['plan_id'] ) ) : '';
		if ( $plan_id ) {
			$this->plugin->file_backup->delete_plan( $plan_id );
		}
		$this->file_backups_redirect( array( 'ab_msg' => 'plan_deleted' ) );
	}

	public function handle_filetree_nav() {
		$this->require_admin_post();
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().
		check_admin_referer( 'aegisbackup_filetree_nav' );
		$uid = get_current_user_id();
		$rel = isset( $_POST['ft_rel'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['ft_rel'] ) ) : '';
		$rel = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $rel );
		$rel = ltrim( $rel, '/' );
		$do = isset( $_POST['ft_do'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['ft_do'] ) ) : 'refresh';
		$sel = isset( $_POST['ft_sel'] ) ? array_values( array_filter( array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['ft_sel'] ) ) ) ) : array();
		$clean = array();
		foreach ( $sel as $p ) {
			$p = (string) $p;
			$p = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $p );
			$p = ltrim( $p, '/' );
			if ( '' !== $p ) {
				$clean[ $p ] = true;
			}
		}
		update_user_meta( $uid, 'aegisbackup_ft_sel', array_keys( $clean ) );

		if ( 'root' === $do ) {
			$rel = '';
		} elseif ( 'up' === $do ) {
			if ( '' !== $rel ) {
				$parts = explode( '/', $rel );
				array_pop( $parts );
				$rel = implode( '/', $parts );
			}
		} elseif ( 'clear' === $do ) {
			update_user_meta( $uid, 'aegisbackup_ft_sel', array() );
		} elseif ( 0 === strpos( $do, 'enter:' ) ) {
			$target = substr( $do, 6 );
			$target = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $target );
			$target = ltrim( $target, '/' );
			$rel = $target;
		} elseif ( 0 === strpos( $do, 'cd:' ) ) {
			$target = substr( $do, 3 );
			$target = str_replace( array( '\\', chr( 0 ) ), array( '/', '' ), $target );
			$target = ltrim( $target, '/' );
			$rel = $target;
		} else {

		}

		update_user_meta( $uid, 'aegisbackup_ft_rel', $rel );

		$url = add_query_arg(
			array(
				'page' => 'aegisbackup',
				'tab'  => 'files',
			),
			admin_url( 'admin.php' )
		);
		wp_safe_redirect( $url );
		exit;
	}

	public function handle_run_file_plan_now() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_run_file_plan_now' );
		$plan_id = isset( $_GET['plan_id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['plan_id'] ) ) : '';
		$plan = $plan_id ? $this->plugin->file_backup->get_plan( $plan_id ) : null;
		if ( is_array( $plan ) ) {
			$res = $this->plugin->file_backup->run_plan_now( $plan );
			if ( ! empty( $res['ok'] ) ) {
				$this->file_backups_redirect( array( 'ab_msg' => 'backup_created' ) );
			} else {
				$err = isset( $res['message'] ) ? (string) $res['message'] : 'Backup failed.';
				$this->file_backups_redirect( array(
					'ab_msg' => 'backup_failed',
					'ab_err' => rawurlencode( $err ),
				) );
			}
		}

		$this->file_backups_redirect( array(
			'ab_msg' => 'backup_failed',
			'ab_err' => rawurlencode( 'Backup plan not found.' ),
		) );
	}

	public function handle_delete_file_backup() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_delete_file_backup' );
		$backup_id = isset( $_GET['backup_id'] ) ? sanitize_key( (string) wp_unslash( $_GET['backup_id'] ) ) : '';
		if ( $backup_id ) {
			$this->plugin->file_backup->delete_backup( $backup_id );
		}

		$return = isset( $_GET['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['ab_return'] ) ) : '';
		if ( $return && 0 === strpos( $return, admin_url() ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_msg' => 'file_deleted' ), $return ) );
			exit;
		}

		$this->file_backups_redirect( array( 'ab_msg' => 'backup_deleted' ) );
	}

	public function handle_restore_file_backup() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_restore_file_backup' );
		$backup_id = isset( $_GET['backup_id'] ) ? sanitize_key( (string) wp_unslash( $_GET['backup_id'] ) ) : '';
        $return = isset( $_GET['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['ab_return'] ) ) : '';
		$return = $return ? wp_validate_redirect( $return, '' ) : '';

		if ( $backup_id ) {
			$res = $this->plugin->file_backup->restore_backup( $backup_id );
			$msg = ! empty( $res['ok'] ) ? 'backup_restored' : 'restore_failed';
			if ( $return ) {
				wp_safe_redirect( add_query_arg( array( 'ab_msg' => $msg ), $return ) );
				exit;
			}
			$this->file_backups_redirect( array( 'ab_msg' => $msg ) );
		}

		if ( $return ) {
			wp_safe_redirect( add_query_arg( array( 'ab_msg' => 'restore_failed' ), $return ) );
			exit;
		}
		$this->file_backups_redirect( array( 'ab_msg' => 'restore_failed' ) );
	}

	public function handle_restore_file_backup_wizard() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_restore_file_backup_wizard', 'aegisbackup_restore_file_backup_wizard_nonce' );

		$backup_id = isset( $_POST['backup_id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['backup_id'] ) ) : '';
		if ( $backup_id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $backup_id ) ) {
			$backup_id = '';
		}

		register_shutdown_function( function () use ( $backup_id ) {
			$err = error_get_last();
			if ( empty( $err ) || ! isset( $err['type'] ) ) {
				return;
			}

			if ( ! in_array( (int) $err['type'], array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR, E_RECOVERABLE_ERROR ), true ) ) {
				return;
			}
			if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) { @error_log( '[AegisBackup] File Restore Wizard fatal: ' . ( isset( $err['message'] ) ? $err['message'] : '' ) . ' in ' . ( isset( $err['file'] ) ? $err['file'] : '' ) . ':' . ( isset( $err['line'] ) ? $err['line'] : '' ) . ' (backup_id=' . (string) $backup_id . ')' ); } // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug only.
			if ( headers_sent() ) {
				return;
			}
			nocache_headers();
			$status = 500;
			if ( function_exists( 'status_header' ) ) {
				status_header( $status );
			}
			echo '<h1>Restore failed</h1>';
			echo '<p>A fatal PHP error occurred during file restore. Check <code>wp-content/debug.log</code> for details.</p>';
			echo '<p><strong>Backup ID:</strong> <code>' . esc_html( (string) $backup_id ) . '</code></p>';
			echo '<p><strong>Error:</strong> <code>' . esc_html( isset( $err['message'] ) ? (string) $err['message'] : '' ) . '</code></p>';
			echo '<p><strong>File:</strong> <code>' . esc_html( isset( $err['file'] ) ? (string) $err['file'] : '' ) . '</code></p>';
			echo '<p><strong>Line:</strong> <code>' . esc_html( isset( $err['line'] ) ? (string) $err['line'] : '' ) . '</code></p>';
			exit;
		} );

        $return = isset( $_POST['ab_redirect'] ) ? esc_url_raw( (string) wp_unslash( $_POST['ab_redirect'] ) ) : '';
		$return    = $return ? wp_validate_redirect( $return, '' ) : '';
		if ( ! $return ) {
			$return = admin_url( 'admin.php?page=aegisbackup-restore&tab=restore' );
		}

		$confirm_box  = ! empty( $_POST['confirm_drop'] );
		$confirm_text = isset( $_POST['confirm_text'] ) ? strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) ) : '';
		if ( ! $confirm_box || 'RESTORE' !== $confirm_text ) {
			$wiz = add_query_arg( array(
				'page'      => 'aegisbackup-restore',
				'tab'       => 'restore',
				'ab_wizard' => 1,
				'ab_kind'   => 'file_backup',
				'id'        => $backup_id,
				'ab_err'    => 'confirm',
			), admin_url( 'admin.php' ) );
			nocache_headers();
			if ( ! wp_safe_redirect( $wiz ) ) {
				wp_die(
					'<p><strong>' . esc_html__( 'Restore Wizard redirect failed.', 'aegisbackup' ) . '</strong></p>' .
					'<p>' . esc_html__( 'A PHP warning/notice likely sent output before headers. Check wp-content/debug.log for the real error.', 'aegisbackup' ) . '</p>' .
					'<p><a class="button button-primary" href="' . esc_url( $wiz ) . '">' . esc_html__( 'Continue', 'aegisbackup' ) . '</a></p>'
				);
			}
			exit;
		}

		if ( ! $backup_id || empty( $this->plugin->file_backup ) ) {
			$wiz = add_query_arg( array(
				'page'      => 'aegisbackup-restore',
				'tab'       => 'restore',
				'ab_wizard' => 1,
				'ab_kind'   => 'file_backup',
				'id'        => $backup_id,
				'ab_err'    => 'restore_failed',
			), admin_url( 'admin.php' ) );
			nocache_headers();
			if ( ! wp_safe_redirect( $wiz ) ) {
				wp_die(
					'<p><strong>' . esc_html__( 'Restore Wizard redirect failed.', 'aegisbackup' ) . '</strong></p>' .
					'<p>' . esc_html__( 'A PHP warning/notice likely sent output before headers. Check wp-content/debug.log for the real error.', 'aegisbackup' ) . '</p>' .
					'<p><a class="button button-primary" href="' . esc_url( $wiz ) . '">' . esc_html__( 'Continue', 'aegisbackup' ) . '</a></p>'
				);
			}
			exit;
		}

		$res = array( 'ok' => false, 'message' => '' );
		try {
			$res = $this->plugin->file_backup->restore_backup( $backup_id );
		} catch ( \Throwable $e ) {
			$res = array( 'ok' => false, 'message' => $e->getMessage() );
		}

		$wiz_args = array(
			'page'      => 'aegisbackup-restore',
			'tab'       => 'restore',
			'ab_wizard' => 1,
			'ab_kind'   => 'file_backup',
			'id'        => $backup_id,
		);

		if ( ! empty( $res['ok'] ) ) {
			$wiz_args['ab_msg'] = 'file_restore_done';
			$wiz_args['ab_restored'] = isset( $res['restored'] ) ? (int) $res['restored'] : 0;
			$wiz_args['ab_skipped']  = isset( $res['skipped'] ) ? (int) $res['skipped'] : 0;
		} else {
			$wiz_args['ab_err'] = 'restore_failed';
			if ( ! empty( $res['message'] ) ) {
				$wiz_args['ab_emsg'] = (string) $res['message'];
			}
		}

		$wiz = add_query_arg( $wiz_args, admin_url( 'admin.php' ) );
		nocache_headers();
		if ( ! wp_safe_redirect( $wiz ) ) {
			wp_die(
				'<p><strong>' . esc_html__( 'Restore Wizard redirect failed.', 'aegisbackup' ) . '</strong></p>' .
				'<p>' . esc_html__( 'A PHP warning/notice likely sent output before headers. Check wp-content/debug.log for the real error.', 'aegisbackup' ) . '</p>' .
				'<p><a class="button button-primary" href="' . esc_url( $wiz ) . '">' . esc_html__( 'Continue', 'aegisbackup' ) . '</a></p>'
			);
		}
		exit;
	}

	public function handle_download_file_backup() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
		}
		check_admin_referer( 'aegisbackup_download_file_backup' );
		$backup_id = isset( $_GET['backup_id'] ) ? sanitize_key( (string) wp_unslash( $_GET['backup_id'] ) ) : '';
		if ( ! $backup_id ) {
			wp_die( 'Missing backup_id.' );
		}
		$dir = $this->plugin->file_backup->backups_dir();
		$path = trailingslashit( $dir ) . basename( $backup_id ) . '.zip';
		if ( ! is_file( $path ) ) {
			wp_die( 'Backup not found.' );
		}
		header( 'Content-Type: application/zip' );
		header( 'Content-Disposition: attachment; filename="' . basename( $path ) . '"' );
		header( 'Content-Length: ' . (string) @filesize( $path ) );
		@readfile( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_readfile -- Streaming download.
		exit;
	}


    public function handle_save_wp_plan() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden' );
        }
        check_admin_referer( 'aegisbackup_save_wp_plan', 'aegisbackup_nonce' );

        $plan = array(
            'id' => isset( $_POST['plan_id'] ) ? sanitize_text_field( wp_unslash( $_POST['plan_id'] ) ) : '',
            'name' => isset( $_POST['name'] ) ? sanitize_text_field( wp_unslash( $_POST['name'] ) ) : 'WP Snapshot',
            'enabled' => ! empty( $_POST['enabled'] ) ? 1 : 0,
            'frequency' => isset( $_POST['frequency'] ) ? sanitize_key( wp_unslash( $_POST['frequency'] ) ) : 'daily',
            'time' => isset( $_POST['time'] ) ? sanitize_text_field( wp_unslash( $_POST['time'] ) ) : '02:00',
            'weekly_day' => isset( $_POST['weekly_day'] ) ? (int) $_POST['weekly_day'] : 1,
            'monthly_day' => isset( $_POST['monthly_day'] ) ? (int) $_POST['monthly_day'] : 1,
            'include_core' => ! empty( $_POST['include_core'] ) ? 1 : 0,
            'include_config' => ! empty( $_POST['include_config'] ) ? 1 : 0,
            'include_htaccess' => ! empty( $_POST['include_htaccess'] ) ? 1 : 0,
            'exclude' => isset( $_POST['exclude'] ) ? sanitize_textarea_field( (string) wp_unslash( $_POST['exclude'] ) ) : '', // phpcs:ignore WordPressVIPMinimum.Performance.WPQueryParams.PostNotIn_exclude -- Not a WP_Query argument; stored as plan config.
        );

        $this->plugin->wp_backup->save_plan( $plan );

        $redir = isset( $_GET['redirect'] ) ? sanitize_key( wp_unslash( $_GET['redirect'] ) ) : '';
        if ( 'migration' === $redir ) {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration' ) );
        } else {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=wordpress' ) );
        }
        exit;
    }

    public function handle_delete_wp_plan() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden' );
        }
        check_admin_referer( 'aegisbackup_delete_wp_plan', 'aegisbackup_nonce' );

        $plan_id = isset( $_GET['plan_id'] ) ? sanitize_text_field( wp_unslash( $_GET['plan_id'] ) ) : '';
        if ( $plan_id ) {
            $this->plugin->wp_backup->delete_plan( $plan_id );
        }

        $redir = isset( $_GET['redirect'] ) ? sanitize_key( wp_unslash( $_GET['redirect'] ) ) : '';
        if ( 'migration' === $redir ) {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration' ) );
        } else {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=wordpress' ) );
        }
        exit;
    }

    public function handle_run_wp_plan_now() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden' );
        }
        check_admin_referer( 'aegisbackup_run_wp_plan_now', 'aegisbackup_nonce' );

        $plan_id = isset( $_GET['plan_id'] ) ? sanitize_text_field( wp_unslash( $_GET['plan_id'] ) ) : '';
        if ( $plan_id ) {
            $this->plugin->wp_backup->run_plan_now( $plan_id );
        }

        $redir = isset( $_GET['redirect'] ) ? sanitize_key( wp_unslash( $_GET['redirect'] ) ) : '';
        if ( 'migration' === $redir ) {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration' ) );
        } else {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=wordpress' ) );
        }
        exit;
    }

    protected function is_safe_package_name( $name ) {
        $name = (string) $name;
        if ( '' === $name ) {
            return false;
        }
        if ( ! preg_match( '/^package-[a-zA-Z0-9_-]+$/', $name ) ) {
            return false;
        }
        return true;
    }

    public function handle_download_package() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden' );
        }
        check_admin_referer( 'aegisbackup_download_package', 'aegisbackup_nonce' );

        $pkg = isset( $_GET['pkg'] ) ? sanitize_text_field( wp_unslash( $_GET['pkg'] ) ) : '';
        if ( ! $this->is_safe_package_name( $pkg ) ) {
            wp_die( 'Invalid package.' );
        }

        $upload = wp_upload_dir();
        $pkg_dir = trailingslashit( trailingslashit( $upload['basedir'] ) . 'aegisbackup' ) . $pkg;
        $path = trailingslashit( $pkg_dir ) . 'AegisBackup-' . $pkg . '.zip';
        if ( ! is_file( $path ) ) {
            $path = trailingslashit( $pkg_dir ) . 'package.zip';
        }
        if ( ! is_file( $path ) ) {
            wp_die( 'Invalid package path.' );
        }

        nocache_headers();
        header( 'Content-Type: application/zip' );
        header( 'Content-Disposition: attachment; filename="' . basename( $path ) . '"' );
        header( 'Content-Length: ' . (string) filesize( $path ) );
        @readfile( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_readfile -- Streaming download.
        exit;
    }

    public function handle_delete_package() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( 'Forbidden' );
        }
        check_admin_referer( 'aegisbackup_delete_package', 'aegisbackup_nonce' );

        $pkg = isset( $_GET['pkg'] ) ? sanitize_text_field( wp_unslash( $_GET['pkg'] ) ) : '';
        if ( ! $this->is_safe_package_name( $pkg ) ) {
            wp_die( 'Invalid package path.' );
        }

        $upload = wp_upload_dir();
        $dir = trailingslashit( trailingslashit( $upload['basedir'] ) . 'aegisbackup' ) . $pkg;
        if ( is_dir( $dir ) ) {
            // Best-effort recursive delete.
            $it = new \RecursiveIteratorIterator(
                new \RecursiveDirectoryIterator( $dir, \FilesystemIterator::SKIP_DOTS ),
                \RecursiveIteratorIterator::CHILD_FIRST
            );
            foreach ( $it as $f ) {
                if ( $f->isDir() ) {
                    @rmdir( $f->getPathname() ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.
                } else {
                    wp_delete_file(  $f->getPathname()  );
                }
            }
            @rmdir( $dir ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.
        }

        $redir = isset( $_GET['redirect'] ) ? sanitize_key( wp_unslash( $_GET['redirect'] ) ) : '';
        if ( 'migration' === $redir ) {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration' ) );
        } else {
            wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=wordpress' ) );
        }
        exit;
    }

    public function handle_tablebacks_post() {
        $this->require_admin_post( 'aegisbackup_tablebacks_post', 'aegisbackup_nonce' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $uid = function_exists( 'get_current_user_id' ) ? (int) get_current_user_id() : 0;
        $state_key  = 'aegisbackup_tb_state_' . $uid;
        $notice_key = 'aegisbackup_tb_notice_' . $uid;

        $db = isset( $_POST['ab_tb_db'] ) ? sanitize_text_field( wp_unslash( $_POST['ab_tb_db'] ) ) : '';
        $name = isset( $_POST['ab_tb_name'] ) ? sanitize_text_field( wp_unslash( $_POST['ab_tb_name'] ) ) : '';
        $tables = isset( $_POST['ab_tb_tables'] ) && is_array( $_POST['ab_tb_tables'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['ab_tb_tables'] ) ) : array();

        $columns_map_in = ( isset( $_POST['ab_tb_columns'] ) && is_array( $_POST['ab_tb_columns'] ) ) ? map_deep( wp_unslash( $_POST['ab_tb_columns'] ), 'sanitize_text_field' ) : array();
        $clean_map = array();
        foreach ( $columns_map_in as $t => $cols ) {
            $t = sanitize_text_field( (string) $t );
            if ( '' === $t ) {
                continue;
            }
            $cols = is_array( $cols ) ? $cols : array();
            $clean_cols = array();
            foreach ( $cols as $c ) {
                $c = sanitize_text_field( (string) $c );
                if ( '' !== $c ) {
                    $clean_cols[] = $c;
                }
            }
            $clean_map[ $t ] = array_values( array_unique( $clean_cols ) );
        }

        $show_cols_table = '';
        if ( isset( $_POST['ab_tb_show_columns'] ) ) {
            $show_cols_table = sanitize_text_field( wp_unslash( $_POST['ab_tb_show_columns'] ) );
        }

        if ( $uid > 0 ) {
            set_transient( $state_key, array(
                'db' => $db,
                'name' => $name,
                'tables' => array_values( array_unique( array_filter( $tables ) ) ),
                'columns_map' => $clean_map,
                'show_cols_table' => $show_cols_table,
            ), 10 * MINUTE_IN_SECONDS );
        }

        if ( '' !== $show_cols_table && ! isset( $_POST['ab_tb_create_backup'] ) ) {
            $this->dbtools_redirect( 'table_backups' );
        }

        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        if ( ! $mgr ) {
            if ( $uid > 0 ) {
                set_transient( $notice_key, 'Table backup manager not available.', 5 * MINUTE_IN_SECONDS );
            }
            $this->dbtools_redirect( 'table_backups' );
        }

        $res = $mgr->create_backup( $name, $db, $tables, $clean_map );
        $msg = '';
        if ( is_array( $res ) ) {
            $msg = isset( $res['message'] ) ? (string) $res['message'] : '';
        }
        if ( '' === $msg ) {
            $msg = ! empty( $res['ok'] ) ? 'Backup created.' : 'Backup failed.';
        }

        if ( $uid > 0 ) {
            set_transient( $notice_key, $msg, 5 * MINUTE_IN_SECONDS );
        }

        $this->dbtools_redirect( 'table_backups' );
    }

    public function handle_tablebacks_save_plan_post() {
        $this->require_admin_post( 'aegisbackup_tablebacks_save_plan', 'aegisbackup_nonce' );
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- Nonce verified via require_admin_post().

        $uid = function_exists( 'get_current_user_id' ) ? (int) get_current_user_id() : 0;
        $state_key  = 'aegisbackup_tb_state_' . $uid;
        $notice_key = 'aegisbackup_tb_notice_' . $uid;

        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        if ( ! $mgr ) {
            if ( $uid > 0 ) {
                set_transient( $notice_key, 'Table backup manager not available.', 5 * MINUTE_IN_SECONDS );
            }
            $this->dbtools_redirect( 'table_backups' );
        }

        $columns_map_in = isset( $_POST['ab_tb_columns'] ) && is_array( $_POST['ab_tb_columns'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['ab_tb_columns'] ) ) : array();
        $clean_map = array();
        foreach ( $columns_map_in as $t => $cols ) {
            $t = sanitize_text_field( (string) $t );
            if ( '' === $t ) {
                continue;
            }
            $cols = is_array( $cols ) ? $cols : array();
            $clean_cols = array();
            foreach ( $cols as $c ) {
                $c = sanitize_text_field( (string) $c );
                if ( '' !== $c ) {
                    $clean_cols[] = $c;
                }
            }
            if ( ! empty( $clean_cols ) ) {
                $clean_map[ $t ] = array_values( array_unique( $clean_cols ) );
            }
        }

        $plan = array(
            'id' => '',
            'name' => isset( $_POST['ab_tb_plan_name'] ) ? sanitize_text_field( wp_unslash( $_POST['ab_tb_plan_name'] ) ) : '',
            'enabled' => 1,
            'frequency' => isset( $_POST['ab_tb_plan_freq'] ) ? sanitize_key( wp_unslash( $_POST['ab_tb_plan_freq'] ) ) : 'daily',
            'time' => isset( $_POST['ab_tb_plan_time'] ) ? sanitize_text_field( wp_unslash( $_POST['ab_tb_plan_time'] ) ) : '02:00',
            'weekdays' => isset( $_POST['ab_tb_plan_weekdays'] ) && is_array( $_POST['ab_tb_plan_weekdays'] ) ? array_map( 'sanitize_key', wp_unslash( $_POST['ab_tb_plan_weekdays'] ) ) : array(),
            'monthday' => isset( $_POST['ab_tb_plan_monthday'] ) ? absint( $_POST['ab_tb_plan_monthday'] ) : 0,
            'db' => isset( $_POST['ab_tb_plan_db'] ) ? sanitize_text_field( wp_unslash( $_POST['ab_tb_plan_db'] ) ) : '',
            'tables' => isset( $_POST['ab_tb_plan_tables'] ) && is_array( $_POST['ab_tb_plan_tables'] ) ? array_map( 'sanitize_text_field', wp_unslash( $_POST['ab_tb_plan_tables'] ) ) : array(),
            'columns_map' => $clean_map,
        );

        $submit = isset( $_POST['ab_tb_submit'] ) ? sanitize_key( (string) wp_unslash( $_POST['ab_tb_submit'] ) ) : 'save';
        if ( 'run_now' === $submit ) {
            $plan_name = isset( $plan['name'] ) && '' !== (string) $plan['name'] ? (string) $plan['name'] : 'Manual Table Backup';
            $db_name   = isset( $plan['db'] ) ? (string) $plan['db'] : '';
            $tables    = isset( $plan['tables'] ) && is_array( $plan['tables'] ) ? $plan['tables'] : array();
            $cols_map  = isset( $plan['columns_map'] ) && is_array( $plan['columns_map'] ) ? $plan['columns_map'] : array();

            $res = $mgr->create_backup( $plan_name, $db_name, (array) $tables, (array) $cols_map );
            if ( $uid > 0 ) {
                if ( is_array( $res ) && ! empty( $res['ok'] ) ) {
                    $bid = isset( $res['id'] ) ? (string) $res['id'] : '';
                    $msg = $bid ? ( 'Backup created: ' . $bid ) : 'Backup created.';
                    set_transient( $notice_key, $msg, 5 * MINUTE_IN_SECONDS );
                } else {
                    $err = is_array( $res ) && isset( $res['message'] ) ? (string) $res['message'] : 'Backup failed.';
                    set_transient( $notice_key, 'Backup failed: ' . $err, 5 * MINUTE_IN_SECONDS );
                }
            }
            $this->dbtools_redirect( 'table_backups' );
        }

        $is_pro = false;
        if ( isset( $this->plugin ) && isset( $this->plugin->license ) && is_object( $this->plugin->license ) && method_exists( $this->plugin->license, 'is_pro_active' ) ) {
            $is_pro = (bool) $this->plugin->license->is_pro_active();
        }
        if ( ! $is_pro ) {
            if ( $uid > 0 ) {
                set_transient( $notice_key, 'Scheduling is a PRO feature. Please upgrade to save schedules.', 5 * MINUTE_IN_SECONDS );
            }
            $this->dbtools_redirect( 'table_backups' );
        }
        $saved = $mgr->save_plan( $plan );
        $msg = 'Schedule saved.';
        if ( is_array( $saved ) && isset( $saved['id'] ) && '' !== (string) $saved['id'] ) {
            $msg = 'Schedule saved: ' . (string) $saved['id'];
        }
        if ( $uid > 0 ) {
            set_transient( $notice_key, $msg, 5 * MINUTE_IN_SECONDS );
        }

        if ( $uid > 0 ) {
            set_transient( $state_key, array(
                'db' => (string) $plan['db'],
                'name' => (string) $plan['name'],
                'tables' => array_values( array_unique( array_filter( (array) $plan['tables'] ) ) ),
                'columns_map' => $clean_map,
                'show_cols_table' => '',
                'plan_freq' => (string) $plan['frequency'],
                'plan_time' => (string) $plan['time'],
                'plan_weekdays' => (array) $plan['weekdays'],
                'plan_monthday' => (int) $plan['monthday'],
            ), 10 * MINUTE_IN_SECONDS );
        }

        $this->dbtools_redirect( 'table_backups' );
    }
    public function ajax_tablebacks_list_databases() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $mgr = $this->plugin->table_backup;
        $dbs = $mgr ? $mgr->list_databases() : array();
        wp_send_json_success( array( 'databases' => $dbs ) );
    }

    public function ajax_tablebacks_list_tables() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $db = isset( $_POST['db'] ) ? sanitize_text_field( wp_unslash( $_POST['db'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        $tables = $mgr ? $mgr->list_tables( $db ) : array();
        wp_send_json_success( array( 'tables' => $tables ) );
    }

    public function ajax_tablebacks_list_columns() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $db = isset( $_POST['db'] ) ? sanitize_text_field( wp_unslash( $_POST['db'] ) ) : '';
        $table = isset( $_POST['table'] ) ? sanitize_text_field( wp_unslash( $_POST['table'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        $cols = $mgr ? $mgr->list_columns( $db, $table ) : array();
        wp_send_json_success( array( 'columns' => $cols ) );
    }

    public function ajax_tablebacks_create_backup() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }

        $db = isset( $_POST['db'] ) ? sanitize_text_field( wp_unslash( $_POST['db'] ) ) : '';
        $name = isset( $_POST['name'] ) ? sanitize_text_field( wp_unslash( $_POST['name'] ) ) : '';
        $tables = isset( $_POST['tables'] ) ? (array) wp_unslash( $_POST['tables'] ) : array(); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Sanitized below.
        $tables = array_values( array_filter( array_map( 'sanitize_text_field', $tables ) ) );
        $columns_map = ( isset( $_POST['columns_map'] ) && is_array( $_POST['columns_map'] ) ) ? map_deep( wp_unslash( $_POST['columns_map'] ), 'sanitize_text_field' ) : array();
        $clean_map = array();
        foreach ( $columns_map as $t => $cols ) {
            $t = sanitize_text_field( (string) $t );
            if ( '' === $t ) { continue; }
            $cols = is_array( $cols ) ? $cols : array();
            $clean_cols = array();
            foreach ( $cols as $c ) {
                $c = sanitize_text_field( (string) $c );
                if ( '' !== $c ) { $clean_cols[] = $c; }
            }
            $clean_map[ $t ] = array_values( array_unique( $clean_cols ) );
        }

        $mgr = $this->plugin->table_backup;
        if ( ! $mgr ) {
            wp_send_json_error( array( 'message' => 'Table backup manager not available.' ) );
        }

        $res = $mgr->create_backup( $name, $db, $tables, $clean_map );
        if ( empty( $res['ok'] ) ) {
            wp_send_json_error( array( 'message' => isset( $res['message'] ) ? (string) $res['message'] : 'Failed.' ) );
        }
        wp_send_json_success( $res );
    }

    public function ajax_tablebacks_list_backups() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $mgr = $this->plugin->table_backup;
        $items = $mgr ? $mgr->list_backups_sorted() : array();

        if ( $mgr ) {
            foreach ( $items as &$it ) {
                $it['download_url'] = $mgr->get_download_url( (string) ( $it['id'] ?? '' ) );
                $it['size_human'] = $mgr->human_bytes( (int) ( $it['size'] ?? 0 ) );
            }
            unset( $it );
        }

        wp_send_json_success( array( 'backups' => $items ) );
    }

    public function ajax_tablebacks_delete_backup() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $id = isset( $_POST['id'] ) ? sanitize_key( wp_unslash( $_POST['id'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        $ok = $mgr ? $mgr->delete_backup( $id ) : false;
        wp_send_json_success( array( 'deleted' => $ok ? 1 : 0 ) );
    }

    public function ajax_tablebacks_start_restore() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $id = isset( $_POST['id'] ) ? sanitize_key( wp_unslash( $_POST['id'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        $res = $mgr ? $mgr->start_restore_job( $id ) : array( 'ok' => false, 'message' => 'Manager unavailable.' );
        if ( empty( $res['ok'] ) ) {
            wp_send_json_error( array( 'message' => isset( $res['message'] ) ? (string) $res['message'] : 'Failed.' ) );
        }
        wp_send_json_success( $res );
    }

    public function ajax_tablebacks_process_restore() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $job = isset( $_POST['job_id'] ) ? sanitize_key( wp_unslash( $_POST['job_id'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        $res = $mgr ? $mgr->process_restore_job( $job ) : array( 'ok' => false, 'done' => true, 'progress' => 100, 'log' => 'Manager unavailable.' );
        if ( empty( $res['ok'] ) ) {
            wp_send_json_error( array( 'message' => $res['log'] ?? 'Restore error.' ) );
        }
        wp_send_json_success( $res );
    }

    public function ajax_tablebacks_save_plan() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $mgr = $this->plugin->table_backup;
        if ( ! $mgr ) {
            wp_send_json_error( array( 'message' => 'Manager unavailable.' ) );
        }

        $plan = array(
            'id' => isset( $_POST['id'] ) ? sanitize_key( wp_unslash( $_POST['id'] ) ) : '',
            'name' => isset( $_POST['name'] ) ? sanitize_text_field( wp_unslash( $_POST['name'] ) ) : '',
            'enabled' => isset( $_POST['enabled'] ) ? absint( $_POST['enabled'] ) : 1,
            'frequency' => isset( $_POST['frequency'] ) ? sanitize_key( wp_unslash( $_POST['frequency'] ) ) : 'daily',
            'time' => isset( $_POST['time'] ) ? sanitize_text_field( wp_unslash( $_POST['time'] ) ) : '02:00',
            'db' => isset( $_POST['db'] ) ? sanitize_text_field( wp_unslash( $_POST['db'] ) ) : '',
            'tables' => isset( $_POST['tables'] ) ? array_values( array_filter( array_map( 'sanitize_text_field', (array) wp_unslash( $_POST['tables'] ) ) ) ) : array(),
        );

        $saved = $mgr->save_plan( $plan );
        wp_send_json_success( array( 'plan' => $saved ) );
    }

    public function ajax_tablebacks_list_plans() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $mgr = $this->plugin->table_backup;
        $plans = $mgr ? $mgr->get_plans() : array();
        wp_send_json_success( array( 'plans' => $plans ) );
    }

    public function ajax_tablebacks_delete_plan() {
        check_ajax_referer( 'aegisbackup_nonce', 'nonce' );
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => 'Forbidden' ), 403 );
        }
        $id = isset( $_POST['id'] ) ? sanitize_key( wp_unslash( $_POST['id'] ) ) : '';
        $mgr = $this->plugin->table_backup;
        if ( $mgr ) {
            $mgr->delete_plan( $id );
        }
        wp_send_json_success( array( 'deleted' => 1 ) );
    }

    public function handle_tablebacks_download() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_download' );

        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        $mgr = $this->plugin->table_backup;
        $b = $mgr ? $mgr->get_backup( $id ) : null;
        if ( empty( $b ) || empty( $b['zip'] ) || ! is_file( $b['zip'] ) ) {
            wp_die( esc_html__( 'Backup zip not found.', 'aegisbackup' ) );
        }

        $path = (string) $b['zip'];
        $fname = 'aegisbackup-table-backup-' . $id . '.zip';

        if ( function_exists( 'nocache_headers' ) ) {
            nocache_headers();
        }
        header( 'Content-Type: application/zip' );
        header( 'Content-Disposition: attachment; filename="' . $fname . '"' );
        header( 'Content-Length: ' . (string) filesize( $path ) );
        @readfile( $path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_readfile -- Streaming download.
        exit;
    }

    public function handle_tablebacks_restore_start() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ) );
        }
        check_admin_referer( 'aegisbackup_tablebacks_restore_start' );

        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        if ( ! $id || ! isset( $this->plugin->table_backup ) || ! $this->plugin->table_backup ) {
            wp_die( esc_html__( 'Backup not found.', 'aegisbackup' ) );
        }

        $return = isset( $_GET['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['ab_return'] ) ) : '';
        $return = ( $return && 0 === strpos( $return, admin_url() ) ) ? $return : '';

        $ab_tb_restore_fatal_logged = false;
        register_shutdown_function( function() use ( &$ab_tb_restore_fatal_logged ) {
            if ( $ab_tb_restore_fatal_logged ) {
                return;
            }
            $e = error_get_last();
            if ( empty( $e ) || empty( $e['type'] ) ) {
                return;
            }
            $fatal_types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR );
            if ( in_array( (int) $e['type'], $fatal_types, true ) ) {
                $ab_tb_restore_fatal_logged = true;
                if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) { error_log( '[AegisBackup][TableRestore][FATAL] ' . ( isset( $e['message'] ) ? (string) $e['message'] : '' ) . ' in ' . ( isset( $e['file'] ) ? (string) $e['file'] : '' ) . ':' . ( isset( $e['line'] ) ? (int) $e['line'] : 0 ) ); } // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug only.
            }
        } );

        $res = $this->plugin->table_backup->start_restore_job( $id );
        $ok  = ! empty( $res['ok'] );
        $job = ! empty( $res['job_id'] ) ? sanitize_key( (string) $res['job_id'] ) : '';

        if ( $ok && $job ) {
            $start = microtime( true );
            $time_budget = 12.0; // seconds
            $loops = 0;
            $done_now = false;

            while ( ( microtime( true ) - $start ) < $time_budget && $loops < 25 ) {
                $loops++;
                $step = $this->plugin->table_backup->process_restore_job( $job );
                if ( ! empty( $step['done'] ) ) {
                    $done_now = true;
                    break;
                }
                usleep( 80000 );
            }

            if ( ! $done_now ) {
                if ( ! wp_next_scheduled( 'aegisbackup_tablebacks_process_restore_job', array( $job ) ) ) {
                    wp_schedule_single_event( time() + 3, 'aegisbackup_tablebacks_process_restore_job', array( $job ) );
                }
            }
        }

        if ( $return ) {
            $args = array(
                'ab_msg' => $ok ? 'table_restore_started' : 'table_restore_failed',
            );
            if ( $job ) {
                $args['ab_job'] = $job;
            }
            wp_safe_redirect( add_query_arg( $args, $return ) );
            exit;
        }

        $fallback = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=table_backups' );
        wp_safe_redirect( add_query_arg( array( 'ab_msg' => $ok ? 'table_restore_started' : 'table_restore_failed' ), $fallback ) );
        exit;
    }

    public function handle_tablebacks_restore_start_wizard() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_restore_start_wizard', 'aegisbackup_tb_restore_wizard_nonce' );

        $id = isset( $_POST['id'] ) ? sanitize_text_field( (string) wp_unslash( $_POST['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }

        $return = isset( $_POST['ab_return'] ) ? esc_url_raw( (string) wp_unslash( $_POST['ab_return'] ) ) : '';
        $return = ( $return && 0 === strpos( $return, admin_url() ) ) ? $return : '';

        if ( ! $id || ! isset( $this->plugin->table_backup ) || ! $this->plugin->table_backup ) {
            wp_die( esc_html__( 'Backup not found.', 'aegisbackup' ) );
        }

        $confirm_box  = ! empty( $_POST['confirm_drop'] );
        $confirm_text = isset( $_POST['confirm_text'] ) ? strtoupper( trim( sanitize_text_field( (string) wp_unslash( $_POST['confirm_text'] ) ) ) ) : '';
        if ( ! $confirm_box || 'RESTORE' !== $confirm_text ) {
            $fallback = admin_url( 'admin.php?page=aegisbackup-restore&tab=restore&ab_wizard=1&ab_kind=table_backup&id=' . rawurlencode( $id ) );
            if ( $return ) {
                $fallback = add_query_arg( array( 'ab_return' => $return ), $fallback );
            }
            wp_safe_redirect( add_query_arg( array( 'ab_msg' => 'confirm_required' ), $fallback ) );
            exit;
        }

        $ab_tb_restore_fatal_logged = false;
        $ab_tb_restore_job_id = '';
        register_shutdown_function( function() use ( &$ab_tb_restore_fatal_logged, &$ab_tb_restore_job_id ) {
            if ( $ab_tb_restore_fatal_logged ) {
                return;
            }
            $e = error_get_last();
            if ( empty( $e ) || empty( $e['type'] ) ) {
                return;
            }
            $fatal_types = array( E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR, E_USER_ERROR );
            if ( in_array( (int) $e['type'], $fatal_types, true ) ) {
                $ab_tb_restore_fatal_logged = true;
                $msg = '[AegisBackup][TableRestoreWizard][FATAL] ' . ( isset( $e['message'] ) ? (string) $e['message'] : '' ) . ' in ' . ( isset( $e['file'] ) ? (string) $e['file'] : '' ) . ':' . ( isset( $e['line'] ) ? (int) $e['line'] : 0 );
                if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) { error_log( $msg ); } // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug only.

                $line = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] [TableRestore ' . ( $ab_tb_restore_job_id ? (string) $ab_tb_restore_job_id : 'wizard' ) . '] ' . $msg;
                $logs = get_option( 'aegisbackup_logs', array() );
                if ( ! is_array( $logs ) ) {
                    $logs = array();
                }
                $logs[] = $line;
                if ( count( $logs ) > 1500 ) {
                    $logs = array_slice( $logs, -1200 );
                }
                update_option( 'aegisbackup_logs', $logs, false );
            }
        } );

        $res = $this->plugin->table_backup->start_restore_job( $id );
        $ok  = ! empty( $res['ok'] );
        $job = ! empty( $res['job_id'] ) ? sanitize_key( (string) $res['job_id'] ) : '';
        $ab_tb_restore_job_id = $job;

        if ( $ok && $job ) {
            $started = microtime( true );
            $time_limit = 12.0; // seconds (best effort)
            $loops = 0;

            do {
                $loops++;
                $step = $this->plugin->table_backup->process_restore_job( $job );
                $done = ! empty( $step['done'] );
                if ( $done ) {
                    break;
                }
            } while ( ( microtime( true ) - $started ) < $time_limit && $loops < 20 );

            if ( empty( $done ) ) {
                if ( ! wp_next_scheduled( 'aegisbackup_tablebacks_process_restore_job', array( $job ) ) ) {
                    wp_schedule_single_event( time() + 3, 'aegisbackup_tablebacks_process_restore_job', array( $job ) );
                }
            }
        }

        $wizard = admin_url( 'admin.php?page=aegisbackup-restore&tab=restore&ab_wizard=1&ab_kind=table_backup&id=' . rawurlencode( $id ) );
        if ( $return ) {
            $wizard = add_query_arg( array( 'ab_return' => $return ), $wizard );
        }
        $msg = ( $ok && ! empty( $done ) ) ? 'table_restore_done' : ( $ok ? 'table_restore_started' : 'table_restore_failed' );
        $wizard = add_query_arg( array( 'ab_msg' => $msg ), $wizard );
        wp_safe_redirect( $wizard );
        exit;

        $fallback = admin_url( 'admin.php?page=aegisbackup&tab=db&dbtab=table_backups' );
        wp_safe_redirect( add_query_arg( array( 'ab_msg' => $ok ? 'table_restore_started' : 'table_restore_failed' ), $fallback ) );
        exit;
    }

    public function cron_tablebacks_process_restore_job( $job_id ) {
        $job_id = sanitize_key( (string) $job_id );
        if ( ! $job_id || ! isset( $this->plugin->table_backup ) || ! $this->plugin->table_backup ) {
            return;
        }

        $step = $this->plugin->table_backup->process_restore_job( $job_id );
        $done = ! empty( $step['done'] );

        if ( ! $done ) {
            if ( ! wp_next_scheduled( 'aegisbackup_tablebacks_process_restore_job', array( $job_id ) ) ) {
                wp_schedule_single_event( time() + 5, 'aegisbackup_tablebacks_process_restore_job', array( $job_id ) );
            }
        }
    }
    public function handle_tablebacks_plan_download() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_plan_download' );

        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        $plan = $mgr ? $mgr->get_plan( $id ) : null;
        if ( empty( $plan ) ) {
            wp_die( esc_html__( 'Schedule not found.', 'aegisbackup' ) );
        }

        if ( function_exists( 'nocache_headers' ) ) {
            nocache_headers();
        }
        header( 'Content-Type: application/json; charset=utf-8' );
        header( 'Content-Disposition: attachment; filename="aegisbackup-table-backup-schedule-' . $id . '.json"' );
        echo wp_json_encode( $plan, JSON_PRETTY_PRINT );
        exit;
    }

    public function handle_tablebacks_plan_delete() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_plan_delete' );

        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        if ( $mgr && '' !== $id ) {
            $mgr->delete_plan( $id );
        }

        $this->dbtools_redirect( 'table_backups' );
    }

    public function handle_tablebacks_plan_run_now() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_plan_run_now' );

        $uid = function_exists( 'get_current_user_id' ) ? (int) get_current_user_id() : 0;
        $notice_key = 'aegisbackup_tb_notice_' . $uid;

        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;

        $msg = 'Failed to run schedule.';
        if ( $mgr && '' !== $id && method_exists( $mgr, 'run_plan_now' ) ) {
            $res = $mgr->run_plan_now( $id );

            if ( is_array( $res ) ) {
                $msg = isset( $res['message'] ) ? (string) $res['message'] : '';
            }
            if ( '' === $msg ) {
                $msg = ! empty( $res['ok'] ) ? 'Schedule started.' : 'Failed to run schedule.';
            }
        } else {
            $msg = 'Schedule not found.';
        }

        if ( $uid > 0 ) {
            set_transient( $notice_key, $msg, 5 * MINUTE_IN_SECONDS );
        }

        $this->dbtools_redirect( 'table_backups' );
    }

    public function handle_tablebacks_backup_delete() {
        if ( ! current_user_can( 'manage_options' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_tablebacks_backup_delete' );

        $uid = function_exists( 'get_current_user_id' ) ? (int) get_current_user_id() : 0;
        $notice_key = 'aegisbackup_tb_notice_' . $uid;
        $id = isset( $_GET['id'] ) ? sanitize_text_field( (string) wp_unslash( $_GET['id'] ) ) : '';
        if ( $id && ! preg_match( '/^[A-Za-z0-9._-]+$/', $id ) ) {
            $id = '';
        }
        $mgr = isset( $this->plugin->table_backup ) ? $this->plugin->table_backup : null;
        if ( $mgr && '' !== $id && method_exists( $mgr, 'delete_backup' ) ) {
            $mgr->delete_backup( $id );
            if ( $uid > 0 ) {
                set_transient( $notice_key, 'Backup deleted.', 5 * MINUTE_IN_SECONDS );
            }
        }

		$return = isset( $_GET['return'] ) ? esc_url_raw( (string) wp_unslash( $_GET['return'] ) ) : '';
		if ( $return && 0 === strpos( $return, admin_url() ) ) {
			wp_safe_redirect( add_query_arg( array( 'ab_msg' => 'tb_deleted' ), $return ) );
			exit;
		}

$this->dbtools_redirect( 'table_backups' );
    }

	public function maybe_dispatch_restore_jobs() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}
		if ( wp_doing_ajax() ) {
			return;
		}

		$lock_key = 'aegisbackup_restore_dispatch_lock';
		if ( get_transient( $lock_key ) ) {
			return;
		}
		set_transient( $lock_key, 1, 20 );

		try {
			$rm = isset( $this->plugin->restore_manager ) ? $this->plugin->restore_manager : null;
			if ( ! $rm || ! is_object( $rm ) || ! method_exists( $rm, 'process_restore_job' ) ) {
				delete_transient( $lock_key );
				return;
			}

			$index = get_option( \AegisBackup\Restore\AB_Restore_Manager::JOBS_INDEX_OPTION, array() );
			if ( ! is_array( $index ) || empty( $index ) ) {
				delete_transient( $lock_key );
				return;
			}

			$job_id = '';
			$best_updated = 0;
			foreach ( $index as $jid => $meta ) {
				if ( empty( $meta['job_id'] ) ) {
					continue;
				}
				if ( empty( $meta['status'] ) || 'running' !== (string) $meta['status'] ) {
					continue;
				}
				$u = isset( $meta['updated'] ) ? (int) $meta['updated'] : 0;
				if ( $u >= $best_updated ) {
					$best_updated = $u;
					$job_id = (string) $meta['job_id'];
				}
			}

			if ( '' === $job_id ) {
				delete_transient( $lock_key );
				return;
			}

			$opt_key = \AegisBackup\Restore\AB_Restore_Manager::JOB_OPTION_PREFIX . $job_id;
			$state = get_option( $opt_key, array() );
			$updated = ( is_array( $state ) && isset( $state['updated'] ) ) ? (int) $state['updated'] : 0;
			if ( $updated && ( time() - $updated ) < 15 ) {
				delete_transient( $lock_key );
				return;
			}

			$rm->process_restore_job( $job_id );
		} catch ( \Throwable $e ) {
		}

		delete_transient( $lock_key );
	}

	private function pp_append_destination_log( $line ) {
		$line = (string) $line;
		if ( '' === trim( $line ) ) {
			return;
		}
		$opt = get_option( 'aegisbackup_pp_destination_live_log', array() );
		if ( ! is_array( $opt ) ) {
			$opt = array();
		}
		$opt[] = $line;
		$max = 400;
		if ( count( $opt ) > $max ) {
			$opt = array_slice( $opt, -$max );
		}
		update_option( 'aegisbackup_pp_destination_live_log', $opt, false );
	}

		/**
		 * Extract a ZIP to a destination folder with fallbacks.
		 *
		 * On some hosts, unzip_file() can fail with "Could not access filesystem".
		 * We try (1) unzip_file (WP_Filesystem), then (2) ZipArchive, then (3) PclZip.
		 *
		 * @param string $zip_path Absolute path to ZIP.
		 * @param string $dest_dir Destination directory.
		 * @return true|\WP_Error
		 */
		private function pp_extract_zip_fallback( $zip_path, $dest_dir ) {
			$zip_path = (string) $zip_path;
			$dest_dir = (string) $dest_dir;
			if ( '' === $zip_path || '' === $dest_dir ) {
				return new \WP_Error( 'ab_pp_extract_invalid', 'Invalid ZIP extraction parameters.' );
			}
			if ( ! is_file( $zip_path ) ) {
				return new \WP_Error( 'ab_pp_extract_missing', 'ZIP file not found.' );
			}
			if ( ! is_dir( $dest_dir ) ) {
				wp_mkdir_p( $dest_dir );
			}
			if ( ! is_dir( $dest_dir ) ) {
				return new \WP_Error( 'ab_pp_extract_dest', 'Unable to create destination directory.' );
			}

			$errors = array();

			// 1) WordPress unzip_file() (uses WP_Filesystem).
			if ( ! function_exists( 'unzip_file' ) ) {
				require_once ABSPATH . 'wp-admin/includes/file.php';
			}
			$unzip_res = unzip_file( $zip_path, $dest_dir );
			if ( ! is_wp_error( $unzip_res ) ) {
				return true;
			}
			$errors[] = $unzip_res->get_error_message();

			// 2) ZipArchive fallback.
			if ( class_exists( 'ZipArchive' ) ) {
				$za = new \ZipArchive();
				$open = $za->open( $zip_path );
				if ( true === $open ) {
					$ok = $za->extractTo( $dest_dir );
					$za->close();
					if ( $ok ) {
						return true;
					}
					$errors[] = 'ZipArchive extractTo() failed.';
				} else {
					$errors[] = 'ZipArchive open() failed.';
				}
			}

			// 3) PclZip fallback (bundled with WP).
			if ( ! class_exists( 'PclZip' ) ) {
				require_once ABSPATH . 'wp-admin/includes/class-pclzip.php';
			}
			if ( class_exists( 'PclZip' ) ) {
				$archive = new \PclZip( $zip_path );
				$extracted = $archive->extract( PCLZIP_OPT_PATH, $dest_dir, PCLZIP_OPT_REPLACE_NEWER );
				if ( 0 !== (int) $extracted ) {
					return true;
				}
				$errors[] = method_exists( $archive, 'errorInfo' ) ? (string) $archive->errorInfo( true ) : 'PclZip extract failed.';
			}

			return new \WP_Error( 'ab_pp_extract_failed', 'Unable to extract ZIP: ' . implode( ' | ', array_filter( $errors ) ) );
		}

    public function handle_delete_dr_token() {
        if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_delete_dr_token', 'ab_dr_del_nonce' );

        $token = isset( $_GET['token'] ) ? sanitize_text_field( wp_unslash( $_GET['token'] ) ) : '';
		if ( '' === $token ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration&ab_err=dr_delete_missing' ) );
            exit;
        }

        $mgr = $this->plugin->backup;
        $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : '';
		if ( ! $tokens_file || ! is_file( $tokens_file ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration&ab_err=dr_tokens_missing' ) );
            exit;
        }

        $raw = @file_get_contents( $tokens_file );
        $tokens = json_decode( (string) $raw, true );
        if ( ! is_array( $tokens ) ) {
            $tokens = array();
        }

        $rec = isset( $tokens[ $token ] ) && is_array( $tokens[ $token ] ) ? $tokens[ $token ] : array();
        unset( $tokens[ $token ] );
        @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );

        if ( ! empty( $rec['package'] ) ) {
            $pkg = (string) $rec['package'];
            $base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
            if ( $base ) {
                $dir = trailingslashit( $base ) . $pkg;
                if ( is_dir( $dir ) ) {
                    $this->rrmdir_best_effort( $dir );
                }
            }
        }

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration&ab_msg=dr_deleted' ) );
        exit;
    }

    private function rrmdir_best_effort( $dir ) {
        $dir = (string) $dir;
        if ( ! is_dir( $dir ) ) {
            return;
        }
        $items = @scandir( $dir );
        if ( ! is_array( $items ) ) {
            return;
        }
        foreach ( $items as $item ) {
            if ( '.' === $item || '..' === $item ) {
                continue;
            }
            $path = $dir . '/' . $item;
            if ( is_dir( $path ) ) {
                $this->rrmdir_best_effort( $path );
            } else {
                wp_delete_file(  $path  );
            }
        }
        @rmdir( $dir ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.
    }

public function handle_generate_dr_link() {
        if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
            wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
        }
        check_admin_referer( 'aegisbackup_generate_dr_link', 'ab_dr_nonce' );

        $mgr = $this->plugin->backup;

        $include_files    = ! empty( $_POST['dr_include_files'] );
        $include_db       = ! empty( $_POST['dr_include_db'] );
        $include_htaccess = ! empty( $_POST['dr_include_htaccess'] );
        $include_config   = ! empty( $_POST['dr_include_config'] );
        $include_core     = ! empty( $_POST['dr_include_core'] );

        $dr_base = method_exists( $mgr, 'get_dr_base_dir' ) ? $mgr->get_dr_base_dir() : '';
        if ( empty( $dr_base ) ) {
            $upload = wp_upload_dir();
            $dr_base = trailingslashit( $upload['basedir'] ) . 'aegisbackup-dr';
        }
        wp_mkdir_p( $dr_base );

        $recovery_dir = trailingslashit( ABSPATH ) . 'aegisbackup-recovery';
        if ( ! is_dir( $recovery_dir ) ) {
            @wp_mkdir_p( $recovery_dir );
        }

        $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : trailingslashit( $dr_base ) . 'dr-tokens.json';

        $endpoint = trailingslashit( $recovery_dir ) . 'index.php';
        if ( ! is_file( $endpoint ) ) {
            $this->write_dr_recovery_endpoint( $endpoint, $tokens_file );
        }

        $token = wp_generate_password( 26, false, false );
        $link  = trailingslashit( site_url() ) . 'aegisbackup-recovery/?token=' . rawurlencode( $token );

        $args = array(
            'include_files'    => $include_files ? 1 : 0,
            'include_db'       => $include_db ? 1 : 0,
            'include_htaccess' => $include_htaccess ? 1 : 0,
            'include_config'   => $include_config ? 1 : 0,
            'include_core'     => $include_core ? 1 : 0,
            'backup_type'      => 'full',
            'package_purpose'  => 'dr',
            'snapshot'         => 1,
            'db_export_mode'   => 'auto',
            'base_dir'         => $dr_base,
        );

        $job = $mgr->start_backup_job( $args );
        if ( empty( $job['job_id'] ) ) {
			wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration&ab_err=dr_start_failed' ) );
            exit;
        }

        $job_id  = (string) $job['job_id'];
        $zip_path = ! empty( $job['zip_path'] ) ? (string) $job['zip_path'] : '';

        $rec = array(
            'created' => time(),
            'status'  => 'building',
            'job_id'  => $job_id,
            'zip_path'=> $zip_path,
            'package' => $zip_path ? basename( dirname( $zip_path ) ) : '',
            'link'    => $link,
            'opts'    => array(
                'include_files'    => $include_files ? 1 : 0,
                'include_db'       => $include_db ? 1 : 0,
                'include_htaccess' => $include_htaccess ? 1 : 0,
                'include_config'   => $include_config ? 1 : 0,
                'include_core'     => $include_core ? 1 : 0,
            ),
        );

        $tokens = array();
        if ( is_file( $tokens_file ) ) {
            $raw = @file_get_contents( $tokens_file );
            $tmp = json_decode( (string) $raw, true );
            if ( is_array( $tmp ) ) {
                $tokens = $tmp;
            }
        }
        $tokens[ $token ] = $rec;

        @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );

        if ( ! wp_next_scheduled( 'aegisbackup_dr_process_job', array( $job_id ) ) ) {
            wp_schedule_single_event( time() + 5, 'aegisbackup_dr_process_job', array( $job_id ) );
        }

		wp_safe_redirect( admin_url( 'admin.php?page=aegisbackup&tab=migration&ab_msg=dr_created' ) );
        exit;
    }

    public function cron_dr_process_job( $job_id ) {
        $job_id = (string) $job_id;
        if ( empty( $job_id ) ) {
            return;
        }

        $mgr = $this->plugin->backup;
        $step = $mgr->process_backup_job( $job_id );
        $done = ( is_array( $step ) && ! empty( $step['done'] ) );
        $tokens_file = method_exists( $mgr, 'get_dr_tokens_file' ) ? $mgr->get_dr_tokens_file() : '';
        if ( $tokens_file && is_file( $tokens_file ) ) {
            $raw = @file_get_contents( $tokens_file );
            $tokens = json_decode( (string) $raw, true );
            if ( is_array( $tokens ) ) {
                $changed = false;
                foreach ( $tokens as $tok => $rec ) {
                    if ( ! empty( $rec['job_id'] ) && (string) $rec['job_id'] === $job_id ) {
                        $tokens[ $tok ]['status'] = $done ? 'ready' : 'building';
                        $changed = true;
                    }
                }
                if ( $changed ) {
                    @file_put_contents( $tokens_file, wp_json_encode( $tokens ) );
                }
            }
        }

        if ( ! $done ) {
            wp_schedule_single_event( time() + 10, 'aegisbackup_dr_process_job', array( $job_id ) );
        }
    }

    private function write_dr_recovery_endpoint( $endpoint_path, $tokens_file ) {
        $endpoint_path = (string) $endpoint_path;
        $tokens_file   = (string) $tokens_file;

        $php = implode( "\n", array(
            '<?php',
            '/**',
            ' * AegisBackup DR Mode v2 – Standalone Recovery Endpoint',
            ' * URL: /aegisbackup-recovery/?token=...',
            ' *',
            ' * This file intentionally does NOT bootstrap WordPress.',
            ' */',
            '@set_time_limit( 0 );',
            '@ini_set( \'memory_limit\', \'512M\' );',
            '',
            'function ab_html( $s ) { return htmlspecialchars( (string) $s, ENT_QUOTES, \'UTF-8\' ); }',
            '',
            '$root = dirname( __DIR__ );',
            '$tokens_file = \'__TOKENS_FILE__\';',
            '',
            '// Allow override if tokens file moved.',
            'if ( isset( $_GET[\'tokens\'] ) && $_GET[\'tokens\'] ) {',
            '    $cand = (string) $_GET[\'tokens\'];',
            '    if ( strpos( $cand, \'..\' ) === false && is_file( $cand ) ) {',
            '        $tokens_file = $cand;',
            '    }',
            '}',
            '',
            '$token = isset( $_GET[\'token\'] ) ? (string) $_GET[\'token\'] : \'\';',
            '$tokens = array();',
            'if ( is_file( $tokens_file ) ) {',
            '    $raw = @file_get_contents( $tokens_file );',
            '    $tmp = json_decode( (string) $raw, true );',
            '    if ( is_array( $tmp ) ) { $tokens = $tmp; }',
            '}',
            '',
            'if ( ! $token || empty( $tokens[ $token ] ) ) {',
            '    header( \'Content-Type: text/html; charset=utf-8\' );',
            '    echo \'<h2>AegisBackup – DR Recovery</h2>\';',
            '    echo \'<p>Invalid or missing token.</p>\';',
            '    exit;',
            '}',
            '',
            '$rec = $tokens[ $token ];',
            '$zip = ! empty( $rec[\'zip_path\'] ) ? (string) $rec[\'zip_path\'] : \'\';',
            '$status = ! empty( $rec[\'status\'] ) ? (string) $rec[\'status\'] : \'unknown\';',
            '$opts = ! empty( $rec[\'opts\'] ) && is_array( $rec[\'opts\'] ) ? $rec[\'opts\'] : array();',
            '',
            '$log_dir = dirname( $tokens_file ) . \'/logs\';',
            'if ( ! is_dir( $log_dir ) ) { @mkdir( $log_dir, 0755, true ); }',
            '$log_file = $log_dir . \'/dr-\' . preg_replace( \'/[^a-zA-Z0-9_-]/\', \'\', $token ) . \'.log\';',
            '',
            'function ab_log( $file, $msg ) {',
            '    $line = \'[\' . gmdate(\'Y-m-d H:i:s\') . \' UTC] \' . $msg . "\\n";',
            '    @file_put_contents( $file, $line, FILE_APPEND );',
            '}',
            '',
            'function ab_rrmdir( $dir ) {',
            '    if ( ! is_dir( $dir ) ) return;',
            '    $it = new RecursiveIteratorIterator(',
            '        new RecursiveDirectoryIterator( $dir, FilesystemIterator::SKIP_DOTS ),',
            '        RecursiveIteratorIterator::CHILD_FIRST',
            '    );',
            '    foreach ( $it as $f ) {',
            '        $p = $f->getRealPath();',
            '        if ( $f->isDir() ) { @rmdir( $p  ); } else { wp_delete_file(  $p  ); } // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.',
            '    }',
            '    @rmdir( $dir ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_rmdir -- Legacy fallback.',
            '}',
            '',
            'function ab_rcopy( $src, $dst, $skip = array() ) {',
            '    $src = rtrim( $src, \'/\\\\\' );',
            '    $dst = rtrim( $dst, \'/\\\\\' );',
            '    if ( is_file( $src ) ) {',
            '        if ( ! is_dir( dirname( $dst ) ) ) { @mkdir( dirname( $dst ), 0755, true ); }',
            '        @copy( $src, $dst );',
            '        return;',
            '    }',
            '    if ( ! is_dir( $src ) ) { return; }',
            '    $it = new RecursiveIteratorIterator(',
            '        new RecursiveDirectoryIterator( $src, FilesystemIterator::SKIP_DOTS ),',
            '        RecursiveIteratorIterator::SELF_FIRST',
            '    );',
            '    foreach ( $it as $f ) {',
            '        $p = $f->getPathname();',
            '        $rel = ltrim( str_replace( $src, \'\', $p ), \'/\\\\\' );',
            '',
            '        foreach ( $skip as $sk ) {',
            '            if ( $rel === $sk || strpos( $rel, $sk . \'/\' ) === 0 ) {',
            '                continue 2;',
            '            }',
            '        }',
            '',
            '        $target = $dst . DIRECTORY_SEPARATOR . $rel;',
            '        if ( $f->isDir() ) {',
            '            if ( ! is_dir( $target ) ) { @mkdir( $target, 0755, true ); }',
            '        } else {',
            '            if ( ! is_dir( dirname( $target ) ) ) { @mkdir( dirname( $target ), 0755, true ); }',
            '            @copy( $p, $target );',
            '        }',
            '    }',
            '}',
            '',
            'function ab_parse_wp_config( $path ) {',
            '    $out = array();',
            '    if ( ! is_file( $path ) ) return $out;',
            '    $c = @file_get_contents( $path );',
            '    if ( ! $c ) return $out;',
            '    foreach ( array(\'DB_NAME\',\'DB_USER\',\'DB_PASSWORD\',\'DB_HOST\') as $k ) {',
            '        if ( preg_match( "/define\\s*\\(\\s*[\'\\"]" . preg_quote($k,\'/\') . "[\'\\"]\\s*,\\s*[\'\\"]([^\'\\"]*)[\'\\"]\\s*\\)/", $c, $m ) ) {',
            '            $out[ $k ] = $m[1];',
            '        }',
            '    }',
            '    return $out;',
            '}',
            '',
            'function ab_import_sql_mysqli( $sql_file, $db, $log_file ) {',
            '    if ( ! is_file( $sql_file ) ) {',
            '        ab_log( $log_file, \'DB restore skipped: SQL file missing: \' . $sql_file );',
            '        return false;',
            '    }',
            '    $cfg = ab_parse_wp_config( $db[\'wp_config\'] );',
            '    if ( empty( $cfg[\'DB_NAME\'] ) ) {',
            '        ab_log( $log_file, \'DB restore failed: could not parse wp-config.php DB constants.\' );',
            '        return false;',
            '    }',
            '    $mysqli = @new mysqli( $cfg[\'DB_HOST\'], $cfg[\'DB_USER\'], $cfg[\'DB_PASSWORD\'], $cfg[\'DB_NAME\'] );',
            '    if ( $mysqli->connect_error ) {',
            '        ab_log( $log_file, \'DB restore failed: mysqli connect error: \' . $mysqli->connect_error );',
            '        return false;',
            '    }',
            '    $mysqli->set_charset( \'utf8mb4\' );',
            '',
            '    ab_log( $log_file, \'DB restore: importing \' . $sql_file );',
            '    $fh = fopen( $sql_file, \'r\' );',
            '    if ( ! $fh ) {',
            '        ab_log( $log_file, \'DB restore failed: cannot open SQL file.\' );',
            '        return false;',
            '    }',
            '',
            '    $query = \'\';',
            '    $count = 0;',
            '    while ( ( $line = fgets( $fh ) ) !== false ) {',
            '        $trim = trim( $line );',
            '        if ( $trim === \'\' ) continue;',
            '        if ( strpos( $trim, \'--\' ) === 0 || strpos( $trim, \'/*\' ) === 0 ) continue;',
            '',
            '        $query .= $line;',
            '        if ( substr( rtrim( $trim ), -1 ) === \';\' ) {',
            '            if ( ! $mysqli->query( $query ) ) {',
            '                ab_log( $log_file, \'DB query error: \' . $mysqli->error );',
            '            }',
            '            $query = \'\';',
            '            $count++;',
            '            if ( $count % 200 === 0 ) {',
            '                ab_log( $log_file, \'DB restore progress: executed \' . $count . \' statements...\' );',
            '            }',
            '        }',
            '    }',
            '    fclose( $fh );',
            '    ab_log( $log_file, \'DB restore done: statements=\' . $count );',
            '    $mysqli->close();',
            '    return true;',
            '}',
            '',
            '$do = isset( $_POST[\'do_restore\'] ) ? (string) $_POST[\'do_restore\'] : \'\';',
            '$confirm = isset( $_POST[\'confirm\'] ) ? (string) $_POST[\'confirm\'] : \'\';',
            '',
            'header( \'Content-Type: text/html; charset=utf-8\' );',
            'echo \'<h2>AegisBackup – DR Recovery</h2>\';',
            'echo \'<p>Status: <strong>\' . ab_html( $status ) . \'</strong></p>\';',
            'echo \'<p>Package: <code>\' . ab_html( $zip ) . \'</code></p>\';',
            '',
            'if ( $do === \'1\' ) {',
            '    if ( $confirm !== \'RESTORE\' ) {',
            '        echo \'<div style="padding:10px;border:1px solid #c00;background:#fff0f0;margin:10px 0;">You must type RESTORE to confirm.</div>\';',
            '    } else {',
            '        ab_log( $log_file, \'DR restore started.\' );',
            '',
            '        if ( ! is_file( $zip ) ) {',
            '            ab_log( $log_file, \'Zip not found. Abort.\' );',
            '            echo \'<p><strong>Zip not found on server.</strong></p>\';',
            '        } else {',
            '            $tmp = sys_get_temp_dir() . \'/ab_dr_\' . substr( md5( $token . microtime(true) ), 0, 10 );',
            '            @mkdir( $tmp, 0755, true );',
            '',
            '            $za = new ZipArchive();',
            '            $ok = $za->open( $zip );',
            '            if ( $ok !== true ) {',
            '                ab_log( $log_file, \'Zip open failed: \' . $ok );',
            '                echo \'<p><strong>Zip open failed.</strong></p>\';',
            '            } else {',
            '                ab_log( $log_file, \'Extracting zip to temp: \' . $tmp );',
            '                $za->extractTo( $tmp );',
            '                $za->close();',
            '',
            '                // Restore files',
            '                if ( ! empty( $opts[\'include_files\'] ) ) {',
            '                    $src = $tmp . \'/wp-content\';',
            '                    $dst = $root . \'/wp-content\';',
            '                    ab_log( $log_file, \'Restoring wp-content...\' );',
            '                    ab_rcopy( $src, $dst, array( \'uploads/aegisbackup\', \'uploads/aegisbackup-dr\' ) );',
            '                }',
            '',
            '                // Restore .htaccess',
            '                if ( ! empty( $opts[\'include_htaccess\'] ) && is_file( $tmp . \'/.htaccess\' ) ) {',
            '                    ab_log( $log_file, \'Restoring .htaccess...\' );',
            '                    @copy( $tmp . \'/.htaccess\', $root . \'/.htaccess\' );',
            '                }',
            '',
            '                // Restore wp-config.php (optional)',
            '                if ( ! empty( $opts[\'include_config\'] ) && is_file( $tmp . \'/wp-config.php\' ) ) {',
            '                    ab_log( $log_file, \'Restoring wp-config.php...\' );',
            '                    @copy( $tmp . \'/wp-config.php\', $root . \'/wp-config.php\' );',
            '                }',
            '',
            '                // Restore WordPress core (optional)',
            '                if ( ! empty( $opts[\'include_core\'] ) ) {',
            '                    ab_log( $log_file, \'Restoring WordPress core...\' );',
            '                    // Copy all extracted root files/dirs EXCEPT wp-content and db',
            '                    $skip = array( \'wp-content\', \'db\' );',
            '                    foreach ( scandir( $tmp ) as $entry ) {',
            '                        if ( $entry === \'.\' || $entry === \'..\' ) continue;',
            '                        if ( in_array( $entry, $skip, true ) ) continue;',
            '                        ab_rcopy( $tmp . \'/\' . $entry, $root . \'/\' . $entry, array() );',
            '                    }',
            '                }',
            '',
            '                // Restore DB',
            '                if ( ! empty( $opts[\'include_db\'] ) ) {',
            '                    $cfg_path = $root . \'/wp-config.php\';',
            '                    ab_import_sql_mysqli( $tmp . \'/db/db.sql\', array( \'wp_config\' => $cfg_path ), $log_file );',
            '                }',
            '',
            '                ab_log( $log_file, \'DR restore finished.\' );',
            '                ab_rrmdir( $tmp );',
            '            }',
            '        }',
            '    }',
            '}',
            '',
            'echo \'<hr>\';',
            'echo \'<form method="post">\';',
            'echo \'<p><strong>WARNING:</strong> This will overwrite files and database in-place.</p>\';',
            'echo \'<p><label>Type <code>RESTORE</code> to confirm: <input name="confirm" value="" /></label></p>\';',
            'echo \'<p><input type="hidden" name="do_restore" value="1" /><button type="submit">Start Restore</button></p>\';',
            'echo \'</form>\';',
            '',
            'echo \'<h3>Logs</h3>\';',
            'if ( is_file( $log_file ) ) {',
            '    echo \'<pre style="max-height:360px;overflow:auto;background:#f7f7f7;padding:10px;">\' . ab_html( file_get_contents( $log_file ) ) . \'</pre>\';',
            '} else {',
            '    echo \'<p>No logs yet.</p>\';',
            '}'
        ) ) . "\n";

        $php = str_replace( '__TOKENS_FILE__', addslashes( $tokens_file ), $php );
        @file_put_contents( $endpoint_path, $php );
        $fs = $this->ab_filesystem();
        if ( $fs && method_exists( $fs, 'chmod' ) ) {
        	$fs->chmod( $endpoint_path, 0644 );
        } else {
        	chmod( $endpoint_path, 0644 ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_system_operations_chmod -- Fallback only.
        }

        $ht = trailingslashit( dirname( $endpoint_path ) ) . '.htaccess';
        if ( ! is_file( $ht ) ) {
            @file_put_contents( $ht, "DirectoryIndex index.php\n" );
        }
    }

    private function ab_debug_job_log( $job_id, $message ) {
        $job_id = (string) $job_id;
        $msg = '[' . gmdate( 'Y-m-d H:i:s' ) . ' UTC] ' . ( $job_id ? ('job=' . $job_id . ' ') : '' ) . (string) $message;

        $logs = get_option( 'aegisbackup_backup_debug', array() );
        if ( ! is_array( $logs ) ) {
            $logs = array();
        }
        $logs[] = $msg;
        $logs = array_slice( $logs, -800 );
        update_option( 'aegisbackup_backup_debug', $logs, false );

        $upload = wp_upload_dir();
        $dir = trailingslashit( (string) $upload['basedir'] ) . 'aegisbackup/logs/backup-jobs';
        if ( ! is_dir( $dir ) ) {
            @wp_mkdir_p( $dir );
        }
        $safe = $job_id ? preg_replace( '/[^a-zA-Z0-9_\-]/', '', $job_id ) : 'unknown';
        $file = trailingslashit( $dir ) . 'job-' . $safe . '.log';
        @file_put_contents( $file, $msg . "\n", FILE_APPEND );

        if ( defined( 'WP_DEBUG' ) && WP_DEBUG ) { @error_log( 'AegisBackup DEBUG: ' . $msg ); } // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug only.
    }

}
