<?php
namespace AegisBackup\Admin\Pages;

use AegisBackup\AB_Plugin;

defined( 'ABSPATH' ) || exit;

class AB_Page_Migration_Wizard {
	protected $plugin;

	public function __construct( AB_Plugin $plugin ) {
		$this->plugin = $plugin;
	}

	public function render() {
		if ( ! current_user_can( 'manage_options' ) && ! current_user_can( 'aegisbackup_manage_backups' ) ) {
			wp_die( esc_html__( 'Insufficient permissions.', 'aegisbackup' ), 403 );
		}

		require_once AEGISBACKUP_DIR . 'includes/migrationwizard/class-ab-mw-installer.php';

		$notice = array();

		// Handle enable/disable toggle.
		if ( isset( $_POST['ab_mw_toggle_action'] ) ) {
			check_admin_referer( 'ab_mw_toggle_action', 'ab_mw_toggle_nonce' );

			$action = sanitize_key( wp_unslash( $_POST['ab_mw_toggle_action'] ) );

			if ( 'enable' === $action ) {
				\AegisBackup\MigrationWizard\AB_MW_Installer::install();

				$notice = array(
					'type' => 'success',
					'text' => __( 'Migration Wizard runner ENABLED. The /aegismw/ folder has been created/copied into your site root.', 'aegisbackup' ),
				);
			} elseif ( 'disable' === $action ) {
				\AegisBackup\MigrationWizard\AB_MW_Installer::uninstall();

				$still_there = \AegisBackup\MigrationWizard\AB_MW_Installer::is_installed();
				$notice      = array(
					'type' => $still_there ? 'error' : 'success',
					'text' => $still_there
						? __( 'Disable attempted, but /aegismw/ still appears to exist. Check filesystem permissions and delete ABSPATH/aegismw manually.', 'aegisbackup' )
						: __( 'Migration Wizard runner DISABLED. The /aegismw/ folder has been removed from your site root.', 'aegisbackup' ),
				);
			}
		}

		$enabled   = \AegisBackup\MigrationWizard\AB_MW_Installer::is_enabled();
		$installed = \AegisBackup\MigrationWizard\AB_MW_Installer::is_installed();

		// If enabled but missing, (re)install it.
		if ( $enabled && ! $installed ) {
			\AegisBackup\MigrationWizard\AB_MW_Installer::ensure_installed();
			$installed = \AegisBackup\MigrationWizard\AB_MW_Installer::is_installed();
		}

		$url  = \AegisBackup\MigrationWizard\AB_MW_Installer::get_runner_url();
		$path = \AegisBackup\MigrationWizard\AB_MW_Installer::get_runner_path();

		?>
		<div class="wrap">
			<h1><?php esc_html_e( 'Migration Wizard', 'aegisbackup' ); ?></h1>

			<?php if ( ! empty( $notice ) ) : ?>
				<div class="notice notice-<?php echo esc_attr( $notice['type'] ); ?>">
					<p><?php echo esc_html( $notice['text'] ); ?></p>
				</div>
			<?php endif; ?>

			<div class="notice notice-warning">
				<p>
					<strong><?php esc_html_e( 'Security Warning:', 'aegisbackup' ); ?></strong>
					<?php esc_html_e( 'Leaving the Migration Wizard runner enabled is HIGH RISK. It exposes a standalone restore runner at /aegismw/ that can be abused by attackers to damage your WordPress site. Keep it DISABLED, enable only when restoring, then disable immediately after.', 'aegisbackup' ); ?>
				</p>
			</div>

			<form method="post" style="margin: 12px 0 18px;">
				<?php wp_nonce_field( 'ab_mw_toggle_action', 'ab_mw_toggle_nonce' ); ?>

				<?php if ( $enabled && $installed ) : ?>
					<span class="dashicons dashicons-yes" style="color:#1a7f37; margin-right:6px;"></span>
					<strong style="color:#1a7f37;"><?php esc_html_e( 'Enabled', 'aegisbackup' ); ?></strong>

					<input type="hidden" name="ab_mw_toggle_action" value="disable" />
					<button type="submit" class="button button-secondary" style="margin-left:12px; border-color:#b32d2e; color:#b32d2e;">
						<?php esc_html_e( 'Disable (Remove /aegismw/)', 'aegisbackup' ); ?>
					</button>
				<?php else : ?>
					<span class="dashicons dashicons-no" style="color:#b32d2e; margin-right:6px;"></span>
					<strong style="color:#b32d2e;"><?php esc_html_e( 'Disabled', 'aegisbackup' ); ?></strong>

					<input type="hidden" name="ab_mw_toggle_action" value="enable" />
					<button type="submit" class="button button-primary" style="margin-left:12px;">
						<?php esc_html_e( 'Enable (Create /aegismw/)', 'aegisbackup' ); ?>
					</button>
				<?php endif; ?>
			</form>

			<div class="notice notice-info">
				<p><?php esc_html_e( 'This wizard restores a Full Backup (DR) package into a clean WordPress install using a standalone runner (does not load WordPress during database overwrite).', 'aegisbackup' ); ?></p>
			</div>

			<table class="widefat striped" style="max-width: 980px;">
				<tbody>
					<tr>
						<th style="width:220px;"><?php esc_html_e( 'Runner URL', 'aegisbackup' ); ?></th>
						<td><code><?php echo esc_html( $url ); ?></code></td>
					</tr>

					<tr>
						<th><?php esc_html_e( 'Report URL', 'aegisbackup' ); ?></th>
						<td><code><?php echo esc_html( home_url( '/aegismw/report/' ) ); ?></code></td>
					</tr>

					<tr>
						<th><?php esc_html_e( 'Runner Path', 'aegisbackup' ); ?></th>
						<td><code><?php echo esc_html( $path ); ?></code></td>
					</tr>
					<tr>
				</tbody>
			</table>

			<p class="description" style="max-width: 980px;">
			<p class="description" style="max-width: 980px;">
				<?php esc_html_e( 'Use the Runner URL to open the standalone runner. The Report URL shows the latest migration report.', 'aegisbackup' ); ?>
			</p>
			</p>


			<p style="margin-top: 12px;">
				<?php if ( $enabled && $installed ) : ?>
					<a class="button button-primary" href="<?php echo esc_url( $url ); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Open Runner', 'aegisbackup' ); ?></a>
				<?php else : ?>
					<a class="button button-secondary" href="#" onclick="return false;" aria-disabled="true" style="opacity:.6; pointer-events:none;">
						<?php esc_html_e( 'Open Runner (Disabled)', 'aegisbackup' ); ?>
					</a>
				<?php endif; ?>
			</p>

			<h2><?php esc_html_e( 'Latest Report', 'aegisbackup' ); ?></h2>
			<?php
			$latest_path = trailingslashit( ABSPATH ) . 'aegismw/report/latest.json';
			$latest_data = array();
			if ( is_readable( $latest_path ) ) {
				$raw = file_get_contents( $latest_path ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents
				$j   = json_decode( (string) $raw, true );
				if ( is_array( $j ) ) {
					$latest_data = $j;
				}
			}
			?>
			<?php if ( empty( $latest_data ) ) : ?>
				<p><?php esc_html_e( 'No report found yet. After running a restore, visit the Report URL or check back here.', 'aegisbackup' ); ?></p>
			<?php else : ?>
				<div class="notice <?php echo ! empty( $latest_data['ok'] ) ? 'notice-success' : 'notice-error'; ?>">
					<p>
						<strong><?php echo esc_html( $latest_data['run_id'] ?? '' ); ?></strong>
						&mdash;
						<?php echo esc_html( $latest_data['message'] ?? '' ); ?>
						<br/>
						<?php esc_html_e( 'Ended:', 'aegisbackup' ); ?>
						<?php echo esc_html( $latest_data['ended'] ?? '' ); ?>
					</p>
				</div>
			<?php endif; ?>

			<h2><?php esc_html_e( 'Recommended Flow', 'aegisbackup' ); ?></h2>
			<ol>
				<li><?php esc_html_e( 'On the SOURCE site, create a Full Backup (DR) package and download it.', 'aegisbackup' ); ?></li>
				<li><?php esc_html_e( 'On the DESTINATION clean WordPress install, install/activate AegisBackup, then open the Runner URL and upload the package.', 'aegisbackup' ); ?></li>
				<li><?php esc_html_e( 'After completion, check /wp-admin and review the report.', 'aegisbackup' ); ?></li>
			</ol>

		</div>
		<?php
	}
}