<?php
namespace AegisBackup\Libs;

defined( 'ABSPATH' ) || exit;

class AB_Activity_Log {
	const OPTION = 'aegisbackup_activity_log';

	public static function add( $type, $status, $message, $context = array() ) {
		$type   = sanitize_key( (string) $type );
		$status = sanitize_key( (string) $status );
		$message = sanitize_text_field( (string) $message );

		if ( ! is_array( $context ) ) {
			$context = array();
		}

		$entry = array(
			'ts'      => (int) current_time( 'timestamp' ),
			'type'    => $type ? $type : 'system',
			'status'  => $status ? $status : 'info',
			'message' => $message,
			'context' => $context,
		);

		$rows = get_option( self::OPTION, array() );
		if ( ! is_array( $rows ) ) {
			$rows = array();
		}

		array_unshift( $rows, $entry );

		if ( count( $rows ) > 700 ) {
			$rows = array_slice( $rows, 0, 700 );
		}

		update_option( self::OPTION, $rows, false );
	}

	public static function get( $limit = 100 ) {
		$limit = max( 1, (int) $limit );
		$rows = get_option( self::OPTION, array() );
		if ( ! is_array( $rows ) ) {
			return array();
		}
		return array_slice( $rows, 0, $limit );
	}
}
