<?php
namespace AegisBackup\Restore;

defined( 'ABSPATH' ) || exit;

class AB_Cache_Clearer {

    public function clear_local_caches() {
        $count = 0;
        $log   = array();
        $warn  = array();

        if ( function_exists( 'wp_cache_flush' ) ) {
            try {
                wp_cache_flush();
                $count++;
                $log[] = 'Cleared WordPress object cache (wp_cache_flush).';
            } catch ( \Throwable $e ) {
                $warn[] = 'Object cache flush failed: ' . $e->getMessage();
            }
        }

        if ( function_exists( 'do_action' ) ) {
            try {
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Third-party integration hook (LiteSpeed Cache).
                do_action( 'litespeed_purge_all' );
                $count++;
                $log[] = 'Requested LiteSpeed Cache purge (litespeed_purge_all).';
            } catch ( \Throwable $e ) {
                $warn[] = 'LiteSpeed purge action failed: ' . $e->getMessage();
            }
        }

        if ( function_exists( 'rocket_clean_domain' ) ) {
            try {
                rocket_clean_domain();
                $count++;
                $log[] = 'Cleared WP Rocket cache (rocket_clean_domain).';
            } catch ( \Throwable $e ) {
                $warn[] = 'WP Rocket cache clear failed: ' . $e->getMessage();
            }
        }

        if ( function_exists( 'w3tc_flush_all' ) ) {
            try {
                w3tc_flush_all();
                $count++;
                $log[] = 'Flushed W3 Total Cache (w3tc_flush_all).';
            } catch ( \Throwable $e ) {
                $warn[] = 'W3TC flush failed: ' . $e->getMessage();
            }
        }

        if ( function_exists( 'wp_cache_clear_cache' ) ) {
            try {
                wp_cache_clear_cache();
                $count++;
                $log[] = 'Cleared WP Super Cache (wp_cache_clear_cache).';
            } catch ( \Throwable $e ) {
                $warn[] = 'WP Super Cache clear failed: ' . $e->getMessage();
            }
        }

        if ( class_exists( '\Cache_Enabler' ) && method_exists( '\Cache_Enabler', 'clear_total_cache' ) ) {
            try {
                \Cache_Enabler::clear_total_cache();
                $count++;
                $log[] = 'Cleared Cache Enabler total cache.';
            } catch ( \Throwable $e ) {
                $warn[] = 'Cache Enabler clear failed: ' . $e->getMessage();
            }
        }

        if ( class_exists( '\autoptimizeCache' ) && method_exists( '\autoptimizeCache', 'clearall' ) ) {
            try {
                \autoptimizeCache::clearall();
                $count++;
                $log[] = 'Cleared Autoptimize cache.';
            } catch ( \Throwable $e ) {
                $warn[] = 'Autoptimize cache clear failed: ' . $e->getMessage();
            }
        }

        if ( function_exists( 'do_action' ) ) {
            try {
                do_action( 'aegisbackup_after_restore_clear_caches' );
                $count++;
                $log[] = 'Fired AegisBackup cache-clear hook (aegisbackup_after_restore_clear_caches).';
            } catch ( \Throwable $e ) {
                $warn[] = 'AegisBackup cache hook failed: ' . $e->getMessage();
            }
        }

        if ( empty( $log ) ) {
            $log[] = 'No cache integrations detected. (Object cache may not be enabled.)';
        }

        return array(
            'count'    => (int) $count,
            'log_lines'=> $log,
            'warnings' => $warn,
        );
    }
}
