<?php
namespace AegisBackup\Restore;

defined( 'ABSPATH' ) || exit;

class AB_Migration_Report {

    public static function blank() {
        return array(
            'started_at' => time(),
            'finished_at' => 0,
            'package' => '',
            'steps' => array(),
            'counts' => array(
                'db_tables_imported' => 0,
                'db_statements_executed' => 0,
                'files_restored' => 0,
                'bytes_restored' => 0,
                'prefix_renamed_tables' => 0,
                'prefix_updated_options' => 0,
                'prefix_updated_usermeta' => 0,
                'domain_rows_updated' => 0,
                'domain_replacements' => 0,
                'failed_writes' => 0,
                'hash_mismatch' => 0,
                'zero_byte_files' => 0,
                'caches_cleared' => 0,
                'attachments_verified' => 0,
                'attachments_missing_files' => 0,
                'attachments_corrupted_meta' => 0,
                'thumbnails_regenerated' => 0,
                'upload_options_normalized' => 0,
                'permission_fixes_attempted' => 0,
            ),

            'samples' => array(
                'missing_files' => array(),
                'corrupted_meta' => array(),
                'zero_byte_files' => array(),
                'failed_writes' => array(),
                'hash_mismatch' => array(),
            ),
            'wpconfig' => array(),
            'warnings' => array(),
            'errors' => array(),
        );
    }

    public static function add_step( array &$report, $step, $message = '' ) {
        $report['steps'][] = array(
            't' => time(),
            'step' => (string) $step,
            'message' => (string) $message,
        );
    }

    public static function add_warning( array &$report, $message ) {
        $report['warnings'][] = (string) $message;
    }

    public static function add_error( array &$report, $message ) {
        $report['errors'][] = (string) $message;
    }

    public static function finish( array &$report ) {
        $report['finished_at'] = time();
    }
}
