<?php
/**
 * Plugin Name: Aegisify Core
 * Plugin URI:  https://aegisify.com/
 * Description: Aegisify Suite: Get Security, SEO, Backup, Spam Protection, WAF and Ticketing with one platform.  Everything you need!
 * Version:     1.0.7
 * Requires at least: 6.8
 * Requires PHP: 8.2
 * Author:      Aegisify Bundle: AegisWAF | AegisShield | AegisSEO | AegisBackup | AegisLink | AegisSiteMap | AegisSpam
 * Author URI:  https://aegisify.com/
 * Text Domain: aegisify
 * License: GPLv2 or later
 */
if (!defined('ABSPATH')) exit;

define('AEGISIFY_CORE_VERSION', '1.0.7');
define('AEGISIFY_CORE_PATH', plugin_dir_path(__FILE__));
define('AEGISIFY_CORE_URL', plugin_dir_url(__FILE__));
define('AEGISIFY_VERSION', AEGISIFY_CORE_VERSION);
define('AEGISIFY_FILE', __FILE__);
define('AEGISIFY_DIR', plugin_dir_path(__FILE__));
define('AEGISIFY_URL', plugin_dir_url(__FILE__));
define('AEGISIFY_BASENAME', plugin_basename(__FILE__));
define('AEGISIFY_SLUG', 'aegisify');

define('AEGISIFY_CLM_BASE', 'https://aegisify.com');
define('AEGISIFY_CLM_FREE_REGISTER_ENDPOINT',  AEGISIFY_CLM_BASE . '/wp-json/chue-license/v1/aegisify/free-register');
define('AEGISIFY_CLM_ACTIVATE_ENDPOINT',       AEGISIFY_CLM_BASE . '/wp-json/chue-license/v1/aegisify/activate');
define('AEGISIFY_CLM_DEACTIVATE_ENDPOINT',     AEGISIFY_CLM_BASE . '/wp-json/chue-license/v1/aegisify/deactivate');
define('AEGISIFY_CLM_STATUS_ENDPOINT',         AEGISIFY_CLM_BASE . '/wp-json/chue-license/v1/aegisify/status');
define('AEGISIFY_CLM_TRIAL_ENDPOINT',          AEGISIFY_CLM_BASE . '/wp-json/chue-license/v1/aegisify/trial');

require_once AEGISIFY_CORE_PATH . 'includes/interfaces/interface-aegisify-module.php';
require_once AEGISIFY_CORE_PATH . 'includes/class-aegisify-modules.php';
require_once AEGISIFY_CORE_PATH . 'includes/class-aegisify-admin.php';
require_once AEGISIFY_CORE_PATH . 'includes/class-aegisify-core.php';
require_once AEGISIFY_CORE_PATH . 'includes/admin_pages/class-aegisify-bundled-plugins-page.php';
require_once AEGISIFY_CORE_PATH . 'includes/utils/class-aegisify-license.php';

if (!function_exists('aegisify_update_log')) {
    function aegisify_update_log(string $message, array $context = array(), string $level = 'INFO'): void {
        if ( defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) {
            // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log
            error_log( '[Aegisify][' . $level . '] ' . $message . ' ' . wp_json_encode( $context ) );
        }
    }
}
if (!function_exists('aegisify_is_pro')) {
    function aegisify_is_pro(bool $force_refresh = false): bool {
        if (!class_exists('Aegisify_Core') || !method_exists('Aegisify_Core', 'instance')) {
            return false;
        }

        try {
            $lic = Aegisify_Core::instance()->license();
        } catch (\Throwable $e) {
            return false;
        }

        if (!$lic || !is_object($lic)) {
            return false;
        }

        $status = $lic->get_status();

        if ($force_refresh || empty($status)) {
            $guard = get_transient('aegisify_status_autorefresh');
            if ($force_refresh || !$guard) {
                set_transient('aegisify_status_autorefresh', 1, 6 * HOUR_IN_SECONDS);
                $status = $lic->check_now(AEGISIFY_VERSION);
            }
        }

        return !empty($status['is_pro']);
    }
}

register_activation_hook(__FILE__, array('Aegisify_Core', 'activate'));
register_deactivation_hook(__FILE__, array('Aegisify_Core', 'deactivate'));

add_action('plugins_loaded', function () {
    Aegisify_Core::instance()->boot();
});
