<?php
if (!defined('ABSPATH')) exit;

class Aegisify_Core {

    private static $instance = null;
    private $admin;
	private $license;
	
    public static function instance(): Aegisify_Core {
        if (self::$instance === null) self::$instance = new self();
        return self::$instance;
    }

    public static function activate(): void {
        if (get_option(Aegisify_Modules::OPTION_ENABLED, null) === null) {
            add_option(Aegisify_Modules::OPTION_ENABLED, array(), '', false);
        }
    }

    public static function deactivate(): void {
    }

    public function boot(): void {
		$this->license = new \Aegisify\Utils\License();
        if (is_admin()) {
            $this->admin = new Aegisify_Admin();
            $this->admin->hooks();
        }

        add_action('plugins_loaded', array($this, 'boot_enabled_modules'), 20);
    }
	public function license(): \Aegisify\Utils\License {
		return $this->license;
	}

    public function is_pro_active(bool $auto_check = true): bool {
        if (!$this->license) {
            return false;
        }
        return $this->license->is_pro_active($auto_check, AEGISIFY_CORE_VERSION);
    }

    public function boot_enabled_modules(): void {
        Aegisify_Modules::boot_enabled_modules();
    }
}
