(function($){
  'use strict';

  function getPostId(){
    var $pid = $('#post_ID');
    return $pid.length ? parseInt($pid.val(), 10) : 0;
  }

  function getAjax(){
    if (window.AegisSEOGenerate && AegisSEOGenerate.ajax_url) return AegisSEOGenerate.ajax_url;
    if (window.AegisSEOAdmin && AegisSEOAdmin.ajax_url) return AegisSEOAdmin.ajax_url;
    if (typeof ajaxurl !== 'undefined') return ajaxurl;
    return '';
  }

  function getNonce(){
    if (window.AegisSEOGenerate && AegisSEOGenerate.nonce) return AegisSEOGenerate.nonce;
    if (window.AegisSEOAdmin && AegisSEOAdmin.nonce) return AegisSEOAdmin.nonce;
    // last resort: try to read any nonce field we can find
    var $n = $('input[name="aegisseo_nonce"], input[name="_wpnonce"]').first();
    return $n.length ? $n.val() : '';
  }

  var selectorMap = {
    title: 'input[name="aegisseo_title"]',
    description: 'textarea[name="aegisseo_description"]',
    canonical: 'input[name="aegisseo_canonical"]',
    og_title: 'input[name="aegisseo_og_title"]',
    og_description: 'textarea[name="aegisseo_og_description"]',
    twitter_title: 'input[name="aegisseo_twitter_title"]',
    twitter_description: 'textarea[name="aegisseo_twitter_description"]'
  };

  $(document).on('click', '.aegisseo-generate-btn', function(e){
    e.preventDefault();

    var $btn = $(this);
    var field = $btn.data('field') || '';
    var sel = selectorMap[field] || '';
    var $field = sel ? $(sel) : $();

    if (!field){
      alert('Generate: missing field.');
      return;
    }

    var postId = getPostId();
    if (!postId){
      alert('Generate: missing post id.');
      return;
    }

    var ajaxUrl = getAjax();
    if (!ajaxUrl){
      alert('Generate: missing ajax url.');
      return;
    }

    var nonce = getNonce();

    var oldText = $btn.text();
    $btn.prop('disabled', true).text('Generating...');

    $.post(ajaxUrl, {
      action: 'aegisseo_generate_field',
      nonce: nonce,
      post_id: postId,
      field: field
    }).done(function(resp){
      if (resp && resp.success && resp.data && typeof resp.data.value !== 'undefined'){
        if ($field.length){
          $field.val(resp.data.value).trigger('change');
        }
        alert('Generated: ' + field);
      } else {
        var msg = (resp && resp.data && resp.data.message) ? resp.data.message : 'Unknown error';
        alert('Generate failed: ' + msg);
      }
    }).fail(function(xhr){
      var msg = (xhr && xhr.responseText) ? xhr.responseText : 'Request failed';
      alert('Generate failed: ' + msg);
    }).always(function(){
      $btn.prop('disabled', false).text(oldText);
    });
  });

})(jQuery);
