<?php
namespace AegisSEO\Admin;

use AegisSEO\Utils\Options;

if (!defined('ABSPATH')) { exit; }

class Admin_Tools {

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;
        add_action('admin_post_aegisseo_reset_settings', array($this, 'reset_settings'));
        add_action('admin_post_aegisseo_run_gsc_snapshot_now', array($this, 'run_gsc_snapshot_now'));
        add_action('admin_post_aegisseo_save_license', array($this, 'save_license'));
        add_action('admin_post_aegisseo_check_license', array($this, 'check_license'));
    }

    public function reset_settings() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_reset_settings');

        update_option(Options::OPTION_KEY, $this->options->defaults(), false);

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=tools&reset=1'));
        exit;
    }
public function run_gsc_snapshot_now() {
    if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
    check_admin_referer('aegisseo_run_gsc_snapshot_now');

    if (function_exists('aegisseo') && isset(aegisseo()->gsc_snapshots) && aegisseo()->gsc_snapshots) {
        aegisseo()->gsc_snapshots->run_daily();
    }

    wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=evidence&ran=1'));
    exit;
}



public function save_license() {
    if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
    check_admin_referer('aegisseo_save_license');

    $key = isset($_POST['license_key']) ? sanitize_text_field(wp_unslash($_POST['license_key'])) : '';
    if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
        aegisseo()->license->set_key($key);
    } else {
        update_option('aegisseo_license_key', trim($key), false);
    }

    wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=license&saved=1'));
    exit;
}

public function check_license() {
    if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
    check_admin_referer('aegisseo_check_license');

    $result = array('success'=>false);
    if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
        $result = aegisseo()->license->check_now(AEGISSEO_VERSION);
    }

    $flag = (!empty($result['is_pro'])) ? 'pro' : 'free';
    wp_safe_redirect(admin_url('admin.php?page=aegisseo&tab=license&checked=1&tier=' . $flag));
    exit;
}
}