<?php
namespace AegisSEO\Admin;

use AegisSEO\Utils\Options;
use AegisSEO\Utils\Sanitize;

if (!defined('ABSPATH')) { exit; }

class Admin_Wizard {

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;

        add_action('admin_post_aegisseo_wizard_save', array($this, 'handle_save'));
        add_action('admin_init', array($this, 'set_wizard_transient_on_activation'));
    }

    public function set_wizard_transient_on_activation() {

        $opts = $this->options->get_all();
        if ((int) $opts['wizard_complete'] === 1) { return; }

        // During plugin activation WordPress includes a nonce in the activation redirect.
        if (
            isset($_GET['activate'], $_GET['plugin'], $_GET['_wpnonce'])
            && $_GET['activate'] === 'true'
        ) {
            $activated_plugin = sanitize_text_field(wp_unslash($_GET['plugin']));
            $nonce            = sanitize_text_field(wp_unslash($_GET['_wpnonce']));

            // Verify activation nonce before acting on query args.
            if (!wp_verify_nonce($nonce, 'activate-plugin_' . $activated_plugin)) {
                return;
            }

            $self_plugin = function_exists('plugin_basename') ? plugin_basename(AEGISSEO_FILE) : '';
            if ($activated_plugin && $self_plugin && $activated_plugin === $self_plugin) {
                set_transient('aegisseo_do_wizard', '1', 60);
            }
        }
    }

    public function handle_save() {
        if (!current_user_can('manage_options')) { wp_die('Forbidden'); }
        check_admin_referer('aegisseo_wizard_save');

        // Sanitize all user input (PluginCheck: ValidatedSanitizedInput).
        $site_type     = isset( $_POST['site_type'] ) ? sanitize_key( wp_unslash( $_POST['site_type'] ) ) : 'organization';
        if ( ! in_array( $site_type, array( 'organization', 'person' ), true ) ) {
            $site_type = 'organization';
        }

        $org_name    = isset( $_POST['org_name'] ) ? sanitize_text_field( wp_unslash( $_POST['org_name'] ) ) : '';
        $person_name = isset( $_POST['person_name'] ) ? sanitize_text_field( wp_unslash( $_POST['person_name'] ) ) : '';
        $logo_id     = isset( $_POST['logo_id'] ) ? absint( wp_unslash( $_POST['logo_id'] ) ) : 0;

        // Enforce max lengths to preserve existing behavior.
        $org_name    = ( strlen( $org_name ) > 150 ) ? substr( $org_name, 0, 150 ) : $org_name;
        $person_name = ( strlen( $person_name ) > 150 ) ? substr( $person_name, 0, 150 ) : $person_name;

        $social = array(
            'facebook'  => isset( $_POST['social_facebook'] ) ? esc_url_raw( wp_unslash( $_POST['social_facebook'] ) ) : '',
            'twitter'   => isset( $_POST['social_twitter'] ) ? esc_url_raw( wp_unslash( $_POST['social_twitter'] ) ) : '',
            'instagram' => isset( $_POST['social_instagram'] ) ? esc_url_raw( wp_unslash( $_POST['social_instagram'] ) ) : '',
            'linkedin'  => isset( $_POST['social_linkedin'] ) ? esc_url_raw( wp_unslash( $_POST['social_linkedin'] ) ) : '',
            'youtube'   => isset( $_POST['social_youtube'] ) ? esc_url_raw( wp_unslash( $_POST['social_youtube'] ) ) : '',
        );

        $title_home     = isset( $_POST['title_home'] ) ? sanitize_text_field( wp_unslash( $_POST['title_home'] ) ) : $this->options->get( 'title_home' );
        $title_home     = ( strlen( $title_home ) > 300 ) ? substr( $title_home, 0, 300 ) : $title_home;

        $this->options->update(array(
            'site_type' => $site_type,
            'org_name' => $org_name,
            'person_name' => $person_name,
            'logo_id' => $logo_id,
            'social_profiles' => $social,
            'title_home' => $title_home,
            'wizard_complete' => 1,
        ));

        wp_safe_redirect(admin_url('admin.php?page=aegisseo&wizard=done'));
        exit;
    }
}
