<?php
namespace AegisSEO\SEO;

if (!defined('ABSPATH')) { exit; }

class Installer {

    const DB_VERSION = '1.2';

    public static function install() {
        global $wpdb;

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';

        $charset_collate = $wpdb->get_charset_collate();

        $t404 = $wpdb->prefix . 'aegisseo_404';
        $tred = $wpdb->prefix . 'aegisseo_redirects';

        $sql1 = "CREATE TABLE {$t404} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            url TEXT NOT NULL,
            url_hash CHAR(32) NOT NULL,
            referrer TEXT NULL,
            user_agent TEXT NULL,
            ip VARCHAR(45) NULL,
            hits BIGINT(20) UNSIGNED NOT NULL DEFAULT 1,
            first_seen DATETIME NOT NULL,
            last_seen DATETIME NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY url_hash (url_hash),
            KEY last_seen (last_seen)
        ) {$charset_collate};";

        $sql2 = "CREATE TABLE {$tred} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            source TEXT NOT NULL,
            source_hash CHAR(32) NOT NULL,
            target TEXT NOT NULL,
            match_type VARCHAR(10) NOT NULL DEFAULT 'exact',
            status_code SMALLINT(5) UNSIGNED NOT NULL DEFAULT 301,
            enabled TINYINT(1) NOT NULL DEFAULT 1,
            is_suggestion TINYINT(1) NOT NULL DEFAULT 0,
            suggestion_status VARCHAR(20) NOT NULL DEFAULT 'approved',
            source_post_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            reason TEXT NULL,
            created_at DATETIME NOT NULL,
            updated_at DATETIME NOT NULL,
            PRIMARY KEY (id),
            UNIQUE KEY source_hash (source_hash),
            KEY enabled (enabled),
            KEY match_type (match_type)
        ) {$charset_collate};";

        
        $table3 = $wpdb->prefix . 'aegisseo_events';
        $sql3 = "CREATE TABLE {$table3} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            event_type VARCHAR(50) NOT NULL,
            object_type VARCHAR(20) NOT NULL,
            object_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            meta_key VARCHAR(191) NULL,
            old_value LONGTEXT NULL,
            new_value LONGTEXT NULL,
            user_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
            created_at DATETIME NOT NULL,
            PRIMARY KEY (id),
            KEY object (object_type, object_id),
            KEY event_type (event_type),
            KEY created_at (created_at)
        ) {$charset_collate};";

        

        $table4 = $wpdb->prefix . 'aegisseo_gsc_snapshots';
        $sql4 = "CREATE TABLE {$table4} (
    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
    snap_date DATE NOT NULL,
    object_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
    page_url TEXT NOT NULL,
    clicks DOUBLE NOT NULL DEFAULT 0,
    impressions DOUBLE NOT NULL DEFAULT 0,
    ctr DOUBLE NOT NULL DEFAULT 0,
    position DOUBLE NOT NULL DEFAULT 0,
    created_at DATETIME NOT NULL,
    PRIMARY KEY (id),
    UNIQUE KEY uniq_date_object (snap_date, object_id),
    KEY snap_date (snap_date),
    KEY object_id (object_id)
) {$charset_collate};";

        dbDelta($sql1);
        dbDelta($sql2);
        dbDelta($sql3);
        dbDelta($sql4);

        update_option('aegisseo_db_version', self::DB_VERSION, false);
    }
}
