<?php
namespace AegisSEO\SEO;

use AegisSEO\Utils\Options;

if (!defined('ABSPATH')) { exit; }

class Local {
    private $options;

    public function __construct(Options $options) {
        $this->options = $options;
        add_action('init', array($this, 'register_location_cpt'));
        add_filter('aegisseo_schema_graph', array($this, 'add_local_schema'), 20, 2);
    }

    public function register_location_cpt() {
        register_post_type('aegisseo_location', array(
            'label' => __('Locations', 'aegisseo'),
            'public' => true,
            'show_in_rest' => true,
            'has_archive' => true,
            'rewrite' => array('slug' => 'locations'),
            'supports' => array('title','editor','thumbnail'),
        ));
    }

    public function add_local_schema($graph, $context) {
        $opts = $this->options->get_all();
        if (empty($opts['local_enabled'])) return $graph;

        if (is_front_page() || is_home()) {
            $graph[] = array(
                '@type' => sanitize_text_field($opts['local_business_type'] ?? 'LocalBusiness'),
                '@id' => trailingslashit(home_url('/')) . '#localbusiness',
                'name' => (string)($opts['local_name'] ?? get_bloginfo('name')),
                'url' => home_url('/'),
                'telephone' => (string)($opts['local_phone'] ?? ''),
                'email' => (string)($opts['local_email'] ?? ''),
                'address' => array(
                    '@type' => 'PostalAddress',
                    'streetAddress' => (string)($opts['local_street'] ?? ''),
                    'addressLocality' => (string)($opts['local_city'] ?? ''),
                    'addressRegion' => (string)($opts['local_state'] ?? ''),
                    'postalCode' => (string)($opts['local_zip'] ?? ''),
                    'addressCountry' => (string)($opts['local_country'] ?? ''),
                ),
            );
        }

        if (!empty($context['is_singular']) && !empty($context['post_id']) && get_post_type((int)$context['post_id']) === 'aegisseo_location') {
            $pid=(int)$context['post_id'];
            $graph[] = array('@type'=>'Place','@id'=>trailingslashit(get_permalink($pid)) . '#place','name'=>get_the_title($pid),'url'=>get_permalink($pid));
        }

        return $graph;
    }
}
