<?php
namespace AegisSEO\SEO;

use AegisSEO\Utils\Options;

if (!defined('ABSPATH')) { exit; }

class Robots {

    private $options;

    public function __construct(Options $options) {
        $this->options = $options;

        add_filter('robots_txt', array($this, 'filter_robots_txt'), 20, 2);
    }

    public function filter_robots_txt($output, $public) {

        $out = (string) $output;

        $sitemap_enabled = (int) $this->options->get('sitemap_enabled', 1) === 1;
        $add_sitemap     = (int) $this->options->get('sitemap_robots_add', 1) === 1;

        if ($sitemap_enabled && $add_sitemap) {
            // Prefer sitemap index (Google best practice) when enabled, otherwise fall back to legacy sitemap.xml.
            $use_index = (int) $this->options->get('sitemap_index_enabled', 1) === 1;
            $sitemap_url = $use_index ? home_url('/sitemap_index.xml') : home_url('/sitemap.xml');
            $sitemap_line = 'Sitemap: ' . $sitemap_url;

            // Don't duplicate our exact line, but do append even if other sitemap lines already exist
            // (e.g., WordPress core wp-sitemap.xml). Google can read multiple Sitemap: lines.
            if (stripos($out, $sitemap_line) === false) {
                $out = rtrim($out) . "\n\n" . $sitemap_line . "\n";
            }
        }

        $enabled = (int) $this->options->get('robots_custom_enabled', 0);
        if ($enabled !== 1) { return $out; }

        $custom = (string) $this->options->get('robots_custom_rules', '');
        $custom = str_replace(array("
","
"), "
", $custom);
        $custom = trim($custom);

        if ($custom === '') { return $out; }

        $out = rtrim($out) . "

# BEGIN AegisSEO
" . $custom . "
# END AegisSEO
";
        return $out;
    }
}
