<?php
namespace AegisSEO\SEO;

if (!defined('ABSPATH')) { exit; }

class Variables {

    public static function replace($template, $context = array()) {
        $template = is_string($template) ? $template : '';

        $sep = isset($context['sep']) ? $context['sep'] : '|';

        $replacements = array(
            '%%title%%'   => isset($context['title']) ? $context['title'] : '',
            '%%sitename%%'=> get_bloginfo('name'),
            '%%tagline%%' => get_bloginfo('description'),
            '%%sep%%'     => ' ' . $sep . ' ',
            '%%excerpt%%' => isset($context['excerpt']) ? $context['excerpt'] : '',
            '%%term%%'    => isset($context['term']) ? $context['term'] : '',
            '%%category%%'=> isset($context['category']) ? $context['category'] : '',
        );

        $out = strtr($template, $replacements);
        $out = preg_replace('/\s{2,}/', ' ', trim($out));
        return $out;
    }

    /**
     * Detect front-end builder/live editor context (Avada uses ?fb-edit=1).
     * In this context we must avoid rendering full content (shortcodes/builders),
     * because builders can hang when the_content is rendered during wp_head.
     *
     * @return bool
     */
    private static function aegisseo_is_live_builder_request() {
        if ( isset( $_GET['fb-edit'] ) || isset( $_GET['builder'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only check.
            return true;
        }
        if ( function_exists( 'wp_doing_ajax' ) && wp_doing_ajax() ) { return true; }
        if ( defined( 'REST_REQUEST' ) && REST_REQUEST ) { return true; }
        return false;
    }



	public static function get_excerpt_for_post($post) {
		if (!$post) { return ''; }

		$excerpt = has_excerpt($post) ? (string) $post->post_excerpt : '';
		if ($excerpt !== '') {
			$excerpt = strip_shortcodes($excerpt);
			$excerpt = preg_replace('/\[[^\]]+\]/', ' ', $excerpt); // remove leftover shortcode text
			$excerpt = wp_strip_all_tags($excerpt, true);
			$excerpt = html_entity_decode($excerpt, ENT_QUOTES, get_bloginfo('charset'));
			$excerpt = preg_replace('/\s+/', ' ', trim($excerpt));
			return self::smart_trim_sentences($excerpt, (int) apply_filters('aegisseo_excerpt_max', 600));
		}

		$content = (string) $post->post_content;
		if ($content === '') { return ''; }

		$rendered = $content;

		// In Avada/Fusion Live Builder (fb-edit), avoid rendering content via blocks/shortcodes.
		if ( self::aegisseo_is_live_builder_request() ) {
			$rendered = strip_shortcodes( (string) $rendered );
		}

		if ( ! self::aegisseo_is_live_builder_request() && function_exists('has_blocks') && has_blocks($rendered) && function_exists('do_blocks') ) {
			$rendered = do_blocks($rendered);
		}

		if ( ! self::aegisseo_is_live_builder_request() && function_exists('apply_filters') ) {
			// Ensure global post context for Avada/Fusion rendering
			$GLOBALS['post'] = $post;
			setup_postdata($post);

			$rendered = apply_filters( 'the_content', $rendered ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core WP filter.

			wp_reset_postdata();
		}

		$rendered = preg_replace('/\[[^\]]+\]/', ' ', (string)$rendered);
		$rendered = preg_replace('/<!--(.|\s)*?-->/', ' ', (string)$rendered);

		$rendered = preg_replace('#<script\b[^>]*>.*?</script>#is', ' ', (string)$rendered);
		$rendered = preg_replace('#<style\b[^>]*>.*?</style>#is', ' ', (string)$rendered);

		$text = wp_strip_all_tags((string)$rendered, false);
		$text = html_entity_decode($text, ENT_QUOTES, get_bloginfo('charset'));
		$text = preg_replace('/[\x00-\x1F\x7F]+/u', ' ', $text);
		$text = preg_replace('/\s+/', ' ', trim($text));

		if ($text === '') { return ''; }

		$text = self::strip_leading_boilerplate($text);

		return self::smart_trim_sentences($text, (int) apply_filters('aegisseo_excerpt_max', 600));

		$text = wp_strip_all_tags($content, false);
		$text = html_entity_decode($text, ENT_QUOTES, get_bloginfo('charset'));
		$text = preg_replace('/[\x00-\x1F\x7F]+/u', ' ', $text);
		$text = preg_replace('/\s+/', ' ', trim($text));

		if ($text === '') { return ''; }

		$text = self::strip_leading_boilerplate($text);

		return self::smart_trim_sentences($text, (int) apply_filters('aegisseo_excerpt_max', 600));
	}

	private static function smart_trim_sentences($text, $max = 160) {
		$text = preg_replace('/\s+/', ' ', trim((string)$text));
		if ($text === '') return '';

		$sentences = preg_split('/(?<=[\.\!\?])\s+/', $text);
		if (!is_array($sentences) || empty($sentences)) $sentences = array($text);

		$out = '';
		foreach ($sentences as $s) {
			$s = trim((string)$s);
			if ($s === '') continue;

			$candidate = ($out === '') ? $s : ($out . ' ' . $s);

			if (function_exists('mb_strlen')) {
				if (mb_strlen($candidate) > $max) break;
			} else {
				if (strlen($candidate) > $max) break;
			}

			$out = $candidate;
			if ($out !== '' && (function_exists('mb_strlen') ? mb_strlen($out) >= ($max - 20) : strlen($out) >= ($max - 20))) {
				break;
			}
		}

		if ($out === '') $out = $text;

		if (function_exists('mb_strlen') && function_exists('mb_substr')) {
			if (mb_strlen($out) > $max) {
				$cut = mb_substr($out, 0, $max);
				$sp  = mb_strrpos($cut, ' ');
				if ($sp !== false && $sp > 80) $cut = mb_substr($cut, 0, $sp);
				$out = rtrim($cut) . '…';
			}
		} else {
			if (strlen($out) > $max) {
				$cut = substr($out, 0, $max);
				$sp  = strrpos($cut, ' ');
				if ($sp !== false && $sp > 80) $cut = substr($cut, 0, $sp);
				$out = rtrim($cut) . '...';
			}
		}

		return trim($out);
	}

	private static function strip_leading_boilerplate($text) {
		$bad_starts = array(
			'welcome', 'hello', 'hi ', 'thanks', 'thank you',
			'read more', 'learn more', 'click here',
			'subscribe', 'sign up', 'log in', 'login', 'register',
			'cookie', 'cookies', 'privacy policy', 'terms', 'copyright',
			'share this', 'share on', 'follow us', 'newsletter',
		);

		$low = function_exists('mb_strtolower') ? mb_strtolower($text) : strtolower($text);
		foreach ($bad_starts as $bs) {
			if ($bs !== '' && strpos($low, $bs) === 0) {
				$parts = preg_split('/(?<=[\.\!\?])\s+/', $text, 2);
				if (is_array($parts) && isset($parts[1])) return trim((string)$parts[1]);
				break;
			}
		}
		return $text;
	}

}
