<?php
namespace AegisSEO\Utils;

if (!defined('ABSPATH')) { exit; }

class Options {

    const OPTION_KEY = 'aegisseo_settings';

    public function ensure_defaults() {
        $existing = get_option(self::OPTION_KEY, null);
        if (!is_array($existing)) {
            update_option(self::OPTION_KEY, $this->defaults(), false);
        } else {
            $merged = array_merge($this->defaults(), $existing);
            update_option(self::OPTION_KEY, $merged, false);
        }
    }

    public function get_all() {
        $opts = get_option(self::OPTION_KEY, array());
        if (!is_array($opts)) { $opts = array(); }
        return array_merge($this->defaults(), $opts);
    }

    public function get($key, $default = null) {
        $opts = $this->get_all();
        return array_key_exists($key, $opts) ? $opts[$key] : $default;
    }

    public function update($new_opts) {
        if (!is_array($new_opts)) { return false; }
        $current = $this->get_all();
        $merged = array_merge($current, $new_opts);
        return update_option(self::OPTION_KEY, $merged, false);
    }

    public function defaults() {
        return array(

            'wizard_complete' => 0,


            'site_type'       => 'organization', // organization|person
            'org_name'        => '',
            'person_name'     => '',
            'logo_id'         => 0,
			'social_profiles' => array(
				'facebook'  => '',
				'twitter'   => '',
				'instagram' => '',
				'linkedin'  => '',
				'youtube'   => '',
				'tiktok'    => '',
				'pinterest' => '',
				'threads'   => '',
			),

            'title_home'      => '%%sitename%% %%sep%% %%tagline%%',
            'title_single'    => '%%title%% %%sep%% %%sitename%%',
            'title_page'      => '%%title%% %%sep%% %%sitename%%',
            'title_archive'   => '%%term%% %%sep%% %%sitename%%',
            'meta_desc_home'  => '%%tagline%%',
            'meta_desc_single'=> '%%excerpt%%',
            'meta_desc_page'  => '%%excerpt%%',

            'separator'       => '|',

            // Content scope (which post types AegisSEO should touch)
            // mode: smart (default) = include public types that support the editor (plus core types), exclude everything else.
            'scope_mode'     => 'smart',
            'scope_include'  => array(),
            'scope_exclude'  => array(),

			// Alerts (GSC-based)
			'alerts_enabled' => 0,
			'alerts_emails'  => get_option('admin_email'),
			'alerts_drop_clicks_pct'      => 35, // percent drop vs previous window
			'alerts_drop_impressions_pct' => 35,
			'alerts_drop_ctr_pct'         => 25,
			'alerts_position_worse'       => 2.0, // position increased by 2+ is worse
			'alerts_last_sent_ymd'        => '',

            'robots_global_index' => 1,
            'robots_global_follow'=> 1,

            'og_enabled'      => 1,
            'twitter_enabled' => 1,
            'twitter_card'    => 'summary_large_image',
			'twitter_site'    => '',
			'twitter_creator' => '',
			'facebook_app_id' => '',
			'facebook_admins' => '',
			'social_default_image' => '',
			'social_enable_article_meta' => 1,

            'schema_post_type_map' => array(),
			'sitemap_enabled' => 1,
			'sitemap_robots_add' => 1,
			'sitemap_max_urls' => 5000,
            
            'sitemap_index_enabled' => 1,
            'sitemap_page_size' => 2000,
            'sitemap_include_images' => 1,
            'sitemap_include_attached_images' => 0,
            'sitemap_last_ping' => array(),
            'sitemap_video_enabled' => 1,
            'sitemap_news_enabled' => 0,
            'sitemap_html_enabled' => 1,

			'injection_enabled'       => 0,
			'verify_google'           => '',
			'verify_bing'             => '',
			'custom_schema_sitewide'  => '',
			'inject_head_html'        => '',
			'inject_footer_html'      => '',

			'ping_search_engines' => 0,
            'sitemap_post_types' => array('post' => 1, 'page' => 1),
            'sitemap_taxonomies' => array('category' => 1, 'post_tag' => 1),

            'breadcrumbs_enabled' => 0,
            'breadcrumbs_sep'     => '›',

            'show_admin_bar_indicator' => 1,

            'focus_phrase_enabled' => 1,
            'safe_defaults_enabled' => 1,
            'allowed_roles' => array('administrator'=>1),

            'gsc_client_id' => '',
            'gsc_client_secret' => '',
            'gsc_property' => '',
            'gsc_refresh_token' => '',

            'autopilot_enabled' => 1,
            'autopilot_require_review' => 1,
            'autopilot_redirect_suggestions' => 1,
            'autopilot_schema_suggestions' => 1,
            'autopilot_link_suggestions' => 1,
            'autopilot_max_internal_links' => 3,
            'autopilot_daily_redirect_limit' => 25,
            'fixpacks_enabled' => 1,

            'security_seo_enabled' => 1,
            'security_seo_log_events' => 1,
            'security_seo_sitemap_strict' => 1,
            'security_seo_keywords' => array('viagra','cialis','casino','porn','payday','crypto','loan','sex','escort'),

            'local_enabled' => 0,
            'local_business_type' => 'LocalBusiness',
            'local_name' => '',
            'local_phone' => '',
            'local_email' => '',
            'local_street' => '',
            'local_city' => '',
            'local_state' => '',
            'local_zip' => '',
            'local_country' => '',
            'local_lat' => '',
            'local_lng' => '',

'monitor_404_enabled' => 1,
'monitor_404_retention_days' => 30,
'monitor_404_max_rows' => 5000,

'redirects_enabled' => 1,

'robots_custom_enabled' => 0,
'robots_custom_rules'   => "",

'htaccess_helper_enabled' => 0,
'htaccess_force_https'    => 0,
'htaccess_force_www'      => 0, // 0=no change, 1=force www, -1=force non-www
'htaccess_trailing_slash' => 0,
        );
    }

    /**
     * Determine which post types AegisSEO should operate on.
     * Default "smart" mode includes public post types that support the editor (plus core types),
     * and excludes anything in scope_exclude.
     */
    public function get_scope_post_types() {
        $opts = $this->get_all();
        $mode = isset($opts['scope_mode']) ? (string) $opts['scope_mode'] : 'smart';
        $include = isset($opts['scope_include']) && is_array($opts['scope_include']) ? $opts['scope_include'] : array();
        $exclude = isset($opts['scope_exclude']) && is_array($opts['scope_exclude']) ? $opts['scope_exclude'] : array();

        $exclude = array_values(array_unique(array_filter(array_map('strval', $exclude))));
        $include = array_values(array_unique(array_filter(array_map('strval', $include))));

        $public = get_post_types(array('public' => true), 'names');

        if ($mode === 'include_only' && !empty($include)) {
            $pts = array_values(array_intersect($public, $include));
        } else {
            // smart mode
            $pts = array();
            foreach ($public as $pt) {
                if ($pt === 'attachment' || $pt === 'post' || $pt === 'page') {
                    $pts[] = $pt;
                    continue;
                }
                if (post_type_supports($pt, 'editor')) {
                    $pts[] = $pt;
                }
            }
            // If WooCommerce is present, products are editor-supported, but keep explicit too.
            if (post_type_exists('product') && !in_array('product', $pts, true)) {
                $pts[] = 'product';
            }
        }

        if (!empty($exclude)) {
            $pts = array_values(array_diff($pts, $exclude));
        }

        return array_values(array_unique($pts));
    }

}
