<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) { echo '<div class="notice notice-error"><p>Forbidden.</p></div>'; return; }

global $wpdb;

$aegisseo_bulk_nonce = isset($_GET['aegisseo_bulk_nonce']) ? sanitize_text_field(wp_unslash($_GET['aegisseo_bulk_nonce'])) : '';
$aegisseo_nonce_ok   = ($aegisseo_bulk_nonce !== '' && wp_verify_nonce($aegisseo_bulk_nonce, 'aegisseo_bulk_page'));

$aegisseo_post_types = get_post_types(array('public' => true), 'objects');
$aegisseo_all_types  = array_keys($aegisseo_post_types);

$aegisseo_post_type = 'any';
$aegisseo_filter    = '';
$aegisseo_search    = '';
$aegisseo_paged     = 1;
$aegisseo_per_page  = 25;

if ($aegisseo_nonce_ok) {
    $aegisseo_post_type = isset($_GET['post_type']) ? sanitize_key(wp_unslash($_GET['post_type'])) : 'any';
    $aegisseo_filter    = isset($_GET['filter']) ? sanitize_key(wp_unslash($_GET['filter'])) : '';
    $aegisseo_search    = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';
    $aegisseo_paged     = isset($_GET['paged']) ? max(1, absint(wp_unslash($_GET['paged']))) : 1;
    $aegisseo_per_page  = isset($_GET['per_page']) ? absint(wp_unslash($_GET['per_page'])) : 25;
}

if (!in_array($aegisseo_per_page, array(25, 50, 100), true)) {
    $aegisseo_per_page = 25;
}

$aegisseo_allowed_filters = array('', 'no_meta', 'thin', 'noindex', 'dup_title');
if (!in_array($aegisseo_filter, $aegisseo_allowed_filters, true)) {
    $aegisseo_filter = '';
}

if ($aegisseo_post_type !== 'any' && !in_array($aegisseo_post_type, $aegisseo_all_types, true)) {
    $aegisseo_post_type = 'any';
}

$aegisseo_offset = ($aegisseo_paged - 1) * $aegisseo_per_page;

$aegisseo_chosen_types = ($aegisseo_post_type === 'any' ? $aegisseo_all_types : array($aegisseo_post_type));

function aegisseo_bulk_cache_key($aegisseo_filter, $types, $aegisseo_search) {
    return 'aegisseo_bulk_' . md5(implode('|', array((string)$aegisseo_filter, implode(',', (array)$types), (string)$aegisseo_search, (string)get_current_blog_id())));
}

function aegisseo_bulk_normalize_title($t) {
    $t = wp_strip_all_tags((string) $t);
    $t = strtolower($t);
    $t = preg_replace('/\s+/', ' ', $t);
    return trim($t);
}

function aegisseo_bulk_compute_ids($aegisseo_filter, $types, $aegisseo_search) {
    $cache_key = aegisseo_bulk_cache_key($aegisseo_filter, $types, $aegisseo_search);
    $cached = get_transient($cache_key);
    if (is_array($cached)) return $cached;

    $aegisseo_ids = array();

    $chunk = 500;
    $page = 0;

    do {
        $args = array(
            'post_type'      => (array) $types,
            'post_status'    => array('publish','draft','pending','future','private'),
            'posts_per_page' => $chunk,
            'offset'         => $page * $chunk,
            'orderby'        => 'ID',
            'order'          => 'ASC',
            'fields'         => 'ids',
            's'              => ($aegisseo_search !== '' ? $aegisseo_search : ''),
        );
        $batch_ids = get_posts($args);
        if (empty($batch_ids)) break;

        foreach ($batch_ids as $aegisseo_id) {
            $aegisseo_p = get_post($aegisseo_id);
            if (!$aegisseo_p) continue;

            if ($aegisseo_filter === 'thin') {
                $aegisseo_content_plain = wp_strip_all_tags((string) $aegisseo_p->post_content);
                $aegisseo_wc = str_word_count($aegisseo_content_plain);
                if ($aegisseo_wc < 300) $aegisseo_ids[] = (int) $aegisseo_id;
                continue;
            }

            if ($aegisseo_filter === 'dup_title') {
                $aegisseo_ids[] = (int) $aegisseo_id;
                continue;
            }
        }

        $page++;
    } while (count($batch_ids) === $chunk);

    if ($aegisseo_filter === 'dup_title') {
        $counts = array();
        $norm_by_id = array();

        foreach ($aegisseo_ids as $aegisseo_id) {
            $aegisseo_seo_title = (string) get_post_meta($aegisseo_id, '_aegisseo_title', true);
            $title = ($aegisseo_seo_title !== '' ? $aegisseo_seo_title : (string) get_the_title($aegisseo_id));
            $norm = aegisseo_bulk_normalize_title($title);
            if ($norm === '') continue;
            $norm_by_id[$aegisseo_id] = $norm;
            if (!isset($counts[$norm])) $counts[$norm] = 0;
            $counts[$norm]++;
        }

        $dup_ids = array();
        foreach ($norm_by_id as $aegisseo_id => $norm) {
            if (!empty($counts[$norm]) && $counts[$norm] > 1) $dup_ids[] = (int) $aegisseo_id;
        }
        $aegisseo_ids = $dup_ids;
    }

    set_transient($cache_key, $aegisseo_ids, 10 * MINUTE_IN_SECONDS);
    return $aegisseo_ids;
}

$aegisseo_rows = array();
$aegisseo_total = 0;

if ($aegisseo_filter === '' || $aegisseo_filter === 'no_meta' || $aegisseo_filter === 'noindex') {
    $aegisseo_posts_table = $wpdb->posts;
    $aegisseo_pm_table = $wpdb->postmeta;

    $aegisseo_types_in    = implode(',', array_fill(0, count($aegisseo_chosen_types), '%s'));
    $aegisseo_statuses_in = implode(',', array_fill(0, 5, '%s'));

    // Params are used only via $wpdb->prepare(). Keep them sanitized at the source.
    $aegisseo_params = array_merge(
        array_map('sanitize_key', (array) $aegisseo_chosen_types),
        array('publish', 'draft', 'pending', 'future', 'private')
    );

    // Build SQL using fixed query strings per filter-combination (no dynamic WHERE string building).
    $aegisseo_has_search = ( $aegisseo_search !== '' );

    // Base placeholders for IN() clauses.
    $aegisseo_types_in    = implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) );
    $aegisseo_statuses_in = implode( ',', array_fill( 0, 5, '%s' ) );

    // Base params: post types + statuses (sanitized early).
    $aegisseo_params_base = array_merge(
        array_map( 'sanitize_key', (array) $aegisseo_chosen_types ),
        array( 'publish', 'draft', 'pending', 'future', 'private' )
    );

    // Search params (if any).
    $aegisseo_params_search = array();
    if ( $aegisseo_has_search ) {
        $aegisseo_search_db = $aegisseo_search;
        if ( $aegisseo_search_db !== '' ) {
            $aegisseo_search_db = esc_sql( $aegisseo_search_db );
        }
        $aegisseo_like            = '%' . $wpdb->esc_like( $aegisseo_search_db ) . '%';
        $aegisseo_params_search[] = $aegisseo_like;
        $aegisseo_params_search[] = $aegisseo_like;
    }

    // Filter params (if any).
    $aegisseo_params_filter = array();
    if ( $aegisseo_filter === 'noindex' ) {
        $aegisseo_params_filter[] = '1';
    }

    // Cache key for this view (helps satisfy Plugin Check caching recommendation).
    $aegisseo_cache_sig = array(
        'filter'   => (string) $aegisseo_filter,
        'types'    => (array) $aegisseo_chosen_types,
        'search'   => (string) $aegisseo_search,
        'per_page' => (int) $aegisseo_per_page,
        'offset'   => (int) $aegisseo_offset,
    );
    $aegisseo_cache_base = 'aegisseo_bulk_sql_' . md5( wp_json_encode( $aegisseo_cache_sig ) );

    // ---------- TOTAL ----------
    if ( false === $aegisseo_total_cache ) {

        if ( $aegisseo_filter === 'noindex' ) {
            $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT COUNT(DISTINCT p.ID)\n"
                    . "FROM %i p\n"
                    . "LEFT JOIN %i pm_no ON pm_no.post_id = p.ID AND pm_no.meta_key = %s\n"
                    . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                    . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                    . "\tAND pm_no.meta_value = %s"
                    , array_merge(
                        array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_noindex' ),
                        $aegisseo_params_base,
                        array( '1' )
                    )
                )
            ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

        } elseif ( $aegisseo_filter === 'nofollow' ) {
            $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT COUNT(DISTINCT p.ID)\n"
                    . "FROM %i p\n"
                    . "LEFT JOIN %i pm_no ON pm_no.post_id = p.ID AND pm_no.meta_key = %s\n"
                    . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                    . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                    . "\tAND pm_no.meta_value = %s"
                    , array_merge(
                        array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_nofollow' ),
                        $aegisseo_params_base,
                        array( '1' )
                    )
                )
            ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

        } elseif ( $aegisseo_filter === 'missing_title' ) {
            if ( $aegisseo_search !== '' ) {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_title ON pm_title.post_id = p.ID AND pm_title.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_title.meta_value IS NULL OR pm_title.meta_value = '')\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_title' ),
                            $aegisseo_params_base,
                            $aegisseo_params_search
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_title ON pm_title.post_id = p.ID AND pm_title.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_title.meta_value IS NULL OR pm_title.meta_value = '')"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_title' ),
                            $aegisseo_params_base
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }

        } elseif ( $aegisseo_filter === 'missing_desc' ) {
            if ( $aegisseo_search !== '' ) {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_desc ON pm_desc.post_id = p.ID AND pm_desc.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_desc.meta_value IS NULL OR pm_desc.meta_value = '')\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_description' ),
                            $aegisseo_params_base,
                            $aegisseo_params_search
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_desc ON pm_desc.post_id = p.ID AND pm_desc.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_desc.meta_value IS NULL OR pm_desc.meta_value = '')"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_description' ),
                            $aegisseo_params_base
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }

        } else {
            if ( $aegisseo_search !== '' ) {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)"
                        , array_merge(
                            array( $aegisseo_posts_table ),
                            $aegisseo_params_base,
                            $aegisseo_params_search
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_total = (int) $wpdb->get_var( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT COUNT(DISTINCT p.ID)\n"
                        . "FROM %i p\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")"
                        , array_merge(
                            array( $aegisseo_posts_table ),
                            $aegisseo_params_base
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }
        }

        wp_cache_set( $aegisseo_cache_base . '_total', $aegisseo_total, 'aegisseo', MINUTE_IN_SECONDS );
        $aegisseo_total_cache = $aegisseo_total;
    }

    // ---------- IDS (paged) ----------
    $aegisseo_ids_cache = wp_cache_get( $aegisseo_cache_base . '_ids', 'aegisseo' );
    if ( false !== $aegisseo_ids_cache && is_array( $aegisseo_ids_cache ) ) {
        $aegisseo_ids = $aegisseo_ids_cache;
    } else {
        if ( $aegisseo_filter === 'noindex' ) {

            $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT DISTINCT p.ID\n"
                    . "FROM %i p\n"
                    . "LEFT JOIN %i pm_no ON pm_no.post_id = p.ID AND pm_no.meta_key = %s\n"
                    . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                    . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                    . "\tAND pm_no.meta_value = %s\n"
                    . "ORDER BY p.post_date DESC\n"
                    . "LIMIT %d OFFSET %d"
                    , array_merge(
                        array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_noindex' ),
                        $aegisseo_params_base,
                        array( '1' ),
                        array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                    )
                )
            ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

        } elseif ( $aegisseo_filter === 'nofollow' ) {

            $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                $wpdb->prepare(
                    "SELECT DISTINCT p.ID\n"
                    . "FROM %i p\n"
                    . "LEFT JOIN %i pm_no ON pm_no.post_id = p.ID AND pm_no.meta_key = %s\n"
                    . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                    . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                    . "\tAND pm_no.meta_value = %s\n"
                    . "ORDER BY p.post_date DESC\n"
                    . "LIMIT %d OFFSET %d"
                    , array_merge(
                        array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_nofollow' ),
                        $aegisseo_params_base,
                        array( '1' ),
                        array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                    )
                )
            ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

        } elseif ( $aegisseo_filter === 'missing_title' ) {

            if ( $aegisseo_search !== '' ) {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_title ON pm_title.post_id = p.ID AND pm_title.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_title.meta_value IS NULL OR pm_title.meta_value = '')\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_title' ),
                            $aegisseo_params_base,
                            $aegisseo_params_search,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_title ON pm_title.post_id = p.ID AND pm_title.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_title.meta_value IS NULL OR pm_title.meta_value = '')\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_title' ),
                            $aegisseo_params_base,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }

        } elseif ( $aegisseo_filter === 'missing_desc' ) {

            if ( $aegisseo_search !== '' ) {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_desc ON pm_desc.post_id = p.ID AND pm_desc.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_desc.meta_value IS NULL OR pm_desc.meta_value = '')\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_description' ),
                            $aegisseo_params_base,
                            $aegisseo_params_search,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "LEFT JOIN %i pm_desc ON pm_desc.post_id = p.ID AND pm_desc.meta_key = %s\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (pm_desc.meta_value IS NULL OR pm_desc.meta_value = '')\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table, $aegisseo_postmeta_table, '_aegisseo_description' ),
                            $aegisseo_params_base,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }

        } else {

            if ( $aegisseo_search !== '' ) {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "\tAND (p.post_title LIKE %s OR p.post_content LIKE %s)\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table ),
                            $aegisseo_params_base,
                            $aegisseo_params_search,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            } else {
                $aegisseo_ids = $wpdb->get_col( // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $wpdb->prepare(
                        "SELECT DISTINCT p.ID\n"
                        . "FROM %i p\n"
                        . "WHERE p.post_type IN (" . implode( ',', array_fill( 0, count( $aegisseo_chosen_types ), '%s' ) ) . ")\n"
                        . "\tAND p.post_status IN (" . implode( ',', array_fill( 0, 5, '%s' ) ) . ")\n"
                        . "ORDER BY p.post_date DESC\n"
                        . "LIMIT %d OFFSET %d"
                        , array_merge(
                            array( $aegisseo_posts_table ),
                            $aegisseo_params_base,
                            array( (int) $aegisseo_per_page, (int) $aegisseo_offset )
                        )
                    )
                ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            }
        }

        wp_cache_set( $aegisseo_cache_base . '_ids', $aegisseo_ids, 'aegisseo', 60 );
        $aegisseo_ids_cache = $aegisseo_ids;
    }
    if (!empty($aegisseo_ids)) {
        $aegisseo_posts = get_posts(array(
            'post__in'       => array_map('intval', $aegisseo_ids),
            'orderby'        => 'post__in',
            'posts_per_page' => count($aegisseo_ids),
            'post_type'      => $aegisseo_chosen_types,
            'post_status'    => array('publish','draft','pending','future','private'),
        ));
    } else {
        $aegisseo_posts = array();
    }

    foreach ($aegisseo_posts as $aegisseo_p) {
        $aegisseo_id = $aegisseo_p->ID;
        $aegisseo_seo_title = (string) get_post_meta($aegisseo_id, '_aegisseo_title', true);
        $aegisseo_seo_desc  = (string) get_post_meta($aegisseo_id, '_aegisseo_description', true);
        $aegisseo_canon     = (string) get_post_meta($aegisseo_id, '_aegisseo_canonical', true);
        $aegisseo_noindex   = (int) get_post_meta($aegisseo_id, '_aegisseo_noindex', true);
        $aegisseo_nofollow  = (int) get_post_meta($aegisseo_id, '_aegisseo_nofollow', true);

        $aegisseo_content_plain = wp_strip_all_tags((string) $aegisseo_p->post_content);
        $aegisseo_word_count = str_word_count($aegisseo_content_plain);

        $aegisseo_rows[] = array($aegisseo_p, $aegisseo_seo_title, $aegisseo_seo_desc, $aegisseo_canon, $aegisseo_noindex, $aegisseo_nofollow, $aegisseo_word_count);
    }
} else {
    $aegisseo_ids = aegisseo_bulk_compute_ids($aegisseo_filter, $aegisseo_chosen_types, $aegisseo_search);
    $aegisseo_total = count($aegisseo_ids);
    $aegisseo_page_ids = array_slice($aegisseo_ids, $aegisseo_offset, $aegisseo_per_page);

    $aegisseo_posts = array();
    if (!empty($aegisseo_page_ids)) {
        $aegisseo_posts = get_posts(array(
            'post__in'       => array_map('intval', $aegisseo_page_ids),
            'orderby'        => 'post__in',
            'posts_per_page' => count($aegisseo_page_ids),
            'post_type'      => $aegisseo_chosen_types,
            'post_status'    => array('publish','draft','pending','future','private'),
        ));
    }

    foreach ($aegisseo_posts as $aegisseo_p) {
        $aegisseo_id = $aegisseo_p->ID;
        $aegisseo_seo_title = (string) get_post_meta($aegisseo_id, '_aegisseo_title', true);
        $aegisseo_seo_desc  = (string) get_post_meta($aegisseo_id, '_aegisseo_description', true);
        $aegisseo_canon     = (string) get_post_meta($aegisseo_id, '_aegisseo_canonical', true);
        $aegisseo_noindex   = (int) get_post_meta($aegisseo_id, '_aegisseo_noindex', true);
        $aegisseo_nofollow  = (int) get_post_meta($aegisseo_id, '_aegisseo_nofollow', true);

        $aegisseo_content_plain = wp_strip_all_tags((string) $aegisseo_p->post_content);
        $aegisseo_word_count = str_word_count($aegisseo_content_plain);

        $aegisseo_rows[] = array($aegisseo_p, $aegisseo_seo_title, $aegisseo_seo_desc, $aegisseo_canon, $aegisseo_noindex, $aegisseo_nofollow, $aegisseo_word_count);
    }
}

$aegisseo_total_pages = max(1, (int) ceil($aegisseo_total / $aegisseo_per_page));
if ($aegisseo_paged > $aegisseo_total_pages) { $aegisseo_paged = $aegisseo_total_pages; }

$aegisseo_nonce_ajax = wp_create_nonce('aegisseo_bulk_save_ajax');
$aegisseo_bulk_nonce_value = wp_create_nonce('aegisseo_bulk_page');
?>
<div class="wrap">
    <h2><?php echo esc_html__('Bulk SEO Manager', 'aegisseo'); ?></h2>

    <div id="aegisseo-bulk-notice"></div>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" style="margin: 12px 0;">
        <input type="hidden" name="page" value="aegisseo" />
        <input type="hidden" name="tab" value="bulk" />
        <input type="hidden" name="aegisseo_bulk_nonce" value="<?php echo esc_attr($aegisseo_bulk_nonce_value); ?>" />

        <label style="margin-right:12px;">
            <?php echo esc_html__('Post Type', 'aegisseo'); ?>
            <select name="post_type">
                <option value="any" <?php selected($aegisseo_post_type, 'any'); ?>><?php echo esc_html__('All', 'aegisseo'); ?></option>
                <?php foreach ($aegisseo_post_types as $aegisseo_k => $aegisseo_obj): ?>
                    <option value="<?php echo esc_attr($aegisseo_k); ?>" <?php selected($aegisseo_post_type, $aegisseo_k); ?>><?php echo esc_html($aegisseo_obj->labels->singular_name); ?></option>
                <?php endforeach; ?>
            </select>
        </label>

        <label style="margin-right:12px;">
            <?php echo esc_html__('Filter', 'aegisseo'); ?>
            <select name="filter">
                <option value="" <?php selected($aegisseo_filter, ''); ?>><?php echo esc_html__('None', 'aegisseo'); ?></option>
                <option value="no_meta" <?php selected($aegisseo_filter, 'no_meta'); ?>><?php echo esc_html__('No title & description', 'aegisseo'); ?></option>
                <option value="thin" <?php selected($aegisseo_filter, 'thin'); ?>><?php echo esc_html__('Thin content (<300 words)', 'aegisseo'); ?></option>
                <option value="noindex" <?php selected($aegisseo_filter, 'noindex'); ?>><?php echo esc_html__('Noindex enabled', 'aegisseo'); ?></option>
                <option value="dup_title" <?php selected($aegisseo_filter, 'dup_title'); ?>><?php echo esc_html__('Duplicate SEO title (site-wide)', 'aegisseo'); ?></option>
            </select>
        </label>

        <label style="margin-right:12px;">
            <?php echo esc_html__('Per page', 'aegisseo'); ?>
            <select name="per_page">
                <option value="25" <?php selected($aegisseo_per_page, 25); ?>>25</option>
                <option value="50" <?php selected($aegisseo_per_page, 50); ?>>50</option>
                <option value="100" <?php selected($aegisseo_per_page, 100); ?>>100</option>
            </select>
        </label>

        <label style="margin-right:12px;">
            <?php echo esc_html__('Search', 'aegisseo'); ?>
            <input type="text" name="s" value="<?php echo esc_attr($aegisseo_search); ?>" placeholder="<?php echo esc_attr__('Title or content…', 'aegisseo'); ?>" />
        </label>

        <button class="button"><?php echo esc_html__('Apply', 'aegisseo'); ?></button>
    </form>

    <div class="aegisseo-card" style="padding:12px; margin-bottom:12px;">
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin-right:8px;">
            <?php wp_nonce_field('aegisseo_bulk_export'); ?>
            <input type="hidden" name="action" value="aegisseo_bulk_export" />
            <input type="hidden" name="post_type" value="<?php echo esc_attr($aegisseo_post_type); ?>" />
            <button class="button"><?php echo esc_html__('Export CSV', 'aegisseo'); ?></button>
        </form>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" enctype="multipart/form-data" style="display:inline-block;">
            <?php wp_nonce_field('aegisseo_bulk_import'); ?>
            <input type="hidden" name="action" value="aegisseo_bulk_import" />
            <input type="file" name="csv" accept=".csv,text/csv" required />
            <button class="button"><?php echo esc_html__('Import CSV', 'aegisseo'); ?></button>
        </form>

        <span style="margin-left:10px; color:#666;">
            <?php
            /* translators: %d: number of matched posts. */
            echo esc_html(sprintf(__('Matches: %d', 'aegisseo'), (int) $aegisseo_total));
            ?>
        </span>
    </div>

    <form id="aegisseo-bulk-form" method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" data-aegisseo-ajax-nonce="<?php echo esc_attr($aegisseo_nonce_ajax); ?>">
        <?php wp_nonce_field('aegisseo_bulk_save'); ?>
        <input type="hidden" name="action" value="aegisseo_bulk_save" />

        <table class="widefat striped">
            <thead>
                <tr>
                    <th><?php echo esc_html__('Post', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('SEO Title', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('Meta Description', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('Canonical', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('Noindex', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('Nofollow', 'aegisseo'); ?></th>
                    <th><?php echo esc_html__('Words', 'aegisseo'); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($aegisseo_rows)): ?>
                <tr><td colspan="7"><?php echo esc_html__('No rows found for this view.', 'aegisseo'); ?></td></tr>
            <?php else: foreach ($aegisseo_rows as $aegisseo_r): list($aegisseo_p,$aegisseo_seo_title,$aegisseo_seo_desc,$aegisseo_canon,$aegisseo_noindex,$aegisseo_nofollow,$aegisseo_wc) = $aegisseo_r; ?>
                <tr data-post-id="<?php echo (int) $aegisseo_p->ID; ?>">
                    <td>
                        <strong><?php echo esc_html($aegisseo_p->post_title); ?></strong><br/>
                        <a href="<?php echo esc_url(get_edit_post_link($aegisseo_p->ID)); ?>"><?php echo esc_html__('Edit', 'aegisseo'); ?></a>
                        <span style="color:#666;">(#<?php echo (int)$aegisseo_p->ID; ?>)</span>
                    </td>
                    <td><input class="widefat" type="text" name="rows[<?php echo (int)$aegisseo_p->ID; ?>][title]" value="<?php echo esc_attr($aegisseo_seo_title); ?>" /></td>
                    <td><textarea class="widefat" name="rows[<?php echo (int)$aegisseo_p->ID; ?>][description]" rows="2"><?php echo esc_textarea($aegisseo_seo_desc); ?></textarea></td>
                    <td><input class="widefat" type="url" name="rows[<?php echo (int)$aegisseo_p->ID; ?>][canonical]" value="<?php echo esc_attr($aegisseo_canon); ?>" /></td>
                    <td style="text-align:center;"><input type="checkbox" name="rows[<?php echo (int)$aegisseo_p->ID; ?>][noindex]" value="1" <?php checked($aegisseo_noindex, 1); ?> /></td>
                    <td style="text-align:center;"><input type="checkbox" name="rows[<?php echo (int)$aegisseo_p->ID; ?>][nofollow]" value="1" <?php checked($aegisseo_nofollow, 1); ?> /></td>
                    <td><?php echo (int)$aegisseo_wc; ?></td>
                </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>

        <p style="margin-top:12px; display:flex; gap:10px; align-items:center;">
            <button id="aegisseo-bulk-save-btn" class="button button-primary"><?php echo esc_html__('Save Changes', 'aegisseo'); ?></button>
            <span id="aegisseo-bulk-saving" style="display:none;"><?php echo esc_html__('Saving…', 'aegisseo'); ?></span>
        </p>
    </form>

    <?php if ($aegisseo_total_pages > 1): 
        $aegisseo_base_url = admin_url('admin.php?page=aegisseo&tab=bulk&post_type=' . urlencode($aegisseo_post_type) . '&filter=' . urlencode($aegisseo_filter) . '&per_page=' . urlencode((string) $aegisseo_per_page) . '&s=' . urlencode($aegisseo_search) . '&aegisseo_bulk_nonce=' . urlencode($aegisseo_bulk_nonce_value));
    ?>
        <div class="tablenav" style="margin-top:12px;">
            <div class="tablenav-pages">
                <span class="displaying-num"><?php
                    /* translators: %d: total number of items. */
                    echo esc_html(sprintf(__('%d items', 'aegisseo'), (int) $aegisseo_total));
                    ?></span>
                <span class="pagination-links">
                    <?php
                    $aegisseo_prev = max(1, $aegisseo_paged - 1);
                    $aegisseo_next = min($aegisseo_total_pages, $aegisseo_paged + 1);
                    ?>
                    <a class="button" href="<?php echo esc_url($aegisseo_base_url . '&paged=1'); ?>">&laquo;</a>
                    <a class="button" href="<?php echo esc_url($aegisseo_base_url . '&paged=' . $aegisseo_prev); ?>">&lsaquo;</a>
                    <span class="paging-input">
                        <?php echo esc_html($aegisseo_paged . ' / ' . $aegisseo_total_pages); ?>
                    </span>
                    <a class="button" href="<?php echo esc_url($aegisseo_base_url . '&paged=' . $aegisseo_next); ?>">&rsaquo;</a>
                    <a class="button" href="<?php echo esc_url($aegisseo_base_url . '&paged=' . $aegisseo_total_pages); ?>">&raquo;</a>
                </span>
            </div>
        </div>
    <?php endif; ?>
</div>