<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}

if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {

    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('(PRO feature: Evidence Reporting (GSC deltas, annotations, annotated events, and “why” explanations) is available in AegisSEO PRO.)', 'aegisseo')
    );

    echo '<p class="description" style="margin-top:10px;">' .
        esc_html__('Activate a PRO license to unlock Evidence Reporting.', 'aegisseo') .
    '</p>';

    return;
}

$aegisseo_nonce_ok = (isset($_GET['_wpnonce']) && wp_verify_nonce(
    sanitize_text_field(wp_unslash($_GET['_wpnonce'])),
    'aegisseo_evidence_filter'
));
$post_id = ($aegisseo_nonce_ok && isset($_GET['post_id'])) ? absint(wp_unslash($_GET['post_id'])) : 0;
$aegisseo_url = ($aegisseo_nonce_ok && isset($_GET['url'])) ? esc_url_raw(wp_unslash($_GET['url'])) : '';
?>

<form method="get" action="" style="margin:10px 0 16px;">
    <?php wp_nonce_field('aegisseo_evidence_filter'); ?>
    <input type="hidden" name="page" value="aegisseo" />
    <input type="hidden" name="tab" value="evidence" />
    <label for="aegisseo-evidence-url" style="display:block; font-weight:600; margin-bottom:6px;"><?php echo esc_html__('Evidence Timeline per URL', 'aegisseo'); ?></label>
    <div style="display:flex; gap:8px; align-items:center; flex-wrap:wrap;">
        <input id="aegisseo-evidence-url" class="regular-text" type="url" name="url" value="<?php echo esc_attr($aegisseo_url); ?>" placeholder="<?php echo esc_attr(site_url('/example-page/')); ?>" style="min-width:320px;" />
        <button class="button"><?php echo esc_html__('Load', 'aegisseo'); ?></button>
        <?php if ($post_id): ?>
            <a class="button button-link-delete" href="<?php echo esc_url(admin_url('admin.php?page=aegisseo&tab=evidence&_wpnonce=' . wp_create_nonce('aegisseo_evidence_filter'))); ?>"><?php echo esc_html__('Clear', 'aegisseo'); ?></a>
        <?php endif; ?>
    </div>
    <p class="description" style="margin-top:6px;"><?php echo esc_html__('Paste a URL from your site. AegisSEO will resolve it to a post/page and show exactly what changed and what happened in Search Console.', 'aegisseo'); ?></p>
</form>

<?php
$aegisseo_nonce_ok = (isset($_GET['_wpnonce']) && wp_verify_nonce(
    sanitize_text_field(wp_unslash($_GET['_wpnonce'])),
    'aegisseo_evidence_filter'
));

$aegisseo_ran = ($aegisseo_nonce_ok && isset($_GET['ran'])) ? absint(wp_unslash($_GET['ran'])) : 0;
if ($aegisseo_ran === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Snapshot runner executed (best-effort).', 'aegisseo') . '</p></div>';
}

$post_id = ($aegisseo_nonce_ok && isset($_GET['post_id'])) ? absint(wp_unslash($_GET['post_id'])) : 0;
$aegisseo_url = ($aegisseo_nonce_ok && isset($_GET['url'])) ? esc_url_raw(wp_unslash($_GET['url'])) : '';
if ($post_id === 0 && $aegisseo_url !== '') {
    $post_id = url_to_postid($aegisseo_url);
}


?>
<h2><?php echo esc_html__('Evidence Reporting', 'aegisseo'); ?></h2>
<p class="description">
    <?php echo esc_html__('Proof > toggles. This screen correlates SEO changes (events) with Search Console metrics (snapshots) to explain what moved and why.', 'aegisseo'); ?>
</p>

<div style="margin:16px 0; padding:12px; border:1px solid #dcdcde; background:#fff;">
    <strong><?php echo esc_html__('Snapshot Runner', 'aegisseo'); ?></strong>
    <p class="description" style="margin-top:6px;">
        <?php echo esc_html__('Runs a best-effort GSC snapshot pull (last 3 days window, up to 50 latest posts). Use daily cron for normal operation.', 'aegisseo'); ?>
    </p>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
        <?php wp_nonce_field('aegisseo_run_gsc_snapshot_now'); ?>
        <input type="hidden" name="action" value="aegisseo_run_gsc_snapshot_now" />
        <button class="button button-secondary" type="submit"><?php echo esc_html__('Run Snapshots Now', 'aegisseo'); ?></button>
    </form>
</div>

<div style="margin:16px 0; padding:12px; border:1px solid #dcdcde; background:#fff;">
    <strong><?php echo esc_html__('Per-Page Before/After Card', 'aegisseo'); ?></strong>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>" style="margin-top:10px;">
        <?php wp_nonce_field('aegisseo_evidence_filter'); ?>
        <input type="hidden" name="page" value="aegisseo" />
        <input type="hidden" name="tab" value="evidence" />
        <label for="aegisseo_evidence_post" style="display:inline-block; min-width:120px;"><?php echo esc_html__('Choose Page', 'aegisseo'); ?></label>
        <select name="post_id" id="aegisseo_evidence_post">
            <option value="0"><?php echo esc_html__('-- Select --', 'aegisseo'); ?></option>
            <?php
            $aegisseo_picks = get_posts(array(
                'post_type' => 'any',
                'post_status' => 'publish',
                'posts_per_page' => 50,
                'orderby' => 'modified',
                'order' => 'DESC',
            ));
            foreach ($aegisseo_picks as $aegisseo_p) {
                echo '<option value="' . (int)$aegisseo_p->ID . '" ' . selected($post_id, (int)$aegisseo_p->ID, false) . '>' . esc_html(get_the_title($aegisseo_p->ID)) . ' (#' . (int)$aegisseo_p->ID . ')</option>';
            }
            ?>
        </select>
        <button class="button" type="submit" style="margin-left:8px;"><?php echo esc_html__('View Evidence', 'aegisseo'); ?></button>
    </form>

    <?php if ($post_id > 0): ?>
        <?php
        $post = get_post($post_id);
        $aegisseo_url = $post ? get_permalink($post_id) : '';
        $aegisseo_series = array();
        if (isset(aegisseo()->gsc_snapshots) && aegisseo()->gsc_snapshots) {
            $aegisseo_series = aegisseo()->gsc_snapshots->get_series($post_id, 28);
        }

        $aegisseo_last14 = 0; $aegisseo_prev14 = 0;
        if (!empty($aegisseo_series)) {
            $aegisseo_by = array();
            foreach ($aegisseo_series as $aegisseo_row) {
                $aegisseo_by[(string)$aegisseo_row['snap_date']] = $aegisseo_row;
            }
            $aegisseo_dates = array_keys($aegisseo_by);
            sort($aegisseo_dates);
            $aegisseo_cut = max(0, count($aegisseo_dates)-14);
            $aegisseo_last_dates = array_slice($aegisseo_dates, $aegisseo_cut);
            $aegisseo_prev_dates = array_slice($aegisseo_dates, max(0, $aegisseo_cut-14), 14);

            foreach ($aegisseo_last_dates as $aegisseo_d) { $aegisseo_last14 += isset($aegisseo_by[$aegisseo_d]['clicks']) ? (float)$aegisseo_by[$aegisseo_d]['clicks'] : 0; }
            foreach ($aegisseo_prev_dates as $aegisseo_d) { $aegisseo_prev14 += isset($aegisseo_by[$aegisseo_d]['clicks']) ? (float)$aegisseo_by[$aegisseo_d]['clicks'] : 0; }
        }

        $aegisseo_delta = ($aegisseo_prev14 > 0) ? (($aegisseo_last14 - $aegisseo_prev14) / $aegisseo_prev14) * 100 : 0;
        ?>
        <hr style="margin:14px 0;" />
        <h3 style="margin:0;"><?php echo esc_html(get_the_title($post_id)); ?></h3>
        <p class="description" style="margin-top:6px;">
            <a href="<?php echo esc_url($aegisseo_url); ?>" target="_blank" rel="noopener"><?php echo esc_html($aegisseo_url); ?></a>
        </p>

        <div style="display:flex; gap:12px; flex-wrap:wrap; margin-top:10px;">
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Clicks (last 14 days)', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;"><?php echo esc_html(number_format_i18n($aegisseo_last14, 2)); ?></div>
            </div>
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Clicks (previous 14 days)', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;"><?php echo esc_html(number_format_i18n($aegisseo_prev14, 2)); ?></div>
            </div>
            <div style="flex:1; min-width:220px; padding:10px; border:1px solid #dcdcde; background:#f6f7f7;">
                <div style="font-size:12px; color:#666;"><?php echo esc_html__('Change', 'aegisseo'); ?></div>
                <div style="font-size:22px; font-weight:600;">
                    <?php
                    $aegisseo_sign = ($aegisseo_last14 - $aegisseo_prev14) >= 0 ? '+' : '';
                    echo esc_html($aegisseo_sign . number_format_i18n(($aegisseo_last14 - $aegisseo_prev14), 2));
                    ?>
                    <span style="font-size:14px; color:#666;">(<?php echo esc_html(number_format_i18n($aegisseo_delta, 1)); ?>%)</span>
                </div>
            </div>
        </div>

        <div style="margin-top:12px;">
            <strong><?php echo esc_html__('Annotated Timeline (snapshots + events)', 'aegisseo'); ?></strong>
            <p class="description" style="margin-top:6px;">
                <?php echo esc_html__('Each row is a daily snapshot. Events are shown as markers (title/meta/schema/redirect/link actions).', 'aegisseo'); ?>
            </p>
            <?php

            $aegisseo_ev = array();
            if (isset(aegisseo()->events) && aegisseo()->events) {
                $aegisseo_ev = aegisseo()->events->get_recent(200, 'post', $post_id);
            }
            $aegisseo_ev_by_date = array();
            foreach ((array)$aegisseo_ev as $aegisseo_e) {
                if (empty($aegisseo_e['created_at'])) continue;
                $aegisseo_d = substr((string)$aegisseo_e['created_at'], 0, 10);
                if (!isset($aegisseo_ev_by_date[$aegisseo_d])) $aegisseo_ev_by_date[$aegisseo_d] = array();
                $aegisseo_ev_by_date[$aegisseo_d][] = $aegisseo_e;
            }

            $aegisseo_max_clicks = 0;
            foreach ((array)$aegisseo_series as $s) {
                $aegisseo_c = isset($s['clicks']) ? (float)$s['clicks'] : 0;
                if ($aegisseo_c > $aegisseo_max_clicks) $aegisseo_max_clicks = $aegisseo_c;
            }
            if ($aegisseo_max_clicks <= 0) $aegisseo_max_clicks = 1;
            ?>

            <table class="widefat striped" style="margin-top:10px;">
                <thead>
                    <tr>
                        <th style="width:120px;"><?php echo esc_html__('Date', 'aegisseo'); ?></th>
                        <th style="width:90px;"><?php echo esc_html__('Clicks', 'aegisseo'); ?></th>
                        <th><?php echo esc_html__('Trend + Event Markers', 'aegisseo'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($aegisseo_series)): ?>
                        <tr><td colspan="3"><?php echo esc_html__('No snapshots yet for this page. Run the snapshot runner and ensure GSC is connected.', 'aegisseo'); ?></td></tr>
                    <?php else: ?>
                        <?php foreach ($aegisseo_series as $s): ?>
                            <?php
                            $aegisseo_d = (string)$s['snap_date'];
                            $aegisseo_clicks = isset($s['clicks']) ? (float)$s['clicks'] : 0;
                            $aegisseo_w = (int) round(($aegisseo_clicks / $aegisseo_max_clicks) * 100);
                            $aegisseo_markers = isset($aegisseo_ev_by_date[$aegisseo_d]) ? $aegisseo_ev_by_date[$aegisseo_d] : array();
                            ?>
                            <tr>
                                <td><code><?php echo esc_html($aegisseo_d); ?></code></td>
                                <td><?php echo esc_html(number_format_i18n($aegisseo_clicks, 2)); ?></td>
                                <td>
                                    <div style="height:12px; background:#e5e5e5; border-radius:8px; overflow:hidden; display:inline-block; width:220px; vertical-align:middle;">
                                        <div style="height:12px; width:<?php echo (int)$aegisseo_w; ?>%; background:#2271b1;"></div>
                                    </div>
                                    <?php if (!empty($aegisseo_markers)): ?>
                                        <span style="margin-left:10px;">
                                            <?php foreach ($aegisseo_markers as $aegisseo_e): ?>
                                                <?php
                                                $aegisseo_t = isset($aegisseo_e['event_type']) ? (string)$aegisseo_e['event_type'] : '';
                                                $aegisseo_label = $aegisseo_t;
                                                if ($aegisseo_t === 'schema_approved') $aegisseo_label = 'Schema';
                                                if ($aegisseo_t === 'links_applied') $aegisseo_label = 'Links';
                                                if ($aegisseo_t === 'redirect_approved') $aegisseo_label = 'Redirect';
                                                if ($aegisseo_t === 'fix_applied') $aegisseo_label = 'Fix';
                                                if ($aegisseo_t === 'meta_update' || $aegisseo_t === 'meta_add' || $aegisseo_t === 'meta_delete') $aegisseo_label = 'Meta';
                                                ?>
                                                <span title="<?php echo esc_attr($aegisseo_t); ?>" style="display:inline-block; margin-right:6px; padding:2px 6px; border-radius:10px; border:1px solid #dcdcde; background:#fff; font-size:11px;">
                                                    <?php echo esc_html($aegisseo_label); ?>
                                                </span>
                                            <?php endforeach; ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>

            <?php
            $aegisseo_schema_event_date = '';
            foreach ((array)$aegisseo_ev as $aegisseo_e) {
                if (!empty($aegisseo_e['event_type']) && $aegisseo_e['event_type'] === 'schema_approved' && !empty($aegisseo_e['created_at'])) {
                    $aegisseo_schema_event_date = substr((string)$aegisseo_e['created_at'], 0, 10);
                    break;
                }
            }
            if ($aegisseo_schema_event_date !== '' && $aegisseo_prev14 > 0 && $aegisseo_last14 > $aegisseo_prev14):
            ?>
                <div style="margin-top:12px; padding:10px; border-left:4px solid #2271b1; background:#f0f6fc;">
                    <strong><?php echo esc_html__('Why it moved', 'aegisseo'); ?></strong>
                    <p style="margin:6px 0 0;">
                        <?php echo esc_html__('Clicks improved after a schema change was applied. Review queries in GSC to confirm which terms benefited.', 'aegisseo'); ?>
                        <span style="color:#666;"><?php echo esc_html__('Schema event date:', 'aegisseo'); ?> <code><?php echo esc_html($aegisseo_schema_event_date); ?></code></span>
                    </p>
                </div>
            
            <?php
            $aegisseo_property = isset(aegisseo()->options) ? (string) aegisseo()->options->get('gsc_property', '') : '';
            $aegisseo_page_url = $aegisseo_url;
            if ($aegisseo_property !== '' && !empty(aegisseo()->gsc) && method_exists(aegisseo()->gsc, 'fetch_page_queries')) {
                $aegisseo_cache_key = 'aegisseo_gsc_q_' . (int)$post_id . '_' . md5($aegisseo_property . '|' . $aegisseo_page_url . '|' . $p14_start . '|' . $last14_start);
                $aegisseo_qpack = get_transient($aegisseo_cache_key);
                if (!is_array($aegisseo_qpack)) {
                    $aegisseo_q_last = aegisseo()->gsc->fetch_page_queries($aegisseo_property, $aegisseo_page_url, $last14_start, $today, 12);
                    $aegisseo_q_prev = aegisseo()->gsc->fetch_page_queries($aegisseo_property, $aegisseo_page_url, $p14_start, $p14_end, 12);
                    $aegisseo_qpack = array('last'=>$aegisseo_q_last, 'prev'=>$aegisseo_q_prev);
                    set_transient($aegisseo_cache_key, $aegisseo_qpack, 10 * MINUTE_IN_SECONDS);
                }

                $aegisseo_q_last = $aegisseo_qpack['last'];
                $aegisseo_q_prev = $aegisseo_qpack['prev'];

                if (!is_wp_error($aegisseo_q_last) && !is_wp_error($aegisseo_q_prev)) {
                    $aegisseo_m_last = array();
                    foreach ((array)$aegisseo_q_last as $aegisseo_r) { $aegisseo_m_last[(string)$aegisseo_r['query']] = $aegisseo_r; }
                    $aegisseo_m_prev = array();
                    foreach ((array)$aegisseo_q_prev as $aegisseo_r) { $aegisseo_m_prev[(string)$aegisseo_r['query']] = $aegisseo_r; }

                    $aegisseo_diff = array();
                    $aegisseo_allq = array_unique(array_merge(array_keys($aegisseo_m_last), array_keys($aegisseo_m_prev)));
                    foreach ($aegisseo_allq as $aegisseo_q) {
                        $aegisseo_a = $aegisseo_m_last[$aegisseo_q] ?? array('clicks'=>0,'impressions'=>0);
                        $aegisseo_b = $aegisseo_m_prev[$aegisseo_q] ?? array('clicks'=>0,'impressions'=>0);
                        $aegisseo_diff[] = array(
                            'query' => $aegisseo_q,
                            'clicks_delta' => (float)$aegisseo_a['clicks'] - (float)$aegisseo_b['clicks'],
                            'impr_delta' => (float)$aegisseo_a['impressions'] - (float)$aegisseo_b['impressions'],
                            'last_clicks' => (float)$aegisseo_a['clicks'],
                            'prev_clicks' => (float)$aegisseo_b['clicks'],
                        );
                    }
                    usort($aegisseo_diff, function($x,$y){
                        return ($y['clicks_delta'] <=> $x['clicks_delta']);
                    });
                    $aegisseo_diff = array_slice($aegisseo_diff, 0, 10);

                    ?>
                    <hr style="margin:16px 0;" />
                    <h3 style="margin:0 0 8px;"><?php echo esc_html__('Top Query Changes (Last 14d vs Prev 14d)', 'aegisseo'); ?></h3>
                    <p class="description" style="margin-top:0;">
                        <?php echo esc_html__('This is live GSC query data (cached ~10 min). It helps explain which searches moved after SEO changes.', 'aegisseo'); ?>
                    </p>
                    <table class="widefat striped">
                        <thead>
                            <tr>
                                <th><?php echo esc_html__('Query', 'aegisseo'); ?></th>
                                <th style="width:120px;"><?php echo esc_html__('Clicks Δ', 'aegisseo'); ?></th>
                                <th style="width:140px;"><?php echo esc_html__('Impressions Δ', 'aegisseo'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($aegisseo_diff as $aegisseo_drow): ?>
                            <tr>
                                <td><?php echo esc_html($aegisseo_drow['query']); ?></td>
                                <td><?php echo esc_html(number_format_i18n($aegisseo_drow['clicks_delta'], 0)); ?></td>
                                <td><?php echo esc_html(number_format_i18n($aegisseo_drow['impr_delta'], 0)); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php
                    $aegisseo_schema_type = (string) get_post_meta($post_id, '_aegisseo_schema_type', true);
                    if ($aegisseo_schema_event_date !== '' && $aegisseo_schema_type !== '') {
                        $aegisseo_pos_hits = 0;
                        foreach ($aegisseo_diff as $aegisseo_drow) { if ($aegisseo_drow['clicks_delta'] > 0) { $aegisseo_pos_hits++; } }
                        if ($aegisseo_pos_hits > 0) {
                            ?>
                            <div style="margin-top:12px; padding:10px; border-left:4px solid #00a32a; background:#edfaef;">
                                <strong><?php echo esc_html__('Why it changed (best-effort)', 'aegisseo'); ?></strong>
                                <p style="margin:6px 0 0;">
                                    <?php
                                    echo esc_html(sprintf(
                                        'After applying %s schema, some queries gained clicks in the last 14 days vs the previous 14 days. Review the table above to confirm which terms benefited.',
                                        $aegisseo_schema_type
                                    ));
                                    ?>
                                    <span style="color:#666;"><?php echo esc_html__('Schema applied on', 'aegisseo'); ?> <code><?php echo esc_html($aegisseo_schema_event_date); ?></code></span>
                                </p>
                            </div>
                            <?php
                        }
                    }
                }
            }
            ?>
<?php endif; ?>

        </div>
    <?php endif; ?>
</div>