<?php
if (!defined('ABSPATH')) { exit; }

add_action('admin_enqueue_scripts', function () {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $page = isset($_GET['page']) ? sanitize_key((string) wp_unslash($_GET['page'])) : '';
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $tab  = isset($_GET['tab']) ? sanitize_key((string) wp_unslash($_GET['tab'])) : '';

    if ($page === 'aegisseo' && $tab === 'issues') {
        wp_enqueue_script('jquery');
    }
});

add_action('wp_ajax_aegisseo_quick_generate', function () {
    if (!current_user_can('edit_posts')) {
        wp_send_json_error(array('message' => 'forbidden'), 403);
    }
    check_ajax_referer('aegisseo_quick_fix', 'nonce');

    $post_id = isset($_POST['post_id']) ? absint($_POST['post_id']) : 0;
    $aegisseo_field   = isset($_POST['field']) ? sanitize_key(wp_unslash($_POST['field'])) : '';

    if (!$post_id || !get_post($post_id) || !current_user_can('edit_post', $post_id)) {
        wp_send_json_error(array('message' => 'invalid_post'), 400);
    }

    $allowed = array(
        'meta_description' => '_aegisseo_description',
        'og_title'         => '_aegisseo_og_title',
        'og_description'   => '_aegisseo_og_description',
        'twitter_title'    => '_aegisseo_twitter_title',
        'twitter_description' => '_aegisseo_twitter_description',
    );
    if (!isset($allowed[$aegisseo_field])) {
        wp_send_json_error(array('message' => 'invalid_field'), 400);
    }

    $meta_key = $allowed[$aegisseo_field];
    $old = (string) get_post_meta($post_id, $meta_key, true);

    $aegisseo_uid = get_current_user_id();
    $snap_key = 'aegisseo_quickfix_' . $aegisseo_field;
    $snap = (array) get_user_meta($aegisseo_uid, $snap_key, true);
    $snap[$post_id] = $old;
    update_user_meta($aegisseo_uid, $snap_key, $snap);

    $post = get_post($post_id);
    $title = $post ? get_the_title($post_id) : '';
    $aegisseo_raw = '';
    if ($post) {
        $aegisseo_raw = (string) $post->post_content;
    }
    $text = wp_strip_all_tags(strip_shortcodes($aegisseo_raw));
    $text = preg_replace('/\s+/u', ' ', $text);
    $text = trim($text);

    $generated = '';
    if ($aegisseo_field === 'meta_description' || $aegisseo_field === 'og_description' || $aegisseo_field === 'twitter_description') {

        $candidate = $text;
        if (strlen($candidate) < 40) {
            $candidate = $title . '. ' . $candidate;
        }

        $candidate = mb_substr($candidate, 0, 360);
        $candidate = rtrim($candidate, " \t\n\r\0\x0B.,;:-");
        if ($title) {
            $generated = $title . ' — ' . $candidate;
        } else {
            $generated = $candidate;
        }

        if (mb_strlen($generated) < 160) {
            $generated .= '. Learn more on this page, including key details, benefits, and next steps.';
        }
    } else {

        $generated = $title ? $title : ('Post #' . $post_id);
    }

    update_post_meta($post_id, $meta_key, $generated);

	$aegisseo_uid = get_current_user_id();
	$snap_key = 'aegisseo_quickfix_' . $aegisseo_field;
	$snap = (array) get_user_meta($aegisseo_uid, $snap_key, true);

	$snap[$post_id] = array(
		'old' => $old,
		'new' => $generated,
		'ts'  => time(),
	);

	update_user_meta($aegisseo_uid, $snap_key, $snap);

    wp_send_json_success(array(
        'post_id' => $post_id,
        'field'   => $aegisseo_field,
        'meta_key'=> $meta_key, // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
        'value'   => $generated,
    ));
});

add_action('wp_ajax_aegisseo_quick_rollback', function () {
    if (!current_user_can('edit_posts')) {
        wp_send_json_error(array('message' => 'forbidden'), 403);
    }
    check_ajax_referer('aegisseo_quick_fix', 'nonce');

    $post_id = isset($_POST['post_id']) ? absint($_POST['post_id']) : 0;
    $aegisseo_field   = isset($_POST['field']) ? sanitize_key(wp_unslash($_POST['field'])) : '';

    if (!$post_id || !get_post($post_id) || !current_user_can('edit_post', $post_id)) {
        wp_send_json_error(array('message' => 'invalid_post'), 400);
    }

    $allowed = array(
        'meta_description' => '_aegisseo_description',
        'og_title'         => '_aegisseo_og_title',
        'og_description'   => '_aegisseo_og_description',
        'twitter_title'    => '_aegisseo_twitter_title',
        'twitter_description' => '_aegisseo_twitter_description',
    );
    if (!isset($allowed[$aegisseo_field])) {
        wp_send_json_error(array('message' => 'invalid_field'), 400);
    }

    $aegisseo_uid = get_current_user_id();
    $snap_key = 'aegisseo_quickfix_' . $aegisseo_field;
    $snap = (array) get_user_meta($aegisseo_uid, $snap_key, true);

    if (!array_key_exists($post_id, $snap)) {
        wp_send_json_error(array('message' => 'no_snapshot'), 404);
    }

    $meta_key = $allowed[$aegisseo_field];
	$snapv = $snap[$post_id];

	if (is_array($snapv) && array_key_exists('old', $snapv)) {
		$restore = (string) $snapv['old'];
	} else {

		$restore = (string) $snapv;
	}

	update_post_meta($post_id, $meta_key, $restore);

	unset($snap[$post_id]);
	update_user_meta($aegisseo_uid, $snap_key, $snap);

    wp_send_json_success(array(
        'post_id' => $post_id,
        'field'   => $aegisseo_field,
        'meta_key'=> $meta_key, // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
        'value'   => $restore,
    ));
});


add_action('admin_post_aegisseo_sel_generate_meta', function () {

    if (!current_user_can('edit_posts')) {
        wp_die('Forbidden', 403);
    }

    check_admin_referer('aegisseo_sel_generate_meta');

    $post_id = isset($_POST['post_id']) ? absint($_POST['post_id']) : 0;
    $aegisseo_field   = isset($_POST['field']) ? sanitize_key(wp_unslash($_POST['field'])) : '';

    if (!$post_id || !get_post($post_id) || !current_user_can('edit_post', $post_id)) {
        wp_die('Invalid post', 400);
    }

    $allowed = array(
        'meta_description'     => '_aegisseo_description',
        'og_title'             => '_aegisseo_og_title',
        'og_description'       => '_aegisseo_og_description',
        'twitter_title'        => '_aegisseo_twitter_title',
        'twitter_description'  => '_aegisseo_twitter_description',
    );

    if (!isset($allowed[$aegisseo_field])) {
        wp_die('Invalid field', 400);
    }

    $meta_key = $allowed[$aegisseo_field];
    $old = (string) get_post_meta($post_id, $meta_key, true);

    // Generate
    $generated = '';
    if ($aegisseo_field === 'meta_description' || $aegisseo_field === 'og_description' || $aegisseo_field === 'twitter_description') {
        $candidate = '';
        if (has_excerpt($post_id)) {
            $candidate = get_the_excerpt($post_id);
        } else {
            $content = (string) get_post_field('post_content', $post_id);
            $content = wp_strip_all_tags($content);
            $content = preg_replace('/\s+/', ' ', $content);
            $candidate = trim($content);
        }
        if ($candidate !== '') {
            $candidate = mb_substr($candidate, 0, 170);
            $candidate = rtrim($candidate, " \t\n\r\0\x0B.,;:!-");
            $generated = $candidate;
        }
        if (mb_strlen($generated) < 160) {
            $generated .= '. Learn more on this page, including key details, benefits, and next steps.';
        }
    } else {
        $title = get_the_title($post_id);
        $generated = $title ? $title : ('Post #' . $post_id);
    }

    update_post_meta($post_id, $meta_key, $generated);

    $aegisseo_uid = get_current_user_id();
    $snap_key = 'aegisseo_quickfix_' . $aegisseo_field;
    $snap = (array) get_user_meta($aegisseo_uid, $snap_key, true);

    $snap[$post_id] = array(
        'old' => $old,
        'new' => $generated,
        'ts'  => time(),
    );

    update_user_meta($aegisseo_uid, $snap_key, $snap);

    $ref = wp_get_referer();
    if (!$ref) { $ref = admin_url('admin.php?page=aegisseo&tab=issues'); }
    wp_safe_redirect($ref);
    exit;
});

add_action('admin_post_aegisseo_sel_rollback_meta', function () {

    if (!current_user_can('edit_posts')) {
        wp_die('Forbidden', 403);
    }

    check_admin_referer('aegisseo_sel_rollback_meta');

    $post_id = isset($_POST['post_id']) ? absint($_POST['post_id']) : 0;
    $aegisseo_field   = isset($_POST['field']) ? sanitize_key(wp_unslash($_POST['field'])) : '';

    if (!$post_id || !get_post($post_id) || !current_user_can('edit_post', $post_id)) {
        wp_die('Invalid post', 400);
    }

    $allowed = array(
        'meta_description'     => '_aegisseo_description',
        'og_title'             => '_aegisseo_og_title',
        'og_description'       => '_aegisseo_og_description',
        'twitter_title'        => '_aegisseo_twitter_title',
        'twitter_description'  => '_aegisseo_twitter_description',
    );

    if (!isset($allowed[$aegisseo_field])) {
        wp_die('Invalid field', 400);
    }

    $meta_key = $allowed[$aegisseo_field];

    // Load snapshot
    $aegisseo_uid = get_current_user_id();
    $snap_key = 'aegisseo_quickfix_' . $aegisseo_field;
    $snap = (array) get_user_meta($aegisseo_uid, $snap_key, true);

    if (!isset($snap[$post_id])) {
        $ref = wp_get_referer();
        if (!$ref) { $ref = admin_url('admin.php?page=aegisseo&tab=issues'); }
        wp_safe_redirect($ref);
        exit;
    }

    $snapv = $snap[$post_id];

    $restore = '';
    if (is_array($snapv) && array_key_exists('old', $snapv)) {
        $restore = (string) $snapv['old'];
    } else {
        // Backward compat
        $restore = (string) $snapv;
    }

    update_post_meta($post_id, $meta_key, $restore);

    // Remove snapshot so New clears and button flips back
    unset($snap[$post_id]);
    update_user_meta($aegisseo_uid, $snap_key, $snap);

    $ref = wp_get_referer();
    if (!$ref) { $ref = admin_url('admin.php?page=aegisseo&tab=issues'); }
    wp_safe_redirect($ref);
    exit;
});
$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}
if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {
    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('PRO feature: SEO Ops Center, Issues & Fixex, Evidence and Migration Wizard with advanced autopilot detection, guided fixes, and bulk remediation actions are available in AegisSEO PRO.', 'aegisseo')
    );
    echo '<p class="description" style="margin-top:10px;">' . esc_html__('Activate a PRO license to unlock Issues & Fixes.', 'aegisseo') . '</p>';
    return;
}

$aegisseo_applied = isset($_GET['applied']) ? absint(wp_unslash($_GET['applied'])) : 0;
$aegisseo_fix     = isset($_GET['fix']) ? sanitize_key(wp_unslash($_GET['fix'])) : '';
$post_id = isset($_GET['post_id']) ? absint(wp_unslash($_GET['post_id'])) : 0;

if ($aegisseo_applied === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Fix applied successfully.', 'aegisseo') . '</p></div>';
} elseif (isset($_GET['rolled']) && absint(wp_unslash($_GET['rolled'])) === 1) {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Rollback completed.', 'aegisseo') . '</p></div>';
} elseif (isset($_GET['error'])) {
    echo '<div class="notice notice-error"><p>' . esc_html__('Could not apply fix. Please try again.', 'aegisseo') . '</p></div>';
}

$aegisseo_args = array(
    'post_type'      => array('post', 'page'),
    'post_status'    => array('publish'),
    'posts_per_page' => 50,
    'orderby'        => 'modified',
    'order'          => 'DESC',
    'fields'         => 'ids',
);

$aegisseo_ids = get_posts($aegisseo_args);

$aegisseo_rows = array();

foreach ($aegisseo_ids as $aegisseo_pid) {
    $aegisseo_title_override = (string) get_post_meta($aegisseo_pid, '_aegisseo_title', true);
    $aegisseo_desc_override  = (string) get_post_meta($aegisseo_pid, '_aegisseo_description', true);

    $post = get_post($aegisseo_pid);
    if (!$post) { continue; }

    $aegisseo_content_raw = wp_strip_all_tags((string) $post->post_content, true);
    $aegisseo_content_raw = preg_replace('/\s+/', ' ', $aegisseo_content_raw);
    $aegisseo_content_raw = trim($aegisseo_content_raw);

    $aegisseo_word_count = 0;
    if ($aegisseo_content_raw !== '') {
        $aegisseo_word_count = str_word_count($aegisseo_content_raw);
    }

    $aegisseo_issues = array();

    if ($aegisseo_desc_override === '') {
        $aegisseo_issues[] = __('Missing meta description override', 'aegisseo');
    }

    if ($aegisseo_word_count > 0 && $aegisseo_word_count < 300) {
        /* translators: %d: word count */
        $aegisseo_issues[] = sprintf(__('Thin content (%d words)', 'aegisseo'), $aegisseo_word_count);
    }
$aegisseo_schema_type = '';
if (!empty(aegisseo()->schema) && method_exists(aegisseo()->schema, 'resolve_schema_type')) {
    $aegisseo_schema_type = (string) aegisseo()->schema->resolve_schema_type($post->ID);
    $aegisseo_schema_issues = (array) aegisseo()->schema->validate_schema($post->ID, $aegisseo_schema_type);
    foreach ($aegisseo_schema_issues as $aegisseo_si) {
        $aegisseo_issues[] = $aegisseo_si;
    }
}

    if (empty($aegisseo_issues)) { continue; }

    $aegisseo_rows[] = array(
        'ID'     => $aegisseo_pid,
        'title'  => get_the_title($aegisseo_pid),
        'type'   => $post->post_type,
        'issues' => $aegisseo_issues,
        'desc_missing' => ($aegisseo_desc_override === ''),
        'schema_issues' => !empty($aegisseo_schema_issues) ? 1 : 0,
    );
}

?>
<h2><?php echo esc_html__('Issues & Fixes', 'aegisseo'); ?></h2>
<?php
// Bulk rollback notice
if (isset($_GET['bulk_rolled']) && absint(wp_unslash($_GET['bulk_rolled'])) === 1) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $aegisseo_ok = isset($_GET['ok']) ? absint(wp_unslash($_GET['ok'])) : 0;
    $aegisseo_fail = isset($_GET['fail']) ? absint(wp_unslash($_GET['fail'])) : 0;

    echo '<div class="notice notice-success is-dismissible"><p>';
    /* translators: 1: number rolled back, 2: number skipped/failed */
    echo esc_html(sprintf(__('Bulk rollback completed. Rolled back: %1$d. Skipped/failed: %2$d.', 'aegisseo'), $aegisseo_ok, $aegisseo_fail));
    echo '</p></div>';
} elseif (isset($_GET['bulk_rolled']) && absint(wp_unslash($_GET['bulk_rolled'])) === 0) {
    echo '<div class="notice notice-error is-dismissible"><p>';
    echo esc_html__('Bulk rollback did not run. No events were selected or request was blocked.', 'aegisseo');
    echo '</p></div>';
}
?>
<?php
if (isset($_GET['pack']) && absint(wp_unslash($_GET['pack'])) === 1 && !empty($_GET['pack_id'])) {
    $aegisseo_pack_id = sanitize_text_field(wp_unslash($_GET['pack_id']));
    $aegisseo_pack_name = isset($_GET['pack_name']) ? sanitize_key(wp_unslash($_GET['pack_name'])) : '';
    $aegisseo_changed = isset($_GET['changed']) ? absint(wp_unslash($_GET['changed'])) : 0;
    $aegisseo_flagged = isset($_GET['flagged']) ? absint(wp_unslash($_GET['flagged'])) : 0;
    /* translators: 1: number changed, 2: number flagged */
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Fix Pack applied.', 'aegisseo') . ' <strong>' . esc_html($aegisseo_pack_name) . '</strong> — ' . esc_html(sprintf(__('Changed: %1$d, Flagged: %2$d', 'aegisseo'), $aegisseo_changed, $aegisseo_flagged)) . '</p>';
    $aegisseo_rollback_url = wp_nonce_url(admin_url('admin-post.php?action=aegisseo_rollback_fix_pack&pack_id=' . urlencode($aegisseo_pack_id)), 'aegisseo_fix_pack_rollback');
    echo '<p style="margin:6px 0 0;"><a class="button" href="' . esc_url($aegisseo_rollback_url) . '">' . esc_html__('Rollback this Fix Pack', 'aegisseo') . '</a></p></div>';
} elseif (isset($_GET['rolled_pack']) && absint(wp_unslash($_GET['rolled_pack'])) === 1) {
    $aegisseo_rolled = isset($_GET['rolled']) ? absint(wp_unslash($_GET['rolled'])) : 0;
    /* translators: %d: number of changes rolled back */
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html(sprintf(__('Fix Pack rolled back (%d changes).', 'aegisseo'), $aegisseo_rolled)) . '</p></div>';
}
?>

<div style="margin:14px 0; padding:12px; border:1px solid #dcdcde; background:#fff; border-radius:8px;">
    <div style="display:flex; align-items:flex-start; justify-content:space-between; gap:12px; flex-wrap:wrap;">
        <div>
            <strong><?php echo esc_html__('Fix Packs (batch actions with rollback)', 'aegisseo'); ?></strong>
            <div class="description" style="margin-top:6px;">
                <?php echo esc_html__('Run a safe batch fix. Every change is logged into the Evidence Timeline so you can rollback.', 'aegisseo'); ?>
            </div>
        </div>
        <div style="display:flex; gap:8px; flex-wrap:wrap;">
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="duplicate_titles" />
                <button class="button"><?php echo esc_html__('Fix duplicate titles', 'aegisseo'); ?></button>
            </form>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="missing_og_image" />
                <button class="button"><?php echo esc_html__('Fix missing OG image', 'aegisseo'); ?></button>
            </form>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="generate_meta_descriptions" />
                <button class="button"><?php echo esc_html__('Generate meta descriptions', 'aegisseo'); ?></button>
            </form>
            
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0;">
                <?php wp_nonce_field('aegisseo_fix_pack'); ?>
                <input type="hidden" name="action" value="aegisseo_apply_fix_pack" />
                <input type="hidden" name="pack" value="orphan_pages" />
                <button class="button"><?php echo esc_html__('Find orphan pages', 'aegisseo'); ?></button>
            </form>
        </div>
    </div>
</div>

<p class="description"><?php echo esc_html__('One screen: find issues, apply safe fixes, and track what changed. ', 'aegisseo'); ?></p>

<?php if (empty($aegisseo_rows)): ?>
    <div class="notice notice-info"><p><?php echo esc_html__('No issues detected in the last 50 published posts/pages using current checks.', 'aegisseo'); ?></p></div>
<?php else: ?>
    <table class="widefat fixed striped">
        <thead>
            <tr>
                <th style="width:70px;"><?php echo esc_html__('ID', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Title', 'aegisseo'); ?></th>
                <th style="width:110px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
                <th><?php echo esc_html__('Issues', 'aegisseo'); ?></th>
                <th style="width:240px;"><?php echo esc_html__('Fix', 'aegisseo'); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($aegisseo_rows as $aegisseo_r): ?>
            <tr>
                <td><?php echo (int) $aegisseo_r['ID']; ?></td>
                <td>
                    <strong><?php echo esc_html($aegisseo_r['title']); ?></strong>
                    <div class="row-actions">
                        <span class="edit"><a href="<?php echo esc_url(get_edit_post_link($aegisseo_r['ID'])); ?>"><?php echo esc_html__('Edit', 'aegisseo'); ?></a></span>
                        |
                        <span class="view"><a href="<?php echo esc_url(get_permalink($aegisseo_r['ID'])); ?>" target="_blank" rel="noopener"><?php echo esc_html__('View', 'aegisseo'); ?></a></span>
                    </div>
                </td>
                <td><?php echo esc_html($aegisseo_r['type']); ?></td>
                <td>
                    <ul style="margin:0; padding-left:18px;">
                        <?php foreach ($aegisseo_r['issues'] as $aegisseo_issue): ?>
                            <li><?php echo esc_html($aegisseo_issue); ?></li>
                        <?php endforeach; ?>
                    </ul>
                </td>
                <td>
                    <?php if ($aegisseo_r['desc_missing']): ?>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0;">
                            <?php wp_nonce_field('aegisseo_apply_fix'); ?>
                            <input type="hidden" name="action" value="aegisseo_apply_fix" />
                            <input type="hidden" name="post_id" value="<?php echo (int) $aegisseo_r['ID']; ?>" />
                            <input type="hidden" name="fix_type" value="gen_meta_desc" />
                            <button type="submit" class="button button-primary"><?php echo esc_html__('Generate Meta Description', 'aegisseo'); ?></button>
                        </form>
                    <?php else: ?>
                        <span class="dashicons dashicons-yes" style="color:#46b450;"></span>
                        <?php echo esc_html__('No safe one-click fix available (yet).', 'aegisseo'); ?>
                    <?php endif; ?>

<?php

$aegisseo_pid = (int) $aegisseo_r['ID'];

$aegisseo_current_schema_type = (string) get_post_meta($aegisseo_pid, '_aegisseo_schema_type', true);
$aegisseo_schema_sug = array();
if (isset(aegisseo()->autopilot) && aegisseo()->autopilot) {
    $aegisseo_schema_sug = aegisseo()->autopilot->suggest_schema($aegisseo_pid);
}

if ($aegisseo_current_schema_type === '' && !empty($aegisseo_schema_sug['type'])): ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Schema Suggestion', 'aegisseo'); ?></strong>
        <div style="margin-top:6px;">
            <span class="dashicons dashicons-lightbulb" style="color:#2271b1;"></span>
            <?php echo esc_html($aegisseo_schema_sug['type']); ?>
            <span style="color:#666;">(<?php echo esc_html__('why', 'aegisseo'); ?>)</span>
        </div>
        <?php if (!empty($aegisseo_schema_sug['why']) && is_array($aegisseo_schema_sug['why'])): ?>
            <ul style="margin:6px 0 0 18px;">
                <?php foreach ($aegisseo_schema_sug['why'] as $aegisseo_w): ?>
                    <li><?php echo esc_html($aegisseo_w); ?></li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top:8px;">
            <?php wp_nonce_field('aegisseo_schema_approve'); ?>
            <input type="hidden" name="action" value="aegisseo_schema_approve" />
            <input type="hidden" name="post_id" value="<?php echo (int) $aegisseo_pid; ?>" />
            <input type="hidden" name="schema_type" value="<?php echo esc_attr($aegisseo_schema_sug['type']); ?>" />
            <button type="submit" class="button button-secondary"><?php echo esc_html__('Approve & Apply Schema', 'aegisseo'); ?></button>
        </form>
    </div>
<?php elseif ($aegisseo_current_schema_type !== ''): ?>
    <div style="margin-top:10px; color:#1d2327;">
        <span class="dashicons dashicons-yes" style="color:#46b450;"></span>
        <?php echo esc_html__('Schema locked:', 'aegisseo'); ?> <strong><?php echo esc_html($aegisseo_current_schema_type); ?></strong>
    </div>
<?php endif; ?>

<?php
global $wpdb;
$aegisseo_tred = $wpdb->prefix . 'aegisseo_redirects';
$aegisseo_pending_redirects = $wpdb->get_results( $wpdb->prepare("SELECT * FROM %i WHERE is_suggestion=%d AND suggestion_status=%s AND source_post_id=%d ORDER BY id DESC LIMIT 5", $aegisseo_tred, 1, 'pending', $aegisseo_pid), ARRAY_A ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching





if (!empty($aegisseo_pending_redirects)): ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Redirect Suggestions', 'aegisseo'); ?></strong>
        <ul style="margin:8px 0 0 18px;">
            <?php foreach ($aegisseo_pending_redirects as $aegisseo_pr): ?>
                <li style="margin-bottom:8px;">
                    <code><?php echo esc_html($aegisseo_pr['source']); ?></code>
                    &rarr;
                    <code><?php echo esc_html($aegisseo_pr['target']); ?></code>
                    <div style="margin-top:6px;">
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0 6px 0 0;">
                            <?php wp_nonce_field('aegisseo_redirect_approve'); ?>
                            <input type="hidden" name="action" value="aegisseo_redirect_approve" />
                            <input type="hidden" name="id" value="<?php echo (int) $aegisseo_pr['id']; ?>" />
                            <button type="submit" class="button button-secondary button-small"><?php echo esc_html__('Approve & Enable', 'aegisseo'); ?></button>
                        </form>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="display:inline-block; margin:0;">
                            <?php wp_nonce_field('aegisseo_redirect_dismiss'); ?>
                            <input type="hidden" name="action" value="aegisseo_redirect_dismiss" />
                            <input type="hidden" name="id" value="<?php echo (int) $aegisseo_pr['id']; ?>" />
                            <button type="submit" class="button button-link-delete button-small"><?php echo esc_html__('Dismiss', 'aegisseo'); ?></button>
                        </form>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<?php
$aegisseo_link_sugs = array();
if (isset(aegisseo()->autopilot) && aegisseo()->autopilot) {
    $aegisseo_max_links = 3;
if (function_exists('aegisseo') && isset(aegisseo()->options) && aegisseo()->options) {
    $aegisseo_max_links = (int) aegisseo()->options->get('autopilot_max_internal_links', 3);
    if ($aegisseo_max_links <= 0) { $aegisseo_max_links = 3; }
}
$aegisseo_link_sugs = aegisseo()->autopilot->suggest_internal_links($aegisseo_pid, $aegisseo_max_links);
}

if (!empty($aegisseo_link_sugs)): 
    $aegisseo_post_obj = get_post($aegisseo_pid);
    $aegisseo_orig = $aegisseo_post_obj ? (string)$aegisseo_post_obj->post_content : '';
    $preview = aegisseo()->autopilot->apply_internal_links($aegisseo_pid, $aegisseo_link_sugs, 3);
    $aegisseo_proposed = (!empty($preview['new_content'])) ? (string)$preview['new_content'] : $aegisseo_orig;
    ?>
    <div style="margin-top:10px; padding:10px; border:1px solid #dcdcde; background:#fff;">
        <strong><?php echo esc_html__('Autopilot: Internal Link Suggestions (max 3)', 'aegisseo'); ?></strong>
        <ul style="margin:8px 0 0 18px;">
            <?php foreach ($aegisseo_link_sugs as $aegisseo_ls): ?>
                <li>
                    <em><?php echo esc_html($aegisseo_ls['anchor']); ?></em>
                    &rarr;
                    <a href="<?php echo esc_url(get_edit_post_link((int)$aegisseo_ls['target_id'])); ?>"><?php echo esc_html($aegisseo_ls['title']); ?></a>
                </li>
            <?php endforeach; ?>
        </ul>

        <details style="margin-top:8px;">
            <summary><?php echo esc_html__('Preview diff (safe preview)', 'aegisseo'); ?></summary>
            <div style="margin-top:8px; background:#fff;">
                <?php
                if (function_exists('wp_text_diff')) {
                    echo wp_kses_post(wp_text_diff(wp_strip_all_tags($aegisseo_orig), wp_strip_all_tags($aegisseo_proposed), array('show_split_view' => true)));
                } else {
                    echo '<pre style="white-space:pre-wrap;">' . esc_html(wp_strip_all_tags($aegisseo_proposed)) . '</pre>';
                }
                ?>
            </div>
        </details>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin-top:8px;">
            <?php wp_nonce_field('aegisseo_apply_links'); ?>
            <input type="hidden" name="action" value="aegisseo_apply_links" />
            <input type="hidden" name="post_id" value="<?php echo (int) $aegisseo_pid; ?>" />
            <button type="submit" class="button button-secondary"><?php echo esc_html__('Approve & Apply Links', 'aegisseo'); ?></button>
            <span class="description" style="margin-left:6px;"><?php echo esc_html__('Applies up to 3 internal links by inserting anchors into safe text nodes only.', 'aegisseo'); ?></span>
        </form>
    </div>
<?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>


<hr style="margin:24px 0;" />
<h2><?php echo esc_html__('Recent SEO Events', 'aegisseo'); ?></h2>
<p class="description"><?php echo esc_html__('Aegis-style audit trail. Rollback restores the previous value for AegisSEO meta fields.', 'aegisseo'); ?></p>

<?php

$aegisseo_evt_default = array(); 

foreach (array('faq','faqs','document','documents','doc','docs') as $aegisseo_maybe_pt) {
    if (post_type_exists($aegisseo_maybe_pt)) { $aegisseo_evt_default[] = $aegisseo_maybe_pt; }
}

$aegisseo_evt_filters_meta_key = 'aegisseo_issues_evt_filters_v1';
$aegisseo_evt_saved = array();

if (is_user_logged_in()) {
    $aegisseo_evt_saved = get_user_meta(get_current_user_id(), $aegisseo_evt_filters_meta_key, true);
    if (!is_array($aegisseo_evt_saved)) { $aegisseo_evt_saved = array(); }
}

$aegisseo_evt_saved_pts = array();
if (isset($aegisseo_evt_saved['evt_pt']) && is_array($aegisseo_evt_saved['evt_pt'])) {
    foreach ($aegisseo_evt_saved['evt_pt'] as $aegisseo_pt) {
        $aegisseo_pt = sanitize_key((string) $aegisseo_pt);
        if ($aegisseo_pt !== '') { $aegisseo_evt_saved_pts[] = $aegisseo_pt; }
    }
}
$aegisseo_evt_saved_pts = array_values(array_unique($aegisseo_evt_saved_pts));

$aegisseo_evt_saved_plugin = '';
if (isset($aegisseo_evt_saved['evt_plugin'])) {
    $aegisseo_evt_saved_plugin = sanitize_key((string) $aegisseo_evt_saved['evt_plugin']);
}

$aegisseo_evt_selected = array();
if (isset($_GET['evt_pt'])) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $aegisseo_raw = wp_unslash($_GET['evt_pt']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
    if (!is_array($aegisseo_raw)) { $aegisseo_raw = array($aegisseo_raw); }
    foreach ($aegisseo_raw as $aegisseo_pt) {
        $aegisseo_pt = sanitize_key((string) $aegisseo_pt);
        if ($aegisseo_pt !== '') { $aegisseo_evt_selected[] = $aegisseo_pt; }
    }
} else {
    $aegisseo_evt_selected = $aegisseo_evt_saved_pts;
}
$aegisseo_evt_selected = array_values(array_unique($aegisseo_evt_selected));

$aegisseo_evt_plugin = isset($_GET['evt_plugin'])
    ? sanitize_key((string) wp_unslash($_GET['evt_plugin']))
    : $aegisseo_evt_saved_plugin;

$aegisseo_evt_plugin_pts = array();

$aegisseo_all_pts = get_post_types(array(), 'names');
$aegisseo_plugin_options = array(); // key => label

if (is_array($aegisseo_all_pts)) {
    foreach ($aegisseo_all_pts as $aegisseo_pt) {
        $aegisseo_pt = (string) $aegisseo_pt;
        if ($aegisseo_pt === '' || $aegisseo_pt === 'aegisseo' || stripos($aegisseo_pt, 'aegisseo') === 0) { continue; }

        $aegisseo_obj = get_post_type_object($aegisseo_pt);
        $aegisseo_is_public = ($aegisseo_obj && !empty($aegisseo_obj->public));
        $aegisseo_is_pluginish = (!$aegisseo_is_public) || (stripos($aegisseo_pt, 'aegis') === 0) || (stripos($aegisseo_pt, 'as_') === 0);

        if (!$aegisseo_is_pluginish) { continue; }

        $aegisseo_key = $aegisseo_pt;
        if (false !== strpos($aegisseo_pt, '_')) { $aegisseo_key = substr($aegisseo_pt, 0, strpos($aegisseo_pt, '_')); }
        if ($aegisseo_key === '') { $aegisseo_key = $aegisseo_pt; }

        if (strlen($aegisseo_key) < 3) { continue; }
        if (stripos($aegisseo_key, 'aegis') !== 0 && stripos($aegisseo_key, 'as') !== 0) { continue; }

        if (!isset($aegisseo_plugin_options[$aegisseo_key])) {
            $aegisseo_plugin_options[$aegisseo_key] = strtoupper($aegisseo_key);
        }
        if ($aegisseo_evt_plugin && $aegisseo_key === $aegisseo_evt_plugin) {
            $aegisseo_evt_plugin_pts[] = $aegisseo_pt;
        }
    }
}

$aegisseo_evt_allowed_pts = array_values(array_unique(array_merge($aegisseo_evt_selected, $aegisseo_evt_plugin_pts)));

if (is_user_logged_in() && isset($_GET['evt_save']) /* phpcs:ignore WordPress.Security.NonceVerification.Recommended */) {
    $aegisseo_nonce = isset($_GET['aegisseo_evt_nonce']) ? sanitize_text_field((string) wp_unslash($_GET['aegisseo_evt_nonce'])) : '';
    if ($aegisseo_nonce && wp_verify_nonce($aegisseo_nonce, 'aegisseo_save_evt_filters')) {
        update_user_meta(
            get_current_user_id(),
            $aegisseo_evt_filters_meta_key,
            array(
                'evt_pt'     => $aegisseo_evt_selected,
                'evt_plugin' => $aegisseo_evt_plugin,
            )
        );
    }
}

function aegisseo_evt_pt_checked($aegisseo_pt, $selected) {
    return in_array($aegisseo_pt, $selected, true) ? 'checked="checked"' : '';
}
?>

<form method="get" style="margin:0 0 12px 0;">
    <?php
    $aegisseo_get = wp_unslash($_GET);
foreach ($aegisseo_get as $aegisseo_k => $aegisseo_v) {
        if (in_array($aegisseo_k, array('evt_page','evt_pt','evt_plugin'), true)) { continue; }
        if (is_array($aegisseo_v)) { continue; }
        echo '<input type="hidden" name="' . esc_attr($aegisseo_k) . '" value="' . esc_attr((string) $aegisseo_v) . '" />';
    }
    ?>
	<?php wp_nonce_field('aegisseo_save_evt_filters', 'aegisseo_evt_nonce'); ?>
    <div style="display:flex; align-items:center; gap:12px; flex-wrap:wrap;">
        <strong><?php echo esc_html__('Show events for:', 'aegisseo'); ?></strong>

        <label style="display:inline-flex; align-items:center; gap:6px;">
            <input type="checkbox" name="evt_pt[]" value="page" <?php checked(in_array('page', $aegisseo_evt_selected, true), true); ?> />
            <?php echo esc_html__('Pages', 'aegisseo'); ?>
        </label>

        <label style="display:inline-flex; align-items:center; gap:6px;">
            <input type="checkbox" name="evt_pt[]" value="post" <?php checked(in_array('post', $aegisseo_evt_selected, true), true); ?> />
            <?php echo esc_html__('Posts', 'aegisseo'); ?>
        </label>

        <label style="display:inline-flex; align-items:center; gap:6px;">
            <input type="checkbox" name="evt_pt[]" value="faq" <?php checked(in_array('faq', $aegisseo_evt_selected, true), true); ?> />
            <?php echo esc_html__('FAQ', 'aegisseo'); ?>
        </label>

        <label style="display:inline-flex; align-items:center; gap:6px;">
            <input type="checkbox" name="evt_pt[]" value="document" <?php checked(in_array('document', $aegisseo_evt_selected, true), true); ?> />
            <?php echo esc_html__('Documents', 'aegisseo'); ?>
        </label>

        <label style="display:inline-flex; align-items:center; gap:6px;">
            <input type="checkbox" name="evt_pt[]" value="attachment" <?php checked(in_array('attachment', $aegisseo_evt_selected, true), true); ?> />
            <?php echo esc_html__('Images/Video', 'aegisseo'); ?>
        </label>

        <span style="margin-left:6px;"><?php echo esc_html__('Include plugin reports:', 'aegisseo'); ?></span>
        <select name="evt_plugin">
            <option value=""><?php echo esc_html__('— None —', 'aegisseo'); ?></option>
            <?php foreach ($aegisseo_plugin_options as $aegisseo_k => $aegisseo_label): ?>
                <option value="<?php echo esc_attr($aegisseo_k); ?>" <?php selected($aegisseo_evt_plugin, $aegisseo_k); ?>><?php echo esc_html($aegisseo_label); ?></option>
            <?php endforeach; ?>
        </select>

        <button class="button button-primary" type="submit" name="evt_save" value="1">
			<?php echo esc_html__('Save', 'aegisseo'); ?>
		</button>
    </div>
</form>
<?php
$aegisseo_evt_selected_labels = array();
$aegisseo_evt_label_map = array(
    'page'      => __('Pages', 'aegisseo'),
    'post'      => __('Posts', 'aegisseo'),
    'attachment'=> __('Images/Video', 'aegisseo'),
    'faq'       => __('FAQ', 'aegisseo'),
    'faqs'      => __('FAQ', 'aegisseo'),
    'document'  => __('Documents', 'aegisseo'),
    'documents' => __('Documents', 'aegisseo'),
    'doc'       => __('Documents', 'aegisseo'),
    'docs'      => __('Documents', 'aegisseo'),
);
foreach ($aegisseo_evt_selected as $aegisseo_pt) {
    $aegisseo_evt_selected_labels[] = isset($aegisseo_evt_label_map[$aegisseo_pt]) ? $aegisseo_evt_label_map[$aegisseo_pt] : $aegisseo_pt;
}
?>
<div style="border:1px solid #dcdcde; background:#fff; padding:12px; margin:12px 0;">
    <div style="margin:0 0 8px 0;">
        <strong><?php echo esc_html__('Selection List (Enabled Only)', 'aegisseo'); ?></strong>
        <span style="color:#666; margin-left:8px;"><?php echo esc_html__('This list is based ONLY on the checkboxes above. Nothing is shown unless enabled.', 'aegisseo'); ?></span>
    </div>

    <?php if (empty($aegisseo_evt_selected)) : ?>
        <p style="margin:0;"><?php echo esc_html__('No post types enabled. Check one or more boxes above and click Apply.', 'aegisseo'); ?></p>
    <?php else : ?>
        <div style="margin:0 0 10px 0;">
            <?php foreach ($aegisseo_evt_selected_labels as $aegisseo_lbl) : ?>
                <span style="display:inline-block; padding:2px 8px; border:1px solid #dcdcde; border-radius:999px; margin:0 6px 6px 0; background:#f6f7f7;">
                    <?php echo esc_html($aegisseo_lbl); ?>
                </span>
            <?php endforeach; ?>
        </div>
        <?php

        $aegisseo_sel_per_page = isset($_GET['sel_per_page']) ? absint(wp_unslash($_GET['sel_per_page'])) : 25;
        if (!in_array($aegisseo_sel_per_page, array(25, 50), true)) { $aegisseo_sel_per_page = 25; }
        $aegisseo_sel_paged = isset($_GET['sel_paged']) ? max(1, absint(wp_unslash($_GET['sel_paged']))) : 1;
            $aegisseo_evt_list_q = new WP_Query(array(
                'post_type'      => $aegisseo_evt_selected,
                'post_status'    => 'any',
                'posts_per_page' => $aegisseo_sel_per_page,
                'orderby'        => 'modified',
                'order'          => 'DESC',
                'no_found_rows'  => false,
                'paged'          => $aegisseo_sel_paged,
                'fields'         => 'ids',
            ));
        ?>
        <?php
        $aegisseo_sel_total = (int) $aegisseo_evt_list_q->found_posts;
        $aegisseo_sel_total_pages = (int) $aegisseo_evt_list_q->max_num_pages;
        $aegisseo_sel_base_args = wp_unslash($_GET);
        ?>
        <div style="display:flex; align-items:center; gap:10px; margin:10px 0 8px 0;">
            <label for="aegisseo-sel-per-page"><strong><?php echo esc_html__('Per page:', 'aegisseo'); ?></strong></label>
            <select id="aegisseo-sel-per-page">
                <option value="25" <?php selected($aegisseo_sel_per_page, 25); ?>>25</option>
                <option value="50" <?php selected($aegisseo_sel_per_page, 50); ?>>50</option>
            </select>
            <?php if ($aegisseo_sel_total_pages > 1): ?>
                <?php /* translators: 1: current page, 2: total pages */ ?>
                <span style="color:#666;"><?php echo esc_html(sprintf(__('Page %1$d of %2$d', 'aegisseo'), $aegisseo_sel_paged, $aegisseo_sel_total_pages)); ?></span>
            <?php endif; ?>
            <span style="margin-left:auto;"></span>
            <?php if ($aegisseo_sel_total_pages > 1): ?>
                <div class="tablenav-pages" style="margin:0;">
                    <?php
                    $aegisseo_sel_base_args['sel_per_page'] = $aegisseo_sel_per_page;
                    $aegisseo_sel_base_args['sel_paged'] = '%#%';
                    echo wp_kses_post(paginate_links(array(
                        'base'      => esc_url(add_query_arg($aegisseo_sel_base_args)),
                        'format'    => '',
                        'current'   => $aegisseo_sel_paged,
                        'total'     => $aegisseo_sel_total_pages,
                        'prev_text' => '&lsaquo;',
                        'next_text' => '&rsaquo;',
                        'type'      => 'plain',
)));
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <form id="aegisseo-selectionlist-form" method="post" action="#">
            <button type="button" class="button" id="aegisseo-sel-rollback-selected" disabled>
                <?php echo esc_html__('Rollback Selected', 'aegisseo'); ?>
            </button>
            <span class="description" style="margin-left:8px;">
                <?php echo esc_html__('Rollback the most recent AegisSEO change for each selected item.', 'aegisseo'); ?>
            </span>

            <table class="widefat striped" style="margin-top:10px;">
                <thead>
                    <tr>
                        <th style="width:34px;"><input type="checkbox" id="aegisseo-sel-select-all" /></th>
                        <th style="width:160px;"><?php echo esc_html__('When', 'aegisseo'); ?></th>
                        <th style="width:110px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
                        <th><?php echo esc_html__('Object', 'aegisseo'); ?></th>
                        <th style="width:170px;"><?php echo esc_html__('Field', 'aegisseo'); ?></th>
                        <th><?php echo esc_html__('Old', 'aegisseo'); ?></th>
                        <th><?php echo esc_html__('New', 'aegisseo'); ?></th>
                        <th style="width:180px;"><?php echo esc_html__('User', 'aegisseo'); ?></th>
                        <th style="width:140px;"><?php echo esc_html__('Action', 'aegisseo'); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php if (empty($aegisseo_evt_list_q->posts)) : ?>
                    <tr><td colspan="9"><?php echo esc_html__('No items to show. Enable one or more content types above and click Save.', 'aegisseo'); ?></td></tr>
                <?php else : ?>
                    <?php

					$aegisseo_sel_evt_map = array();

					$aegisseo_sel_recent_events = aegisseo()->events->get_recent_paged(2000, 0, null, null, $aegisseo_evt_allowed_pts);

					if (!empty($aegisseo_sel_recent_events)) {
						foreach ($aegisseo_sel_recent_events as $aegisseo_ev) {
							$aegisseo_otype = isset($aegisseo_ev['object_type']) ? (string) $aegisseo_ev['object_type'] : '';
							$aegisseo_oid   = isset($aegisseo_ev['object_id']) ? (int) $aegisseo_ev['object_id'] : 0;
							$aegisseo_mkey  = isset($aegisseo_ev['meta_key']) ? (string) $aegisseo_ev['meta_key'] : '';
							$aegisseo_field = isset($aegisseo_ev['field']) ? (string) $aegisseo_ev['field'] : '';

							if ($aegisseo_otype !== 'post' || $aegisseo_oid <= 0) { continue; }

							$aegisseo_is_meta_desc = (
								$aegisseo_mkey === '_aegisseo_description'
								|| $aegisseo_mkey === 'aegisseo_description'
								|| $aegisseo_mkey === '_aegisseo_meta_description'
								|| $aegisseo_field === 'meta_description'
								|| $aegisseo_field === 'description'
							);

							if (!$aegisseo_is_meta_desc) { continue; }

							if (!isset($aegisseo_sel_evt_map[$aegisseo_oid])) {
								$aegisseo_sel_evt_map[$aegisseo_oid] = $aegisseo_ev; // contains id, old_value, new_value, event_type, user_id, created_at, etc.
							}
						}
					}

                    foreach ($aegisseo_evt_list_q->posts as $aegisseo_pid) :
                        $aegisseo_p = get_post($aegisseo_pid);
                        if (!$aegisseo_p) { continue; }
                        $aegisseo_ptype = (string) $aegisseo_p->post_type;
                        $aegisseo_when = !empty($aegisseo_p->post_modified_gmt) ? get_date_from_gmt($aegisseo_p->post_modified_gmt, 'Y-m-d H:i:s') : '';
                        $aegisseo_email = '';
                        if (!empty($aegisseo_p->post_author)) {
                            $aegisseo_u = get_user_by('id', (int) $aegisseo_p->post_author);
                            if ($aegisseo_u && !empty($aegisseo_u->user_email)) { $aegisseo_email = $aegisseo_u->user_email; }
                        }

                        $title = get_the_title($aegisseo_pid);
                        if ($title === '') { $title = sprintf('#%d', $aegisseo_pid); }
                        $aegisseo_edit_link = get_edit_post_link($aegisseo_pid, '');

                        $aegisseo_cur_desc = (string) get_post_meta($aegisseo_pid, '_aegisseo_description', true);
                        $aegisseo_needs_desc = (trim((string) $aegisseo_cur_desc) === '');

                    ?>
                        <tr>
                            <td><input type="checkbox" class="aegisseo-sel-row" value="<?php echo esc_attr($aegisseo_pid); ?>" /></td>
                            <td><?php echo esc_html($aegisseo_when); ?></td>
                            <td><span class="aegisseo-pill"><?php echo esc_html($aegisseo_ptype); ?></span></td>
                            <td>
                                <?php if ($aegisseo_edit_link): ?>
                                    <a href="<?php echo esc_url($aegisseo_edit_link); ?>"><?php echo esc_html($title); ?></a>
                                <?php else: ?>
                                    <?php echo esc_html($title); ?>
                                <?php endif; ?>
                                <span style="color:#666;"><?php echo ' (' . esc_html($aegisseo_ptype) . ')'; ?></span>
                            </td>
							<td><?php echo esc_html('meta_description'); ?></td>

							<?php
							$aegisseo_oldv = '—';
							$aegisseo_newv = '—';

							$aegisseo_sel_ev = isset($aegisseo_sel_evt_map[$aegisseo_pid]) ? $aegisseo_sel_evt_map[$aegisseo_pid] : null;

							if ($aegisseo_sel_ev) {
								$aegisseo_oldv = isset($aegisseo_sel_ev['old_value']) ? $aegisseo_sel_ev['old_value'] : '—';
								$aegisseo_newv = isset($aegisseo_sel_ev['new_value']) ? $aegisseo_sel_ev['new_value'] : '—';

								if ($aegisseo_oldv === null || (is_string($aegisseo_oldv) && trim($aegisseo_oldv) === '')) { $aegisseo_oldv = '—'; }
								if ($aegisseo_newv === null || (is_string($aegisseo_newv) && trim($aegisseo_newv) === '')) { $aegisseo_newv = '—'; }
							}
							?>
							<td>
							  <span title="<?php echo esc_attr((string) $aegisseo_oldv); ?>">
								<?php echo esc_html(function_exists('aegisseo_evt_short') ? aegisseo_evt_short($aegisseo_oldv) : wp_html_excerpt($aegisseo_oldv, 80, '...')); ?>
							  </span>
							</td>
							<td>
							  <span title="<?php echo esc_attr((string) $aegisseo_newv); ?>">
								<?php echo esc_html(function_exists('aegisseo_evt_short') ? aegisseo_evt_short($aegisseo_newv) : wp_html_excerpt($aegisseo_newv, 80, '...')); ?>
							  </span>
							</td>

							<td><?php echo esc_html($aegisseo_email); ?></td>
							<td>
							  <?php
							$aegisseo_sel_can_rollback_keys = array(
								'_aegisseo_title',
								'_aegisseo_description',
								'_aegisseo_canonical',
								'_aegisseo_robots',
								'_aegisseo_focus_phrase',
								'_aegisseo_schema_mode',
								'post_content',
							);

							$aegisseo_sel_can_rollback_types = array(
								'meta_add','meta_update','meta_delete',
								'fix_applied','links_applied',
								'fix_pack','fix_pack_applied',
								'fixpack_generate_meta_descriptions'
							);

							$aegisseo_sel_ev   = isset($aegisseo_sel_evt_map[$aegisseo_pid]) ? $aegisseo_sel_evt_map[$aegisseo_pid] : null;
							  $aegisseo_can_rb   = false;
							  $aegisseo_event_id = 0;

							  if ($aegisseo_sel_ev) {
								  $aegisseo_otype = isset($aegisseo_sel_ev['object_type']) ? (string) $aegisseo_sel_ev['object_type'] : '';
								  $aegisseo_etype = isset($aegisseo_sel_ev['event_type']) ? (string) $aegisseo_sel_ev['event_type'] : '';
								  $aegisseo_mkey  = isset($aegisseo_sel_ev['meta_key']) ? (string) $aegisseo_sel_ev['meta_key'] : '';
								  $aegisseo_event_id = isset($aegisseo_sel_ev['id']) ? (int) $aegisseo_sel_ev['id'] : 0;

								  $aegisseo_old_tmp = isset($aegisseo_sel_ev['old_value']) ? (string) $aegisseo_sel_ev['old_value'] : '';
								  $aegisseo_new_tmp = isset($aegisseo_sel_ev['new_value']) ? (string) $aegisseo_sel_ev['new_value'] : '';
								  $aegisseo_can_rb = ($aegisseo_otype === 'post'
									  && $aegisseo_event_id > 0
									  && in_array($aegisseo_etype, $aegisseo_sel_can_rollback_types, true)
									  && in_array($aegisseo_mkey,  $aegisseo_sel_can_rollback_keys,  true)
								  );

								  if ($aegisseo_can_rb && $aegisseo_old_tmp === $aegisseo_new_tmp) { $aegisseo_can_rb = false; }
							  }

							  if ($aegisseo_can_rb): ?>
								  <form method="post"
										action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
										style="margin:0;"
										onsubmit="return confirm('<?php echo esc_js(__('Rollback this change?', 'aegisseo')); ?>');">
									  <?php wp_nonce_field('aegisseo_rollback_event'); ?>
									  <input type="hidden" name="action" value="aegisseo_rollback_event" />
									  <input type="hidden" name="event_id" value="<?php echo (int) $aegisseo_event_id; ?>" />
									  <button type="submit" class="button button-small"><?php echo esc_html__('Rollback', 'aegisseo'); ?></button>
								  </form>

							  <?php elseif ($aegisseo_needs_desc): ?>

								  <form method="post"
										action="<?php echo esc_url(admin_url('admin-post.php')); ?>"
										style="margin:0;"
										onsubmit="return confirm('<?php echo esc_js(__('Generate meta description now?', 'aegisseo')); ?>');">
									  <?php wp_nonce_field('aegisseo_apply_fix'); ?>
									  <input type="hidden" name="action" value="aegisseo_apply_fix" />
									  <input type="hidden" name="post_id" value="<?php echo (int) $aegisseo_pid; ?>" />
									  <input type="hidden" name="fix_type" value="gen_meta_desc" />
									  <button type="submit" class="button button-small button-primary"><?php echo esc_html__('Generate Meta', 'aegisseo'); ?></button>
								  </form>

							  <?php else: ?>
								  <a class="button button-small" href="<?php echo esc_url($aegisseo_edit_link); ?>">
									  <?php echo esc_html__('Edit', 'aegisseo'); ?>
								  </a>
							  <?php endif; ?>
							</td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
        </form>

        <script>
        (function($){

            $('#aegisseo-sel-per-page').on('change', function(){
                var v = $(this).val();
                var url = new URL(window.location.href);
                url.searchParams.set('sel_per_page', v);
                url.searchParams.set('sel_paged', '1');
                window.location.href = url.toString();
            });

            $('#aegisseo-sel-select-all').on('change', function(){
                $('.aegisseo-sel-row').prop('checked', this.checked).trigger('change');
            });

            function selUpdateBtn(){
                var any = $('.aegisseo-sel-row:checked').length > 0;
                $('#aegisseo-sel-rollback-selected').prop('disabled', !any);
            }
            $(document).on('change', '.aegisseo-sel-row', selUpdateBtn);
            selUpdateBtn();

            $('#aegisseo-sel-rollback-selected').on('click', function(e){
                e.preventDefault();
                var ids = $('.aegisseo-sel-row:checked').map(function(){ return $(this).val(); }).get();
                if (!ids.length) return;
                if (!confirm('Rollback the last generated Meta Description for selected items?')) return;

                var i = 0;
                function next(){
                    if (i >= ids.length) { window.location.reload(); return; }
                    var pid = ids[i++];
                    $.post(ajaxurl, {action:'aegisseo_quick_rollback', nonce: "<?php echo esc_js(wp_create_nonce('aegisseo_quick_fix')); ?>", post_id: pid, field:'meta_description'})
                      .always(next);
                }
                next();
            });
        })(jQuery);
        </script>

    <?php endif; ?>
</div>


<?php
$aegisseo_events = array();
if (isset(aegisseo()->events) && aegisseo()->events) {
	$aegisseo_evt_per_page = isset($_GET['evt_per_page']) ? absint(wp_unslash($_GET['evt_per_page'])) : 25;
    if (!in_array($aegisseo_evt_per_page, array(25, 50), true)) { $aegisseo_evt_per_page = 25; }

	$aegisseo_evt_page = isset($_GET['evt_page']) ? max(1, absint(wp_unslash($_GET['evt_page']))) : 1;
	$aegisseo_offset = ($aegisseo_evt_page - 1) * $aegisseo_evt_per_page;

	if (empty($aegisseo_evt_allowed_pts)) {
        $aegisseo_total = 0;
        $aegisseo_events = array();
    } else {
        $aegisseo_total = (int) aegisseo()->events->count_all(null, null, $aegisseo_evt_allowed_pts);
        $aegisseo_events = aegisseo()->events->get_recent_paged($per_page, $aegisseo_offset, null, null, $aegisseo_evt_allowed_pts);
    }
	$aegisseo_total_pages = ($per_page > 0) ? max(1, (int) ceil($aegisseo_total / $per_page)) : 1;
}

$aegisseo_can_rollback_keys = array(
    '_aegisseo_title',
    '_aegisseo_description',
    '_aegisseo_canonical',
    '_aegisseo_robots',
    '_aegisseo_focus_phrase',
    '_aegisseo_schema_mode',
    'post_content',
);

$aegisseo_can_rollback_types = array(
    'meta_add','meta_update','meta_delete',
    'fix_applied','links_applied',
    'fix_pack','fix_pack_applied',
    'fixpack_generate_meta_descriptions'
);

function aegisseo_evt_short($aegisseo_v) {
    if (null === $aegisseo_v) { return '—'; }
    $aegisseo_v = (string) $aegisseo_v;
    $aegisseo_v = trim($aegisseo_v);
    if ($aegisseo_v === '') { return '—'; }
    if (mb_strlen($aegisseo_v) > 80) { return mb_substr($aegisseo_v, 0, 80) . '…'; }
    return $aegisseo_v;
}
?>

<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" id="aegisseo-bulk-rollback-form" style="margin:0;">
    <?php wp_nonce_field('aegisseo_bulk_rollback_events'); ?>
    <input type="hidden" name="action" value="aegisseo_bulk_rollback_events" />

    <div style="margin:10px 0;">
        <button type="submit" class="button button-secondary" id="aegisseo-bulk-rollback-btn" disabled onclick="return confirm('<?php echo esc_js(__('Rollback selected changes?', 'aegisseo')); ?>');">
            <?php echo esc_html__('Rollback Selected', 'aegisseo'); ?>
        </button>
        <span class="description" style="margin-left:10px;"><?php echo esc_html__('Select multiple rollbackable rows and rollback in one action.', 'aegisseo'); ?></span>
    </div>
	
	<div style="margin:8px 0 12px; display:flex; align-items:center; gap:10px;">
        <?php /* translators: %d: total number of events */ ?>
		<strong><?php echo esc_html(sprintf(__('Total events: %d', 'aegisseo'), $aegisseo_total)); ?></strong>
        <span style="margin-left:auto;"></span>
        <label for="aegisseo-evt-per-page"><strong><?php echo esc_html__('Per page:', 'aegisseo'); ?></strong></label>
        <select id="aegisseo-evt-per-page">
            <option value="25" <?php selected($per_page, 25); ?>>25</option>
            <option value="50" <?php selected($per_page, 50); ?>>50</option>
        </select>
	</div>


	<?php if ($aegisseo_total_pages > 1): ?>
		<div class="tablenav top">
			<div class="tablenav-pages">
				<?php
			$aegisseo_request_uri = isset($_SERVER['REQUEST_URI']) ? esc_url_raw(wp_unslash($_SERVER['REQUEST_URI'])) : ''; $aegisseo_base_url = remove_query_arg(array('evt_page'), $aegisseo_request_uri);
				$aegisseo_prev = max(1, $page - 1);
				$aegisseo_next = min($aegisseo_total_pages, $page + 1);

				echo '<span class="pagination-links">';
				if ($page > 1) {
					echo '<a class="prev-page button" href="' . esc_url(add_query_arg('evt_page', $aegisseo_prev, $aegisseo_base_url)) . '">&lsaquo;</a> ';
				} else {
					echo '<span class="tablenav-pages-navspan button disabled">&lsaquo;</span> ';
				}

				echo '<span class="paging-input">' . esc_html($page) . ' / ' . esc_html($aegisseo_total_pages) . '</span>';

				if ($page < $aegisseo_total_pages) {
					echo ' <a class="next-page button" href="' . esc_url(add_query_arg('evt_page', $aegisseo_next, $aegisseo_base_url)) . '">&rsaquo;</a>';
				} else {
					echo ' <span class="tablenav-pages-navspan button disabled">&rsaquo;</span>';
				}
				echo '</span>';
				?>
			</div>
		</div>
	<?php endif; ?>

<table class="widefat striped">
    <thead>
        <tr>
            <th style="width:34px;"><input type="checkbox" id="aegisseo-evt-select-all" /></th>
            <th style="width:140px;"><?php echo esc_html__('When', 'aegisseo'); ?></th>
            <th style="width:110px;"><?php echo esc_html__('Type', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('Object', 'aegisseo'); ?></th>
            <th style="width:170px;"><?php echo esc_html__('Field', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('Old', 'aegisseo'); ?></th>
            <th><?php echo esc_html__('New', 'aegisseo'); ?></th>
            <th style="width:90px;"><?php echo esc_html__('User', 'aegisseo'); ?></th>
            <th style="width:110px;"><?php echo esc_html__('Action', 'aegisseo'); ?></th>
        </tr>
    </thead>
    <tbody>
    <?php if (empty($aegisseo_events)) : ?>
        <tr><td colspan="9"><?php echo esc_html__('No events recorded yet.', 'aegisseo'); ?></td></tr>
    <?php else : ?>
        <?php foreach ($aegisseo_events as $aegisseo_e) : ?>
            <?php
                $aegisseo_etype = isset($aegisseo_e['event_type']) ? (string) $aegisseo_e['event_type'] : '';
                $aegisseo_otype = isset($aegisseo_e['object_type']) ? (string) $aegisseo_e['object_type'] : '';
                $aegisseo_oid   = isset($aegisseo_e['object_id']) ? (int) $aegisseo_e['object_id'] : 0;
                $aegisseo_mkey  = isset($aegisseo_e['meta_key']) ? (string) $aegisseo_e['meta_key'] : '';
                $aegisseo_oldv  = isset($aegisseo_e['old_value']) ? $aegisseo_e['old_value'] : null;
                $aegisseo_newv  = isset($aegisseo_e['new_value']) ? $aegisseo_e['new_value'] : null;
                $aegisseo_when  = isset($aegisseo_e['created_at']) ? (string) $aegisseo_e['created_at'] : '';
                $aegisseo_uid   = isset($aegisseo_e['user_id']) ? (int) $aegisseo_e['user_id'] : 0;

                $aegisseo_obj_label = $aegisseo_otype . ':' . $aegisseo_oid;
                $aegisseo_obj_link = '';
                if ($aegisseo_otype === 'post' && $aegisseo_oid > 0) {
                    $aegisseo_ptitle = get_the_title($aegisseo_oid);
                    if ($aegisseo_ptitle) {
                        $aegisseo_obj_label = $aegisseo_ptitle . ' (#' . $aegisseo_oid . ')';
                        $aegisseo_obj_link = get_edit_post_link($aegisseo_oid, '');
                    }
                }

                $aegisseo_u = $aegisseo_uid ? get_userdata($aegisseo_uid) : null;
                $aegisseo_uname = ($aegisseo_u && !empty($aegisseo_u->user_login)) ? $aegisseo_u->user_login : '—';

                $aegisseo_can_rb = ($aegisseo_otype === 'post' && in_array($aegisseo_etype, $aegisseo_can_rollback_types, true) && in_array($aegisseo_mkey, $aegisseo_can_rollback_keys, true));
                if ($aegisseo_can_rb && (string)$aegisseo_oldv === (string)$aegisseo_newv) { $aegisseo_can_rb = false; }
            ?>
            <tr>
                <td style="text-align:center;">
                    <?php if ($aegisseo_can_rb) : ?>
                        <input type="checkbox" class="aegisseo-evt-cb" name="event_ids[]" value="<?php echo (int) $aegisseo_e['id']; ?>" />
                    <?php else : ?>
                        <input type="checkbox" disabled />
                    <?php endif; ?>
                </td>
                <td><?php echo esc_html($aegisseo_when); ?></td>
                <td><code><?php echo esc_html($aegisseo_etype); ?></code></td>
                <td>
                    <?php if ($aegisseo_obj_link) : ?>
                        <a href="<?php echo esc_url($aegisseo_obj_link); ?>"><?php echo esc_html($aegisseo_obj_label); ?></a>
                    <?php else : ?>
                        <?php echo esc_html($aegisseo_obj_label); ?>
                    <?php endif; ?>
                </td>
                <td><code><?php echo esc_html($aegisseo_mkey ? $aegisseo_mkey : '—'); ?></code></td>
                <td><span title="<?php echo esc_attr((string)$aegisseo_oldv); ?>"><?php echo esc_html(aegisseo_evt_short($aegisseo_oldv)); ?></span></td>
                <td><span title="<?php echo esc_attr((string)$aegisseo_newv); ?>"><?php echo esc_html(aegisseo_evt_short($aegisseo_newv)); ?></span></td>
                <td><?php echo esc_html($aegisseo_uname); ?></td>
                <td>
                    <?php if ($aegisseo_can_rb) : ?>
                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" style="margin:0; display:inline-block;" onsubmit="return confirm('<?php echo esc_js(__('Rollback this change?', 'aegisseo')); ?>');">
                            <?php wp_nonce_field('aegisseo_rollback_event'); ?>
                            <input type="hidden" name="action" value="aegisseo_rollback_event" />
                            <input type="hidden" name="event_id" value="<?php echo (int) $aegisseo_e['id']; ?>" />
                            <button type="submit" class="button button-small"><?php echo esc_html__('Rollback', 'aegisseo'); ?></button>
                        </form>
                    <?php else : ?>
                        <span style="color:#666;">—</span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>
    </tbody>
</table>

<script>
(function($){
  $('#aegisseo-evt-per-page').on('change', function(){
    var v = $(this).val();
    var url = new URL(window.location.href);
    url.searchParams.set('evt_per_page', v);
    url.searchParams.set('evt_page', '1');
    window.location.href = url.toString();
  });
})(jQuery);
</script>


<?php
    $aegisseo_prev_url   = home_url('/');
    $aegisseo_prev_host  = preg_replace('#^https?://#', '', $aegisseo_prev_url);
    $aegisseo_prev_title = get_bloginfo('name');
    $aegisseo_prev_desc  = get_bloginfo('description');
?>
<div style="display:flex; gap:16px; margin-top:16px; flex-wrap:wrap;">
    <div style="flex:1; min-width:320px; border:1px solid #dcdcde; background:#fff; padding:12px;">
        <h4 style="margin:0 0 8px 0;"><?php echo esc_html__('Live SERP Preview', 'aegisseo'); ?></h4>
        <div style="margin:0 0 8px 0;">
            <button type="button" class="button button-small aegisseo-device-toggle is-active" data-device="desktop"><?php echo esc_html__('Desktop', 'aegisseo'); ?></button>
            <button type="button" class="button button-small aegisseo-device-toggle" data-device="mobile"><?php echo esc_html__('Mobile', 'aegisseo'); ?></button>
        </div>
        <div class="aegisseo-serp-preview" data-device="desktop">
            <div style="color:#1d2327; font-size:18px; line-height:1.3; margin-bottom:2px;"><?php echo esc_html($aegisseo_prev_title); ?></div>
            <div style="color:#006621; font-size:13px; margin-bottom:4px;"><?php echo esc_html($aegisseo_prev_host); ?></div>
            <div style="color:#3c4043; font-size:13px;"><?php echo esc_html($aegisseo_prev_desc); ?></div>
        </div>
    </div>

    <div style="flex:1; min-width:320px; border:1px solid #dcdcde; background:#fff; padding:12px;">
        <h4 style="margin:0 0 8px 0;"><?php echo esc_html__('Live Social Preview', 'aegisseo'); ?></h4>
        <div style="margin:0 0 8px 0;">
            <button type="button" class="button button-small aegisseo-social-toggle is-active" data-social="og"><?php echo esc_html__('Open Graph', 'aegisseo'); ?></button>
            <button type="button" class="button button-small aegisseo-social-toggle" data-social="twitter"><?php echo esc_html__('Twitter', 'aegisseo'); ?></button>
        </div>
        <div class="aegisseo-social-preview" data-social="og" style="border:1px solid #dcdcde; display:flex; min-height:90px;">
            <div style="width:120px; background:#f6f7f7; display:flex; align-items:center; justify-content:center; color:#666; font-size:12px;">
                <?php echo esc_html__('No image set', 'aegisseo'); ?>
            </div>
            <div style="padding:10px;">
                <div style="color:#6a6a6a; font-size:11px; margin-bottom:4px;"><?php echo esc_html(strtoupper((string) wp_parse_url($aegisseo_prev_url, PHP_URL_HOST))); ?></div>
                <div style="font-weight:600; margin-bottom:2px;"><?php echo esc_html($aegisseo_prev_title); ?></div>
                <div style="color:#3c4043; font-size:13px;"><?php echo esc_html($aegisseo_prev_desc); ?></div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(function($){
    var $form = $('#aegisseo-bulk-rollback-form');
    if (!$form.length) { return; }

    var $selectAll = $('#aegisseo-evt-select-all');
    var $boxes = $form.find('input.aegisseo-evt-cb');
    var $btn = $('#aegisseo-bulk-rollback-btn');

    function sync(){
        var checked = $boxes.filter(':checked').length;

        $btn.prop('disabled', checked === 0);

        if ($selectAll.length) {
            $selectAll.prop('checked', checked > 0 && checked === $boxes.length);
            $selectAll.prop('indeterminate', checked > 0 && checked < $boxes.length);
        }
    }

    $selectAll.off('change.aegisseo').on('change.aegisseo', function(){
        var on = $(this).is(':checked');
        $boxes.prop('checked', on);
        sync();
    });

    $form.off('change.aegisseo', 'input.aegisseo-evt-cb')
         .on('change.aegisseo', 'input.aegisseo-evt-cb', function(){
            sync();
         });

    sync();
});
</script>
</form>

<?php
$aegisseo_orphans = get_posts(array(
    'post_type' => 'page',
    'post_status' => 'publish',
    'numberposts' => 50,
    'meta_key' => '_aegisseo_orphan', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
    'meta_value' => '1', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
    'fields' => 'ids',
));
if (!empty($aegisseo_orphans)):
?>
<div style="margin-top:16px; padding:12px; border:1px solid #dcdcde; background:#fff; border-radius:8px;">
    <strong><?php echo esc_html__('Orphan Pages (needs internal links)', 'aegisseo'); ?></strong>
    <p class="description" style="margin-top:6px;"><?php echo esc_html__('These pages were detected as having no inbound mentions in published content (best-effort). Add at least one internal link from a relevant hub page.', 'aegisseo'); ?></p>
    <ul style="margin:8px 0 0; padding-left:18px;">
        <?php foreach ((array)$aegisseo_orphans as $aegisseo_oid): ?>
            <li>
                <a href="<?php echo esc_url(get_edit_post_link((int)$aegisseo_oid)); ?>"><?php echo esc_html(get_the_title((int)$aegisseo_oid)); ?></a>
                <span style="color:#666;"> — <?php echo esc_html(get_permalink((int)$aegisseo_oid)); ?></span>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>


<script>
(function(){
  var nonce = "<?php echo esc_js(wp_create_nonce('aegisseo_quick_fix')); ?>";

  function postAjax(action, data){
    data = data || {};
    data.action = action;
    data.nonce = nonce;
    return window.jQuery.post(ajaxurl, data);
  }

  jQuery(document).on('click', '.aegisseo-quick-generate', function(e){
    e.preventDefault();
    var $btn = jQuery(this);
    var postId = parseInt($btn.data('post'), 10) || 0;
    var field = String($btn.data('field') || '');
    if (!postId || !field) return;

    var label = $btn.text();
    $btn.prop('disabled', true).text('Generating…');
    postAjax('aegisseo_quick_generate', {post_id: postId, field: field})
      .done(function(resp){
        if (resp && resp.success) {
          alert('Generated successfully.');
          window.location.reload();
          return;
        }
        alert('Generate failed.');
      })
      .fail(function(){ alert('Generate failed (request).'); })
      .always(function(){ $btn.prop('disabled', false).text(label); });
  });

  jQuery(document).on('click', '.aegisseo-quick-rollback', function(e){
    e.preventDefault();
    var $btn = jQuery(this);
    var postId = parseInt($btn.data('post'), 10) || 0;
    var field = String($btn.data('field') || '');
    if (!postId || !field) return;

    if (!confirm('Rollback the last generated change for this field?')) return;

    var label = $btn.text();
    $btn.prop('disabled', true).text('Rolling back…');
    postAjax('aegisseo_quick_rollback', {post_id: postId, field: field})
      .done(function(resp){
        if (resp && resp.success) {
          alert('Rollback complete.');
          window.location.reload();
          return;
        }
        alert('Rollback failed.');
      })
      .fail(function(){ alert('Rollback failed (request).'); })
      .always(function(){ $btn.prop('disabled', false).text(label); });
  });
})();
</script>
