<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('edit_posts')) { echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>'; return; }

$aegisseo_smart_opt_key = 'aegisseo_smart_links';
$aegisseo_smart_opts = get_option($aegisseo_smart_opt_key, array('enabled' => 0, 'map' => array()));
if (!is_array($aegisseo_smart_opts)) { $aegisseo_smart_opts = array('enabled' => 0, 'map' => array()); }
if (!isset($aegisseo_smart_opts['enabled'])) { $aegisseo_smart_opts['enabled'] = 0; }
if (!isset($aegisseo_smart_opts['map']) || !is_array($aegisseo_smart_opts['map'])) { $aegisseo_smart_opts['map'] = array(); }

// Handle Smart Links save
if (!empty($_POST['aegisseo_smart_links_save'])) {
    check_admin_referer('aegisseo_smart_links_save');

    $aegisseo_enabled = ! empty( $_POST['smart_links_enabled'] ) ? 1 : 0;

    $aegisseo_keywords = array();
    if ( isset( $_POST['smart_keyword'] ) ) {
    $aegisseo_keywords_raw = filter_input( INPUT_POST, 'smart_keyword', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY );
    if ( null !== $aegisseo_keywords_raw ) {
        $aegisseo_keywords_raw = wp_unslash( $aegisseo_keywords_raw );
    } else {
        $aegisseo_keywords_raw = array();
    }
        if ( is_array( $aegisseo_keywords_raw ) ) {
            foreach ( $aegisseo_keywords_raw as $aegisseo_idx => $aegisseo_val ) {
                if ( is_scalar( $aegisseo_val ) || is_null( $aegisseo_val ) ) {
                    $aegisseo_keywords[ $aegisseo_idx ] = sanitize_text_field( (string) $aegisseo_val );
                }
            }
        }
    }
    $aegisseo_urls = array();
    if ( isset( $_POST['smart_url'] ) ) {
    $aegisseo_urls_raw = filter_input( INPUT_POST, 'smart_url', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY );
    if ( null !== $aegisseo_urls_raw ) {
        $aegisseo_urls_raw = wp_unslash( $aegisseo_urls_raw );
    } else {
        $aegisseo_urls_raw = array();
    }
        if ( is_array( $aegisseo_urls_raw ) ) {
            foreach ( $aegisseo_urls_raw as $aegisseo_idx => $aegisseo_val ) {
                if ( is_scalar( $aegisseo_val ) || is_null( $aegisseo_val ) ) {
                    $aegisseo_urls[ $aegisseo_idx ] = esc_url_raw( (string) $aegisseo_val );
                }
            }
        }
    }

    $aegisseo_map = array();
    $aegisseo_count = max(count($aegisseo_keywords), count($aegisseo_urls));

    for ($aegisseo_i = 0; $aegisseo_i < $aegisseo_count; $aegisseo_i++) {
        $aegisseo_kw  = isset( $aegisseo_keywords[ $aegisseo_i ] ) ? sanitize_text_field( (string) $aegisseo_keywords[ $aegisseo_i ] ) : '';
        $aegisseo_url = isset( $aegisseo_urls[ $aegisseo_i ] ) ? esc_url_raw( trim( (string) $aegisseo_urls[ $aegisseo_i ] ) ) : '';

        $aegisseo_kw = trim( $aegisseo_kw );

        // enforce: one word only (no whitespace)
        if ($aegisseo_kw === '' || preg_match('/\s/', $aegisseo_kw)) { continue; }
        if ($aegisseo_url === '') { continue; }

        // avoid duplicates (case-insensitive)
        $aegisseo_map[strtolower($aegisseo_kw)] = array(
            'keyword' => $aegisseo_kw,
            'url'     => $aegisseo_url,
        );
    }

    $aegisseo_smart_opts = array(
        'enabled' => $aegisseo_enabled,
        'map'     => array_values($aegisseo_map),
    );

    update_option($aegisseo_smart_opt_key, $aegisseo_smart_opts, false);

    echo '<div class="notice notice-success"><p>' . esc_html__('Smart Links saved.', 'aegisseo') . '</p></div>';
}

$aegisseo_post_id = 0;
$aegisseo___aegisseo_links_nonce = isset( $_GET['_wpnonce'] ) ? sanitize_text_field( wp_unslash( (string) $_GET['_wpnonce'] ) ) : '';
if ( isset( $_GET['post_id'] ) && '' !== $aegisseo___aegisseo_links_nonce && wp_verify_nonce( $aegisseo___aegisseo_links_nonce, 'aegisseo_links_suggest' ) ) {
    $aegisseo_post_id = absint( wp_unslash( (string) $_GET['post_id'] ) );
}
unset( $aegisseo___aegisseo_links_nonce );

echo '<h2>' . esc_html__('Internal Linking Assistant', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Suggestions are based on the post title + categories/tags keywords.', 'aegisseo') . '</p>';
echo '<hr style="margin:18px 0;" />';
echo '<h2 style="margin:0 0 6px 0;">' . esc_html__('Smart Links (Keyword → URL)', 'aegisseo') . '</h2>';
echo '<p class="description" style="margin:0 0 12px 0;">' . esc_html__('Create one-word keywords that automatically link across your entire site content. Example: AegisWAF → https://aegisify.com/aegiswaf/', 'aegisseo') . '</p>';

echo '<form method="post" action="">';
wp_nonce_field('aegisseo_smart_links_save');
echo '<input type="hidden" name="aegisseo_smart_links_save" value="1" />';

echo '<label style="display:inline-flex; align-items:center; gap:8px; margin: 0 0 10px 0;">';
echo '<input type="checkbox" name="smart_links_enabled" value="1" ' . checked(!empty($aegisseo_smart_opts['enabled']), true, false) . ' />';
echo '<strong>' . esc_html__('Enable Smart Links site-wide', 'aegisseo') . '</strong>';
echo '</label>';

echo '<table class="widefat striped" style="max-width:1100px;">';
echo '<thead><tr>';
echo '<th style="width:240px;">' . esc_html__('Keyword (one word)', 'aegisseo') . '</th>';
echo '<th>' . esc_html__('Destination URL', 'aegisseo') . '</th>';
echo '</tr></thead><tbody>';

$aegisseo_rows = !empty($aegisseo_smart_opts['map']) ? $aegisseo_smart_opts['map'] : array();
if (count($aegisseo_rows) < 6) {
    for ($aegisseo_i = count($aegisseo_rows); $aegisseo_i < 6; $aegisseo_i++) { $aegisseo_rows[] = array('keyword'=>'', 'url'=>''); }
}

foreach ($aegisseo_rows as $aegisseo_row) {
    $aegisseo_kw  = isset($aegisseo_row['keyword']) ? $aegisseo_row['keyword'] : '';
    $aegisseo_url = isset($aegisseo_row['url']) ? $aegisseo_row['url'] : '';
    echo '<tr>';
    echo '<td><input class="regular-text" type="text" name="smart_keyword[]" value="' . esc_attr($aegisseo_kw) . '" placeholder="AegisSEO" /></td>';
    echo '<td><input class="large-text" type="url" name="smart_url[]" value="' . esc_attr($aegisseo_url) . '" placeholder="https://aegisify.com/aegisseo/" /></td>';
    echo '</tr>';
}

echo '</tbody></table>';

echo '<p class="description" style="margin-top:10px;">' . esc_html__('Rules: one keyword = one URL. Keywords are case-insensitive. Existing links are not modified.', 'aegisseo') . '</p>';

submit_button(__('Save Smart Links', 'aegisseo'), 'primary', 'submit', false);
echo '</form>';

echo '<hr style="margin:18px 0;" />';

$aegisseo_posts = get_posts(array('post_type'=>'post','numberposts'=>50,'post_status'=>array('publish','draft')));
echo '<form method="get" action="">';
echo '<input type="hidden" name="page" value="aegisseo" />';
echo '<input type="hidden" name="tab" value="links" />';
wp_nonce_field( 'aegisseo_links_suggest', '_wpnonce', false );
echo '<select name="post_id">';
echo '<option value="0">' . esc_html__('-- Select a post --', 'aegisseo') . '</option>';
foreach ($aegisseo_posts as $aegisseo_p) {
    echo '<option value="' . esc_attr($aegisseo_p->ID) . '" ' . selected($aegisseo_post_id, $aegisseo_p->ID, false) . '>' . esc_html(get_the_title($aegisseo_p->ID)) . '</option>';
}
echo '</select> ';
submit_button(__('Suggest', 'aegisseo'), 'secondary', '', false);
echo '</form>';
if ($aegisseo_post_id) {
    $aegisseo_suggestions = aegisseo()->linking->suggest_links($aegisseo_post_id, 10);
    if (empty($aegisseo_suggestions)) echo '<p>' . esc_html__('No suggestions found yet.', 'aegisseo') . '</p>';
    else {
        echo '<ul>';
        foreach ($aegisseo_suggestions as $aegisseo_s) echo '<li><a href="' . esc_url($aegisseo_s['url']) . '" target="_blank" rel="noopener">' . esc_html($aegisseo_s['title']) . '</a></li>';
        echo '</ul>';
    }
}
