<?php
if (!defined('ABSPATH')) { exit; }
if (!current_user_can('manage_options')) {
    echo '<p>' . esc_html__('Forbidden', 'aegisseo') . '</p>';
    return;
}
$aegisseo_opts = function_exists('aegisseo') ? aegisseo()->options->get_all() : array();

echo '<h2>' . esc_html__('Local SEO', 'aegisseo') . '</h2>';
echo '<p class="description">' . esc_html__('Adds LocalBusiness schema to your homepage and provides a Locations post type.', 'aegisseo') . '</p>';
?>
<form method="post" action="options.php">
    <?php settings_fields('aegisseo_settings_group'); ?>
    <table class="form-table" role="presentation">
        <tr>
            <th scope="row"><?php echo esc_html__('Enable Local SEO', 'aegisseo'); ?></th>
            <td><label><input type="checkbox" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_enabled]" value="1" <?php checked(1, (int)($aegisseo_opts['local_enabled'] ?? 0)); ?> /> <?php echo esc_html__('Enabled', 'aegisseo'); ?></label></td>
        </tr>
        <tr><th><?php echo esc_html__('Business Type', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_business_type]" value="<?php echo esc_attr($aegisseo_opts['local_business_type'] ?? 'LocalBusiness'); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Business Name', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_name]" value="<?php echo esc_attr($aegisseo_opts['local_name'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Phone', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_phone]" value="<?php echo esc_attr($aegisseo_opts['local_phone'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Email', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_email]" value="<?php echo esc_attr($aegisseo_opts['local_email'] ?? ''); ?>" /></td></tr>

        <tr><th colspan="2"><h3><?php echo esc_html__('Address', 'aegisseo'); ?></h3></th></tr>
        <tr><th><?php echo esc_html__('Street', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_street]" value="<?php echo esc_attr($aegisseo_opts['local_street'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('City', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_city]" value="<?php echo esc_attr($aegisseo_opts['local_city'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('State/Region', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_state]" value="<?php echo esc_attr($aegisseo_opts['local_state'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('ZIP', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_zip]" value="<?php echo esc_attr($aegisseo_opts['local_zip'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Country', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_country]" value="<?php echo esc_attr($aegisseo_opts['local_country'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Latitude', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_lat]" value="<?php echo esc_attr($aegisseo_opts['local_lat'] ?? ''); ?>" /></td></tr>
        <tr><th><?php echo esc_html__('Longitude', 'aegisseo'); ?></th><td><input type="text" class="regular-text" name="<?php echo esc_attr(\AegisSEO\Utils\Options::OPTION_KEY); ?>[local_lng]" value="<?php echo esc_attr($aegisseo_opts['local_lng'] ?? ''); ?>" /></td></tr>
    </table>
    <?php submit_button(__('Save Local SEO Settings', 'aegisseo')); ?>
</form>

<?php
// Submission helpers (these platforms require owner login + verification).
$aegisseo_google_submit_url = 'https://business.google.com/en-all/business-profile/';
$aegisseo_yelp_submit_url   = 'https://biz.yelp.com/claim';

// Build a copy/paste NAP block from saved settings.
$aegisseo_nap_lines = array_filter(array(
    ($aegisseo_opts['local_name']   ?? '') ? 'Business Name: ' . ($aegisseo_opts['local_name'] ?? '') : '',
    ($aegisseo_opts['local_phone']  ?? '') ? 'Phone: ' . ($aegisseo_opts['local_phone'] ?? '') : '',
    ($aegisseo_opts['local_email']  ?? '') ? 'Email: ' . ($aegisseo_opts['local_email'] ?? '') : '',
    ($aegisseo_opts['local_street'] ?? '') ? 'Street: ' . ($aegisseo_opts['local_street'] ?? '') : '',
    ($aegisseo_opts['local_city']   ?? '') ? 'City: ' . ($aegisseo_opts['local_city'] ?? '') : '',
    ($aegisseo_opts['local_state']  ?? '') ? 'State/Region: ' . ($aegisseo_opts['local_state'] ?? '') : '',
    ($aegisseo_opts['local_zip']    ?? '') ? 'ZIP: ' . ($aegisseo_opts['local_zip'] ?? '') : '',
    ($aegisseo_opts['local_country']?? '') ? 'Country: ' . ($aegisseo_opts['local_country'] ?? '') : '',
    (($aegisseo_opts['local_lat'] ?? '') && ($aegisseo_opts['local_lng'] ?? '')) ? 'Geo: ' . ($aegisseo_opts['local_lat'] ?? '') . ', ' . ($aegisseo_opts['local_lng'] ?? '') : '',
));
$aegisseo_nap_text = implode("\n", $aegisseo_nap_lines);
?>

<hr style="margin:22px 0;" />

<h2 style="margin:0 0 8px 0;"><?php echo esc_html__('Submit Your Business Listing', 'aegisseo'); ?></h2>
<p class="description" style="margin:0 0 12px 0;">
    <?php echo esc_html__('Google and Yelp require you to sign in and verify ownership. Use the buttons below to start the official submission/claim flow.', 'aegisseo'); ?>
</p>

<div style="display:flex; gap:14px; flex-wrap:wrap; max-width: 1100px;">
    <div class="postbox" style="flex:1; min-width:320px; padding:14px;">
        <h3 style="margin:0 0 10px 0;"><?php echo esc_html__('Google Business Profile', 'aegisseo'); ?></h3>
        <p class="description" style="margin:0 0 12px 0;">
            <?php echo esc_html__('Create or claim your Business Profile so your business can appear on Google Search & Maps.', 'aegisseo'); ?>
        </p>
        <p style="margin:0;">
            <a class="button button-primary" target="_blank" rel="noopener noreferrer"
               href="<?php echo esc_url($aegisseo_google_submit_url); ?>">
                <?php echo esc_html__('Submit/Claim on Google', 'aegisseo'); ?>
            </a>
        </p>
    </div>

    <div class="postbox" style="flex:1; min-width:320px; padding:14px;">
        <h3 style="margin:0 0 10px 0;"><?php echo esc_html__('Yelp Business Page', 'aegisseo'); ?></h3>
        <p class="description" style="margin:0 0 12px 0;">
            <?php echo esc_html__('Search for your business on Yelp and claim it — or add it if it doesn’t exist yet.', 'aegisseo'); ?>
        </p>
        <p style="margin:0;">
            <a class="button button-secondary" target="_blank" rel="noopener noreferrer"
               href="<?php echo esc_url($aegisseo_yelp_submit_url); ?>">
                <?php echo esc_html__('Submit/Claim on Yelp', 'aegisseo'); ?>
            </a>
        </p>
    </div>
</div>

<?php if (!empty($aegisseo_nap_text)) : ?>
    <div class="postbox" style="max-width:1100px; padding:14px; margin-top:14px;">
        <h3 style="margin:0 0 10px 0;"><?php echo esc_html__('Copy/Paste Business Info (NAP)', 'aegisseo'); ?></h3>
        <p class="description" style="margin:0 0 10px 0;">
            <?php echo esc_html__('Use this when Google/Yelp asks for your business details.', 'aegisseo'); ?>
        </p>
        <textarea readonly="readonly" class="large-text code" rows="8"><?php echo esc_textarea($aegisseo_nap_text); ?></textarea>
    </div>
<?php endif; ?>

<p class="description"><?php echo esc_html__('Locations: use the Locations post type (created by AegisSEO) to build location pages.', 'aegisseo'); ?></p>
