<?php
if (!defined('ABSPATH')) { exit; }

$aegisseo_has_pro = false;
if (function_exists('aegisseo') && isset(aegisseo()->license) && aegisseo()->license) {
    $aegisseo_has_pro = (bool) aegisseo()->license->is_pro();
}
if (!$aegisseo_has_pro && class_exists('AegisSEO\\Utils\\License')) {
    \AegisSEO\Utils\License::render_pro_banner(
        __('Upgrade to PRO', 'aegisseo'),
        __('PRO feature: SEO Ops Center, Issues & Fixex, Evidence and Migration Wizard with advanced autopilot detection, guided fixes, and bulk remediation actions are available in AegisSEO PRO.', 'aegisseo')
    );
    echo '<p class="description" style="margin-top:10px;">' . esc_html__('Activate a PRO license to unlock Issues & Fixes.', 'aegisseo') . '</p>';
    return;
}

if (!current_user_can('manage_options')) { echo '<div class="notice notice-error"><p>Forbidden.</p></div>'; return; }

// Verify notice query args (GET) with a nonce to satisfy Plugin Checker recommendations.
$aegisseo_notice_ok = false;
$aegisseo_notice_nonce = '';
if (isset($_GET['aegisseo_notice_nonce'])) {
    $aegisseo_notice_nonce = sanitize_text_field(wp_unslash($_GET['aegisseo_notice_nonce']));
    $aegisseo_notice_ok = (bool) wp_verify_nonce($aegisseo_notice_nonce, 'aegisseo_migration_notice');
}
$aegisseo_meta_migrated = ($aegisseo_notice_ok && isset($_GET['meta'])) ? absint(wp_unslash($_GET['meta'])) : 0;
$aegisseo_redir_imported = ($aegisseo_notice_ok && isset($_GET['redir'])) ? absint(wp_unslash($_GET['redir'])) : 0;
$aegisseo_next_offset = ($aegisseo_notice_ok && isset($_GET['next'])) ? absint(wp_unslash($_GET['next'])) : 0;

?>
<div class="aegisseo-wrap">
    <h1><?php echo esc_html__('Migration Wizard', 'aegisseo'); ?></h1>

    <div class="aegisseo-card" style="padding:14px; margin-bottom:14px;">
        <h2 style="margin-top:0;"><?php echo esc_html__('Import SEO Meta From Other Plugins', 'aegisseo'); ?></h2>

        <?php if ($aegisseo_meta_migrated): ?>
            <div class="notice notice-success"><p><?php
                    /* translators: %d: number of posts migrated in this batch. */
                    echo esc_html(sprintf(__('Migrated %d posts (this batch).', 'aegisseo'), $aegisseo_meta_migrated));
            ?></p></div>
        <?php endif; ?>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_migrate_meta'); ?>
            <input type="hidden" name="action" value="aegisseo_migrate_meta" />

            <p>
                <label><strong><?php echo esc_html__('Source plugin', 'aegisseo'); ?></strong></label><br />
                <select name="source">
                    <option value="yoast">Yoast SEO</option>
                    <option value="rankmath">Rank Math</option>
                    <option value="aioseo">All in One SEO (AIOSEO)</option>
                    <option value="seopress">SEOPress</option>
                </select>
            </p>

            <p style="display:flex; gap:10px; align-items:center;">
                <label><?php echo esc_html__('Batch size', 'aegisseo'); ?>
                    <input type="number" name="limit" value="500" min="50" max="2000" />
                </label>
                <label><?php echo esc_html__('Offset', 'aegisseo'); ?>
                    <input type="number" name="offset" value="<?php echo esc_attr($aegisseo_next_offset); ?>" min="0" />
                </label>
            </p>

            <p class="description"><?php echo esc_html__('We only fill AegisSEO fields when they are empty, so this is safe to run multiple times.', 'aegisseo'); ?></p>

            <p><button class="button button-primary"><?php echo esc_html__('Run Import Batch', 'aegisseo'); ?></button></p>
        </form>
    </div>

    <div class="aegisseo-card" style="padding:14px;">
        <h2 style="margin-top:0;"><?php echo esc_html__('Import Redirects from Redirection Plugin', 'aegisseo'); ?></h2>

        <?php if ($aegisseo_redir_imported): ?>
            <div class="notice notice-success"><p><?php
                    /* translators: %d: number of redirects imported. */
                    echo esc_html(sprintf(__('Imported %d redirects.', 'aegisseo'), $aegisseo_redir_imported));
            ?></p></div>
        <?php endif; ?>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('aegisseo_migrate_redirection'); ?>
            <input type="hidden" name="action" value="aegisseo_migrate_redirection" />
            <p class="description"><?php echo esc_html__('This reads enabled rules from wp_redirection_items and imports them into AegisSEO Redirects.', 'aegisseo'); ?></p>
            <p><button class="button button-primary"><?php echo esc_html__('Import Redirects', 'aegisseo'); ?></button></p>
        </form>
    </div>
</div>